/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.changepw.service;

import java.io.UnsupportedEncodingException;
import org.apache.directory.server.changepw.exceptions.ChangePasswordException;
import org.apache.directory.server.changepw.exceptions.ErrorType;
import org.apache.directory.server.changepw.io.ChangePasswordDataDecoder;
import org.apache.directory.server.changepw.messages.ChangePasswordRequest;
import org.apache.directory.server.changepw.service.ChangePasswordContext;
import org.apache.directory.server.changepw.value.ChangePasswordData;
import org.apache.directory.server.changepw.value.ChangePasswordDataModifier;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.server.kerberos.shared.messages.components.EncKrbPrivPart;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.service.LockBox;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractPassword
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger((Class)ExtractPassword.class);
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        EncKrbPrivPart privatePart;
        ChangePasswordContext changepwContext = (ChangePasswordContext)((Object)session.getAttribute(this.getContextKey()));
        ChangePasswordRequest request = (ChangePasswordRequest)changepwContext.getRequest();
        Authenticator authenticator = changepwContext.getAuthenticator();
        LockBox lockBox = changepwContext.getLockBox();
        EncryptionKey subSessionKey = authenticator.getSubSessionKey();
        EncryptedData encReqPrivPart = request.getPrivateMessage().getEncryptedPart();
        try {
            privatePart = (EncKrbPrivPart)lockBox.unseal(EncKrbPrivPart.class, subSessionKey, encReqPrivPart);
        }
        catch (KerberosException ke) {
            log.error(ke.getMessage(), (Throwable)ke);
            throw new ChangePasswordException(ErrorType.KRB5_KPASSWD_SOFTERROR);
        }
        ChangePasswordData passwordData = null;
        if (request.getVersionNumber() == 1) {
            ChangePasswordDataModifier modifier = new ChangePasswordDataModifier();
            modifier.setNewPassword(privatePart.getUserData());
            passwordData = modifier.getChangePasswdData();
        } else {
            ChangePasswordDataDecoder passwordDecoder = new ChangePasswordDataDecoder();
            passwordData = passwordDecoder.decodeChangePasswordData(privatePart.getUserData());
        }
        try {
            changepwContext.setPassword(new String(passwordData.getPassword(), "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            log.error(uee.getMessage(), (Throwable)uee);
            throw new ChangePasswordException(ErrorType.KRB5_KPASSWD_SOFTERROR);
        }
        next.execute(session, message);
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

