/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.changepw.service;

import java.net.InetAddress;
import org.apache.directory.server.changepw.exceptions.ChangePasswordException;
import org.apache.directory.server.changepw.exceptions.ErrorType;
import org.apache.directory.server.changepw.messages.ChangePasswordReplyModifier;
import org.apache.directory.server.changepw.service.ChangePasswordContext;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.application.ApplicationReply;
import org.apache.directory.server.kerberos.shared.messages.application.PrivateMessage;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.server.kerberos.shared.messages.components.EncApRepPart;
import org.apache.directory.server.kerberos.shared.messages.components.EncApRepPartModifier;
import org.apache.directory.server.kerberos.shared.messages.components.EncKrbPrivPart;
import org.apache.directory.server.kerberos.shared.messages.components.EncKrbPrivPartModifier;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddress;
import org.apache.directory.server.kerberos.shared.service.LockBox;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildReply
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger((Class)BuildReply.class);
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        EncryptedData encRepPart;
        EncryptedData encPrivPart;
        ChangePasswordContext changepwContext = (ChangePasswordContext)((Object)session.getAttribute(this.getContextKey()));
        Authenticator authenticator = changepwContext.getAuthenticator();
        Ticket ticket = changepwContext.getTicket();
        LockBox lockBox = changepwContext.getLockBox();
        EncKrbPrivPartModifier modifier = new EncKrbPrivPartModifier();
        byte[] resultCode = new byte[]{0, 0};
        modifier.setUserData(resultCode);
        modifier.setSenderAddress(new HostAddress(InetAddress.getLocalHost()));
        EncKrbPrivPart privPart = modifier.getEncKrbPrivPart();
        EncryptionKey subSessionKey = authenticator.getSubSessionKey();
        try {
            encPrivPart = lockBox.seal(subSessionKey, (Encodable)privPart);
        }
        catch (KerberosException ke) {
            log.error(ke.getMessage(), (Throwable)ke);
            throw new ChangePasswordException(ErrorType.KRB5_KPASSWD_SOFTERROR);
        }
        PrivateMessage privateMessage = new PrivateMessage(encPrivPart);
        EncApRepPartModifier encApModifier = new EncApRepPartModifier();
        encApModifier.setClientTime(authenticator.getClientTime());
        encApModifier.setClientMicroSecond(authenticator.getClientMicroSecond());
        encApModifier.setSequenceNumber(new Integer(authenticator.getSequenceNumber()));
        encApModifier.setSubSessionKey(authenticator.getSubSessionKey());
        EncApRepPart repPart = encApModifier.getEncApRepPart();
        try {
            encRepPart = lockBox.seal(ticket.getSessionKey(), (Encodable)repPart);
        }
        catch (KerberosException ke) {
            log.error(ke.getMessage(), (Throwable)ke);
            throw new ChangePasswordException(ErrorType.KRB5_KPASSWD_SOFTERROR);
        }
        ApplicationReply appReply = new ApplicationReply(encRepPart);
        ChangePasswordReplyModifier replyModifier = new ChangePasswordReplyModifier();
        replyModifier.setApplicationReply(appReply);
        replyModifier.setPrivateMessage(privateMessage);
        changepwContext.setReply(replyModifier.getChangePasswordReply());
        next.execute(session, message);
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

