/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.UnsupportedEncodingException;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CcsidManager;

public class Utf8CcsidManager
extends CcsidManager {
    public Utf8CcsidManager() {
        super((byte)32, (byte)46, new byte[]{-16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -63, -62, -61, -60, -59, -58}, new byte[]{-57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -63, -62, -61, -60, -59, -58});
    }

    public byte[] convertFromJavaString(String string, Agent agent) throws SqlException {
        byte[] byArray = new byte[this.getByteLength(string)];
        this.convertFromJavaString(string, byArray, 0, agent);
        return byArray;
    }

    public String convertToJavaString(byte[] byArray) {
        return this.convertToJavaString(byArray, 0, byArray.length);
    }

    public String convertToJavaString(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public int convertFromJavaString(String string, byte[] byArray, int n, Agent agent) throws SqlException {
        try {
            byte[] byArray2 = string.getBytes("UTF-8");
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[n++] = byArray2[i];
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(agent.logWriter_, new ClientMessageId("22005.S.7"));
        }
        return n;
    }

    int maxBytesPerChar() {
        return 4;
    }

    public int getByteLength(String string) {
        try {
            return string.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return -1;
        }
    }
}

