/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.generators;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.jws.HandlerChain;
import javax.xml.ws.Service;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.common.model.JavaPort;
import org.apache.cxf.tools.common.model.JavaServiceClass;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.AbstractJAXWSGenerator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.HandlerConfigGenerator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.WSDLToJavaProcessor;

public class ServiceGenerator
extends AbstractJAXWSGenerator {
    private static final String SERVICE_TEMPLATE = "org/apache/cxf/tools/wsdlto/frontend/jaxws/template/service.vm";

    public ServiceGenerator() {
        this.name = "service.generator";
    }

    @Override
    public boolean passthrough() {
        if (this.env.optionSet("genService") || this.env.optionSet("all")) {
            return false;
        }
        return this.env.optionSet("genAnt") || this.env.optionSet("genTypes") || this.env.optionSet("genClient") || this.env.optionSet("genImpl") || this.env.optionSet("genSEI") || this.env.optionSet("genServer") || this.env.optionSet("genFault");
    }

    @Override
    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        if (this.passthrough()) {
            return;
        }
        Map map = CastUtils.cast((Map)((Map)penv.get(WSDLToJavaProcessor.MODEL_MAP)));
        for (JavaModel javaModel : map.values()) {
            ClassCollector collector = (ClassCollector)penv.get(ClassCollector.class);
            Map serviceClasses = javaModel.getServiceClasses();
            if (serviceClasses.size() == 0) {
                ServiceInfo serviceInfo = (ServiceInfo)this.env.get(ServiceInfo.class);
                String wsdl = serviceInfo.getDescription().getBaseURI();
                Message msg = new Message("CAN_NOT_GEN_SERVICE", LOG, new Object[]{wsdl});
                if (penv.isVerbose()) {
                    System.out.println(msg.toString());
                }
                return;
            }
            for (JavaServiceClass js : serviceClasses.values()) {
                if (js.getHandlerChains() != null) {
                    HandlerConfigGenerator handlerGen = new HandlerConfigGenerator();
                    handlerGen.setJavaInterface((JavaInterface)js);
                    handlerGen.generate(this.getEnvironment());
                    JAnnotation annot = handlerGen.getHandlerAnnotation();
                    if (handlerGen.getHandlerAnnotation() != null) {
                        boolean existHandlerAnno = false;
                        for (JAnnotation jann : js.getAnnotations()) {
                            if (jann.getType() != HandlerChain.class) continue;
                            existHandlerAnno = true;
                        }
                        if (!existHandlerAnno) {
                            js.addAnnotation(annot);
                            js.addImport("javax.jws.HandlerChain");
                        }
                    }
                }
                for (JavaPort port : js.getPorts()) {
                    if (port.getPackageName().equals(js.getPackageName()) || port.getInterfaceClass().equals(js.getName())) continue;
                    js.addImport(port.getFullClassName());
                }
                String url = (String)this.env.get("wsdlurl");
                String location = (String)this.env.get("wsdlLocation");
                if (location == null) {
                    location = url;
                }
                String serviceSuperclass = "Service";
                for (String s : collector.getGeneratedFileInfo()) {
                    if (!s.equals(js.getPackageName() + ".Service")) continue;
                    serviceSuperclass = "javax.xml.ws.Service";
                }
                this.clearAttributes();
                boolean useGetResource = false;
                try {
                    new URL(location);
                }
                catch (MalformedURLException e) {
                    useGetResource = true;
                }
                this.setAttributes("service", js);
                this.setAttributes("wsdlLocation", location);
                this.setAttributes("useGetResource", useGetResource);
                this.setAttributes("serviceSuperclass", serviceSuperclass);
                if ("Service".equals(serviceSuperclass)) {
                    js.addImport("javax.xml.ws.Service");
                }
                this.setAttributes("wsdlUrl", url);
                this.setCommonAttributes();
                if (this.isJaxws22()) {
                    this.setAttributes("jaxws22", true);
                }
                this.doWrite(SERVICE_TEMPLATE, this.parseOutputName(js.getPackageName(), js.getName()));
            }
        }
    }

    public boolean isJaxws22() {
        return Service.class.getDeclaredConstructors().length == 2;
    }

    @Override
    public void register(ClassCollector collector, String packageName, String fileName) {
        collector.addServiceClassName(packageName, fileName, packageName + "." + fileName);
    }
}

