/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxb.JAXBEncoderDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsImplementorInfo {
    private static final Logger LOG = LogUtils.getL7dLogger(JaxWsImplementorInfo.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();
    private Class<?> implementorClass;
    private Class<?> seiClass;
    private ParameterizedType seiType;
    private List<WebService> wsAnnotations = new ArrayList<WebService>(2);
    private WebServiceProvider wsProviderAnnotation;

    public JaxWsImplementorInfo(Class<?> ic) {
        this.implementorClass = ic;
        this.initialize();
    }

    public Class<?> getSEIClass() {
        return this.seiClass;
    }

    public ParameterizedType getSEIType() {
        return this.seiType;
    }

    public Class<?> getImplementorClass() {
        return this.implementorClass;
    }

    public Class<?> getEndpointClass() {
        Class<?> endpointInterface = this.getSEIClass();
        if (null == endpointInterface) {
            endpointInterface = this.getImplementorClass();
        }
        return endpointInterface;
    }

    public String getWsdlLocation() {
        for (WebService service : this.wsAnnotations) {
            if (StringUtils.isEmpty((String)service.wsdlLocation())) continue;
            return service.wsdlLocation();
        }
        if (null != this.wsProviderAnnotation && !StringUtils.isEmpty((String)this.wsProviderAnnotation.wsdlLocation())) {
            return this.wsProviderAnnotation.wsdlLocation();
        }
        return null;
    }

    public QName getServiceName() {
        String serviceName = null;
        String namespace = null;
        if (this.wsAnnotations.size() > 0) {
            int offset = 1;
            if (this.seiClass == null) {
                offset = 0;
            }
            for (int x = 0; x < this.wsAnnotations.size() - offset; ++x) {
                if (StringUtils.isEmpty((String)serviceName)) {
                    serviceName = this.wsAnnotations.get(x).serviceName();
                }
                if (!StringUtils.isEmpty((String)namespace)) continue;
                namespace = this.wsAnnotations.get(x).targetNamespace();
            }
        }
        if ((serviceName == null || namespace == null) && this.wsProviderAnnotation != null) {
            serviceName = this.wsProviderAnnotation.serviceName();
            namespace = this.wsProviderAnnotation.targetNamespace();
        }
        if (StringUtils.isEmpty(serviceName)) {
            serviceName = this.implementorClass.getSimpleName() + "Service";
        }
        if (StringUtils.isEmpty(namespace)) {
            namespace = this.getDefaultNamespace(this.implementorClass);
        }
        return new QName(namespace, serviceName);
    }

    public QName getEndpointName() {
        String portName = null;
        String namespace = null;
        String name = null;
        if (this.wsAnnotations.size() > 0) {
            int offset = 1;
            if (this.seiClass == null) {
                offset = 0;
            }
            for (int x = 0; x < this.wsAnnotations.size() - offset; ++x) {
                if (StringUtils.isEmpty((String)portName)) {
                    portName = this.wsAnnotations.get(x).portName();
                }
                if (StringUtils.isEmpty((String)namespace)) {
                    namespace = this.wsAnnotations.get(x).targetNamespace();
                }
                if (!StringUtils.isEmpty(name)) continue;
                name = this.wsAnnotations.get(x).name();
            }
        }
        if ((portName == null || namespace == null) && this.wsProviderAnnotation != null) {
            portName = this.wsProviderAnnotation.portName();
            namespace = this.wsProviderAnnotation.targetNamespace();
        }
        if (StringUtils.isEmpty(portName) && !StringUtils.isEmpty(name)) {
            portName = name + "Port";
        }
        if (StringUtils.isEmpty(portName)) {
            portName = this.implementorClass.getSimpleName() + "Port";
        }
        if (StringUtils.isEmpty(namespace)) {
            namespace = this.getDefaultNamespace(this.implementorClass);
        }
        return new QName(namespace, portName);
    }

    public QName getInterfaceName() {
        String name = null;
        String namespace = null;
        if (this.seiClass != null) {
            WebService service = this.seiClass.getAnnotation(WebService.class);
            if (!StringUtils.isEmpty((String)service.name())) {
                name = service.name();
            }
            if (!StringUtils.isEmpty((String)service.targetNamespace())) {
                namespace = service.targetNamespace();
            }
        } else {
            for (WebService service : this.wsAnnotations) {
                if (!StringUtils.isEmpty((String)service.name()) && name == null) {
                    name = service.name();
                }
                if (StringUtils.isEmpty((String)service.targetNamespace()) || namespace != null) continue;
                namespace = service.targetNamespace();
            }
        }
        if (name == null) {
            if (this.seiClass != null) {
                name = this.seiClass.getSimpleName();
            } else if (this.implementorClass != null) {
                name = this.implementorClass.getSimpleName();
            }
        }
        if (namespace == null) {
            if (this.seiClass != null) {
                namespace = this.getDefaultNamespace(this.seiClass);
            } else if (this.implementorClass != null) {
                namespace = this.getDefaultNamespace(this.implementorClass);
            }
        }
        return new QName(namespace, name);
    }

    private String getDefaultNamespace(Class clazz) {
        String pkg = PackageUtils.getNamespace((String)PackageUtils.getPackageName((Class)clazz));
        return StringUtils.isEmpty((String)pkg) ? "http://unknown.namespace/" : pkg;
    }

    private String getWSInterfaceName(Class<?> implClz) {
        Class<?>[] clzs;
        if (implClz.isInterface() && implClz.getAnnotation(WebService.class) != null) {
            return implClz.getName();
        }
        for (Class<?> clz : clzs = implClz.getInterfaces()) {
            if (null == clz.getAnnotation(WebService.class)) continue;
            return clz.getName();
        }
        return null;
    }

    private String getImplementorClassName() {
        for (WebService service : this.wsAnnotations) {
            if (StringUtils.isEmpty((String)service.endpointInterface())) continue;
            return service.endpointInterface();
        }
        return null;
    }

    private void initialize() {
        Class<?> cls = this.implementorClass;
        while (cls != null) {
            WebService annotation = cls.getAnnotation(WebService.class);
            if (annotation != null) {
                this.wsAnnotations.add(annotation);
                if (cls.isInterface()) {
                    cls = null;
                }
            }
            if (cls == null) continue;
            cls = cls.getSuperclass();
        }
        String sei = this.getImplementorClassName();
        boolean seiFromWsAnnotation = true;
        if (StringUtils.isEmpty((String)sei)) {
            seiFromWsAnnotation = false;
            sei = this.getWSInterfaceName(this.implementorClass);
        }
        if (!StringUtils.isEmpty((String)sei)) {
            try {
                this.seiClass = ClassLoaderUtils.loadClass((String)sei, this.implementorClass);
            }
            catch (ClassNotFoundException ex) {
                throw new WebServiceException(BUNDLE.getString("SEI_LOAD_FAILURE_MSG"), (Throwable)ex);
            }
            WebService seiAnnotation = this.seiClass.getAnnotation(WebService.class);
            if (null == seiAnnotation) {
                throw new WebServiceException(BUNDLE.getString("SEI_WITHOUT_WEBSERVICE_ANNOTATION_EXC"));
            }
            if (!(!seiFromWsAnnotation || StringUtils.isEmpty((String)seiAnnotation.portName()) && StringUtils.isEmpty((String)seiAnnotation.serviceName()) && StringUtils.isEmpty((String)seiAnnotation.endpointInterface()))) {
                String expString = BUNDLE.getString("ILLEGAL_ATTRIBUTE_IN_SEI_ANNOTATION_EXC");
                throw new WebServiceException(expString);
            }
            this.wsAnnotations.add(seiAnnotation);
            for (int x = this.implementorClass.getInterfaces().length - 1; x >= 0; --x) {
                Type type;
                if (!this.seiClass.equals(this.implementorClass.getInterfaces()[x]) || !((type = this.implementorClass.getGenericInterfaces()[x]) instanceof ParameterizedType)) continue;
                this.seiType = (ParameterizedType)type;
            }
        }
        this.wsProviderAnnotation = this.implementorClass.getAnnotation(WebServiceProvider.class);
    }

    public boolean isWebServiceProvider() {
        return Provider.class.isAssignableFrom(this.implementorClass);
    }

    public WebServiceProvider getWsProvider() {
        return this.wsProviderAnnotation;
    }

    public Service.Mode getServiceMode() {
        ServiceMode m = this.implementorClass.getAnnotation(ServiceMode.class);
        if (m != null && m.value() != null) {
            return m.value();
        }
        return Service.Mode.PAYLOAD;
    }

    public Class<?> getProviderParameterType() {
        for (Class<?> c = this.implementorClass; c != null; c = c.getSuperclass()) {
            Type[] intfTypes;
            for (Type t : intfTypes = c.getGenericInterfaces()) {
                Class clazz = JAXBEncoderDecoder.getClassFromType((Type)t);
                if (Provider.class != clazz) continue;
                Type[] paramTypes = ((ParameterizedType)t).getActualTypeArguments();
                return JAXBEncoderDecoder.getClassFromType((Type)paramTypes[0]);
            }
        }
        return null;
    }

    public String getBindingType() {
        BindingType bType = this.implementorClass.getAnnotation(BindingType.class);
        if (bType != null) {
            return bType.value();
        }
        return "http://schemas.xmlsoap.org/wsdl/soap/http";
    }
}

