/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.cxf.ws.rm.AckRequestedType;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.SequenceType;
import org.apache.cxf.ws.rm.SourceSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMProperties {
    private SequenceType sequence;
    private Collection<SequenceAcknowledgement> acks;
    private Collection<AckRequestedType> acksRequested;

    public Collection<SequenceAcknowledgement> getAcks() {
        return this.acks;
    }

    public Collection<AckRequestedType> getAcksRequested() {
        return this.acksRequested;
    }

    public SequenceType getSequence() {
        return this.sequence;
    }

    public void setAcks(Collection<SequenceAcknowledgement> a) {
        this.acks = a;
    }

    public void setAcksRequested(Collection<AckRequestedType> ar) {
        this.acksRequested = ar;
    }

    public void setSequence(SequenceType s) {
        this.sequence = s;
    }

    public void setSequence(SourceSequence seq) {
        SequenceType s = RMUtils.getWSRMFactory().createSequenceType();
        s.setIdentifier(seq.getIdentifier());
        s.setMessageNumber(seq.getCurrentMessageNr());
        if (seq.isLastMessage()) {
            s.setLastMessage(new SequenceType.LastMessage());
        }
        this.setSequence(s);
    }

    public void addAck(DestinationSequence seq) {
        if (null == this.acks) {
            this.acks = new ArrayList<SequenceAcknowledgement>();
        }
        SequenceAcknowledgement ack = seq.getAcknowledgment();
        this.acks.add(ack);
        seq.acknowledgmentSent();
    }
}

