/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.WSDLConstants;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertiesLoaderUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.AbstractCXFToolContainer;
import org.apache.cxf.tools.common.ClassNameProcessor;
import org.apache.cxf.tools.common.ClassUtils;
import org.apache.cxf.tools.common.FrontEndGenerator;
import org.apache.cxf.tools.common.Processor;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.CommandDocument;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.URIParserUtil;
import org.apache.cxf.tools.validator.ServiceValidator;
import org.apache.cxf.tools.wsdlto.core.AbstractWSDLBuilder;
import org.apache.cxf.tools.wsdlto.core.DataBindingProfile;
import org.apache.cxf.tools.wsdlto.core.FrontEndProfile;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLToJavaContainer
extends AbstractCXFToolContainer {
    protected static final Logger LOG = LogUtils.getL7dLogger(WSDLToJavaContainer.class);
    private static final String DEFAULT_NS2PACKAGE = "http://www.w3.org/2005/08/addressing";
    private static final String SERVICE_VALIDATOR = "META-INF/tools.service.validator.xml";
    String toolName;

    public WSDLToJavaContainer(String name, ToolSpec toolspec) throws Exception {
        super(name, toolspec);
        this.toolName = name;
    }

    public Set<String> getArrayKeys() {
        HashSet<String> set = new HashSet<String>();
        set.add("packagename");
        set.add("nexclude");
        set.add("xjc");
        return set;
    }

    public WSDLConstants.WSDLVersion getWSDLVersion() {
        String version = (String)this.context.get("wsdlversion");
        return WSDLConstants.getVersion(version);
    }

    public void execute() throws ToolException {
        if (this.hasInfoOption()) {
            return;
        }
        this.buildToolContext();
        boolean isWsdlList = this.context.optionSet("wsdlList");
        if (isWsdlList) {
            try {
                ToolContext initialContextState = this.context.makeCopy();
                String wsdlURL = (String)this.context.get("wsdlurl");
                wsdlURL = URIParserUtil.getAbsoluteURI(wsdlURL);
                URL url = new URL(wsdlURL);
                InputStream is = (InputStream)url.getContent();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String tempLine = null;
                while ((tempLine = reader.readLine()) != null) {
                    ToolContext freshContext = initialContextState.makeCopy();
                    freshContext.put("wsdlurl", tempLine);
                    this.setContext(freshContext);
                    this.buildToolContext();
                    this.processWsdl();
                }
            }
            catch (IOException e) {
                throw new ToolException(e);
            }
        } else {
            this.processWsdl();
        }
    }

    private void processWsdl() {
        this.validate(this.context);
        FrontEndProfile frontend = this.context.get(FrontEndProfile.class);
        if (frontend == null) {
            throw new ToolException(new Message("FOUND_NO_FRONTEND", LOG, new Object[0]));
        }
        WSDLConstants.WSDLVersion version = this.getWSDLVersion();
        String wsdlURL = (String)this.context.get("wsdlurl");
        List<ServiceInfo> serviceList = (ArrayList<ServiceInfo>)this.context.get("serviceList");
        if (serviceList == null) {
            serviceList = new ArrayList<ServiceInfo>();
            if (version == WSDLConstants.WSDLVersion.WSDL11) {
                String serviceName;
                AbstractWSDLBuilder builder = frontend.getWSDLBuilder();
                builder.setContext(this.context);
                builder.setBus(this.getBus());
                this.context.put(Bus.class, this.getBus());
                wsdlURL = URIParserUtil.getAbsoluteURI(wsdlURL);
                builder.build(wsdlURL);
                builder.customize();
                Definition definition = (Definition)builder.getWSDLModel();
                this.context.put(Definition.class, definition);
                builder.validate(definition);
                WSDLServiceBuilder serviceBuilder = new WSDLServiceBuilder(this.getBus());
                serviceBuilder.setIgnoreUnknownBindings(true);
                String allowRefs = (String)this.context.get("allowElementReferences");
                if (!StringUtils.isEmpty(allowRefs) || this.context.optionSet("allowElementReferences")) {
                    if (allowRefs.length() > 0 && allowRefs.charAt(0) == '=') {
                        allowRefs = allowRefs.substring(1);
                    }
                    if (StringUtils.isEmpty(allowRefs)) {
                        allowRefs = "true";
                    }
                    serviceBuilder.setAllowElementRefs(Boolean.valueOf(allowRefs));
                }
                if ((serviceName = (String)this.context.get("servicename")) != null) {
                    List<ServiceInfo> services = serviceBuilder.buildServices(definition, this.getServiceQName(definition));
                    serviceList.addAll(services);
                } else {
                    serviceList = definition.getServices().size() > 0 ? serviceBuilder.buildServices(definition) : serviceBuilder.buildMockServices(definition);
                }
            }
        }
        this.context.put("serviceList", serviceList);
        LinkedHashMap interfaces = new LinkedHashMap();
        ServiceInfo service0 = (ServiceInfo)serviceList.get(0);
        SchemaCollection schemaCollection = service0.getXmlSchemaCollection();
        this.context.put("xmlSchemaCollection", schemaCollection);
        this.context.put("portTypeMap", interfaces);
        ClassCollector collector = new ClassCollector();
        String[] reserved = (String[])this.context.get("reserveClass");
        if (reserved != null) {
            for (String r : reserved) {
                collector.reserveClass(r);
            }
        }
        this.context.put(ClassCollector.class, collector);
        Processor processor = frontend.getProcessor();
        if (processor instanceof ClassNameProcessor) {
            processor.setEnvironment(this.context);
            for (ServiceInfo service : serviceList) {
                this.context.put(ServiceInfo.class, service);
                ((ClassNameProcessor)processor).processClassNames();
                this.context.put(ServiceInfo.class, null);
            }
        }
        this.generateTypes();
        for (ServiceInfo service : serviceList) {
            this.context.put(ServiceInfo.class, service);
            this.validate(service);
            processor.setEnvironment(this.context);
            processor.process();
        }
        if (!this.isSuppressCodeGen()) {
            for (FrontEndGenerator generator : frontend.getGenerators()) {
                generator.generate(this.context);
            }
        }
        this.context.remove("serviceList");
        if (this.context.optionSet("compile")) {
            new ClassUtils().compile(this.context);
        }
        if (this.context.isExcludeNamespaceEnabled()) {
            try {
                this.removeExcludeFiles();
            }
            catch (IOException e) {
                throw new ToolException(e);
            }
        }
    }

    private boolean isSuppressCodeGen() {
        return this.context.optionSet("suppress");
    }

    @Override
    public void execute(boolean exitOnFinish) throws ToolException {
        try {
            if (this.getArgument() != null) {
                super.execute(exitOnFinish);
            }
            this.execute();
        }
        catch (ToolException ex) {
            if (ex.getCause() instanceof BadUsageException) {
                this.printUsageException(this.toolName, (BadUsageException)ex.getCause());
            }
            throw ex;
        }
        catch (Exception ex) {
            throw new ToolException(ex);
        }
        finally {
            this.tearDown();
        }
    }

    public QName getServiceQName(Definition def) {
        ArrayList<Definition> defs = new ArrayList<Definition>();
        defs.add(def);
        for (List defList : def.getImports().values()) {
            for (Import importDef : defList) {
                defs.add(importDef.getDefinition());
            }
        }
        String serviceName = (String)this.context.get("servicename");
        QName qname = null;
        for (Definition definition : defs) {
            if (serviceName == null) continue;
            for (QName qn : definition.getServices().keySet()) {
                if (!qn.getLocalPart().equalsIgnoreCase(serviceName.toLowerCase())) continue;
                return qn;
            }
        }
        if (qname == null) {
            Message msg = new Message("SERVICE_NOT_FOUND", LOG, serviceName);
            throw new ToolException(msg);
        }
        return qname;
    }

    public void loadDefaultNSPackageMapping(ToolContext env) {
        if (!env.hasExcludeNamespace(DEFAULT_NS2PACKAGE) && env.getBooleanValue("defaultns", "true") && env.get("noAddressBinding") != null) {
            env.loadDefaultNS2Pck(WSDLToJavaContainer.getResourceAsStream("namespace2package.cfg"));
        }
        if (env.getBooleanValue("defaultex", "true")) {
            env.loadDefaultExcludes(WSDLToJavaContainer.getResourceAsStream("wsdltojavaexclude.cfg"));
        }
    }

    public void setExcludePackageAndNamespaces(ToolContext env) {
        if (env.get("nexclude") != null) {
            String[] pns = null;
            try {
                pns = (String[])env.get("nexclude");
            }
            catch (ClassCastException e) {
                pns = new String[]{(String)env.get("nexclude")};
            }
            for (int j = 0; j < pns.length; ++j) {
                int pos = pns[j].indexOf("=");
                String excludePackagename = pns[j];
                if (pos != -1) {
                    String ns = pns[j].substring(0, pos);
                    if (ns.equals(DEFAULT_NS2PACKAGE)) {
                        env.put("noAddressBinding", "noAddressBinding");
                    }
                    excludePackagename = pns[j].substring(pos + 1);
                    env.addExcludeNamespacePackageMap(ns, excludePackagename);
                    env.addNamespacePackageMap(ns, excludePackagename);
                    continue;
                }
                env.addExcludeNamespacePackageMap(pns[j], env.mapPackageName(pns[j]));
            }
        }
    }

    public void setPackageAndNamespaces(ToolContext env) {
        if (env.get("packagename") != null) {
            String[] pns = null;
            try {
                pns = (String[])env.get("packagename");
            }
            catch (ClassCastException e) {
                pns = new String[]{(String)env.get("packagename")};
            }
            for (int j = 0; j < pns.length; ++j) {
                int pos = pns[j].indexOf("=");
                String packagename = pns[j];
                if (pos != -1) {
                    String ns = pns[j].substring(0, pos);
                    if (ns.equals(DEFAULT_NS2PACKAGE)) {
                        env.put("noAddressBinding", "noAddressBinding");
                    }
                    packagename = pns[j].substring(pos + 1);
                    env.addNamespacePackageMap(ns, packagename);
                    continue;
                }
                env.setPackageName(packagename);
            }
        }
    }

    public void validate(ToolContext env) throws ToolException {
        String[] bindingFiles;
        String wsdl;
        String outdir = (String)env.get("outputdir");
        if (!this.isSuppressCodeGen()) {
            File dir;
            String clsdir;
            if (outdir != null) {
                File dir2 = new File(outdir);
                if (!dir2.exists() && !dir2.mkdirs()) {
                    Message msg = new Message("DIRECTORY_COULD_NOT_BE_CREATED", LOG, outdir);
                    throw new ToolException(msg);
                }
                if (!dir2.isDirectory()) {
                    Message msg = new Message("NOT_A_DIRECTORY", LOG, outdir);
                    throw new ToolException(msg);
                }
            }
            if (env.optionSet("compile") && (clsdir = (String)env.get("classdir")) != null && !(dir = new File(clsdir)).exists() && !dir.mkdirs()) {
                Message msg = new Message("DIRECTORY_COULD_NOT_BE_CREATED", LOG, clsdir);
                throw new ToolException(msg);
            }
        }
        if (StringUtils.isEmpty(wsdl = (String)env.get("wsdlurl"))) {
            Message msg = new Message("NO_WSDL_URL", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        env.put("wsdlurl", URIParserUtil.normalize(wsdl));
        if (!env.containsKey("wsdlLocation")) {
            try {
                URL url = new URL(wsdl);
                wsdl = url.toString();
            }
            catch (MalformedURLException e) {
                wsdl = wsdl.indexOf(":") != -1 && !wsdl.startsWith("/") ? "file:/" + wsdl : "file:" + wsdl;
                try {
                    URL url = new URL(wsdl);
                    wsdl = url.toString();
                }
                catch (MalformedURLException e1) {
                    // empty catch block
                }
            }
            wsdl = wsdl.replace("\\", "/");
            env.put("wsdlLocation", wsdl);
        }
        try {
            bindingFiles = (String[])env.get("binding");
            if (bindingFiles == null) {
                return;
            }
        }
        catch (ClassCastException e) {
            bindingFiles = new String[]{(String)env.get("binding")};
        }
        for (int i = 0; i < bindingFiles.length; ++i) {
            bindingFiles[i] = URIParserUtil.getAbsoluteURI(bindingFiles[i]);
        }
        env.put("binding", bindingFiles);
    }

    public void setAntProperties(ToolContext env) {
        String installDir = System.getProperty("install.dir");
        if (installDir != null) {
            env.put("install.dir", installDir);
        } else {
            env.put("install.dir", ".");
        }
    }

    protected void setLibraryReferences(ToolContext env) {
        Properties props = this.loadProperties(WSDLToJavaContainer.getResourceAsStream("wsdltojavalib.properties"));
        if (props != null) {
            for (String string : props.keySet()) {
                env.put(string, props.get(string));
            }
        }
        env.put("ant.prop", props);
    }

    public void buildToolContext() {
        this.context = this.getContext();
        this.context.addParameters(this.getParametersMap(this.getArrayKeys()));
        if (this.context.get("outputdir") == null) {
            this.context.put("outputdir", ".");
        }
        if (this.context.containsKey("ant")) {
            this.setAntProperties(this.context);
            this.setLibraryReferences(this.context);
        }
        if (!this.context.containsKey("wsdlversion")) {
            this.context.put("wsdlversion", "1.1");
        }
        this.context.put("suppressWarnings", (Object)true);
        this.loadDefaultNSPackageMapping(this.context);
        this.setPackageAndNamespaces(this.context);
        this.setExcludePackageAndNamespaces(this.context);
    }

    protected static InputStream getResourceAsStream(String file) {
        return WSDLToJavaContainer.class.getResourceAsStream(file);
    }

    @Override
    public void checkParams(ErrorVisitor errors) throws ToolException {
        CommandDocument doc = super.getCommandDocument();
        if (!doc.hasParameter("wsdlurl")) {
            errors.add(new ErrorVisitor.UserError("WSDL/SCHEMA URL has to be specified"));
        }
        if (errors.getErrors().size() > 0) {
            Message msg = new Message("PARAMETER_MISSING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)new BadUsageException(this.getUsage(), errors));
        }
    }

    public void removeExcludeFiles() throws IOException {
        List<String> excludeGenFiles = this.context.getExcludeFileList();
        if (excludeGenFiles == null) {
            return;
        }
        String outPutDir = (String)this.context.get("outputdir");
        for (int i = 0; i < excludeGenFiles.size(); ++i) {
            String excludeFile = excludeGenFiles.get(i);
            File file = new File(outPutDir, excludeFile);
            file.delete();
            for (File tmpFile = file.getParentFile(); tmpFile != null && !tmpFile.getCanonicalPath().equalsIgnoreCase(outPutDir); tmpFile = tmpFile.getParentFile()) {
                if (!tmpFile.isDirectory() || tmpFile.list().length != 0) continue;
                tmpFile.delete();
            }
            if (this.context.get("compile") == null) continue;
            String classDir = this.context.get("classdir") == null ? outPutDir : (String)this.context.get("classdir");
            File classFile = new File(classDir, excludeFile.substring(0, excludeFile.indexOf(".java")) + ".class");
            classFile.delete();
            for (File tmpClzFile = classFile.getParentFile(); tmpClzFile != null && !tmpClzFile.getCanonicalPath().equalsIgnoreCase(outPutDir); tmpClzFile = tmpClzFile.getParentFile()) {
                if (!tmpClzFile.isDirectory() || tmpClzFile.list().length != 0) continue;
                tmpClzFile.delete();
            }
        }
    }

    public boolean passthrough() {
        if (this.context.optionSet("genTypes") || this.context.optionSet("all")) {
            return false;
        }
        return this.context.optionSet("genAnt") || this.context.optionSet("genClient") || this.context.optionSet("genImpl") || this.context.optionSet("genSEI") || this.context.optionSet("genServer") || this.context.optionSet("genService") || this.context.optionSet("genFault");
    }

    public void generateTypes() throws ToolException {
        DataBindingProfile dataBindingProfile = this.context.get(DataBindingProfile.class);
        if (dataBindingProfile == null) {
            Message msg = new Message("FOUND_NO_DATABINDING", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        dataBindingProfile.initialize(this.context);
        if (this.passthrough()) {
            return;
        }
        dataBindingProfile.generate(this.context);
    }

    public void validate(ServiceInfo service) throws ToolException {
        for (ServiceValidator validator : this.getServiceValidators()) {
            service.setProperty(ToolContext.class.getName(), this.context);
            validator.setService(service);
            if (validator.isValid()) continue;
            throw new ToolException(validator.getErrorMessage());
        }
    }

    public List<ServiceValidator> getServiceValidators() {
        ArrayList<ServiceValidator> validators = new ArrayList<ServiceValidator>();
        Properties initialExtensions = null;
        try {
            initialExtensions = PropertiesLoaderUtils.loadAllProperties(SERVICE_VALIDATOR, Thread.currentThread().getContextClassLoader());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        for (String string : initialExtensions.values()) {
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Found service validator : " + string);
                }
                ServiceValidator validator = (ServiceValidator)Class.forName(string, true, Thread.currentThread().getContextClassLoader()).newInstance();
                validators.add(validator);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex);
            }
        }
        return validators;
    }
}

