/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.disk;

import java.io.File;
import java.io.FileNotFoundException;
import org.alfresco.jlan.server.filesys.FileAttribute;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.smb.server.disk.JavaFileDiskDriver;
import org.alfresco.jlan.util.WildCard;

public class JavaFileSearchContext
extends SearchContext {
    private File m_root;
    private String[] m_list;
    private int m_idx;
    private int m_attr;
    private boolean m_single;
    private WildCard m_wildcard;
    private String m_relPath;

    protected JavaFileSearchContext() {
    }

    protected final String[] getListForDirectory(File file) {
        if (!this.isDirectory(file)) {
            return null;
        }
        String[] fileList = file.list();
        if (fileList == null) {
            File file2 = new File(file.getPath().substring(0, file.getPath().length() - 1));
            fileList = file2.list();
        }
        return fileList;
    }

    @Override
    public int getResumeId() {
        return this.m_idx;
    }

    @Override
    public boolean hasMoreFiles() {
        if (this.m_single && this.m_idx > 0) {
            return false;
        }
        return this.m_list == null || this.m_idx < this.m_list.length;
    }

    public final void initSearch(String path, int attr) throws FileNotFoundException {
        this.m_attr = attr;
        String[] pathStr = FileName.splitPath(path, File.separatorChar);
        if (pathStr[1] != null) {
            this.setSearchString(pathStr[1]);
        }
        if (pathStr[1] != null && !WildCard.containsWildcards(pathStr[1])) {
            this.setSingleFileSearch(true);
            this.m_root = new File(pathStr[0], pathStr[1]);
            if (!this.m_root.exists()) {
                this.m_root = new File(FileName.buildPath(pathStr[0], pathStr[1], null, File.separatorChar));
                if (!this.m_root.exists()) {
                    throw new FileNotFoundException(path);
                }
            }
        } else {
            String root = pathStr[0];
            if (root.endsWith(":")) {
                root = root + File.separator;
            }
            this.m_root = new File(root);
            if (this.isDirectory(this.m_root)) {
                if (pathStr[1] == null) {
                    this.setSingleFileSearch(true);
                } else {
                    this.m_list = this.getListForDirectory(this.m_root);
                    if (this.m_list == null) {
                        throw new FileNotFoundException(path);
                    }
                    this.setSingleFileSearch(false);
                    this.m_wildcard = new WildCard(pathStr[1], false);
                }
            }
        }
        this.m_idx = 0;
    }

    protected final boolean isDirectory(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.list() != null;
    }

    protected final boolean isSingleFileSearch() {
        return this.m_single;
    }

    public final boolean isValidSearch() {
        return this.m_root != null;
    }

    @Override
    public boolean nextFileInfo(FileInfo info) {
        boolean infoValid = false;
        if (this.isSingleFileSearch()) {
            if (this.m_idx == 0) {
                ++this.m_idx;
                int fattr = 0;
                long flen = 0L;
                if (this.isDirectory(this.m_root)) {
                    fattr = 16;
                } else {
                    flen = this.m_root.length();
                }
                if (!this.m_root.canWrite()) {
                    ++fattr;
                }
                info.setFileName(this.m_root.getName());
                info.setSize(flen);
                info.setFileAttributes(fattr);
                info.setFileId(this.m_root.getAbsolutePath().hashCode());
                long modifyDate = this.m_root.lastModified();
                info.setModifyDateTime(modifyDate);
                info.setChangeDateTime(modifyDate);
                long dummyCreate = JavaFileDiskDriver.getGlobalCreateDateTime();
                if (dummyCreate > modifyDate) {
                    dummyCreate = modifyDate;
                }
                info.setCreationDateTime(dummyCreate);
                infoValid = true;
            }
        } else if (this.m_list != null && this.m_idx < this.m_list.length) {
            boolean foundMatch = false;
            File curFile = new File(this.m_root, this.m_list[this.m_idx++]);
            while (!foundMatch && curFile != null) {
                if (this.m_wildcard.matchesPattern(curFile.getName())) {
                    if (FileAttribute.hasAttribute(this.m_attr, 16) && this.isDirectory(curFile)) {
                        foundMatch = true;
                    } else if (curFile.isFile()) {
                        foundMatch = true;
                    }
                }
                if (foundMatch) continue;
                if (this.m_idx < this.m_list.length) {
                    curFile = new File(this.m_root, this.m_list[this.m_idx++]);
                    continue;
                }
                curFile = null;
            }
            if (curFile != null) {
                int fattr = 0;
                long flen = 0L;
                String fname = curFile.getName();
                if (this.isDirectory(curFile)) {
                    fattr = 16;
                    if (fname.startsWith(".")) {
                        fattr += 2;
                    }
                } else {
                    flen = curFile.length();
                    if (!curFile.canWrite()) {
                        ++fattr;
                    }
                    if (fname.equalsIgnoreCase("Desktop.ini") || fname.equalsIgnoreCase("Thumbs.db") || fname.startsWith(".")) {
                        fattr += 2;
                    }
                }
                info.setFileName(curFile.getName());
                info.setSize(flen);
                info.setFileAttributes(fattr);
                StringBuffer relPath = new StringBuffer();
                relPath.append(this.m_relPath);
                relPath.append(curFile.getName());
                info.setFileId(relPath.toString().hashCode());
                long modifyDate = this.m_root.lastModified();
                info.setModifyDateTime(modifyDate);
                info.setChangeDateTime(modifyDate);
                long dummyCreate = JavaFileDiskDriver.getGlobalCreateDateTime();
                if (dummyCreate > modifyDate) {
                    dummyCreate = modifyDate;
                }
                info.setCreationDateTime(dummyCreate);
                infoValid = true;
            }
        }
        return infoValid;
    }

    @Override
    public String nextFileName() {
        if (!this.isDirectory(this.m_root)) {
            if (this.m_idx == 0) {
                ++this.m_idx;
                return this.m_root.getName();
            }
            return null;
        }
        if (this.m_list != null && this.m_idx < this.m_list.length) {
            while (this.m_idx < this.m_list.length) {
                String fname;
                if (!this.m_wildcard.matchesPattern(fname = this.m_list[this.m_idx++])) continue;
                return fname;
            }
        }
        return null;
    }

    @Override
    public boolean restartAt(int resumeId) {
        if (this.m_list == null || resumeId >= this.m_list.length) {
            return false;
        }
        this.m_idx = resumeId;
        return true;
    }

    @Override
    public boolean restartAt(FileInfo info) {
        boolean restartOK = false;
        --this.m_idx;
        if (this.m_list != null) {
            while (this.m_idx > 0 && !restartOK) {
                if (this.m_list[this.m_idx].compareTo(info.getFileName()) == 0) {
                    restartOK = true;
                    continue;
                }
                --this.m_idx;
            }
        }
        return restartOK;
    }

    protected final void setSingleFileSearch(boolean single) {
        this.m_single = single;
    }

    @Override
    public int numberOfEntries() {
        if (this.isSingleFileSearch()) {
            return 1;
        }
        if (this.m_list != null) {
            return this.m_list.length;
        }
        return -1;
    }

    public final void setRelativePath(String relPath) {
        this.m_relPath = relPath;
        if (this.m_relPath != null && !this.m_relPath.endsWith("\\")) {
            this.m_relPath = this.m_relPath + "\\";
        }
    }
}

