/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.VirtualCircuit;

public class VirtualCircuitList {
    public static final int DefaultCircuits = 4;
    public static final int DefMaxCircuits = 16;
    public static final int MinCircuits = 4;
    public static final int MaxCircuits = 2000;
    private static final int UIDMask = 65535;
    private Map<Integer, VirtualCircuit> m_vcircuits;
    private int m_UID = 1;
    private int m_maxVC = 2000;

    public VirtualCircuitList() {
    }

    public VirtualCircuitList(int maxVC) {
        this.m_maxVC = maxVC;
        this.m_vcircuits = new HashMap<Integer, VirtualCircuit>(this.getMaximumVirtualCircuits());
    }

    public final int getMaximumVirtualCircuits() {
        return this.m_maxVC;
    }

    public synchronized int addCircuit(VirtualCircuit vcircuit) {
        if (this.m_vcircuits == null) {
            this.m_vcircuits = new HashMap<Integer, VirtualCircuit>(4);
        }
        int uid = 0;
        if (this.m_vcircuits.size() == this.getMaximumVirtualCircuits()) {
            return -1;
        }
        uid = this.m_UID++ & 0xFFFF;
        while (this.m_vcircuits.containsKey(uid)) {
            uid = this.m_UID++ & 0xFFFF;
        }
        vcircuit.setUID(uid);
        this.m_vcircuits.put(uid, vcircuit);
        return uid;
    }

    public final synchronized VirtualCircuit findCircuit(int uid) {
        if (this.m_vcircuits == null) {
            return null;
        }
        return this.m_vcircuits.get(uid);
    }

    public synchronized void removeCircuit(int uid, SrvSession sess) {
        if (this.m_vcircuits == null) {
            return;
        }
        VirtualCircuit vc = this.m_vcircuits.get(uid);
        if (vc != null) {
            vc.closeCircuit(sess);
            this.m_vcircuits.remove(uid);
        }
    }

    public final synchronized int getCircuitCount() {
        return this.m_vcircuits != null ? this.m_vcircuits.size() : 0;
    }

    public final synchronized void clearCircuitList(SMBSrvSession sess) {
        if (this.m_vcircuits != null) {
            for (VirtualCircuit vc : this.m_vcircuits.values()) {
                if (!sess.isShutdown()) {
                    sess.setClientInformation(vc.getClientInformation());
                    sess.getSMBServer().getCifsAuthenticator().setCurrentUser(vc.getClientInformation());
                }
                if (sess.hasDebug(2)) {
                    sess.debugPrintln("  Cleanup vc=" + vc);
                }
                vc.closeCircuit(sess);
            }
            this.m_vcircuits.clear();
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[VCs=");
        str.append(this.getCircuitCount());
        str.append("/");
        str.append(this.getMaximumVirtualCircuits());
        str.append("]");
        return str.toString();
    }
}

