/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.dcerpc.info;

import java.util.BitSet;
import org.alfresco.jlan.smb.dcerpc.DCEBuffer;
import org.alfresco.jlan.smb.dcerpc.DCEBufferException;
import org.alfresco.jlan.smb.dcerpc.DCEReadable;

public class UserInfo
implements DCEReadable {
    public static final int InfoLevel1 = 1;
    public static final int InfoLevel3 = 3;
    public static final int InfoLevel21 = 21;
    public static final int PrivGuest = 0;
    public static final int PrivUser = 1;
    public static final int PrivAdmin = 2;
    public static final int OperPrint = 0;
    public static final int OperComm = 1;
    public static final int OperServer = 2;
    public static final int OperAccounts = 3;
    private static final int AccountDisabled = 1;
    private static final int AccountHomeDirRequired = 2;
    private static final int AccountPasswordNotRequired = 4;
    private static final int AccountTemporaryDuplicate = 8;
    private static final int AccountNormal = 16;
    private static final int AccountMNSUser = 32;
    private static final int AccountDomainTrust = 64;
    private static final int AccountWorkstationTrust = 128;
    private static final int AccountServerTrust = 256;
    private static final int AccountPasswordNotExpire = 512;
    private static final int AccountAutoLocked = 1024;
    private int m_infoLevel;
    private String m_userName;
    private int m_pwdAge;
    private int m_priv;
    private String m_homeDir;
    private String m_comment;
    private String m_description;
    private String m_accComment;
    private int m_flags;
    private String m_scriptPath;
    private String m_fullName;
    private String m_appParam;
    private String m_workStations;
    private long m_lastLogon;
    private long m_lastLogoff;
    private long m_acctExpires;
    private long m_lastPwdChange;
    private long m_pwdCanChange;
    private long m_pwdMustchange;
    private int m_unitsPerWeek;
    private byte[] m_logonHoursRaw;
    private BitSet m_logonHours;
    private int m_badPwdCount;
    private int m_numLogons;
    private String logonSrv;
    private int m_countryCode;
    private int m_codePage;
    private int m_userRID;
    private int m_groupRID;
    private String m_profile;
    private String m_homeDirDrive;
    private int m_pwdExpired;
    private String m_callBack;
    private String m_unknown1;
    private String m_unknown2;
    private String m_unknown3;

    public UserInfo() {
    }

    public UserInfo(int lev) {
        this.m_infoLevel = lev;
    }

    public final int getInformationLevel() {
        return this.m_infoLevel;
    }

    public final String getLogonServer() {
        return this.logonSrv;
    }

    public final long getAccountExpires() {
        return this.m_acctExpires;
    }

    public final String getApplicationParameter() {
        return this.m_appParam;
    }

    public final int getBadPasswordCount() {
        return this.m_badPwdCount;
    }

    public final int getCodePage() {
        return this.m_codePage;
    }

    public final String getComment() {
        return this.m_comment;
    }

    public final String getDescription() {
        return this.m_description;
    }

    public final int getCountryCode() {
        return this.m_countryCode;
    }

    public final int getFlags() {
        return this.m_flags;
    }

    public final boolean isDisabled() {
        return (this.m_flags & 1) != 0;
    }

    public final boolean requiresHomeDirectory() {
        return (this.m_flags & 2) != 0;
    }

    public final boolean requiresPassword() {
        return (this.m_flags & 4) == 0;
    }

    public final boolean isNormalUser() {
        return (this.m_flags & 0x10) != 0;
    }

    public final boolean isDomainTrust() {
        return (this.m_flags & 0x40) != 0;
    }

    public final boolean isWorkstationTrust() {
        return (this.m_flags & 0x80) != 0;
    }

    public final boolean isServerTrust() {
        return (this.m_flags & 0x100) != 0;
    }

    public final boolean passwordExpires() {
        return (this.m_flags & 0x200) == 0;
    }

    public final boolean isAutoLocked() {
        return (this.m_flags & 0x400) != 0;
    }

    public final String getFullName() {
        return this.m_fullName;
    }

    public final int getGroupRID() {
        return this.m_groupRID;
    }

    public final String getHomeDirectory() {
        return this.m_homeDir;
    }

    public final String getHomeDirectoryDrive() {
        return this.m_homeDirDrive;
    }

    public final long getLastLogoff() {
        return this.m_lastLogoff;
    }

    public final long getLastLogon() {
        return this.m_lastLogon;
    }

    public final BitSet getLogonHours() {
        return this.m_logonHours;
    }

    public final int numberOfLogons() {
        return this.m_numLogons;
    }

    public final int getPrivileges() {
        return this.m_priv;
    }

    public final String getProfile() {
        return this.m_profile;
    }

    public final int getPasswordExpired() {
        return this.m_pwdExpired;
    }

    public final String getLogonScriptPath() {
        return this.m_scriptPath;
    }

    public final int getUnitsPerWeek() {
        return this.m_unitsPerWeek;
    }

    public final String getUserName() {
        return this.m_userName;
    }

    public final int getUserRID() {
        return this.m_userRID;
    }

    public final String getWorkStations() {
        return this.m_workStations;
    }

    public final long getLastPasswordChange() {
        return this.m_lastPwdChange;
    }

    public final long getPasswordMustChangeBy() {
        return this.m_pwdMustchange;
    }

    private final void clearStrings() {
        this.m_appParam = null;
        this.m_comment = null;
        this.m_fullName = null;
        this.m_homeDir = null;
        this.m_homeDirDrive = null;
        this.m_profile = null;
        this.m_scriptPath = null;
        this.m_userName = null;
        this.m_workStations = null;
        this.m_description = null;
        this.m_accComment = null;
    }

    @Override
    public void readObject(DCEBuffer buf) throws DCEBufferException {
        this.clearStrings();
        int ival = 0;
        int pval = 0;
        switch (this.getInformationLevel()) {
            case 1: {
                this.m_userName = buf.getCharArrayPointer();
                this.m_fullName = buf.getCharArrayPointer();
                this.m_groupRID = buf.getInt();
                this.m_description = buf.getCharArrayPointer();
                this.m_comment = buf.getCharArrayPointer();
                break;
            }
            case 3: {
                this.m_userName = buf.getCharArrayPointer();
                this.m_fullName = buf.getCharArrayPointer();
                this.m_userRID = buf.getInt();
                this.m_groupRID = buf.getInt();
                this.m_homeDir = buf.getCharArrayPointer();
                this.m_homeDirDrive = buf.getCharArrayPointer();
                this.m_scriptPath = buf.getCharArrayPointer();
                this.m_profile = buf.getCharArrayPointer();
                this.m_workStations = buf.getCharArrayPointer();
                this.m_lastLogon = buf.getNTTime();
                this.m_lastLogoff = buf.getNTTime();
                this.m_lastPwdChange = buf.getNTTime();
                buf.skipBytes(8);
                buf.skipBytes(8);
                ival = buf.getShort(1);
                pval = buf.getPointer();
                if (ival != 0 && pval != 0) {
                    this.m_logonHoursRaw = new byte[ival / 8];
                }
                this.m_badPwdCount = buf.getShort();
                this.m_numLogons = buf.getShort();
                this.m_flags = buf.getInt();
                break;
            }
            case 21: {
                this.m_lastLogon = buf.getNTTime();
                this.m_lastLogoff = buf.getNTTime();
                this.m_lastPwdChange = buf.getNTTime();
                this.m_acctExpires = buf.getNTTime();
                this.m_pwdCanChange = buf.getNTTime();
                this.m_pwdMustchange = buf.getNTTime();
                this.m_userName = buf.getCharArrayPointer();
                this.m_fullName = buf.getCharArrayPointer();
                this.m_homeDir = buf.getCharArrayPointer();
                this.m_homeDirDrive = buf.getCharArrayPointer();
                this.m_scriptPath = buf.getCharArrayPointer();
                this.m_profile = buf.getCharArrayPointer();
                this.m_description = buf.getCharArrayPointer();
                this.m_workStations = buf.getCharArrayPointer();
                this.m_accComment = buf.getCharArrayPointer();
                this.m_callBack = buf.getCharArrayPointer();
                this.m_unknown1 = buf.getCharArrayPointer();
                this.m_unknown2 = buf.getCharArrayPointer();
                this.m_unknown3 = buf.getCharArrayPointer();
                buf.skipBytes(8);
                this.m_userRID = buf.getInt();
                this.m_groupRID = buf.getInt();
                this.m_flags = buf.getInt();
                buf.getInt();
                ival = buf.getShort(1);
                pval = buf.getPointer();
                if (ival != 0 && pval != 0) {
                    this.m_logonHoursRaw = new byte[ival / 8];
                }
                this.m_badPwdCount = buf.getShort();
                this.m_numLogons = buf.getShort();
                this.m_countryCode = buf.getShort();
                this.m_codePage = buf.getShort();
                buf.skipBytes(2);
                this.m_pwdExpired = buf.getByte(1);
            }
        }
    }

    @Override
    public void readStrings(DCEBuffer buf) throws DCEBufferException {
        switch (this.getInformationLevel()) {
            case 1: {
                this.m_userName = buf.getCharArrayNotNull(this.m_userName, 1);
                this.m_fullName = buf.getCharArrayNotNull(this.m_fullName, 1);
                this.m_description = buf.getCharArrayNotNull(this.m_description, 1);
                this.m_comment = buf.getCharArrayNotNull(this.m_comment, 1);
                break;
            }
            case 3: {
                this.m_userName = buf.getCharArrayNotNull(this.m_userName, 1);
                this.m_fullName = buf.getCharArrayNotNull(this.m_fullName, 1);
                this.m_homeDir = buf.getCharArrayNotNull(this.m_homeDir, 1);
                this.m_homeDirDrive = buf.getCharArrayNotNull(this.m_homeDirDrive, 1);
                this.m_scriptPath = buf.getCharArrayNotNull(this.m_scriptPath, 1);
                this.m_profile = buf.getCharArrayNotNull(this.m_profile, 1);
                this.m_workStations = buf.getCharArrayNotNull(this.m_workStations, 1);
                this.m_logonHoursRaw = buf.getByteStructure(this.m_logonHoursRaw);
                break;
            }
            case 21: {
                this.m_userName = buf.getCharArrayNotNull(this.m_userName, 1);
                this.m_fullName = buf.getCharArrayNotNull(this.m_fullName, 1);
                this.m_homeDir = buf.getCharArrayNotNull(this.m_homeDir, 1);
                this.m_homeDirDrive = buf.getCharArrayNotNull(this.m_homeDirDrive, 1);
                this.m_scriptPath = buf.getCharArrayNotNull(this.m_scriptPath, 1);
                this.m_profile = buf.getCharArrayNotNull(this.m_profile, 1);
                this.m_description = buf.getCharArrayNotNull(this.m_description, 1);
                this.m_workStations = buf.getCharArrayNotNull(this.m_workStations, 1);
                this.m_accComment = buf.getCharArrayNotNull(this.m_profile, 1);
                this.m_callBack = buf.getCharArrayNotNull(this.m_callBack, 1);
                this.m_unknown1 = buf.getCharArrayNotNull(this.m_unknown1, 1);
                this.m_unknown2 = buf.getCharArrayNotNull(this.m_unknown2, 1);
                this.m_unknown3 = buf.getCharArrayNotNull(this.m_unknown3, 1);
                this.m_logonHoursRaw = buf.getByteStructure(this.m_logonHoursRaw);
            }
        }
    }

    public static final String getAccountTypeAsString(int typ) {
        String ret = "";
        switch (typ) {
            case 0: {
                ret = "Guest";
                break;
            }
            case 1: {
                ret = "User";
                break;
            }
            case 2: {
                ret = "Administrator";
            }
        }
        return ret;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getUserName());
        str.append(":");
        str.append(this.getInformationLevel());
        str.append(":");
        str.append("]");
        return str.toString();
    }
}

