/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.alfresco.jlan.locking.FileLock;
import org.alfresco.jlan.locking.LockConflictException;
import org.alfresco.jlan.locking.NotLockedException;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.filesys.DeferFailedException;
import org.alfresco.jlan.server.filesys.ExistingOpLockException;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateCache;
import org.alfresco.jlan.server.filesys.cache.NetworkFileStateInterface;
import org.alfresco.jlan.server.locking.LockManager;
import org.alfresco.jlan.server.locking.OpLockDetails;
import org.alfresco.jlan.server.locking.OpLockManager;
import org.alfresco.jlan.server.thread.ThreadRequestPool;
import org.alfresco.jlan.server.thread.TimedThreadRequest;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;

public class FileStateLockManager
implements LockManager,
OpLockManager,
Runnable {
    private static final long OpLockBreakTimeout = 5000L;
    private static final long OpLockBreakTimeoutSecs = 5L;
    private FileStateCache m_stateCache;
    private Hashtable<String, OpLockDetails> m_oplockQueue;
    private Thread m_expiryThread;
    private boolean m_shutdown;
    private ThreadRequestPool m_threadPool;
    private OplockExpiryTimedRequest m_threadReq;

    public FileStateLockManager(FileStateCache stateCache) {
        this.m_stateCache = stateCache;
        this.m_oplockQueue = new Hashtable();
    }

    @Override
    public void lockFile(SrvSession sess, TreeConnection tree, NetworkFile file, FileLock lock) throws LockConflictException, IOException {
        if (!(file instanceof NetworkFileStateInterface)) {
            throw new IllegalArgumentException("NetworkFile does not implement NetworkFileStateInterface, path=" + file.getFullName());
        }
        NetworkFileStateInterface fstateIface = (NetworkFileStateInterface)((Object)file);
        FileState fstate = fstateIface.getFileState();
        if (fstate == null) {
            throw new IOException("Open file without state (lock)");
        }
        this.m_stateCache.addLock(fstate, lock);
        file.addLock(lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockFile(SrvSession sess, TreeConnection tree, NetworkFile file, FileLock lock) throws NotLockedException, IOException {
        if (!(file instanceof NetworkFileStateInterface)) {
            throw new IllegalArgumentException("NetworkFile does not implement NetworkFileStateInterface");
        }
        NetworkFileStateInterface fstateIface = (NetworkFileStateInterface)((Object)file);
        FileState fstate = fstateIface.getFileState();
        if (fstate == null) {
            throw new IOException("Open file without state (unlock)");
        }
        try {
            this.m_stateCache.removeLock(fstate, lock);
        }
        finally {
            file.removeLock(lock);
        }
    }

    @Override
    public FileLock createLockObject(SrvSession sess, TreeConnection tree, NetworkFile file, long offset, long len, int pid) {
        return this.m_stateCache.createFileLockObject(file, offset, len, pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void releaseLocksForFile(SrvSession sess, TreeConnection tree, NetworkFile file) {
        if (!file.hasLocks()) return;
        NetworkFile networkFile = file;
        synchronized (networkFile) {
            while (file.numberOfLocks() > 0) {
                FileLock curLock = file.getLockAt(0);
                try {
                    this.unlockFile(sess, tree, file, curLock);
                }
                catch (Exception ex) {}
            }
            return;
        }
    }

    @Override
    public int hasOpLock(String path) {
        OpLockDetails oplock;
        FileState fstate = this.m_stateCache.findFileState(path);
        if (fstate != null && fstate.hasOpLock() && (oplock = fstate.getOpLock()) != null) {
            return oplock.getLockType();
        }
        return 0;
    }

    @Override
    public OpLockDetails getOpLockDetails(String path) {
        FileState fstate = this.m_stateCache.findFileState(path);
        if (fstate != null) {
            return this.m_stateCache.getOpLock(fstate);
        }
        return null;
    }

    @Override
    public boolean grantOpLock(String path, OpLockDetails oplock, NetworkFile netFile) throws ExistingOpLockException {
        FileState fstate = this.m_stateCache.findFileState(path, true);
        return this.m_stateCache.addOpLock(fstate, oplock, netFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestOpLockBreak(String path, OpLockDetails oplock, SMBSrvSession sess, SMBSrvPacket pkt) throws IOException, DeferFailedException {
        this.m_stateCache.requestOplockBreak(path, oplock, sess, pkt);
        Hashtable<String, OpLockDetails> hashtable = this.m_oplockQueue;
        synchronized (hashtable) {
            this.m_oplockQueue.put(path, oplock);
            if (this.m_threadPool == null) {
                this.m_oplockQueue.notify();
            } else {
                this.m_threadReq.restartRequest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseOpLock(String path) {
        FileState fstate = this.m_stateCache.findFileState(path);
        if (fstate != null) {
            fstate.clearOpLock();
        }
        Hashtable<String, OpLockDetails> hashtable = this.m_oplockQueue;
        synchronized (hashtable) {
            OpLockDetails oplock = this.m_oplockQueue.remove(path);
            if (oplock != null && oplock.hasDeferredSessions()) {
                oplock.requeueDeferredRequests();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeOpLockType(OpLockDetails oplock, int newTyp) {
        this.m_stateCache.changeOpLockType(oplock, newTyp);
        Hashtable<String, OpLockDetails> hashtable = this.m_oplockQueue;
        synchronized (hashtable) {
            if (this.m_oplockQueue.remove(oplock.getPath()) != null && oplock.hasDeferredSessions()) {
                oplock.requeueDeferredRequests();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelOplockTimer(String path) {
        Hashtable<String, OpLockDetails> hashtable = this.m_oplockQueue;
        synchronized (hashtable) {
            this.m_oplockQueue.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkExpiredOplockBreaks() {
        if (this.m_oplockQueue == null) {
            return 0;
        }
        int expireCnt = 0;
        Hashtable<String, OpLockDetails> hashtable = this.m_oplockQueue;
        synchronized (hashtable) {
            if (this.m_oplockQueue.size() == 0) {
                return 0;
            }
            long timeNow = System.currentTimeMillis();
            Enumeration<String> opBreakKeys = this.m_oplockQueue.keys();
            while (opBreakKeys.hasMoreElements()) {
                String path = opBreakKeys.nextElement();
                OpLockDetails opLock = this.m_oplockQueue.get(path);
                if (opLock == null || !opLock.hasDeferredSessions()) continue;
                if (opLock.getOplockBreakTime() + 5000L <= timeNow) {
                    opLock.failDeferredRequests();
                    this.m_oplockQueue.remove(path);
                    opLock.setOplockBreakFailed();
                    ++expireCnt;
                    continue;
                }
                opLock.updateDeferredPacketLease();
            }
        }
        return expireCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_shutdown = false;
        while (!this.m_shutdown) {
            try {
                Hashtable<String, OpLockDetails> hashtable = this.m_oplockQueue;
                synchronized (hashtable) {
                    if (this.m_oplockQueue.size() == 0) {
                        this.m_oplockQueue.wait();
                    }
                }
                if (this.m_oplockQueue.size() > 0) {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.m_shutdown) {
                return;
            }
            this.checkExpiredOplockBreaks();
        }
    }

    public final void shutdownRequest() {
        this.m_shutdown = true;
        if (this.m_expiryThread != null) {
            try {
                this.m_expiryThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void startLockManager(String threadName, ThreadRequestPool threadPool) {
        this.m_threadPool = threadPool;
        if (this.m_threadPool == null) {
            this.m_expiryThread = new Thread(this);
            this.m_expiryThread.setDaemon(true);
            this.m_expiryThread.setName(threadName);
            this.m_expiryThread.start();
        } else {
            this.m_threadReq = new OplockExpiryTimedRequest(threadName, 2L);
            this.m_threadPool.queueTimedRequest(this.m_threadReq);
        }
    }

    private class OplockExpiryTimedRequest
    extends TimedThreadRequest {
        public OplockExpiryTimedRequest(String name, long interval) {
            super(name, 0L, interval);
        }

        @Override
        protected void runTimedRequest() {
            FileStateLockManager.this.checkExpiredOplockBreaks();
            if (FileStateLockManager.this.m_shutdown) {
                this.setRepeatInterval(0L);
            } else if (FileStateLockManager.this.m_oplockQueue.size() == 0) {
                this.setRunAtTime(0L);
            }
        }
    }
}

