/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.oncrpc.portmap;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.oncrpc.PortMapping;
import org.alfresco.jlan.oncrpc.Rpc;
import org.alfresco.jlan.oncrpc.RpcPacket;
import org.alfresco.jlan.oncrpc.RpcProcessor;
import org.alfresco.jlan.oncrpc.TcpRpcSessionHandler;
import org.alfresco.jlan.oncrpc.UdpRpcDatagramHandler;
import org.alfresco.jlan.oncrpc.nfs.NFSConfigSection;
import org.alfresco.jlan.server.NetworkServer;
import org.alfresco.jlan.server.Version;
import org.alfresco.jlan.server.config.ServerConfiguration;

public class PortMapperServer
extends NetworkServer
implements RpcProcessor {
    private static final String ServerVersion = Version.PortMapServerVersion;
    public static final int DefaultPort = 111;
    public static final int MaxRequestSize = 1024;
    private NFSConfigSection m_nfsConfig;
    private UdpRpcDatagramHandler m_udpHandler;
    private TcpRpcSessionHandler m_tcpHandler;
    private int m_port;
    private Hashtable<Integer, PortMapping> m_mappings;
    private Hashtable<Integer, PortMapping> m_noVerMappings;

    public PortMapperServer(ServerConfiguration config) {
        super("Portmap", config);
        this.setVersion(ServerVersion);
        this.m_nfsConfig = (NFSConfigSection)config.getConfigSection("NFS");
        if (this.m_nfsConfig != null) {
            this.setDebug(this.getNFSConfiguration().hasPortMapperDebug());
            if (this.getNFSConfiguration().getPortMapperPort() != 0) {
                this.setPort(this.getNFSConfiguration().getPortMapperPort());
            } else {
                this.setPort(111);
            }
            this.m_mappings = new Hashtable();
            this.m_noVerMappings = new Hashtable();
        } else {
            this.setEnabled(false);
        }
    }

    public final int getPort() {
        return this.m_port;
    }

    private final NFSConfigSection getNFSConfiguration() {
        return this.m_nfsConfig;
    }

    @Override
    public void startServer() {
        try {
            this.m_udpHandler = new UdpRpcDatagramHandler("PortMap", "Port", this, this, null, this.getPort(), 1024);
            this.m_udpHandler.initializeSessionHandler(this);
            Thread udpThread = new Thread(this.m_udpHandler);
            udpThread.setName("PortMap_UDP");
            udpThread.start();
            this.m_tcpHandler = new TcpRpcSessionHandler("PortMap", "Port", this, this, null, this.getPort(), 1024);
            this.m_tcpHandler.initializeSessionHandler(this);
            Thread tcpThread = new Thread(this.m_tcpHandler);
            tcpThread.setName("PortMap_TCP");
            tcpThread.start();
            PortMapping portMap = new PortMapping(100000, 2, 17, this.getPort());
            this.addPortMapping(portMap);
            portMap = new PortMapping(100000, 2, 6, this.getPort());
            this.addPortMapping(portMap);
        }
        catch (Exception ex) {
            Debug.println(ex);
        }
    }

    @Override
    public void shutdownServer(boolean immediate) {
        if (this.m_udpHandler != null) {
            this.m_udpHandler.closeSessionHandler(this);
            this.m_udpHandler = null;
        }
        if (this.m_tcpHandler != null) {
            this.m_tcpHandler.closeSessionHandler(this);
            this.m_tcpHandler = null;
        }
        this.fireServerEvent(2);
    }

    public final void setPort(int port) {
        this.m_port = port;
    }

    @Override
    public RpcPacket processRpc(RpcPacket rpc) throws IOException {
        if (rpc.getProgramId() != 100000) {
            rpc.buildAcceptErrorResponse(1);
            return rpc;
        }
        if (rpc.getProgramVersion() != 2) {
            rpc.buildProgramMismatchResponse(2, 2);
            return rpc;
        }
        rpc.positionAtParameters();
        RpcPacket response = null;
        switch (rpc.getProcedureId()) {
            case 0: {
                response = this.procNull(rpc);
                break;
            }
            case 1: {
                response = this.procSet(rpc);
                break;
            }
            case 2: {
                response = this.procUnSet(rpc);
                break;
            }
            case 3: {
                response = this.procGetPort(rpc);
                break;
            }
            case 4: {
                response = this.procDump(rpc);
            }
        }
        return response;
    }

    private final RpcPacket procNull(RpcPacket rpc) {
        rpc.buildResponseHeader();
        return rpc;
    }

    private final RpcPacket procSet(RpcPacket rpc) {
        int progId = rpc.unpackInt();
        int verId = rpc.unpackInt();
        int proto = rpc.unpackInt();
        int port = rpc.unpackInt();
        if (this.hasDebug()) {
            Debug.println("[PortMap] Set port program=" + Rpc.getServiceName(progId) + ", version=" + verId + ", protocol=" + (proto == 6 ? "TCP" : "UDP") + ", port=" + port);
        }
        PortMapping portMap = this.findPortMapping(progId, verId, proto);
        int portAdded = 0;
        if (portMap == null) {
            portMap = new PortMapping(progId, verId, proto, port);
            if (this.addPortMapping(portMap)) {
                portAdded = 1;
            }
        } else if (progId != 100000 && portMap.getPort() == port) {
            portAdded = 1;
        }
        rpc.buildResponseHeader();
        rpc.packInt(portAdded);
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procUnSet(RpcPacket rpc) {
        int progId = rpc.unpackInt();
        int verId = rpc.unpackInt();
        int proto = rpc.unpackInt();
        int port = rpc.unpackInt();
        if (this.hasDebug()) {
            Debug.println("[PortMap] UnSet port program=" + Rpc.getServiceName(progId) + ", version=" + verId + ", protocol=" + (proto == 6 ? "TCP" : "UDP") + ", port=" + port);
        }
        PortMapping portMap = this.findPortMapping(progId, verId, proto);
        int portRemoved = 0;
        if (portMap != null && progId != 100000 && this.removePortMapping(portMap)) {
            portRemoved = 1;
        }
        rpc.buildResponseHeader();
        rpc.packInt(portRemoved);
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procGetPort(RpcPacket rpc) {
        int progId = rpc.unpackInt();
        int verId = rpc.unpackInt();
        int proto = rpc.unpackInt();
        PortMapping portMap = this.findPortMapping(progId, verId, proto);
        if (this.hasDebug()) {
            Debug.println("[PortMap] Get port program=" + Rpc.getServiceName(progId) + ", version=" + verId + ", protocol=" + (proto == 6 ? "TCP" : "UDP") + ", port=" + (portMap != null ? portMap.getPort() : 0));
        }
        rpc.buildResponseHeader();
        rpc.packInt(portMap != null ? portMap.getPort() : 0);
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procDump(RpcPacket rpc) {
        if (this.hasDebug()) {
            Debug.println("[PortMap] Dump ports request from " + rpc.getClientDetails());
        }
        rpc.buildResponseHeader();
        Enumeration<PortMapping> enm = this.m_mappings.elements();
        while (enm.hasMoreElements()) {
            PortMapping portMap = enm.nextElement();
            rpc.packInt(1);
            rpc.packPortMapping(portMap);
        }
        rpc.packInt(0);
        rpc.setLength();
        return rpc;
    }

    private final boolean addPortMapping(PortMapping portMap) {
        Integer key = new Integer(portMap.hashCode());
        if (this.m_mappings.get(key) != null) {
            return false;
        }
        this.m_mappings.put(key, portMap);
        key = new Integer(PortMapping.generateHashCode(portMap.getProgramId(), 0, portMap.getProtocol()));
        this.m_noVerMappings.put(key, portMap);
        return true;
    }

    private final boolean removePortMapping(PortMapping portMap) {
        Integer key = new Integer(portMap.hashCode());
        PortMapping removedObj = this.m_mappings.remove(key);
        key = new Integer(PortMapping.generateHashCode(portMap.getProgramId(), 0, portMap.getProtocol()));
        this.m_noVerMappings.remove(key);
        return removedObj != null;
    }

    private final PortMapping findPortMapping(int progId, int verId, int proto) {
        Integer key = new Integer(PortMapping.generateHashCode(progId, verId, proto));
        PortMapping portMap = this.m_mappings.get(key);
        if (portMap == null && verId == 0) {
            portMap = this.m_noVerMappings.get(key);
        }
        return portMap;
    }
}

