/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.oncrpc.nfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.oncrpc.MultiThreadedTcpRpcSessionHandler;
import org.alfresco.jlan.oncrpc.MultiThreadedUdpRpcDatagramHandler;
import org.alfresco.jlan.oncrpc.PortMapping;
import org.alfresco.jlan.oncrpc.RpcAuthenticationException;
import org.alfresco.jlan.oncrpc.RpcAuthenticator;
import org.alfresco.jlan.oncrpc.RpcNetworkServer;
import org.alfresco.jlan.oncrpc.RpcPacket;
import org.alfresco.jlan.oncrpc.RpcPacketPool;
import org.alfresco.jlan.oncrpc.RpcProcessor;
import org.alfresco.jlan.oncrpc.RpcRequestThreadPool;
import org.alfresco.jlan.oncrpc.nfs.BadCookieException;
import org.alfresco.jlan.oncrpc.nfs.BadHandleException;
import org.alfresco.jlan.oncrpc.nfs.FileIdCache;
import org.alfresco.jlan.oncrpc.nfs.NFS;
import org.alfresco.jlan.oncrpc.nfs.NFSConfigSection;
import org.alfresco.jlan.oncrpc.nfs.NFSHandle;
import org.alfresco.jlan.oncrpc.nfs.NFSSessionTable;
import org.alfresco.jlan.oncrpc.nfs.NFSSrvSession;
import org.alfresco.jlan.oncrpc.nfs.NetworkFileCache;
import org.alfresco.jlan.oncrpc.nfs.ShareDetails;
import org.alfresco.jlan.oncrpc.nfs.ShareDetailsHash;
import org.alfresco.jlan.oncrpc.nfs.StaleHandleException;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.Version;
import org.alfresco.jlan.server.auth.acl.AccessControlManager;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.InvalidDeviceInterfaceException;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.core.SharedDeviceList;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskFullException;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskSizeInterface;
import org.alfresco.jlan.server.filesys.FileExistsException;
import org.alfresco.jlan.server.filesys.FileIdInterface;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.SrvDiskInfo;
import org.alfresco.jlan.server.filesys.SymbolicLinkInterface;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.TreeConnectionHash;
import org.alfresco.jlan.util.HexDump;

public class NFSServer
extends RpcNetworkServer
implements RpcProcessor {
    private static final String ServerVersion = Version.NFSServerVersion;
    public static final int DBG_RXDATA = 1;
    public static final int DBG_TXDATA = 2;
    public static final int DBG_DUMPDATA = 4;
    public static final int DBG_SEARCH = 8;
    public static final int DBG_INFO = 16;
    public static final int DBG_FILE = 32;
    public static final int DBG_FILEIO = 64;
    public static final int DBG_ERROR = 128;
    public static final int DBG_TIMING = 256;
    public static final int DBG_DIRECTORY = 512;
    public static final int DBG_SESSION = 1024;
    public static final String UNIX_SEPERATOR = "/";
    public static final char UNIX_SEPERATOR_CHAR = '/';
    public static final String DOS_SEPERATOR = "\\";
    public static final char DOS_SEPERATOR_CHAR = '\\';
    public static final int MODE_STFILE = 32768;
    public static final int MODE_STDIR = 16384;
    public static final int MODE_STREAD = 365;
    public static final int MODE_STWRITE = 219;
    public static final int MODE_DIR_DEFAULT = 16895;
    public static final int MODE_FILE_DEFAULT = 33279;
    public static final long COOKIE_RESUMEID_MASK = 0xFFFFFFL;
    public static final long COOKIE_SEARCHID_MASK = 0xFF000000L;
    public static final int COOKIE_SEARCHID_SHIFT = 24;
    public static final long COOKIE_DOT_DIRECTORY = 0xFFFFFFL;
    public static final long COOKIE_DOTDOT_DIRECTORY = 0xFFFFFEL;
    public static final int READDIRPLUS_HEADER_LENGTH = 108;
    public static final int READDIRPLUS_ENTRY_LENGTH = 200;
    public static final int READDIR_HEADER_LENGTH = 108;
    public static final int READDIR_ENTRY_LENGTH = 24;
    public static final long FILE_ID_OFFSET = 2L;
    public static final int MaxRequestSize = 65535;
    public static final int MaxReadSize = 65535;
    public static final int PrefReadSize = 65535;
    public static final int MultReadSize = 4096;
    public static final int MaxWriteSize = 65535;
    public static final int PrefWriteSize = 65535;
    public static final int MultWriteSize = 4096;
    public static final int PrefReadDirSize = 8192;
    public static final long MaxFileSize = 0x1FFFFFFF000L;
    private static final int DefaultThreadPoolSize = 8;
    private static final int DefaultPacketPoolSize = 50;
    private NFSConfigSection m_nfsConfig;
    private MultiThreadedUdpRpcDatagramHandler m_udpHandler;
    private MultiThreadedTcpRpcSessionHandler m_tcpHandler;
    private ShareDetailsHash m_shareDetails;
    private TreeConnectionHash m_connections;
    private NFSSessionTable m_sessAuthNull;
    private NFSSessionTable m_sessAuthUnix;
    private int m_sessId = 1;
    private int m_port;
    private RpcRequestThreadPool m_threadPool;
    private RpcPacketPool m_packetPool;
    private RpcAuthenticator m_rpcAuthenticator;
    private long m_writeVerifier;

    public NFSServer(ServerConfiguration config) {
        super("NFS", config);
        this.setVersion(ServerVersion);
        this.m_nfsConfig = (NFSConfigSection)config.getConfigSection("NFS");
        if (this.m_nfsConfig != null) {
            this.setDebugFlags(this.getNFSConfiguration().getNFSDebug());
            if (this.getNFSConfiguration().getNFSServerPort() != 0) {
                this.setPort(this.getNFSConfiguration().getNFSServerPort());
            } else {
                this.setPort(2049);
            }
            this.m_rpcAuthenticator = this.getNFSConfiguration().getRpcAuthenticator();
            this.m_writeVerifier = System.currentTimeMillis();
            this.setPortMapper(this.getNFSConfiguration().getPortMapperPort());
        } else {
            this.setEnabled(false);
        }
    }

    public final int getPort() {
        return this.m_port;
    }

    protected final NFSConfigSection getNFSConfiguration() {
        return this.m_nfsConfig;
    }

    public final void setPort(int port) {
        this.m_port = port;
    }

    @Override
    public void startServer() {
        try {
            this.m_shareDetails = new ShareDetailsHash();
            this.m_connections = new TreeConnectionHash();
            this.checkForNewShares();
            int threadPoolSize = 8;
            if (this.getNFSConfiguration().getNFSThreadPoolSize() > 0) {
                threadPoolSize = this.getNFSConfiguration().getNFSThreadPoolSize();
            }
            int packetPoolSize = 50;
            if (this.getNFSConfiguration().getNFSPacketPoolSize() > 0) {
                packetPoolSize = this.getNFSConfiguration().getNFSPacketPoolSize();
            }
            this.m_threadPool = new RpcRequestThreadPool("NFS", threadPoolSize, this);
            this.m_packetPool = new RpcPacketPool(65535, packetPoolSize);
            this.m_udpHandler = new MultiThreadedUdpRpcDatagramHandler("Nfsd", "Nfs", this, this, null, this.getPort(), 65535);
            this.m_udpHandler.setThreadPool(this.m_threadPool);
            this.m_udpHandler.setPacketPool(this.m_packetPool);
            this.m_udpHandler.initializeSessionHandler(this);
            Thread udpThread = new Thread(this.m_udpHandler);
            udpThread.setName("NFS_UDP");
            udpThread.start();
            this.m_tcpHandler = new MultiThreadedTcpRpcSessionHandler("Nfsd", "Nfs", this, this, null, this.getPort(), 65535);
            this.m_tcpHandler.setThreadPool(this.m_threadPool);
            this.m_tcpHandler.setPacketPool(this.m_packetPool);
            this.m_tcpHandler.initializeSessionHandler(this);
            Thread tcpThread = new Thread(this.m_tcpHandler);
            tcpThread.setName("NFS_TCP");
            tcpThread.start();
            PortMapping[] mappings = new PortMapping[]{new PortMapping(100003, 3, 17, this.m_udpHandler.getPort()), new PortMapping(100003, 3, 6, this.m_tcpHandler.getPort())};
            this.registerRPCServer(mappings);
        }
        catch (Exception ex) {
            this.setException(ex);
            Debug.println(ex);
        }
    }

    @Override
    public void shutdownServer(boolean immediate) {
        block4: {
            try {
                PortMapping[] mappings = new PortMapping[]{new PortMapping(100003, 3, 17, this.m_udpHandler.getPort()), new PortMapping(100003, 3, 6, this.m_tcpHandler.getPort())};
                this.unregisterRPCServer(mappings);
            }
            catch (IOException ex) {
                if (!this.hasDebugFlag(128)) break block4;
                Debug.println(ex);
            }
        }
        if (this.m_udpHandler != null) {
            this.m_udpHandler.closeSessionHandler(this);
            this.m_udpHandler = null;
        }
        if (this.m_tcpHandler != null) {
            this.m_tcpHandler.closeSessionHandler(this);
            this.m_tcpHandler = null;
        }
        this.m_threadPool.shutdownThreadPool();
        this.fireServerEvent(2);
    }

    @Override
    public RpcPacket processRpc(RpcPacket rpc) throws IOException {
        if (this.hasDebugFlag(4)) {
            Debug.println("NFS Req=" + rpc.toString());
        }
        int version = rpc.getProgramVersion();
        if (rpc.getProgramId() != 100003) {
            rpc.buildAcceptErrorResponse(1);
            return rpc;
        }
        if (version != 3) {
            rpc.buildProgramMismatchResponse(3, 3);
            return rpc;
        }
        NFSSrvSession nfsSess = null;
        try {
            nfsSess = this.findSessionForRequest(rpc);
        }
        catch (RpcAuthenticationException ex) {
            rpc.buildAuthFailResponse(ex.getAuthenticationErrorCode());
            return rpc;
        }
        rpc.positionAtParameters();
        RpcPacket response = null;
        switch (rpc.getProcedureId()) {
            case 0: {
                response = this.procNull(nfsSess, rpc);
                break;
            }
            case 1: {
                response = this.procGetAttr(nfsSess, rpc);
                break;
            }
            case 2: {
                response = this.procSetAttr(nfsSess, rpc);
                break;
            }
            case 3: {
                response = this.procLookup(nfsSess, rpc);
                break;
            }
            case 4: {
                response = this.procAccess(nfsSess, rpc);
                break;
            }
            case 5: {
                response = this.procReadLink(nfsSess, rpc);
                break;
            }
            case 6: {
                response = this.procRead(nfsSess, rpc);
                break;
            }
            case 7: {
                response = this.procWrite(nfsSess, rpc);
                break;
            }
            case 8: {
                response = this.procCreate(nfsSess, rpc);
                break;
            }
            case 9: {
                response = this.procMkDir(nfsSess, rpc);
                break;
            }
            case 10: {
                response = this.procSymLink(nfsSess, rpc);
                break;
            }
            case 11: {
                response = this.procMkNode(nfsSess, rpc);
                break;
            }
            case 12: {
                response = this.procRemove(nfsSess, rpc);
                break;
            }
            case 13: {
                response = this.procRmDir(nfsSess, rpc);
                break;
            }
            case 14: {
                response = this.procRename(nfsSess, rpc);
                break;
            }
            case 15: {
                response = this.procLink(nfsSess, rpc);
                break;
            }
            case 16: {
                response = this.procReadDir(nfsSess, rpc);
                break;
            }
            case 17: {
                response = this.procReadDirPlus(nfsSess, rpc);
                break;
            }
            case 18: {
                response = this.procFsStat(nfsSess, rpc);
                break;
            }
            case 19: {
                response = this.procFsInfo(nfsSess, rpc);
                break;
            }
            case 20: {
                response = this.procPathConf(nfsSess, rpc);
                break;
            }
            case 21: {
                response = this.procCommit(nfsSess, rpc);
            }
        }
        if (nfsSess != null) {
            nfsSess.endTransaction();
        }
        if (this.hasDebugFlag(4)) {
            Debug.println("NFS Resp=" + (rpc != null ? rpc.toString() : "<Null>"));
            HexDump.Dump(rpc.getBuffer(), rpc.getLength(), 0);
        }
        return response;
    }

    private final RpcPacket procNull(NFSSrvSession sess, RpcPacket rpc) {
        rpc.buildResponseHeader();
        return rpc;
    }

    private final RpcPacket procGetAttr(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        block15: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            if (this.hasDebugFlag(16)) {
                sess.debugPrintln("GetAttr request from " + rpc.getClientDetails() + ", handle=" + NFSHandle.asString(handle));
            }
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(10001);
                return rpc;
            }
            rpc.buildResponseHeader();
            int shareId = -1;
            String path = null;
            errorSts = 0;
            try {
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(sess, shareId);
                if (!conn.hasReadAccess()) {
                    throw new AccessDeniedException();
                }
                path = this.getPathForHandle(sess, handle, conn);
                if (!conn.hasReadAccess()) {
                    throw new AccessDeniedException();
                }
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                NetworkFile netFile = this.getOpenNetworkFileForHandle(sess, handle, conn);
                FileInfo finfo = disk.getFileInformation(sess, conn, path);
                if (finfo != null) {
                    if (netFile != null) {
                        finfo.setFileSize(netFile.getFileSize());
                        if (this.hasDebugFlag(16)) {
                            sess.debugPrintln("GetAttr added details from open file");
                        }
                    }
                    rpc.packInt(0);
                    this.packAttributes3(rpc, finfo, shareId);
                    if (this.hasDebugFlag(16)) {
                        sess.debugPrintln("GetAttr path=" + path + ", info=" + finfo);
                    }
                }
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (StaleHandleException ex) {
                errorSts = 70;
            }
            catch (AccessDeniedException ex) {
                errorSts = 13;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block15;
                sess.debugPrintln("GetAttr Exception: " + ex.toString());
                sess.debugPrintln(ex);
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("GetAttr error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RpcPacket procSetAttr(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        block36: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            if (this.hasDebugFlag(16)) {
                sess.debugPrintln("SetAttr request from " + rpc.getClientDetails());
            }
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(10001);
                return rpc;
            }
            int shareId = -1;
            String path = null;
            errorSts = 0;
            try {
                int setTime;
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(sess, shareId);
                if (!conn.hasWriteAccess()) {
                    throw new AccessDeniedException();
                }
                path = this.getPathForHandle(sess, handle, conn);
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileInfo oldInfo = disk.getFileInformation(sess, conn, path);
                int setFlags = 0;
                int gid = -1;
                int uid = -1;
                int mode = -1;
                long fsize = -1L;
                long atime = -1L;
                long mtime = -1L;
                if (rpc.unpackInt() == 1) {
                    mode = rpc.unpackInt();
                    setFlags += 512;
                }
                if (rpc.unpackInt() == 1) {
                    uid = rpc.unpackInt();
                    setFlags += 256;
                }
                if (rpc.unpackInt() == 1) {
                    gid = rpc.unpackInt();
                    setFlags += 128;
                }
                if (rpc.unpackInt() == 1) {
                    fsize = rpc.unpackLong();
                    ++setFlags;
                }
                if ((setTime = rpc.unpackInt()) == 2) {
                    atime = rpc.unpackInt();
                    atime *= 1000L;
                    rpc.skipBytes(4);
                    setFlags += 32;
                } else if (setTime == 1) {
                    atime = System.currentTimeMillis();
                    setFlags += 32;
                }
                setTime = rpc.unpackInt();
                if (setTime == 2) {
                    mtime = rpc.unpackInt();
                    mtime *= 1000L;
                    rpc.skipBytes(4);
                    setFlags += 8;
                } else if (setTime == 1) {
                    mtime = System.currentTimeMillis();
                    setFlags += 8;
                }
                if (setFlags != 0) {
                    FileInfo finfo = new FileInfo();
                    finfo.setFileInformationFlags(setFlags);
                    if (atime != -1L) {
                        finfo.setAccessDateTime(atime);
                    }
                    if (mtime != -1L) {
                        finfo.setModifyDateTime(mtime);
                    }
                    if (gid != -1) {
                        finfo.setGid(gid);
                    }
                    if (uid != -1) {
                        finfo.setUid(uid);
                    }
                    if (mode != -1) {
                        finfo.setMode(mode);
                    }
                    disk.setFileInformation(sess, conn, path, finfo);
                    if (this.hasDebugFlag(16)) {
                        sess.debugPrintln("SetAttr handle=" + NFSHandle.asString(handle) + ", accessTime=" + finfo.getAccessDateTime() + ", modifyTime=" + finfo.getModifyDateTime() + ", mode=" + mode + ", gid/uid=" + gid + UNIX_SEPERATOR + uid);
                    }
                }
                if (fsize != -1L) {
                    NetworkFile netFile;
                    NetworkFile networkFile = netFile = this.getNetworkFileForHandle(sess, handle, conn, false);
                    synchronized (networkFile) {
                        netFile.openFile(false);
                        disk.truncateFile(sess, conn, netFile, fsize);
                    }
                    if (this.hasDebugFlag(16)) {
                        sess.debugPrintln("SetAttr handle=" + NFSHandle.asString(handle) + ", newSize=" + fsize);
                    }
                }
                FileInfo newInfo = disk.getFileInformation(sess, conn, path);
                if (fsize != -1L) {
                    newInfo.setFileSize(fsize);
                } else {
                    NetworkFile netFile = this.getOpenNetworkFileForHandle(sess, handle, conn);
                    if (netFile != null) {
                        newInfo.setFileSize(netFile.getFileSize());
                    }
                }
                rpc.buildResponseHeader();
                rpc.packInt(0);
                this.packWccData(rpc, oldInfo);
                this.packPostOpAttr(sess, newInfo, shareId, rpc);
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (StaleHandleException ex) {
                errorSts = 70;
            }
            catch (AccessDeniedException ex) {
                errorSts = 13;
            }
            catch (DiskFullException ex) {
                errorSts = 69;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block36;
                sess.debugPrintln("SetAttr Exception: " + ex.toString());
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            this.packWccData(rpc, null);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("SetAttr error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procLookup(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        int shareId;
        block19: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            String fileName = rpc.unpackUTF8String();
            if (this.hasDebugFlag(8)) {
                sess.debugPrintln("Lookup request from " + rpc.getClientDetails() + ", handle=" + NFSHandle.asString(handle) + ", name=" + fileName);
            }
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(10001);
                return rpc;
            }
            shareId = -1;
            String path = null;
            errorSts = 0;
            try {
                String lookupPath;
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(sess, shareId);
                if (!conn.hasReadAccess()) {
                    throw new AccessDeniedException();
                }
                path = this.getPathForHandle(sess, handle, conn);
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                if (disk.fileExists(sess, conn, lookupPath = this.generatePath(path, fileName)) != 0) {
                    FileInfo finfo = disk.getFileInformation(sess, conn, lookupPath);
                    if (finfo != null) {
                        byte[] fHandle = this.getHandleForFile(sess, handle, conn, fileName);
                        NetworkFile netFile = this.getOpenNetworkFileForHandle(sess, fHandle, conn);
                        if (netFile != null) {
                            finfo.setFileSize(netFile.getFileSize());
                        }
                        rpc.buildResponseHeader();
                        rpc.packInt(0);
                        if (finfo.isDirectory()) {
                            NFSHandle.packDirectoryHandle(shareId, finfo.getFileId(), rpc, 32);
                        } else {
                            NFSHandle.packFileHandle(shareId, this.getFileIdForHandle(handle), finfo.getFileId(), rpc, 32);
                        }
                        this.packPostOpAttr(sess, finfo, shareId, rpc);
                        ShareDetails details = this.m_shareDetails.findDetails(shareId);
                        details.getFileIdCache().addPath(finfo.getFileId(), lookupPath);
                        if (!this.pathHasDirectories(fileName) || fileName.equals("..")) {
                            FileInfo dirInfo = disk.getFileInformation(sess, conn, path);
                            this.packPostOpAttr(sess, dirInfo, shareId, rpc);
                            if (!details.hasFileIdSupport()) {
                                details.getFileIdCache().addPath(dirInfo.getFileId(), path);
                            }
                        }
                        if (this.hasDebugFlag(8)) {
                            sess.debugPrintln("Lookup path=" + lookupPath + ", finfo=" + finfo.toString());
                        }
                    }
                } else {
                    errorSts = 2;
                }
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (StaleHandleException ex) {
                errorSts = 70;
            }
            catch (AccessDeniedException ex) {
                errorSts = 13;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block19;
                sess.debugPrintln("Lookup Exception: " + ex.toString());
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            this.packPostOpAttr(sess, null, shareId, rpc);
            if (this.hasDebugFlag(128)) {
                Debug.println("Lookup error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procAccess(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        int shareId;
        block18: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            int accessMode = rpc.unpackInt();
            if (this.hasDebugFlag(16)) {
                sess.debugPrintln("Access request from " + rpc.getClientDetails() + ", handle=" + NFSHandle.asString(handle) + ", access=0x" + Integer.toHexString(accessMode));
            }
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(10001);
                return rpc;
            }
            shareId = -1;
            String path = null;
            errorSts = 0;
            try {
                if (NFSHandle.isShareHandle(handle)) {
                    rpc.buildResponseHeader();
                    rpc.packInt(0);
                    this.packPostOpAttr(sess, null, shareId, rpc);
                    rpc.packInt(accessMode & 0x3F);
                    if (this.hasDebugFlag(16)) {
                        Debug.println("Access share path=" + path);
                    }
                } else {
                    shareId = this.getShareIdFromHandle(handle);
                    TreeConnection conn = this.getTreeConnection(sess, shareId);
                    path = this.getPathForHandle(sess, handle, conn);
                    DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                    FileInfo finfo = disk.getFileInformation(sess, conn, path);
                    if (finfo != null) {
                        int mask = 0;
                        if (conn.hasWriteAccess()) {
                            mask = 63;
                        } else if (conn.hasReadAccess()) {
                            mask = 35;
                        }
                        NetworkFile netFile = this.getOpenNetworkFileForHandle(sess, handle, conn);
                        if (netFile != null) {
                            finfo.setFileSize(netFile.getFileSize());
                        }
                        rpc.buildResponseHeader();
                        rpc.packInt(0);
                        this.packPostOpAttr(sess, finfo, shareId, rpc);
                        rpc.packInt(accessMode & mask);
                        if (this.hasDebugFlag(16)) {
                            Debug.println("Access path=" + path + ", info=" + finfo);
                        }
                    } else {
                        errorSts = 2;
                    }
                }
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (StaleHandleException ex) {
                errorSts = 70;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block18;
                sess.debugPrintln("Access3 Exception: " + ex.toString());
                sess.debugPrintln(ex);
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            this.packPostOpAttr(sess, null, shareId, rpc);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("Access error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procReadLink(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        block12: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(10001);
                return rpc;
            }
            rpc.buildResponseHeader();
            int shareId = -1;
            String path = null;
            errorSts = 0;
            try {
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(sess, shareId);
                path = this.getPathForHandle(sess, handle, conn);
                boolean symLinks = false;
                if (conn.getInterface() instanceof SymbolicLinkInterface) {
                    SymbolicLinkInterface symLinkIface = (SymbolicLinkInterface)((Object)conn.getInterface());
                    symLinks = symLinkIface.hasSymbolicLinksEnabled(sess, conn);
                }
                if (!symLinks) {
                    rpc.buildErrorResponse(10004);
                    this.packPostOpAttr(sess, null, 0, rpc);
                    this.packWccData(rpc, null);
                    rpc.setLength();
                    return rpc;
                }
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileInfo finfo = disk.getFileInformation(sess, conn, path);
                if (finfo != null && finfo.isFileType() == 3) {
                    SymbolicLinkInterface symLinkInterface = (SymbolicLinkInterface)((Object)disk);
                    String linkData = symLinkInterface.readSymbolicLink(sess, conn, path);
                    rpc.packInt(0);
                    this.packPostOpAttr(sess, finfo, shareId, rpc);
                    rpc.packString(linkData);
                } else {
                    errorSts = 22;
                }
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (StaleHandleException ex) {
                errorSts = 70;
            }
            catch (AccessDeniedException ex) {
                errorSts = 13;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block12;
                sess.debugPrintln("ReadLink Exception: " + ex.toString());
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("ReadLink error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RpcPacket procRead(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        int shareId;
        block14: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            long offset = rpc.unpackLong();
            int count = rpc.unpackInt();
            if (this.hasDebugFlag(64)) {
                sess.debugPrintln("[NFS] Read request " + rpc.getClientDetails() + ", count=" + count + ", pos=" + offset);
            }
            shareId = -1;
            NetworkFile netFile = null;
            errorSts = 0;
            try {
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(sess, shareId);
                if (!conn.hasReadAccess()) {
                    throw new AccessDeniedException();
                }
                netFile = this.getNetworkFileForHandle(sess, handle, conn, true);
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                rpc.buildResponseHeader();
                rpc.packInt(0);
                FileInfo finfo = disk.getFileInformation(sess, conn, netFile.getFullName());
                finfo.setFileSize(netFile.getFileSize());
                this.packPostOpAttr(sess, finfo, shareId, rpc);
                int bufPos = rpc.getPosition();
                int rdlen = -1;
                NetworkFile networkFile = netFile;
                synchronized (networkFile) {
                    if (netFile.isClosed()) {
                        netFile.openFile(false);
                    }
                    rdlen = disk.readFile(sess, conn, netFile, rpc.getBuffer(), bufPos + 12, count, offset);
                }
                rpc.packInt(rdlen);
                rpc.packInt(rdlen < count ? 1 : 0);
                rpc.packInt(rdlen);
                rpc.setLength(bufPos + 12 + (rdlen + 3 & 0xFFFFFFFC));
                if (this.hasDebugFlag(64)) {
                    sess.debugPrintln("Read fid=" + netFile.getFileId() + ", name=" + netFile.getName() + ", rdlen=" + rdlen);
                }
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (StaleHandleException ex) {
                errorSts = 70;
            }
            catch (AccessDeniedException ex) {
                errorSts = 13;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block14;
                sess.debugPrintln("Read Exception: netFile=" + netFile + ", cache=" + sess.getFileCache().numberOfEntries());
                Debug.println(ex);
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            this.packPostOpAttr(sess, null, shareId, rpc);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("Read error=" + NFS.getStatusString(errorSts));
            }
        }
        return rpc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RpcPacket procWrite(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        block15: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            long offset = rpc.unpackLong();
            int count = rpc.unpackInt();
            int stable = rpc.unpackInt();
            rpc.skipBytes(4);
            if (this.hasDebugFlag(64)) {
                sess.debugPrintln("Write request from " + rpc.getClientDetails() + " , count=" + count + ", offset=" + offset);
            }
            int shareId = -1;
            String path = null;
            NetworkFile netFile = null;
            errorSts = 0;
            try {
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(sess, shareId);
                if (!conn.hasWriteAccess()) {
                    throw new AccessDeniedException();
                }
                netFile = this.getNetworkFileForHandle(sess, handle, conn, false);
                path = this.getPathForHandle(sess, handle, conn);
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileInfo preInfo = null;
                NetworkFile networkFile = netFile;
                synchronized (networkFile) {
                    if (netFile.isClosed()) {
                        netFile.openFile(false);
                    }
                    preInfo = disk.getFileInformation(sess, conn, path);
                    disk.writeFile(sess, conn, netFile, rpc.getBuffer(), rpc.getPosition(), count, offset);
                }
                FileInfo finfo = disk.getFileInformation(sess, conn, path);
                finfo.setFileSize(netFile.getFileSize());
                rpc.buildResponseHeader();
                rpc.packInt(0);
                this.packPreOpAttr(sess, preInfo, rpc);
                this.packPostOpAttr(sess, finfo, shareId, rpc);
                rpc.packInt(count);
                rpc.packInt(stable);
                rpc.packLong(this.m_writeVerifier);
                if (this.hasDebugFlag(64)) {
                    sess.debugPrintln("Write fid=" + netFile.getFileId() + ", name=" + netFile.getName() + ", wrlen=" + count);
                }
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (StaleHandleException ex) {
                errorSts = 70;
            }
            catch (AccessDeniedException ex) {
                errorSts = 13;
            }
            catch (DiskFullException ex) {
                errorSts = 28;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block15;
                sess.debugPrintln("Write Exception: netFile=" + netFile + ", cache=" + sess.getFileCache().numberOfEntries());
                sess.debugPrintln(ex);
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            this.packWccData(rpc, null);
            this.packWccData(rpc, null);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("Write error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procCreate(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        block24: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            String fileName = rpc.unpackUTF8String();
            int createMode = rpc.unpackInt();
            if (this.hasDebugFlag(32)) {
                sess.debugPrintln("Create request from " + rpc.getClientDetails() + ", name=" + fileName);
            }
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(10001);
                return rpc;
            }
            int shareId = -1;
            String path = null;
            errorSts = 0;
            try {
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(sess, shareId);
                path = this.getPathForHandle(sess, handle, conn);
                if (!conn.hasWriteAccess()) {
                    throw new AccessDeniedException();
                }
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileInfo preInfo = disk.getFileInformation(sess, conn, path);
                StringBuffer str = new StringBuffer();
                str.append(path);
                if (!path.endsWith(DOS_SEPERATOR)) {
                    str.append(DOS_SEPERATOR);
                }
                str.append(fileName);
                String filePath = str.toString();
                int existSts = disk.fileExists(sess, conn, filePath);
                if (existSts == 1) {
                    errorSts = 17;
                } else if (existSts == 2) {
                    errorSts = 21;
                } else {
                    FileInfo finfo;
                    int gid = -1;
                    int uid = -1;
                    int mode = -1;
                    if (rpc.unpackInt() == 1) {
                        mode = rpc.unpackInt();
                    }
                    if (rpc.unpackInt() == 1) {
                        uid = rpc.unpackInt();
                    }
                    if (rpc.unpackInt() == 1) {
                        gid = rpc.unpackInt();
                    }
                    FileOpenParams params = new FileOpenParams(filePath, 16, 2, 0, gid, uid, mode, 0);
                    NetworkFile netFile = disk.createFile(sess, conn, params);
                    if (this.hasDebugFlag(32)) {
                        sess.debugPrintln("  Create file params=" + params);
                    }
                    if ((finfo = disk.getFileInformation(sess, conn, filePath)) != null) {
                        DiskDeviceContext diskCtx;
                        rpc.buildResponseHeader();
                        rpc.packInt(0);
                        if (finfo.isDirectory()) {
                            this.packDirectoryHandle(shareId, finfo.getFileId(), rpc);
                        } else {
                            this.packFileHandle(shareId, this.getFileIdForHandle(handle), finfo.getFileId(), rpc);
                        }
                        this.packPostOpAttr(sess, finfo, shareId, rpc);
                        ShareDetails details = this.m_shareDetails.findDetails(shareId);
                        details.getFileIdCache().addPath(finfo.getFileId(), filePath);
                        sess.getFileCache().addFile(netFile, conn, sess);
                        this.packPreOpAttr(sess, preInfo, rpc);
                        FileInfo postInfo = disk.getFileInformation(sess, conn, path);
                        this.packPostOpAttr(sess, postInfo, shareId, rpc);
                        if (this.hasDebugFlag(32)) {
                            sess.debugPrintln("Create path=" + filePath + ", finfo=" + finfo.toString());
                        }
                        if ((diskCtx = (DiskDeviceContext)conn.getContext()).hasChangeHandler()) {
                            diskCtx.getChangeHandler().notifyFileChanged(1, filePath);
                        }
                    }
                }
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (StaleHandleException ex) {
                errorSts = 70;
            }
            catch (AccessDeniedException ex) {
                errorSts = 13;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block24;
                sess.debugPrintln("Create Exception: " + ex.toString());
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            this.packWccData(rpc, null);
            this.packWccData(rpc, null);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("Create error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procMkDir(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        block19: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            String dirName = rpc.unpackUTF8String();
            if (this.hasDebugFlag(512)) {
                sess.debugPrintln("MkDir request from " + rpc.getClientDetails() + ", name=" + dirName);
            }
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(10001);
                return rpc;
            }
            int shareId = -1;
            String path = null;
            errorSts = 0;
            try {
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(sess, shareId);
                path = this.getPathForHandle(sess, handle, conn);
                if (!conn.hasWriteAccess()) {
                    throw new AccessDeniedException();
                }
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileInfo preInfo = disk.getFileInformation(sess, conn, path);
                StringBuffer str = new StringBuffer();
                str.append(path);
                if (!path.endsWith(DOS_SEPERATOR)) {
                    str.append(DOS_SEPERATOR);
                }
                str.append(dirName);
                String dirPath = str.toString();
                int existSts = disk.fileExists(sess, conn, dirPath);
                if (existSts != 0) {
                    errorSts = 17;
                } else {
                    int gid = -1;
                    int uid = -1;
                    int mode = -1;
                    if (rpc.unpackInt() == 1) {
                        mode = rpc.unpackInt();
                    }
                    if (rpc.unpackInt() == 1) {
                        uid = rpc.unpackInt();
                    }
                    if (rpc.unpackInt() == 1) {
                        gid = rpc.unpackInt();
                    }
                    FileOpenParams params = new FileOpenParams(dirPath, 16, 2, 16, gid, uid, mode, 0);
                    disk.createDirectory(sess, conn, params);
                    FileInfo finfo = disk.getFileInformation(sess, conn, dirPath);
                    if (finfo != null) {
                        rpc.buildResponseHeader();
                        rpc.packInt(0);
                        this.packDirectoryHandle(shareId, finfo.getFileId(), rpc);
                        this.packPostOpAttr(sess, finfo, shareId, rpc);
                        ShareDetails details = this.m_shareDetails.findDetails(shareId);
                        details.getFileIdCache().addPath(finfo.getFileId(), dirPath);
                        this.packWccData(rpc, preInfo);
                        this.packPostOpAttr(sess, conn, handle, rpc);
                        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
                        if (diskCtx.hasChangeHandler()) {
                            diskCtx.getChangeHandler().notifyFileChanged(1, dirPath);
                        }
                        if (this.hasDebugFlag(512)) {
                            sess.debugPrintln("Mkdir path=" + dirPath + ", finfo=" + finfo.toString());
                        }
                    }
                }
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (StaleHandleException ex) {
                errorSts = 70;
            }
            catch (AccessDeniedException ex) {
                errorSts = 13;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block19;
                sess.debugPrintln("Mkdir Exception: " + ex.toString());
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            this.packWccData(rpc, null);
            this.packWccData(rpc, null);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("Mkdir error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procSymLink(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        block30: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            String fileName = rpc.unpackUTF8String();
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(10001);
                return rpc;
            }
            int shareId = -1;
            String path = null;
            errorSts = 0;
            try {
                int setTime;
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(sess, shareId);
                path = this.getPathForHandle(sess, handle, conn);
                boolean symLinks = false;
                if (conn.getInterface() instanceof SymbolicLinkInterface) {
                    SymbolicLinkInterface symLinkIface = (SymbolicLinkInterface)((Object)conn.getInterface());
                    symLinks = symLinkIface.hasSymbolicLinksEnabled(sess, conn);
                }
                if (!symLinks) {
                    rpc.buildErrorResponse(10004);
                    this.packPostOpAttr(sess, null, 0, rpc);
                    this.packWccData(rpc, null);
                    rpc.setLength();
                    return rpc;
                }
                if (!conn.hasWriteAccess()) {
                    throw new AccessDeniedException();
                }
                int setFlags = 0;
                int gid = -1;
                int uid = -1;
                int mode = -1;
                long fsize = -1L;
                long atime = -1L;
                long mtime = -1L;
                if (rpc.unpackInt() == 1) {
                    mode = rpc.unpackInt();
                    setFlags += 512;
                }
                if (rpc.unpackInt() == 1) {
                    uid = rpc.unpackInt();
                    setFlags += 256;
                }
                if (rpc.unpackInt() == 1) {
                    gid = rpc.unpackInt();
                    setFlags += 128;
                }
                if (rpc.unpackInt() == 1) {
                    fsize = rpc.unpackLong();
                    ++setFlags;
                }
                if ((setTime = rpc.unpackInt()) == 2) {
                    atime = rpc.unpackInt();
                    atime *= 1000L;
                    rpc.skipBytes(4);
                    setFlags += 32;
                } else if (setTime == 1) {
                    atime = System.currentTimeMillis();
                    setFlags += 32;
                }
                setTime = rpc.unpackInt();
                if (setTime == 2) {
                    mtime = rpc.unpackInt();
                    mtime *= 1000L;
                    rpc.skipBytes(4);
                    setFlags += 8;
                } else if (setTime == 1) {
                    mtime = System.currentTimeMillis();
                    setFlags += 8;
                }
                String linkName = rpc.unpackString();
                if (this.hasDebugFlag(32)) {
                    sess.debugPrintln("Symbolic link request from " + rpc.getClientDetails() + ", name=" + fileName + ", link=" + linkName);
                }
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileInfo preInfo = disk.getFileInformation(sess, conn, path);
                StringBuffer str = new StringBuffer();
                str.append(path);
                if (!path.endsWith(DOS_SEPERATOR)) {
                    str.append(DOS_SEPERATOR);
                }
                str.append(fileName);
                String filePath = str.toString();
                int existSts = disk.fileExists(sess, conn, filePath);
                if (existSts == 1) {
                    errorSts = 17;
                } else if (existSts == 2) {
                    errorSts = 21;
                } else {
                    FileInfo finfo;
                    FileOpenParams params = new FileOpenParams(filePath, 16, 2, 0, gid, uid, mode, 0);
                    params.setSymbolicLink(linkName);
                    NetworkFile netFile = disk.createFile(sess, conn, params);
                    if (this.hasDebugFlag(32)) {
                        sess.debugPrintln("  Symbolic link params=" + params);
                    }
                    if ((finfo = disk.getFileInformation(sess, conn, filePath)) != null) {
                        rpc.buildResponseHeader();
                        rpc.packInt(0);
                        this.packFileHandle(shareId, this.getFileIdForHandle(handle), finfo.getFileId(), rpc);
                        this.packPostOpAttr(sess, finfo, shareId, rpc);
                        ShareDetails details = this.m_shareDetails.findDetails(shareId);
                        details.getFileIdCache().addPath(finfo.getFileId(), filePath);
                        sess.getFileCache().addFile(netFile, conn, sess);
                        this.packPreOpAttr(sess, preInfo, rpc);
                        FileInfo postInfo = disk.getFileInformation(sess, conn, path);
                        this.packPostOpAttr(sess, postInfo, shareId, rpc);
                        if (this.hasDebugFlag(32)) {
                            sess.debugPrintln("Symbolic link path=" + filePath + ", finfo=" + finfo.toString());
                        }
                    }
                }
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (StaleHandleException ex) {
                errorSts = 70;
            }
            catch (AccessDeniedException ex) {
                errorSts = 13;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block30;
                sess.debugPrintln("SymbolicLink Exception: " + ex.toString());
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("SymLink error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procMkNode(NFSSrvSession sess, RpcPacket rpc) {
        if (this.hasDebugFlag(512)) {
            sess.debugPrintln("MkNode request from " + rpc.getClientDetails());
        }
        rpc.buildErrorResponse(10004);
        this.packPostOpAttr(sess, null, 0, rpc);
        this.packWccData(rpc, null);
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procRemove(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        block17: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            String fileName = rpc.unpackUTF8String();
            if (this.hasDebugFlag(32)) {
                sess.debugPrintln("Remove request from " + rpc.getClientDetails() + ", name=" + fileName);
            }
            int shareId = -1;
            String path = null;
            errorSts = 0;
            try {
                shareId = this.getShareIdFromHandle(handle);
                ShareDetails details = this.m_shareDetails.findDetails(shareId);
                TreeConnection conn = this.getTreeConnection(sess, shareId);
                path = this.getPathForHandle(sess, handle, conn);
                if (!conn.hasWriteAccess()) {
                    throw new AccessDeniedException();
                }
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileInfo preInfo = disk.getFileInformation(sess, conn, path);
                StringBuffer str = new StringBuffer();
                str.append(path);
                if (!path.endsWith(DOS_SEPERATOR)) {
                    str.append(DOS_SEPERATOR);
                }
                str.append(fileName);
                String delPath = str.toString();
                int existSts = disk.fileExists(sess, conn, delPath);
                if (existSts == 0) {
                    errorSts = 2;
                } else if (existSts == 2) {
                    errorSts = 21;
                } else {
                    FileInfo finfo = disk.getFileInformation(sess, conn, delPath);
                    disk.deleteFile(sess, conn, delPath);
                    if (finfo != null) {
                        details.getFileIdCache().deletePath(finfo.getFileId());
                        sess.getFileCache().removeFile(finfo.getFileId());
                    }
                    FileInfo postInfo = disk.getFileInformation(sess, conn, path);
                    rpc.buildResponseHeader();
                    rpc.packInt(0);
                    this.packPreOpAttr(sess, preInfo, rpc);
                    this.packPostOpAttr(sess, postInfo, shareId, rpc);
                    DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
                    if (diskCtx.hasChangeHandler()) {
                        diskCtx.getChangeHandler().notifyFileChanged(2, delPath);
                    }
                }
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (StaleHandleException ex) {
                errorSts = 70;
            }
            catch (SecurityException ex) {
                errorSts = 13;
            }
            catch (AccessDeniedException ex) {
                errorSts = 13;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block17;
                sess.debugPrintln("GetAttr Exception: " + ex.toString());
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            this.packWccData(rpc, null);
            this.packWccData(rpc, null);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("Remove error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procRmDir(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        block18: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            String dirName = rpc.unpackUTF8String();
            if (this.hasDebugFlag(512)) {
                sess.debugPrintln("RmDir request from " + rpc.getClientDetails() + ", name=" + dirName);
            }
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(10001);
                return rpc;
            }
            int shareId = -1;
            String path = null;
            errorSts = 0;
            try {
                shareId = this.getShareIdFromHandle(handle);
                ShareDetails details = this.m_shareDetails.findDetails(shareId);
                TreeConnection conn = this.getTreeConnection(sess, shareId);
                if (!conn.hasWriteAccess()) {
                    throw new AccessDeniedException();
                }
                rpc.buildResponseHeader();
                rpc.packInt(0);
                this.packPreOpAttr(sess, conn, handle, rpc);
                path = this.getPathForHandle(sess, handle, conn);
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                StringBuffer str = new StringBuffer();
                str.append(path);
                if (!path.endsWith(DOS_SEPERATOR)) {
                    str.append(DOS_SEPERATOR);
                }
                str.append(dirName);
                String delPath = str.toString();
                int existSts = disk.fileExists(sess, conn, delPath);
                if (existSts == 0) {
                    errorSts = 2;
                } else if (existSts == 1) {
                    errorSts = 2;
                } else {
                    FileInfo finfo = disk.getFileInformation(sess, conn, delPath);
                    disk.deleteDirectory(sess, conn, delPath);
                    if (finfo != null) {
                        details.getFileIdCache().deletePath(finfo.getFileId());
                    }
                    this.packPostOpAttr(sess, conn, handle, rpc);
                    DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
                    if (diskCtx.hasChangeHandler()) {
                        diskCtx.getChangeHandler().notifyFileChanged(2, delPath);
                    }
                }
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (StaleHandleException ex) {
                errorSts = 70;
            }
            catch (SecurityException ex) {
                errorSts = 13;
            }
            catch (AccessDeniedException ex) {
                errorSts = 13;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block18;
                sess.debugPrintln("Rmdir Exception: " + ex.toString());
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            this.packWccData(rpc, null);
            this.packWccData(rpc, null);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("Rmdir error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RpcPacket procRename(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        block25: {
            byte[] fromHandle = new byte[32];
            rpc.unpackByteArrayWithLength(fromHandle);
            String fromName = rpc.unpackUTF8String();
            byte[] toHandle = new byte[32];
            rpc.unpackByteArrayWithLength(toHandle);
            String toName = rpc.unpackUTF8String();
            if (this.hasDebugFlag(32)) {
                sess.debugPrintln("Rename request from " + rpc.getClientDetails() + ", fromHandle=" + NFSHandle.asString(fromHandle) + ", fromname=" + fromName);
                sess.debugPrintln("               tohandle=" + NFSHandle.asString(toHandle) + ", toname=" + toName);
            }
            int shareId = -1;
            String fromPath = null;
            String toPath = null;
            errorSts = 0;
            try {
                DiskDeviceContext diskCtx;
                byte[] fHandle;
                NetworkFile netFile;
                FileInfo finfo;
                shareId = this.getShareIdFromHandle(fromHandle);
                ShareDetails details = this.m_shareDetails.findDetails(shareId);
                TreeConnection conn = this.getTreeConnection(sess, shareId);
                if (!conn.hasWriteAccess()) {
                    throw new AccessDeniedException();
                }
                fromPath = this.getPathForHandle(sess, fromHandle, conn);
                toPath = this.getPathForHandle(sess, toHandle, conn);
                StringBuffer str = new StringBuffer();
                str.append(fromPath);
                if (!fromPath.endsWith(DOS_SEPERATOR)) {
                    str.append(DOS_SEPERATOR);
                }
                str.append(fromName);
                String oldPath = str.toString();
                str.setLength(0);
                str.append(toPath);
                if (!toPath.endsWith(DOS_SEPERATOR)) {
                    str.append(DOS_SEPERATOR);
                }
                str.append(toName);
                String newPath = str.toString();
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileInfo preFromInfo = disk.getFileInformation(sess, conn, fromPath);
                FileInfo preToInfo = null;
                preToInfo = NFSHandle.unpackDirectoryId(fromHandle) == NFSHandle.unpackDirectoryId(toHandle) ? preFromInfo : disk.getFileInformation(sess, conn, toPath);
                int existSts = disk.fileExists(sess, conn, oldPath);
                if (existSts == 0) {
                    errorSts = 2;
                    break block25;
                }
                if (this.hasDebugFlag(32)) {
                    sess.debugPrintln("Rename from=" + oldPath + ", to=" + newPath);
                }
                if ((finfo = disk.getFileInformation(sess, conn, oldPath)) != null && !finfo.isDirectory() && (netFile = this.getOpenNetworkFileForHandle(sess, fHandle = this.getHandleForFile(sess, fromHandle, conn, fromName), conn)) != null) {
                    NetworkFileCache fileCache;
                    if (this.hasDebugFlag(32)) {
                        sess.debugPrintln("  Closing file " + oldPath + " before rename");
                    }
                    disk.closeFile(sess, conn, netFile);
                    NetworkFileCache networkFileCache = fileCache = sess.getFileCache();
                    synchronized (networkFileCache) {
                        fileCache.removeFile(netFile.getFileId());
                    }
                }
                if (disk.fileExists(sess, conn, newPath) == 1) {
                    if (this.hasDebugFlag(32)) {
                        sess.debugPrintln("  Delete existing file before rename, newPath=" + newPath);
                    }
                    disk.deleteFile(sess, conn, newPath);
                }
                disk.renameFile(sess, conn, oldPath, newPath);
                if (finfo != null && finfo.getFileId() != -1) {
                    details.getFileIdCache().deletePath(finfo.getFileId());
                    details.getFileIdCache().addPath(finfo.getFileId(), newPath);
                }
                if ((finfo = disk.getFileInformation(sess, conn, newPath)) != null) {
                    details.getFileIdCache().addPath(finfo.getFileId(), newPath);
                }
                if ((diskCtx = (DiskDeviceContext)conn.getContext()).hasChangeHandler()) {
                    diskCtx.getChangeHandler().notifyRename(oldPath, newPath);
                }
                FileInfo postFromInfo = disk.getFileInformation(sess, conn, fromPath);
                FileInfo postToInfo = null;
                postToInfo = NFSHandle.unpackDirectoryId(fromHandle) == NFSHandle.unpackDirectoryId(toHandle) ? postFromInfo : disk.getFileInformation(sess, conn, toPath);
                rpc.buildResponseHeader();
                rpc.packInt(0);
                this.packWccData(rpc, preFromInfo);
                this.packPostOpAttr(sess, postFromInfo, shareId, rpc);
                this.packWccData(rpc, preToInfo);
                this.packPostOpAttr(sess, postToInfo, shareId, rpc);
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (StaleHandleException ex) {
                errorSts = 70;
            }
            catch (SecurityException ex) {
                errorSts = 13;
            }
            catch (AccessDeniedException ex) {
                errorSts = 13;
            }
            catch (FileExistsException ex) {
                errorSts = 17;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block25;
                sess.debugPrintln("Rename Exception: " + ex.toString());
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            this.packWccData(rpc, null);
            this.packWccData(rpc, null);
            this.packWccData(rpc, null);
            this.packWccData(rpc, null);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("Rename error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procLink(NFSSrvSession sess, RpcPacket rpc) {
        if (this.hasDebugFlag(1)) {
            sess.debugPrintln("Link request from " + rpc.getClientDetails());
        }
        rpc.buildErrorResponse(13);
        this.packPostOpAttr(sess, null, 0, rpc);
        this.packWccData(rpc, null);
        this.packWccData(rpc, null);
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procReadDir(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        int shareId;
        block28: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            long cookie = rpc.unpackLong();
            long cookieVerf = rpc.unpackLong();
            int maxCount = rpc.unpackInt();
            if (this.hasDebugFlag(8)) {
                sess.debugPrintln("ReadDir request from " + rpc.getClientDetails() + " handle=" + NFSHandle.asString(handle) + ", count=" + maxCount);
            }
            shareId = -1;
            String path = null;
            errorSts = 0;
            try {
                shareId = this.getShareIdFromHandle(handle);
                ShareDetails details = this.m_shareDetails.findDetails(shareId);
                TreeConnection conn = this.getTreeConnection(sess, shareId);
                if (!conn.hasReadAccess()) {
                    throw new AccessDeniedException();
                }
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                path = this.getPathForHandle(sess, handle, conn);
                StringBuffer pathBuf = null;
                int pathLen = 0;
                FileIdCache fileCache = details.getFileIdCache();
                if (!details.hasFileIdSupport()) {
                    pathBuf = new StringBuffer(256);
                    pathBuf.append(path);
                    if (!path.endsWith(DOS_SEPERATOR)) {
                        pathBuf.append(DOS_SEPERATOR);
                    }
                    pathLen = pathBuf.length();
                }
                rpc.buildResponseHeader();
                rpc.packInt(0);
                FileInfo dinfo = disk.getFileInformation(sess, conn, path);
                this.packPostOpAttr(sess, dinfo, shareId, rpc);
                String searchPath = this.generatePath(path, "*.*");
                if (this.hasDebugFlag(8)) {
                    sess.debugPrintln("ReadDir searchPath=" + searchPath + ", cookie=" + cookie);
                }
                SearchContext search = null;
                long searchId = -1L;
                if (cookie == 0L) {
                    search = disk.startSearch(sess, conn, searchPath, 16);
                    searchId = sess.allocateSearchSlot(search);
                    cookieVerf = dinfo.getModifyDateTime();
                    if (this.hasDebugFlag(8)) {
                        sess.debugPrintln("ReadDir allocated searchId=" + searchId);
                    }
                } else {
                    if (cookieVerf != 0L && cookieVerf != dinfo.getModifyDateTime() && Long.reverseBytes(cookieVerf) != dinfo.getModifyDateTime()) {
                        throw new BadCookieException();
                    }
                    searchId = (cookie & 0xFF000000L) >> 24;
                    search = sess.getSearchContext((int)searchId);
                    if (search == null) {
                        search = disk.startSearch(sess, conn, searchPath, 16);
                        searchId = sess.allocateSearchSlot(search);
                        cookieVerf = dinfo.getModifyDateTime();
                        if (this.hasDebugFlag(8)) {
                            sess.debugPrintln("ReadDir restarted search, searchId=" + searchId);
                        }
                    }
                    int resumeId = (int)(cookie & 0xFFFFFFL);
                    if (search.getResumeId() != resumeId) {
                        search.restartAt(resumeId);
                    }
                }
                rpc.packLong(cookieVerf);
                if (searchId == -1L) {
                    throw new Exception("Bad search id");
                }
                long searchMask = searchId << 24;
                int entCnt = 0;
                FileInfo finfo = new FileInfo();
                if (cookie == 0L) {
                    rpc.packInt(1);
                    rpc.packLong(dinfo.getFileIdLong() + 2L);
                    rpc.packString(".");
                    rpc.packLong(0xFFFFFFL);
                    String parentPath = this.generatePath(path, "..");
                    FileInfo parentInfo = disk.getFileInformation(sess, conn, parentPath);
                    rpc.packInt(1);
                    rpc.packLong(parentInfo.getFileIdLong() + 2L);
                    rpc.packString("..");
                    rpc.packLong(0xFFFFFEL);
                    entCnt = 2;
                }
                boolean replyFull = false;
                while (entCnt++ < maxCount && !replyFull && search.nextFileInfo(finfo)) {
                    int entryLen = 24 + (finfo.getFileName().length() + 3 & 0xFFFFFFFC);
                    if (entryLen > rpc.getAvailableLength() || rpc.getPosition() + entryLen > maxCount) {
                        replyFull = true;
                        if (this.hasDebugFlag(8)) {
                            sess.debugPrintln("ReadDir response full, restart at=" + finfo.getFileName() + ", resumeId=" + search.getResumeId());
                        }
                        search.restartAt(finfo);
                        break;
                    }
                    rpc.packInt(1);
                    rpc.packLong(finfo.getFileIdLong() + 2L);
                    rpc.packUTF8String(finfo.getFileName());
                    rpc.packLong((long)search.getResumeId() + searchMask);
                    if (details.hasFileIdSupport() || fileCache.findPath(finfo.getFileId()) != null) continue;
                    pathBuf.setLength(pathLen);
                    pathBuf.append(finfo.getFileName());
                    fileCache.addPath(finfo.getFileId(), pathBuf.toString());
                }
                rpc.packInt(0);
                if (search.hasMoreFiles()) {
                    rpc.packInt(0);
                } else {
                    rpc.packInt(1);
                    search.closeSearch();
                    sess.deallocateSearchSlot((int)searchId);
                    if (this.hasDebugFlag(8)) {
                        sess.debugPrintln("ReadDir released searchId=" + searchId);
                    }
                }
                if (this.hasDebugFlag(8)) {
                    sess.debugPrintln("ReadDir return entries=" + (entCnt - 1) + ", eof=" + search.hasMoreFiles());
                }
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (BadCookieException ex) {
                errorSts = 10003;
            }
            catch (AccessDeniedException ex) {
                errorSts = 13;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block28;
                sess.debugPrintln("ReadDir Exception: " + ex.toString());
                sess.debugPrintln(ex);
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            this.packPostOpAttr(sess, null, shareId, rpc);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("ReadDir error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procReadDirPlus(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        int shareId;
        block30: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            long cookie = rpc.unpackLong();
            long cookieVerf = rpc.unpackLong();
            int maxDir = rpc.unpackInt();
            int maxCount = rpc.unpackInt();
            if (this.hasDebugFlag(8)) {
                sess.debugPrintln("ReadDir request from " + rpc.getClientDetails() + " handle=" + NFSHandle.asString(handle) + ", dir=" + maxDir + ", count=" + maxCount);
            }
            shareId = -1;
            String path = null;
            errorSts = 0;
            try {
                shareId = this.getShareIdFromHandle(handle);
                ShareDetails details = this.m_shareDetails.findDetails(shareId);
                TreeConnection conn = this.getTreeConnection(sess, shareId);
                if (!conn.hasReadAccess()) {
                    throw new AccessDeniedException();
                }
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                path = this.getPathForHandle(sess, handle, conn);
                StringBuffer pathBuf = null;
                int pathLen = 0;
                FileIdCache fileCache = details.getFileIdCache();
                if (!details.hasFileIdSupport()) {
                    pathBuf = new StringBuffer(256);
                    pathBuf.append(path);
                    if (!path.endsWith(DOS_SEPERATOR)) {
                        pathBuf.append(DOS_SEPERATOR);
                    }
                    pathLen = pathBuf.length();
                }
                rpc.buildResponseHeader();
                rpc.packInt(0);
                FileInfo dinfo = disk.getFileInformation(sess, conn, path);
                this.packPostOpAttr(sess, dinfo, shareId, rpc);
                String searchPath = this.generatePath(path, "*.*");
                if (this.hasDebugFlag(8)) {
                    sess.debugPrintln("ReadDirPlus searchPath=" + searchPath + ", cookie=" + cookie);
                }
                SearchContext search = null;
                long searchId = -1L;
                if (cookie == 0L) {
                    search = disk.startSearch(sess, conn, searchPath, 16);
                    searchId = sess.allocateSearchSlot(search);
                    cookieVerf = dinfo.getModifyDateTime();
                    if (this.hasDebugFlag(8)) {
                        sess.debugPrintln("ReadDirPlus allocated searchId=" + searchId);
                    }
                } else {
                    if (cookieVerf != 0L && cookieVerf != dinfo.getModifyDateTime() && Long.reverseBytes(cookieVerf) != dinfo.getModifyDateTime()) {
                        sess.debugPrintln("Bad cookie verifier, verf=0x" + Long.toHexString(cookieVerf) + ", modTime=0x" + Long.toHexString(dinfo.getModifyDateTime()));
                        throw new BadCookieException();
                    }
                    searchId = (cookie & 0xFF000000L) >> 24;
                    search = sess.getSearchContext((int)searchId);
                    if (search == null) {
                        search = disk.startSearch(sess, conn, searchPath, 16);
                        searchId = sess.allocateSearchSlot(search);
                        cookieVerf = dinfo.getModifyDateTime();
                        if (this.hasDebugFlag(8)) {
                            sess.debugPrintln("ReadDirPlus restarted search, searchId=" + searchId);
                        }
                    }
                    int resumeId = (int)(cookie & 0xFFFFFFL);
                    if (search != null && search.getResumeId() != resumeId) {
                        search.restartAt(resumeId);
                    }
                }
                rpc.packLong(cookieVerf);
                if (searchId == -1L) {
                    throw new Exception("Bad search id");
                }
                long searchMask = searchId << 24;
                int entCnt = 0;
                FileInfo finfo = new FileInfo();
                if (cookie == 0L) {
                    rpc.packInt(1);
                    rpc.packLong(dinfo.getFileIdLong() + 2L);
                    rpc.packString(".");
                    rpc.packLong(0xFFFFFFL);
                    rpc.packInt(1);
                    this.packAttributes3(rpc, dinfo, shareId);
                    this.packDirectoryHandle(shareId, dinfo.getFileId(), rpc);
                    String parentPath = this.generatePath(path, "..");
                    FileInfo parentInfo = disk.getFileInformation(sess, conn, parentPath);
                    rpc.packInt(1);
                    rpc.packLong(parentInfo.getFileIdLong() + 2L);
                    rpc.packString("..");
                    rpc.packLong(0xFFFFFEL);
                    rpc.packInt(1);
                    this.packAttributes3(rpc, parentInfo, shareId);
                    this.packDirectoryHandle(shareId, parentInfo.getFileId(), rpc);
                    entCnt = 2;
                }
                boolean replyFull = false;
                while (entCnt++ < maxDir && !replyFull && search.nextFileInfo(finfo)) {
                    int entryLen = 200 + (finfo.getFileName().length() + 3 & 0xFFFFFFFC);
                    if (entryLen > rpc.getAvailableLength() || rpc.getPosition() + entryLen > maxCount) {
                        replyFull = true;
                        if (this.hasDebugFlag(8)) {
                            sess.debugPrintln("ReadDirPlus response full, restart at=" + finfo.getFileName() + ", resumeId=" + search.getResumeId());
                        }
                        search.restartAt(finfo);
                        break;
                    }
                    rpc.packInt(1);
                    rpc.packLong(finfo.getFileIdLong() + 2L);
                    rpc.packUTF8String(finfo.getFileName());
                    rpc.packLong((long)search.getResumeId() + searchMask);
                    rpc.packInt(1);
                    this.packAttributes3(rpc, finfo, shareId);
                    if (finfo.isDirectory()) {
                        this.packDirectoryHandle(shareId, finfo.getFileId(), rpc);
                    } else {
                        this.packFileHandle(shareId, dinfo.getFileId(), finfo.getFileId(), rpc);
                    }
                    if (!details.hasFileIdSupport() && fileCache.findPath(finfo.getFileId()) == null) {
                        pathBuf.setLength(pathLen);
                        pathBuf.append(finfo.getFileName());
                        fileCache.addPath(finfo.getFileId(), pathBuf.toString());
                    }
                    finfo.setFileType(1);
                }
                rpc.packInt(0);
                if (search.hasMoreFiles()) {
                    rpc.packInt(0);
                } else {
                    rpc.packInt(1);
                    search.closeSearch();
                    sess.deallocateSearchSlot((int)searchId);
                }
                if (this.hasDebugFlag(8)) {
                    sess.debugPrintln("ReadDirPlus return entries=" + (entCnt - 1) + ", eof=" + !search.hasMoreFiles());
                }
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (BadCookieException ex) {
                errorSts = 10003;
            }
            catch (AccessDeniedException ex) {
                errorSts = 13;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block30;
                sess.debugPrintln("ReadDirPlus Exception: " + ex.toString());
                sess.debugPrintln(ex);
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            this.packPostOpAttr(sess, null, shareId, rpc);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("ReadDir error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procFsStat(NFSSrvSession sess, RpcPacket rpc) {
        byte[] handle = new byte[32];
        rpc.unpackByteArrayWithLength(handle);
        if (this.hasDebugFlag(16)) {
            sess.debugPrintln("FsInfo request from " + rpc.getClientDetails());
        }
        int shareId = -1;
        int errorSts = 0;
        try {
            DiskInterface disk;
            shareId = this.getShareIdFromHandle(handle);
            TreeConnection conn = this.getTreeConnection(sess, shareId);
            if (!conn.hasReadAccess()) {
                throw new AccessDeniedException();
            }
            DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
            SrvDiskInfo diskInfo = diskCtx.getDiskInformation();
            if (diskInfo == null) {
                diskInfo = new SrvDiskInfo();
            }
            if ((disk = (DiskInterface)conn.getSharedDevice().getInterface()) instanceof DiskSizeInterface) {
                DiskSizeInterface sizeInterface = (DiskSizeInterface)((Object)disk);
                sizeInterface.getDiskInformation(diskCtx, diskInfo);
            }
            String rootPath = this.getPathForHandle(sess, handle, conn);
            FileInfo rootInfo = disk.getFileInformation(sess, conn, rootPath);
            rpc.buildResponseHeader();
            rpc.packInt(0);
            this.packPostOpAttr(sess, rootInfo, shareId, rpc);
            long totalSize = diskInfo.getDiskSizeKb() * 1024L;
            long freeSize = diskInfo.getDiskFreeSizeKb() * 1024L;
            rpc.packLong(totalSize);
            rpc.packLong(freeSize);
            rpc.packLong(freeSize);
            long totalSlots = diskInfo.getDiskSizeKb();
            long freeSlots = diskInfo.getDiskFreeSizeKb();
            rpc.packLong(totalSlots);
            rpc.packLong(freeSlots);
            rpc.packLong(freeSlots);
            rpc.packInt(0);
        }
        catch (SecurityException ex) {
            errorSts = 13;
        }
        catch (AccessDeniedException ex) {
            errorSts = 13;
        }
        catch (Exception ex) {
            errorSts = 10006;
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            this.packPostOpAttr(sess, null, shareId, rpc);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("FsStat error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procFsInfo(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        int shareId;
        block10: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            if (this.hasDebugFlag(16)) {
                sess.debugPrintln("[NFS] FsInfo request from " + rpc.getClientDetails());
            }
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(10001);
                return rpc;
            }
            rpc.buildResponseHeader();
            shareId = -1;
            errorSts = 0;
            try {
                SymbolicLinkInterface symLinkIface;
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(sess, shareId);
                if (!conn.hasReadAccess()) {
                    throw new AccessDeniedException();
                }
                rpc.packInt(0);
                this.packPostOpAttr(sess, conn, handle, rpc);
                rpc.packInt(65535);
                rpc.packInt(65535);
                rpc.packInt(4096);
                rpc.packInt(65535);
                rpc.packInt(65535);
                rpc.packInt(4096);
                rpc.packInt(8192);
                rpc.packLong(0x1FFFFFFF000L);
                rpc.packInt(1);
                rpc.packInt(0);
                int fileSysProps = 12;
                if (conn.getInterface() instanceof SymbolicLinkInterface && (symLinkIface = (SymbolicLinkInterface)((Object)conn.getInterface())).hasSymbolicLinksEnabled(sess, conn)) {
                    fileSysProps += 2;
                }
                rpc.packInt(fileSysProps);
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (StaleHandleException ex) {
                errorSts = 70;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block10;
                sess.debugPrintln("FsInfo Exception: " + ex.toString());
                sess.debugPrintln(ex);
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            this.packPostOpAttr(sess, null, shareId, rpc);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("FsInfo error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procPathConf(NFSSrvSession sess, RpcPacket rpc) {
        int errorSts;
        int shareId;
        block12: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            if (this.hasDebugFlag(8)) {
                sess.debugPrintln("PathConf request from " + rpc.getClientDetails() + " handle=" + NFSHandle.asString(handle));
            }
            shareId = -1;
            String path = null;
            errorSts = 0;
            try {
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(sess, shareId);
                if (!conn.hasReadAccess()) {
                    throw new AccessDeniedException();
                }
                path = this.getPathForHandle(sess, handle, conn);
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                if (disk.fileExists(sess, conn, path) != 0) {
                    FileInfo finfo = disk.getFileInformation(sess, conn, path);
                    rpc.buildResponseHeader();
                    rpc.packInt(0);
                    this.packPostOpAttr(sess, finfo, shareId, rpc);
                    rpc.packInt(Short.MAX_VALUE);
                    rpc.packInt(255);
                    rpc.packInt(1);
                    rpc.packInt(1);
                    rpc.packInt(1);
                    rpc.packInt(1);
                    if (this.hasDebugFlag(8)) {
                        sess.debugPrintln("Pathconf path=" + path + ", finfo=" + (finfo != null ? finfo.toString() : "<null>"));
                    }
                } else {
                    errorSts = 2;
                }
            }
            catch (BadHandleException ex) {
                errorSts = 10001;
            }
            catch (StaleHandleException ex) {
                errorSts = 70;
            }
            catch (AccessDeniedException ex) {
                errorSts = 13;
            }
            catch (Exception ex) {
                errorSts = 10006;
                if (!this.hasDebugFlag(128)) break block12;
                sess.debugPrintln("Pathconf Exception: " + ex.toString());
            }
        }
        if (errorSts != 0) {
            rpc.buildErrorResponse(errorSts);
            this.packPostOpAttr(sess, null, shareId, rpc);
            if (this.hasDebugFlag(128)) {
                sess.debugPrintln("Pathconf error=" + NFS.getStatusString(errorSts));
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procCommit(NFSSrvSession sess, RpcPacket rpc) {
        if (this.hasDebugFlag(64)) {
            sess.debugPrintln("Commit request from " + rpc.getClientDetails());
        }
        rpc.buildResponseHeader();
        rpc.packInt(0);
        this.packWccData(rpc, null);
        this.packPostOpAttr(sess, null, 0, rpc);
        rpc.packLong(this.m_writeVerifier);
        rpc.setLength();
        return rpc;
    }

    private final NFSSrvSession findSessionForRequest(RpcPacket rpc) throws RpcAuthenticationException {
        NFSSrvSession sess;
        boolean authFailed;
        block10: {
            int authType = rpc.getCredentialsType();
            authFailed = true;
            sess = null;
            try {
                Object sessKey = this.getRpcAuthenticator().authenticateRpcClient(authType, rpc);
                switch (authType) {
                    case 0: {
                        sess = this.findAuthNullSession(rpc, sessKey);
                        break;
                    }
                    case 1: {
                        sess = this.findAuthUnixSession(rpc, sessKey);
                    }
                }
                if (sess != null) {
                    this.getRpcAuthenticator().setCurrentUser(sess, sess.getClientInformation());
                    authFailed = false;
                    if (this.hasDebugFlag(1024)) {
                        Debug.println("[NFS] Found session " + sess + ", client=" + sess.getClientInformation());
                    }
                }
            }
            catch (Throwable ex) {
                if (!this.hasDebugFlag(128)) break block10;
                Debug.println("[NFS] RPC Authencation Exception: " + ex.toString());
            }
        }
        if (authFailed) {
            rpc.positionAtParameters();
            if (rpc.getProcedureId() != 0) {
                throw new RpcAuthenticationException(1);
            }
        }
        return sess;
    }

    private final NFSSrvSession findAuthNullSession(RpcPacket rpc, Object sessKey) {
        NFSSrvSession sess = null;
        if (this.m_sessAuthNull != null) {
            sess = this.m_sessAuthNull.findSession(sessKey);
        } else {
            this.m_sessAuthNull = new NFSSessionTable();
        }
        if (sess == null) {
            sess = new NFSSrvSession(this, rpc.getClientAddress(), rpc.getClientPort(), rpc.getClientProtocol());
            sess.setAuthIdentifier(sessKey);
            sess.setClientInformation(this.getRpcAuthenticator().getRpcClientInformation(sessKey, rpc));
            this.m_sessAuthNull.addSession(sess);
            sess.setUniqueId("" + sessKey.hashCode());
            sess.setDebugPrefix("[NFS_AN_" + this.getNextSessionId() + "] ");
            sess.setDebug(this.getNFSConfiguration().getNFSDebug());
            if (this.hasDebugFlag(1024)) {
                Debug.println("[NFS] Added Null session " + sess.getUniqueId());
            }
        }
        return sess;
    }

    private final NFSSrvSession findAuthUnixSession(RpcPacket rpc, Object sessKey) {
        NFSSrvSession sess = null;
        if (this.m_sessAuthUnix != null) {
            sess = this.m_sessAuthUnix.findSession(sessKey);
        } else {
            this.m_sessAuthUnix = new NFSSessionTable();
        }
        if (sess == null) {
            sess = new NFSSrvSession(this, rpc.getClientAddress(), rpc.getClientPort(), rpc.getClientProtocol());
            sess.setAuthIdentifier(sessKey);
            sess.setUniqueId("" + sessKey.hashCode());
            sess.setDebugPrefix("[NFS_AU_" + this.getNextSessionId() + "] ");
            sess.setDebug(this.getNFSConfiguration().getNFSDebug());
            sess.setNFSClientInformation(this.getRpcAuthenticator().getRpcClientInformation(sessKey, rpc));
            sess.setClientInformation(sess.getNFSClientInformation());
            this.m_sessAuthUnix.addSession(sess);
            if (this.hasDebugFlag(1024)) {
                Debug.println("[NFS] Added Unix session " + sess.getUniqueId());
            }
        } else {
            sess.setClientInformation(sess.getNFSClientInformation());
        }
        return sess;
    }

    protected final void packAttributes3(RpcPacket rpc, FileInfo finfo, int fileSysId) {
        if (finfo.isDirectory()) {
            rpc.packInt(2);
            if (finfo.hasMode()) {
                rpc.packInt(finfo.getMode());
            } else {
                rpc.packInt(16895);
            }
        } else {
            if (finfo.isFileType() == 3) {
                rpc.packInt(5);
            } else {
                rpc.packInt(1);
            }
            if (finfo.hasMode()) {
                rpc.packInt(finfo.getMode());
            } else {
                rpc.packInt(33279);
            }
        }
        rpc.packInt(1);
        rpc.packInt(finfo.hasUid() ? finfo.getUid() : 0);
        rpc.packInt(finfo.hasGid() ? finfo.getGid() : 0);
        if (finfo.isDirectory()) {
            rpc.packLong(512L);
            rpc.packLong(1024L);
        } else {
            rpc.packLong(finfo.getSize());
            if (finfo.getAllocationSize() != 0L) {
                rpc.packLong(finfo.getAllocationSize());
            } else {
                rpc.packLong(finfo.getSize());
            }
        }
        rpc.packInt(0);
        rpc.packInt(0);
        long fid = (long)finfo.getFileId() & 0xFFFFFFFFL;
        rpc.packLong(fileSysId);
        rpc.packLong(fid += 2L);
        if (finfo.hasAccessDateTime()) {
            rpc.packInt((int)(finfo.getAccessDateTime() / 1000L));
            rpc.packInt(0);
        } else {
            rpc.packLong(0L);
        }
        if (finfo.hasModifyDateTime()) {
            rpc.packInt((int)(finfo.getModifyDateTime() / 1000L));
            rpc.packInt(0);
        } else {
            rpc.packLong(0L);
        }
        if (finfo.hasChangeDateTime()) {
            rpc.packInt((int)(finfo.getChangeDateTime() / 1000L));
            rpc.packInt(0);
        } else {
            rpc.packLong(0L);
        }
    }

    protected final void packShareHandle(String shareName, RpcPacket rpc) {
        rpc.packInt(1);
        NFSHandle.packShareHandle(shareName, rpc, 32);
    }

    protected final void packDirectoryHandle(int shareId, int dirId, RpcPacket rpc) {
        rpc.packInt(1);
        NFSHandle.packDirectoryHandle(shareId, dirId, rpc, 32);
    }

    protected final void packFileHandle(int shareId, int dirId, int fileId, RpcPacket rpc) {
        rpc.packInt(1);
        NFSHandle.packFileHandle(shareId, dirId, fileId, rpc, 32);
    }

    protected final int getShareIdFromHandle(byte[] handle) throws BadHandleException {
        int shareId = NFSHandle.unpackShareId(handle);
        if (shareId == -1) {
            throw new BadHandleException();
        }
        return shareId;
    }

    protected final String getPathForHandle(NFSSrvSession sess, byte[] handle, TreeConnection tree) throws BadHandleException, StaleHandleException {
        ShareDetails details = this.m_shareDetails.findDetails(this.getShareIdFromHandle(handle));
        String path = null;
        int dirId = -1;
        int fileId = -1;
        if (NFSHandle.isShareHandle(handle)) {
            path = DOS_SEPERATOR;
        } else if (NFSHandle.isDirectoryHandle(handle)) {
            dirId = NFSHandle.unpackDirectoryId(handle);
            path = details.getFileIdCache().findPath(dirId);
        } else if (NFSHandle.isFileHandle(handle)) {
            fileId = NFSHandle.unpackFileId(handle);
            path = details.getFileIdCache().findPath(fileId);
        } else {
            throw new BadHandleException();
        }
        if (path == null) {
            if (details.hasFileIdSupport()) {
                dirId = NFSHandle.unpackDirectoryId(handle);
                fileId = NFSHandle.unpackFileId(handle);
                if (fileId == -1) {
                    fileId = dirId;
                    dirId = -1;
                }
                FileIdInterface fileIdInterface = (FileIdInterface)((Object)tree.getInterface());
                try {
                    path = fileIdInterface.buildPathForFileId(sess, tree, dirId, fileId);
                    details.getFileIdCache().addPath(fileId, path);
                }
                catch (FileNotFoundException ex) {}
            } else if (NFSHandle.isDirectoryHandle(handle) && dirId == 0) {
                path = DOS_SEPERATOR;
                details.getFileIdCache().addPath(dirId, path);
            }
        }
        if (path == null) {
            throw new StaleHandleException();
        }
        return path;
    }

    protected final byte[] getHandleForFile(NFSSrvSession sess, byte[] handle, TreeConnection tree, String fname) throws BadHandleException, StaleHandleException {
        int shareId = this.getShareIdFromHandle(handle);
        ShareDetails details = this.m_shareDetails.findDetails(shareId);
        String path = null;
        int dirId = -1;
        int fileId = -1;
        if (NFSHandle.isDirectoryHandle(handle)) {
            dirId = NFSHandle.unpackDirectoryId(handle);
            path = details.getFileIdCache().findPath(dirId);
        } else if (NFSHandle.isShareHandle(handle)) {
            dirId = 0;
            path = DOS_SEPERATOR;
        } else {
            throw new BadHandleException();
        }
        byte[] fHandle = null;
        try {
            FileInfo finfo;
            DiskInterface disk = (DiskInterface)tree.getSharedDevice().getInterface();
            String filePath = this.generatePath(path, fname);
            int fsts = disk.fileExists(sess, tree, filePath);
            if ((fsts == 1 || fsts == 2) && (finfo = disk.getFileInformation(sess, tree, filePath)) != null) {
                fileId = finfo.getFileId();
                fHandle = new byte[32];
                if (finfo.isDirectory()) {
                    NFSHandle.packDirectoryHandle(shareId, dirId, fHandle);
                } else {
                    NFSHandle.packFileHandle(shareId, dirId, fileId, fHandle);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (fHandle == null) {
            throw new BadHandleException();
        }
        return fHandle;
    }

    protected final int getFileIdForHandle(byte[] handle) throws BadHandleException {
        int fileId = -1;
        if (NFSHandle.isShareHandle(handle)) {
            fileId = 0;
        } else if (NFSHandle.isDirectoryHandle(handle)) {
            fileId = NFSHandle.unpackDirectoryId(handle);
        } else if (NFSHandle.isFileHandle(handle)) {
            fileId = NFSHandle.unpackFileId(handle);
        }
        if (fileId == -1) {
            throw new BadHandleException();
        }
        return fileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final NetworkFile getNetworkFileForHandle(NFSSrvSession sess, byte[] handle, TreeConnection conn, boolean readOnly) throws BadHandleException, StaleHandleException {
        if (!NFSHandle.isFileHandle(handle)) {
            throw new BadHandleException("Not a file handle");
        }
        int fileId = this.getFileIdForHandle(handle);
        NetworkFileCache fileCache = sess.getFileCache();
        NetworkFile file = null;
        NetworkFileCache networkFileCache = fileCache;
        synchronized (networkFileCache) {
            file = fileCache.findFile(fileId, sess);
            if (file == null || file.getGrantedAccess() == 1 && !readOnly) {
                String path = this.getPathForHandle(sess, handle, conn);
                if (path == null) {
                    throw new StaleHandleException();
                }
                try {
                    FileOpenParams params;
                    DiskInterface disk;
                    if (file != null) {
                        file.closeFile();
                    }
                    if ((file = (disk = (DiskInterface)conn.getSharedDevice().getInterface()).openFile(sess, conn, params = new FileOpenParams(path, 1, readOnly ? 0 : 2, 0, 0))) != null) {
                        fileCache.addFile(file, conn, sess);
                    }
                }
                catch (AccessDeniedException ex) {
                    if (this.hasDebug()) {
                        Debug.println(ex);
                    }
                }
                catch (Exception ex) {
                    Debug.println(ex);
                }
            } else if (file.getGrantedAccess() != 1 || !readOnly) {
                // empty if block
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final NetworkFile getOpenNetworkFileForHandle(NFSSrvSession sess, byte[] handle, TreeConnection conn) throws BadHandleException, StaleHandleException {
        if (!NFSHandle.isFileHandle(handle)) {
            return null;
        }
        int fileId = this.getFileIdForHandle(handle);
        NetworkFileCache fileCache = sess.getFileCache();
        NetworkFile file = null;
        NetworkFileCache networkFileCache = fileCache;
        synchronized (networkFileCache) {
            file = fileCache.findFile(fileId, sess);
        }
        return file;
    }

    protected final TreeConnection getTreeConnection(NFSSrvSession sess, int shareId) throws BadHandleException {
        TreeConnection conn = sess.findConnection(shareId);
        if (conn == null) {
            TreeConnection template = this.m_connections.findConnection(shareId);
            if (template == null && this.checkForNewShares() > 0) {
                template = this.m_connections.findConnection(shareId);
            }
            if (template == null) {
                throw new BadHandleException();
            }
            if (this.hasAccessControlManager()) {
                AccessControlManager aclMgr = this.getAccessControlManager();
                int sharePerm = aclMgr.checkAccessControl(sess, template.getSharedDevice());
                if (sharePerm == 0) {
                    throw new BadHandleException();
                }
                if (sharePerm == -1) {
                    sharePerm = 2;
                }
                conn = new TreeConnection(template.getSharedDevice());
                conn.setPermission(sharePerm);
                sess.addConnection(conn);
            } else {
                conn = new TreeConnection(template.getSharedDevice());
                conn.setPermission(2);
                sess.addConnection(conn);
            }
        }
        return conn;
    }

    protected final void packWccData(RpcPacket rpc, FileInfo finfo) {
        if (finfo != null) {
            rpc.packInt(1);
            if (finfo.isDirectory()) {
                rpc.packLong(512L);
            } else {
                rpc.packLong(finfo.getSize());
            }
            if (finfo.hasModifyDateTime()) {
                rpc.packInt((int)(finfo.getModifyDateTime() / 1000L));
                rpc.packInt(0);
            } else {
                rpc.packLong(0L);
            }
            if (finfo.hasChangeDateTime()) {
                rpc.packInt((int)(finfo.getChangeDateTime() / 1000L));
                rpc.packInt(0);
            } else {
                rpc.packLong(0L);
            }
        } else {
            rpc.packInt(0);
        }
    }

    protected final boolean pathHasDirectories(String fpath) {
        if (fpath == null || fpath.length() == 0) {
            return false;
        }
        if (fpath.startsWith(DOS_SEPERATOR) || fpath.startsWith(UNIX_SEPERATOR) || fpath.startsWith("..")) {
            return true;
        }
        return fpath.indexOf(DOS_SEPERATOR) != -1 || fpath.indexOf(UNIX_SEPERATOR) != -1;
    }

    protected final void packPreOpAttr(NFSSrvSession sess, FileInfo finfo, RpcPacket rpc) {
        if (finfo != null) {
            this.packWccData(rpc, finfo);
        } else {
            rpc.packInt(0);
        }
    }

    protected final void packPreOpAttr(NFSSrvSession sess, TreeConnection conn, byte[] fhandle, RpcPacket rpc) throws BadHandleException, StaleHandleException, InvalidDeviceInterfaceException, IOException {
        String path = this.getPathForHandle(sess, fhandle, conn);
        DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
        FileInfo finfo = disk.getFileInformation(sess, conn, path);
        this.packWccData(rpc, finfo);
    }

    protected final void packPostOpAttr(NFSSrvSession sess, TreeConnection conn, byte[] fhandle, RpcPacket rpc) throws BadHandleException, StaleHandleException, InvalidDeviceInterfaceException, IOException {
        String path = this.getPathForHandle(sess, fhandle, conn);
        DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
        FileInfo finfo = disk.getFileInformation(sess, conn, path);
        if (finfo != null) {
            rpc.packInt(1);
            this.packAttributes3(rpc, finfo, this.getShareIdFromHandle(fhandle));
        } else {
            rpc.packInt(0);
        }
    }

    protected final void packPostOpAttr(NFSSrvSession sess, FileInfo finfo, int fileSysId, RpcPacket rpc) {
        if (finfo != null) {
            rpc.packInt(1);
            this.packAttributes3(rpc, finfo, fileSysId);
        } else {
            rpc.packInt(0);
        }
    }

    protected final String generatePath(String dirPath, String argPath) {
        StringBuffer pathBuf = new StringBuffer();
        if (argPath.equals("..")) {
            String[] dirs = FileName.splitAllPaths(dirPath);
            pathBuf.append(DOS_SEPERATOR);
            int dirCnt = dirs.length - 1;
            if (dirCnt > 0) {
                for (int i = 0; i < dirCnt; ++i) {
                    pathBuf.append(dirs[i]);
                    pathBuf.append(DOS_SEPERATOR);
                }
            }
            if (pathBuf.length() > 1) {
                pathBuf.setLength(pathBuf.length() - 1);
            }
        } else {
            pathBuf.append(dirPath);
            if (!dirPath.endsWith(DOS_SEPERATOR)) {
                pathBuf.append(DOS_SEPERATOR);
            }
            if (!argPath.equals(".")) {
                pathBuf.append(argPath);
            }
        }
        return pathBuf.toString();
    }

    protected final int checkForNewShares() {
        SharedDeviceList shareList = this.getShareMapper().getShareList(this.getConfiguration().getServerName(), null, false);
        Enumeration<SharedDevice> shares = shareList.enumerateShares();
        int newShares = 0;
        while (shares.hasMoreElements()) {
            SharedDevice share = shares.nextElement();
            if (share == null || share.getType() != 0) continue;
            boolean fileIdSupport = false;
            try {
                if (share.getInterface() instanceof FileIdInterface) {
                    fileIdSupport = true;
                }
            }
            catch (InvalidDeviceInterfaceException ex) {
                // empty catch block
            }
            if (this.m_shareDetails.findDetails(share.getName()) != null) continue;
            this.m_shareDetails.addDetails(new ShareDetails(share.getName(), fileIdSupport));
            this.m_connections.addConnection(new TreeConnection(share));
            ++newShares;
        }
        return newShares;
    }

    protected final synchronized int getNextSessionId() {
        return this.m_sessId++;
    }

    protected final RpcAuthenticator getRpcAuthenticator() {
        return this.m_rpcAuthenticator;
    }

    public ShareDetailsHash getShareDetails() {
        return this.m_shareDetails;
    }

    protected final void fireSessionOpened(SrvSession sess) {
        this.fireSessionOpenEvent(sess);
    }

    protected final void fireSessionClosed(SrvSession sess) {
        this.fireSessionClosedEvent(sess);
    }
}

