/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.XRFFLoader;
import weka.core.xml.XMLInstances;

public class XRFFSaver
extends AbstractFileSaver
implements BatchConverter {
    private static final long serialVersionUID = -7226404765213522043L;
    protected SingleIndex m_ClassIndex = new SingleIndex();
    protected XMLInstances m_XMLInstances;
    protected boolean m_CompressOutput = false;

    public XRFFSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in the XML version of the ARFF format. The data can be compressed with gzip, in order to save space.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe class index (first and last are valid as well).\n\t(default: last)", "C", 1, "-C <class index>"));
        result.addElement(new Option("\tCompresses the data (uses '" + XRFFLoader.FILE_EXTENSION_COMPRESSED + "' as extension instead of '" + XRFFLoader.FILE_EXTENSION + "')\n" + "\t(default: off)", "compress", 0, "-compress"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getClassIndex().length() != 0) {
            result.add("-C");
            result.add(this.getClassIndex());
        }
        if (this.getCompressOutput()) {
            result.add("-compress");
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setClassIndex(tmpStr);
        } else {
            this.setClassIndex("last");
        }
        this.setCompressOutput(Utils.getFlag("compress", options));
        super.setOptions(options);
    }

    @Override
    public String getFileDescription() {
        return "XRFF data files";
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{XRFFLoader.FILE_EXTENSION, XRFFLoader.FILE_EXTENSION_COMPRESSED};
    }

    @Override
    public void setFile(File outputFile) throws IOException {
        if (outputFile.getAbsolutePath().endsWith(XRFFLoader.FILE_EXTENSION_COMPRESSED)) {
            this.setCompressOutput(true);
        }
        super.setFile(outputFile);
    }

    @Override
    public void resetOptions() {
        super.resetOptions();
        if (this.getCompressOutput()) {
            this.setFileExtension(XRFFLoader.FILE_EXTENSION_COMPRESSED);
        } else {
            this.setFileExtension(XRFFLoader.FILE_EXTENSION);
        }
        try {
            this.m_XMLInstances = new XMLInstances();
        }
        catch (Exception e) {
            this.m_XMLInstances = null;
        }
    }

    public String classIndexTipText() {
        return "Sets the class index (\"first\" and \"last\" are valid values)";
    }

    public String getClassIndex() {
        return this.m_ClassIndex.getSingleIndex();
    }

    public void setClassIndex(String value) {
        this.m_ClassIndex.setSingleIndex(value);
    }

    public String compressOutputTipText() {
        return "Optional compression of the output data";
    }

    public boolean getCompressOutput() {
        return this.m_CompressOutput;
    }

    public void setCompressOutput(boolean value) {
        this.m_CompressOutput = value;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void setInstances(Instances instances) {
        if (this.m_ClassIndex.getSingleIndex().length() != 0) {
            this.m_ClassIndex.setUpper(instances.numAttributes() - 1);
            instances.setClassIndex(this.m_ClassIndex.getIndex());
        }
        super.setInstances(instances);
    }

    @Override
    public void setDestination(OutputStream output) throws IOException {
        if (this.getCompressOutput()) {
            super.setDestination(new GZIPOutputStream(output));
        } else {
            super.setDestination(output);
        }
    }

    @Override
    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        this.m_XMLInstances.setInstances(this.getInstances());
        if (this.retrieveFile() == null && this.getWriter() == null) {
            System.out.println(this.m_XMLInstances.toString());
            this.setWriteMode(1);
        } else {
            PrintWriter outW = new PrintWriter(this.getWriter());
            outW.println(this.m_XMLInstances.toString());
            outW.flush();
            outW.close();
            this.setWriteMode(1);
            outW = null;
            this.resetWriter();
            this.setWriteMode(2);
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }

    public static void main(String[] args) {
        XRFFSaver.runFileSaver(new XRFFSaver(), args);
    }
}

