/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableParallelIteratedSingleClassifierEnhancer;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.trees.REPTree;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.unsupervised.attribute.Remove;

public class RandomSubSpace
extends RandomizableParallelIteratedSingleClassifierEnhancer
implements WeightedInstancesHandler,
TechnicalInformationHandler {
    private static final long serialVersionUID = 1278172513912424947L;
    protected double m_SubSpaceSize = 0.5;
    protected Classifier m_ZeroR;
    protected Instances m_data;

    public RandomSubSpace() {
        this.m_Classifier = new REPTree();
    }

    public String globalInfo() {
        return "This method constructs a decision tree based classifier that maintains highest accuracy on training data and improves on generalization accuracy as it grows in complexity. The classifier consists of multiple trees constructed systematically by pseudorandomly selecting subsets of components of the feature vector, that is, trees constructed in randomly chosen subspaces.\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Tin Kam Ho");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "The Random Subspace Method for Constructing Decision Forests");
        result.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Transactions on Pattern Analysis and Machine Intelligence");
        result.setValue(TechnicalInformation.Field.VOLUME, "20");
        result.setValue(TechnicalInformation.Field.NUMBER, "8");
        result.setValue(TechnicalInformation.Field.PAGES, "832-844");
        result.setValue(TechnicalInformation.Field.URL, "http://citeseer.ist.psu.edu/ho98random.html");
        result.setValue(TechnicalInformation.Field.ISSN, "0162-8828");
        return result;
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.REPTree";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSize of each subspace:\n\t\t< 1: percentage of the number of attributes\n\t\t>=1: absolute number of attributes\n", "P", 1, "-P"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('P', options);
        if (tmpStr.length() != 0) {
            this.setSubSpaceSize(Double.parseDouble(tmpStr));
        } else {
            this.setSubSpaceSize(0.5);
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-P");
        result.add("" + this.getSubSpaceSize());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String subSpaceSizeTipText() {
        return "Size of each subSpace: if less than 1 as a percentage of the number of attributes, otherwise the absolute number of attributes.";
    }

    public double getSubSpaceSize() {
        return this.m_SubSpaceSize;
    }

    public void setSubSpaceSize(double value) {
        this.m_SubSpaceSize = value;
    }

    protected int numberOfAttributes(int total, double fraction) {
        int k = (int)Math.round(fraction < 1.0 ? (double)total * fraction : fraction);
        if (k > total) {
            k = total;
        }
        if (k < 1) {
            k = 1;
        }
        return k;
    }

    protected String randomSubSpace(Integer[] indices, int subSpaceSize, int classIndex, Random random) {
        Collections.shuffle(Arrays.asList(indices), random);
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < subSpaceSize; ++i) {
            sb.append(indices[i] + ",");
        }
        sb.append(classIndex);
        if (this.getDebug()) {
            System.out.println("subSPACE = " + sb);
        }
        return sb.toString();
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_data = new Instances(data);
        if (this.m_data.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(this.m_data);
            return;
        }
        this.m_ZeroR = null;
        super.buildClassifier(data);
        Integer[] indices = new Integer[data.numAttributes() - 1];
        int classIndex = data.classIndex();
        int offset = 0;
        for (int i = 0; i < indices.length + 1; ++i) {
            if (i == classIndex) continue;
            indices[offset++] = i + 1;
        }
        int subSpaceSize = this.numberOfAttributes(indices.length, this.getSubSpaceSize());
        Random random = data.getRandomNumberGenerator(this.m_Seed);
        for (int j = 0; j < this.m_Classifiers.length; ++j) {
            if (this.m_Classifier instanceof Randomizable) {
                ((Randomizable)((Object)this.m_Classifiers[j])).setSeed(random.nextInt());
            }
            FilteredClassifier fc = new FilteredClassifier();
            fc.setClassifier(this.m_Classifiers[j]);
            this.m_Classifiers[j] = fc;
            Remove rm = new Remove();
            rm.setOptions(new String[]{"-V", "-R", this.randomSubSpace(indices, subSpaceSize, classIndex + 1, random)});
            fc.setFilter(rm);
        }
        this.buildClassifiers();
        this.m_data = null;
    }

    @Override
    protected synchronized Instances getTrainingSet(int iteration) throws Exception {
        return this.m_data;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        double[] sums = new double[instance.numClasses()];
        double numPreds = 0.0;
        for (int i = 0; i < this.m_NumIterations; ++i) {
            if (instance.classAttribute().isNumeric()) {
                double pred = this.m_Classifiers[i].classifyInstance(instance);
                if (Utils.isMissingValue(pred)) continue;
                sums[0] = sums[0] + pred;
                numPreds += 1.0;
                continue;
            }
            double[] newProbs = this.m_Classifiers[i].distributionForInstance(instance);
            for (int j = 0; j < newProbs.length; ++j) {
                int n = j;
                sums[n] = sums[n] + newProbs[j];
            }
        }
        if (instance.classAttribute().isNumeric()) {
            sums[0] = numPreds == 0.0 ? Utils.missingValue() : sums[0] / numPreds;
            return sums;
        }
        if (Utils.eq(Utils.sum(sums), 0.0)) {
            return sums;
        }
        Utils.normalize(sums);
        return sums;
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            buf.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            buf.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            buf.append(this.m_ZeroR.toString());
            return buf.toString();
        }
        if (this.m_Classifiers == null) {
            return "RandomSubSpace: No model built yet.";
        }
        StringBuffer text = new StringBuffer();
        text.append("All the base classifiers: \n\n");
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            text.append(this.m_Classifiers[i].toString() + "\n\n");
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11461 $");
    }

    public static void main(String[] args) {
        RandomSubSpace.runClassifier(new RandomSubSpace(), args);
    }
}

