/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import java.util.HashMap;
import java.util.Map;

public enum Type {
    NUMBER('N'),
    FLOAT('F'),
    CHARACTER('C'),
    LOGICAL('L', 1),
    DATE('D', 8),
    MEMO('M', 10),
    GENERAL('G', 10),
    PICTURE('P', 10),
    BINARY('B', 10);

    private static final Map<Character, Type> typeMap;
    private final char code;
    private final int length;

    private Type(char code) {
        this(code, -1);
    }

    private Type(char code, int length) {
        this.code = code;
        this.length = length;
    }

    char getCode() {
        return this.code;
    }

    static Type getTypeByCode(char code) {
        return typeMap.get(Character.valueOf(code));
    }

    int getLength() {
        return this.length;
    }

    static {
        typeMap = new HashMap<Character, Type>();
        for (Type type : Type.values()) {
            typeMap.put(Character.valueOf(type.getCode()), type);
        }
    }
}

