/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.listeners.tcp.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import javax.jms.JMSException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.jmx.JMXAgent;
import net.timewalker.ffmq4.listeners.ClientProcessor;
import net.timewalker.ffmq4.listeners.tcp.AbstractTcpClientListener;
import net.timewalker.ffmq4.listeners.tcp.io.TcpListenerMBean;
import net.timewalker.ffmq4.local.FFMQEngine;
import net.timewalker.ffmq4.transport.PacketTransport;
import net.timewalker.ffmq4.transport.PacketTransportException;
import net.timewalker.ffmq4.transport.tcp.io.TcpPacketTransport;
import net.timewalker.ffmq4.utils.Settings;
import net.timewalker.ffmq4.utils.id.UUIDProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TcpListener
extends AbstractTcpClientListener
implements Runnable,
TcpListenerMBean {
    private static final Log log = LogFactory.getLog(TcpListener.class);
    private ServerSocket serverSocket;
    private Thread listenerThread;
    private boolean stopRequired = false;
    private boolean usingSSL;

    public TcpListener(FFMQEngine engine, String listenAddr, int port, Settings settings) {
        this(engine, listenAddr, port, settings, null);
    }

    public TcpListener(FFMQEngine engine, String listenAddr, int port, Settings settings, JMXAgent jmxAgent) {
        super(engine, settings, jmxAgent, listenAddr, port);
        this.usingSSL = settings.getBooleanProperty("transport.tcp.ssl.enabled", false);
    }

    @Override
    public synchronized void start() throws JMSException {
        if (this.started) {
            return;
        }
        log.info((Object)("Starting listener [" + this.getName() + "]"));
        this.stopRequired = false;
        this.initServerSocket();
        this.listenerThread = new Thread((Runnable)this, "FFMQ-TCP-Server-" + this.serverSocket.getLocalPort());
        this.listenerThread.start();
        this.started = true;
    }

    @Override
    public String getName() {
        return (this.usingSSL ? "tcps" : "tcp") + "-" + this.listenAddr + "-" + this.listenPort;
    }

    private void initServerSocket() throws JMSException {
        try {
            InetAddress bindAddress = this.getBindAddress();
            int tcpBackLog = this.settings.getIntProperty("listener.tcp.backLog", 50);
            log.debug((Object)("TCP back log = " + tcpBackLog));
            this.serverSocket = this.createServerSocket(this.listenPort, tcpBackLog, bindAddress, this.usingSSL);
            this.serverSocket.setReuseAddress(true);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FFMQException("Could not initialize server socket", "NETWORK_ERROR", (Throwable)e);
        }
    }

    private void closeServerSocket() {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"Could not close server socket", (Throwable)e);
        }
        finally {
            this.serverSocket = null;
        }
    }

    @Override
    public void run() {
        block10: {
            try {
                log.debug((Object)("Waiting for clients [" + this.getName() + "]"));
                while (!this.stopRequired) {
                    Socket clientSocket = this.serverSocket.accept();
                    int activeClients = this.getActiveClients();
                    if (activeClients >= this.listenerCapacity) {
                        log.warn((Object)("Listener is full (max=" + this.listenerCapacity + "), dropping new connection attempt."));
                        try {
                            clientSocket.close();
                        }
                        catch (Exception e) {
                            log.error((Object)"Cannot close incoming connection", (Throwable)e);
                        }
                        continue;
                    }
                    String clientId = UUIDProvider.getInstance().getShortUUID();
                    log.debug((Object)("Accepting a new client from " + clientSocket.getInetAddress().getHostAddress() + " (" + (activeClients + 1) + ") : " + clientId + " [" + this.getName() + "]"));
                    try {
                        ClientProcessor processor = this.createProcessor(clientId, clientSocket);
                        this.registerClient(processor);
                        processor.start();
                    }
                    catch (Exception e) {
                        try {
                            clientSocket.close();
                        }
                        catch (Exception ex) {
                            log.error((Object)("Could not close socket [" + this.getName() + "]"), (Throwable)ex);
                        }
                        log.error((Object)("Client failed : " + clientId + " [" + this.getName() + "]"), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (this.stopRequired) break block10;
                log.fatal((Object)("Server failed [" + this.getName() + "]"), (Throwable)e);
            }
        }
    }

    protected ClientProcessor createProcessor(String clientId, Socket clientSocket) throws PacketTransportException {
        TcpPacketTransport transport = new TcpPacketTransport(clientId, clientSocket, this.settings);
        ClientProcessor clientProcessor = new ClientProcessor(clientId, this, this.localEngine, (PacketTransport)transport);
        return clientProcessor;
    }

    @Override
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        log.info((Object)("Stopping listener [" + this.getName() + "]"));
        this.stopRequired = true;
        this.closeServerSocket();
        try {
            if (this.listenerThread != null) {
                this.listenerThread.join();
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"Wait for listener thread termination was interrupted");
        }
        finally {
            this.listenerThread = null;
        }
        this.closeRemainingClients();
        this.started = false;
    }

    private ServerSocket createServerSocket(int port, int tcpBackLog, InetAddress localAddr, boolean useSSL) throws JMSException {
        try {
            if (useSSL) {
                SSLServerSocket socket = (SSLServerSocket)this.createSSLContext().getServerSocketFactory().createServerSocket(port, tcpBackLog, localAddr);
                socket.setNeedClientAuth(false);
                return socket;
            }
            return new ServerSocket(port, tcpBackLog, localAddr);
        }
        catch (Exception e) {
            throw new FFMQException("Cannot create server socket", "NETWORK_ERROR", (Throwable)e);
        }
    }

    private SSLContext createSSLContext() throws JMSException {
        try {
            String sslProtocol = this.settings.getStringProperty("transport.tcp.ssl.protocol", "SSLv3");
            String keyManagerAlgorithm = this.settings.getStringProperty("transport.tcp.ssl.keyManager.algorithm", "SunX509");
            String keyStoreType = this.settings.getStringProperty("transport.tcp.ssl.keyStore.type", "JKS");
            String keyStorePath = this.settings.getStringProperty("transport.tcp.ssl.keyStore.path", "../conf/server-keystore.jks");
            String keyStorePass = this.settings.getStringProperty("transport.tcp.ssl.keyStore.password", "ffmqpass");
            String keyPass = this.settings.getStringProperty("transport.tcp.ssl.keyStore.keyPassword", "ffmqpass");
            SSLContext sslContext = SSLContext.getInstance(sslProtocol);
            log.debug((Object)("Created an SSL context : protocol=[" + sslContext.getProtocol() + "] provider=[" + sslContext.getProvider() + "]"));
            File keyStoreFile = new File(keyStorePath);
            if (!keyStoreFile.canRead()) {
                throw new FFMQException("Cannot read keystore file : " + keyStoreFile.getAbsolutePath(), "FS_ERROR");
            }
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            log.debug((Object)("Created keystore : type=[" + ks.getType() + "] provider=[" + ks.getProvider() + "]"));
            char[] ksPass = keyStorePass.toCharArray();
            char[] ctPass = keyPass.toCharArray();
            log.debug((Object)("Loading keystore from " + keyStoreFile.getAbsolutePath()));
            FileInputStream kis = new FileInputStream(keyStoreFile);
            ks.load(kis, ksPass);
            ((InputStream)kis).close();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerAlgorithm);
            log.debug((Object)("Created KeyManagerFactory : algorithm=[" + kmf.getAlgorithm() + "] provider=[" + kmf.getProvider() + "]"));
            log.debug((Object)"Initializing KeyManagerFactory with keystore ...");
            kmf.init(ks, ctPass);
            KeyManager[] keyManagers = kmf.getKeyManagers();
            sslContext.init(keyManagers, null, null);
            return sslContext;
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FFMQException("Cannot create SSL context", "NETWORK_ERROR", (Throwable)e);
        }
    }
}

