/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import net.timewalker.ffmq4.common.message.selector.expression.utils.StringUtils;
import net.timewalker.ffmq4.management.ManagementUtils;
import net.timewalker.ffmq4.utils.InetUtils;
import net.timewalker.ffmq4.utils.Settings;
import net.timewalker.ffmq4.utils.pool.ObjectPool;

public final class FFMQJMXConsole
implements Runnable {
    private Settings settings;
    private JMXServiceURL jmxServiceURL;
    private JMXConnector connector;
    private MBeanServerConnection connection;
    private boolean stopRequired;
    private PrintStream out;
    private PrintStream err;
    private BufferedReader in;

    public FFMQJMXConsole(Settings settings, InputStream in, PrintStream out, PrintStream err) {
        this.settings = settings;
        this.in = new BufferedReader(new InputStreamReader(in));
        this.out = out;
        this.err = err;
    }

    @Override
    public void run() {
        try {
            String serverHost = InetUtils.resolveAutoInterfaceAddress(this.settings.getStringProperty("jmx.console.server.host", "localhost"));
            int serverPort = this.settings.getIntProperty("jmx.console.server.port", 10003);
            String serviceUrl = "service:jmx:rmi://" + serverHost + "/jndi/rmi://" + serverHost + ":" + serverPort + "/jmxconnector-FFMQ-server";
            this.out.println("JMX Service URL : " + serviceUrl);
            this.jmxServiceURL = new JMXServiceURL(serviceUrl);
            this.printServerVersion();
            boolean interactive = this.settings.getBooleanProperty("jmx.console.interactive", false);
            if (interactive) {
                this.interactiveMode();
            } else {
                String command = this.settings.getStringProperty("jmx.console.command", "help");
                this.processCommand(command);
            }
        }
        catch (Exception e) {
            this.closeJMXResources();
            this.handleException(e);
        }
    }

    private void interactiveMode() throws Exception {
        this.out.println("FFMQ JMX Console");
        this.out.println("----------------");
        while (!this.stopRequired) {
            this.out.print("> ");
            this.out.flush();
            String command = this.in.readLine();
            if (command == null) break;
            command = command.trim();
            try {
                if (command.length() <= 0) continue;
                this.processCommand(command);
            }
            catch (Exception e) {
                this.closeJMXResources();
                this.handleException(e);
            }
        }
    }

    private String[] splitCommand(String command) {
        StringTokenizer st = new StringTokenizer(command, " \t");
        String[] tokens = new String[st.countTokens()];
        int pos = 0;
        while (st.hasMoreTokens()) {
            tokens[pos++] = st.nextToken();
        }
        return tokens;
    }

    private void processCommand(String command) throws Exception {
        String[] commandTokens = this.splitCommand(command);
        switch (commandTokens.length) {
            case 1: {
                if (command.equals("help")) {
                    this.printHelp();
                    break;
                }
                if (command.equals("serverstatus")) {
                    this.printServerStatus();
                    break;
                }
                if (command.equals("enginesstatus")) {
                    this.printEnginesStatus();
                    break;
                }
                if (command.equals("listenersstatus")) {
                    this.printListenersStatus();
                    break;
                }
                if (command.equals("bridgesstatus")) {
                    this.printBridgesStatus();
                    break;
                }
                if (command.equals("fullstatus")) {
                    this.printFullStatus();
                    break;
                }
                if (command.equals("quit") || command.equals("exit")) {
                    this.stopRequired = true;
                    this.out.println("Exiting.");
                    break;
                }
                this.err.println("Invalid command : " + command);
                break;
            }
            case 2: {
                if (commandTokens[0].equals("enginestatus")) {
                    this.printEngineStatus(commandTokens[1]);
                    break;
                }
                if (commandTokens[0].equals("listenerstatus")) {
                    this.printListenerStatus(commandTokens[1]);
                    break;
                }
                if (commandTokens[0].equals("bridgestatus")) {
                    this.printBridgeStatus(commandTokens[1]);
                    break;
                }
                this.err.println("Invalid command : " + command);
                break;
            }
            default: {
                this.err.println("Invalid command : " + command);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleException(Exception e) {
        if (e instanceof InvocationTargetException) {
            Throwable cause = ((InvocationTargetException)e).getTargetException();
            if (!(cause instanceof Exception)) throw (Error)cause;
            this.handleException((Exception)cause);
            return;
        } else {
            this.err.println("ERROR: " + e.toString());
        }
    }

    private void printHelp() {
        this.out.println("Available commands :");
        this.out.println(" serverstatus    : display server status");
        this.out.println(" listenersstatus : display listeners status");
        this.out.println(" enginesstatus   : display engines status");
        this.out.println(" bridgesstatus   : display bridges status");
        this.out.println(" fullstatus      : display full server status");
        this.out.println(" enginestatus <engineName>     : display engine status");
        this.out.println(" listenerstatus <listenerName> : display listener status");
        this.out.println(" bridgestatus <bridgeName>     : display bridge status");
        this.out.println(" help            : display console help");
        this.out.println(" exit/quit       : exit the console application");
    }

    private void printFullStatus() throws Exception {
        this.out.println("=============================");
        this.out.println("    FULL SERVER STATUS");
        this.out.println("=============================");
        this.printServerStatus();
        this.printListenersStatus();
        this.printEnginesStatus();
        this.printBridgesStatus();
    }

    private void printServerVersion() throws Exception {
        MBeanServerConnection conn = this.getMBeanServerConnection();
        ObjectName serverON = new ObjectName("FFMQ:type=Server");
        String version = (String)conn.getAttribute(serverON, "Version");
        this.out.println("Connected to server version " + version);
    }

    private void printServerStatus() throws Exception {
        MBeanServerConnection conn = this.getMBeanServerConnection();
        ObjectName serverON = new ObjectName("FFMQ:type=Server");
        Boolean started = (Boolean)conn.getAttribute(serverON, "Started");
        String version = (String)conn.getAttribute(serverON, "Version");
        Long uptime = (Long)conn.getAttribute(serverON, "Uptime");
        Boolean remoteAdmin = (Boolean)conn.getAttribute(serverON, "RemoteAdministrationEnabled");
        this.out.println("Server (started=" + started + ")");
        this.out.println("  Version        : " + version);
        this.out.println("  Uptime         : " + this.formatDelay(uptime));
        this.out.println("  Remote admin.  : " + (remoteAdmin != null && remoteAdmin != false ? "ENABLED" : "DISABLED"));
    }

    private void printListenersStatus() throws Exception {
        MBeanServerConnection conn = this.getMBeanServerConnection();
        for (ObjectInstance listenerInstance : conn.queryMBeans(new ObjectName("FFMQ:type=Listeners,listener=*"), null)) {
            String listenerName = (String)conn.getAttribute(listenerInstance.getObjectName(), "Name");
            this.printListenerStatus(listenerName);
        }
    }

    private void printListenerStatus(String listenerName) throws Exception {
        MBeanServerConnection conn = this.getMBeanServerConnection();
        ObjectName listenerON = new ObjectName("FFMQ:type=Listeners,listener=" + listenerName);
        try {
            conn.getObjectInstance(listenerON);
        }
        catch (InstanceNotFoundException e) {
            this.err.println("No such listener : " + listenerName);
            return;
        }
        Boolean started = (Boolean)conn.getAttribute(listenerON, "Started");
        Integer activeClients = (Integer)conn.getAttribute(listenerON, "ActiveClients");
        Integer acceptedTotal = (Integer)conn.getAttribute(listenerON, "AcceptedTotal");
        Integer droppedTotal = (Integer)conn.getAttribute(listenerON, "DroppedTotal");
        Integer maxActiveClients = (Integer)conn.getAttribute(listenerON, "MaxActiveClients");
        Integer capacity = (Integer)conn.getAttribute(listenerON, "Capacity");
        this.out.println("Listener [" + listenerName + "] (started=" + started + ")");
        this.out.println("  Active clients : " + activeClients + " (peak=" + maxActiveClients + ",max=" + capacity + ")");
        this.out.println("  Accepted total : " + acceptedTotal);
        this.out.println("  Dropped total  : " + droppedTotal);
    }

    private void printBridgesStatus() throws Exception {
        MBeanServerConnection conn = this.getMBeanServerConnection();
        for (ObjectInstance bridgeInstance : conn.queryMBeans(new ObjectName("FFMQ:type=Bridges,bridge=*"), null)) {
            String bridgeName = (String)conn.getAttribute(bridgeInstance.getObjectName(), "Name");
            this.printBridgeStatus(bridgeName);
        }
    }

    private void printBridgeStatus(String bridgeName) throws Exception {
        MBeanServerConnection conn = this.getMBeanServerConnection();
        ObjectName engineON = new ObjectName("FFMQ:type=Bridges,bridge=" + bridgeName);
        try {
            conn.getObjectInstance(engineON);
        }
        catch (InstanceNotFoundException e) {
            this.err.println("No such bridge : " + bridgeName);
            return;
        }
        Boolean started = (Boolean)conn.getAttribute(engineON, "Started");
        Long failures = (Long)conn.getAttribute(engineON, "Failures");
        Long forwardedMessages = (Long)conn.getAttribute(engineON, "ForwardedMessages");
        Boolean commitSourceFirst = (Boolean)conn.getAttribute(engineON, "CommitSourceFirst");
        Boolean consumerTransacted = (Boolean)conn.getAttribute(engineON, "ConsumerTransacted");
        Boolean producerTransacted = (Boolean)conn.getAttribute(engineON, "ProducerTransacted");
        Integer consumerAckMode = (Integer)conn.getAttribute(engineON, "ConsumerAcknowledgeMode");
        Integer producerDeliveryMode = (Integer)conn.getAttribute(engineON, "ProducerDeliveryMode");
        Integer retryInterval = (Integer)conn.getAttribute(engineON, "RetryInterval");
        this.out.println("Bridge [" + bridgeName + "]");
        this.out.println("  Started                : " + (started != null && started != false ? "YES" : "NO"));
        this.out.println("  Forwarded Messages     : " + forwardedMessages);
        this.out.println("  Failures               : " + failures);
        this.out.println("  Commit source first    : " + (commitSourceFirst != null && commitSourceFirst != false ? "YES" : "NO"));
        this.out.println("  Consumer transacted    : " + (consumerTransacted != null && consumerTransacted != false ? "YES" : "NO"));
        this.out.println("  Producer transacted    : " + (producerTransacted != null && producerTransacted != false ? "YES" : "NO"));
        this.out.println("  Consumer Ack Mode      : " + ManagementUtils.acknowledgeModeAsString((int)consumerAckMode));
        this.out.println("  Producer Delivery Mode : " + ManagementUtils.deliveryModeAsString((int)producerDeliveryMode));
        this.out.println("  Retry interval         : " + retryInterval + "s");
    }

    private void printEnginesStatus() throws Exception {
        MBeanServerConnection conn = this.getMBeanServerConnection();
        for (ObjectInstance engineInstance : conn.queryMBeans(new ObjectName("FFMQ:type=Engines,engine=*"), null)) {
            String engineName = (String)conn.getAttribute(engineInstance.getObjectName(), "Name");
            this.printEngineStatus(engineName);
        }
    }

    private void printEngineStatus(String engineName) throws Exception {
        MBeanServerConnection conn = this.getMBeanServerConnection();
        ObjectName engineON = new ObjectName("FFMQ:type=Engines,engine=" + engineName);
        try {
            conn.getObjectInstance(engineON);
        }
        catch (InstanceNotFoundException e) {
            this.err.println("No such engine : " + engineName);
            return;
        }
        Boolean deployed = (Boolean)conn.getAttribute(engineON, "Deployed");
        this.out.println("Engine [" + engineName + "] (deployed=" + deployed + ")");
        this.out.println("  Queues");
        this.printEngineQueues(engineName, "    ");
        this.out.println("  Topics");
        this.printEngineTopics(engineName, "    ");
        this.out.println("  Async. Managers");
        this.printEngineAsyncManagers(engineName, "    ");
    }

    private void printEngineQueues(String engineName, String indent) throws Exception {
        MBeanServerConnection conn = this.getMBeanServerConnection();
        for (ObjectInstance queueInstance : conn.queryMBeans(new ObjectName("FFMQ:type=Engines,engine=" + engineName + ",children=queues,name=*"), null)) {
            String queueName = (String)conn.getAttribute(queueInstance.getObjectName(), "Name");
            Long sentToQueueCount = (Long)this.connection.getAttribute(queueInstance.getObjectName(), "SentToQueueCount");
            Long receivedFromQueueCount = (Long)this.connection.getAttribute(queueInstance.getObjectName(), "ReceivedFromQueueCount");
            Long acknowledgedGetCount = (Long)this.connection.getAttribute(queueInstance.getObjectName(), "AcknowledgedGetCount");
            Long rollbackedGetCount = (Long)this.connection.getAttribute(queueInstance.getObjectName(), "RollbackedGetCount");
            Long expiredCount = (Long)this.connection.getAttribute(queueInstance.getObjectName(), "ExpiredCount");
            Integer size = (Integer)this.connection.getAttribute(queueInstance.getObjectName(), "Size");
            Integer registeredConsumersCount = (Integer)this.connection.getAttribute(queueInstance.getObjectName(), "RegisteredConsumersCount");
            this.out.print(indent + StringUtils.rightPad((String)queueName, (int)32, (char)' '));
            this.out.print(" - size=" + size + " consumers=" + registeredConsumersCount + " ack=" + acknowledgedGetCount + " rollback=" + rollbackedGetCount + " expired=" + expiredCount);
            this.out.println(" sentTo=" + sentToQueueCount + " receivedFrom=" + receivedFromQueueCount);
        }
    }

    private void printEngineTopics(String engineName, String indent) throws Exception {
        MBeanServerConnection conn = this.getMBeanServerConnection();
        for (ObjectInstance topicInstance : conn.queryMBeans(new ObjectName("FFMQ:type=Engines,engine=" + engineName + ",children=topics,name=*"), null)) {
            String topicName = (String)conn.getAttribute(topicInstance.getObjectName(), "Name");
            Long sentToTopicCount = (Long)this.connection.getAttribute(topicInstance.getObjectName(), "SentToTopicCount");
            Long dispatchedFromTopicCount = (Long)this.connection.getAttribute(topicInstance.getObjectName(), "DispatchedFromTopicCount");
            Integer size = (Integer)this.connection.getAttribute(topicInstance.getObjectName(), "Size");
            Integer registeredConsumersCount = (Integer)this.connection.getAttribute(topicInstance.getObjectName(), "RegisteredConsumersCount");
            this.out.print(indent + StringUtils.rightPad((String)topicName, (int)32, (char)' '));
            this.out.print(" - size=" + size + " consumers=" + registeredConsumersCount);
            this.out.println(" sentTo=" + sentToTopicCount + " dispatchedFrom=" + dispatchedFromTopicCount);
        }
    }

    private void printEngineAsyncManagers(String engineName, String indent) throws Exception {
        MBeanServerConnection conn = this.getMBeanServerConnection();
        for (ObjectInstance asyncManagerInstance : conn.queryMBeans(new ObjectName("FFMQ:type=Engines,engine=" + engineName + ",children=async-managers,name=*"), null)) {
            String asyncManagerName = (String)conn.getAttribute(asyncManagerInstance.getObjectName(), "Name");
            Integer taskQueueSize = (Integer)this.connection.getAttribute(asyncManagerInstance.getObjectName(), "TaskQueueSize");
            Integer threadPoolAvailableCount = (Integer)this.connection.getAttribute(asyncManagerInstance.getObjectName(), "ThreadPoolAvailableCount");
            Integer threadPoolExhaustionPolicy = (Integer)this.connection.getAttribute(asyncManagerInstance.getObjectName(), "ThreadPoolExhaustionPolicy");
            Integer threadPoolMaxIdle = (Integer)this.connection.getAttribute(asyncManagerInstance.getObjectName(), "ThreadPoolMaxIdle");
            Integer threadPoolMaxSize = (Integer)this.connection.getAttribute(asyncManagerInstance.getObjectName(), "ThreadPoolMaxSize");
            Integer threadPoolMinSize = (Integer)this.connection.getAttribute(asyncManagerInstance.getObjectName(), "ThreadPoolMinSize");
            Integer threadPoolPendingWaits = (Integer)this.connection.getAttribute(asyncManagerInstance.getObjectName(), "ThreadPoolPendingWaits");
            Integer threadPoolSize = (Integer)this.connection.getAttribute(asyncManagerInstance.getObjectName(), "ThreadPoolSize");
            Long threadPoolWaitTimeout = (Long)this.connection.getAttribute(asyncManagerInstance.getObjectName(), "ThreadPoolWaitTimeout");
            this.out.println(indent + "[" + asyncManagerName + "]");
            this.out.println(indent + "  Task queue size                 : " + taskQueueSize);
            this.out.println(indent + "  Thread Pool - Size              : " + threadPoolSize);
            this.out.println(indent + "  Thread Pool - Available         : " + threadPoolAvailableCount);
            this.out.println(indent + "  Thread Pool - Pending           : " + threadPoolPendingWaits);
            this.out.println(indent + "  Thread Pool - Min. Size         : " + threadPoolMinSize);
            this.out.println(indent + "  Thread Pool - Max. Size         : " + threadPoolMaxSize);
            this.out.println(indent + "  Thread Pool - Max. Idle         : " + threadPoolMaxIdle);
            this.out.println(indent + "  Thread Pool - Max. Idle         : " + threadPoolMaxIdle);
            this.out.println(indent + "  Thread Pool - Exhaustion Policy : " + ObjectPool.exhaustionPolicyAsString((int)threadPoolExhaustionPolicy));
            this.out.println(indent + "  Thread Pool - Wait timeout      : " + threadPoolWaitTimeout + "ms");
        }
    }

    private JMXConnector getConnector() throws Exception {
        if (this.connector == null) {
            this.connector = JMXConnectorFactory.connect(this.jmxServiceURL);
        }
        return this.connector;
    }

    private MBeanServerConnection getMBeanServerConnection() throws Exception {
        if (this.connection == null) {
            this.connection = this.getConnector().getMBeanServerConnection();
        }
        return this.connection;
    }

    private void closeJMXResources() {
        this.connection = null;
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (Exception e) {
                this.err.println("Cannot close JMX connector");
                e.printStackTrace(this.err);
            }
            finally {
                this.connector = null;
            }
        }
    }

    private String formatDelay(long delay) {
        long seconds;
        long minutes;
        long hours;
        long days;
        StringBuilder sb = new StringBuilder();
        if (delay < 0L) {
            delay = -delay;
            sb.append("-");
        }
        if ((days = delay / 86400000L) > 0L) {
            sb.append(days);
            sb.append("d");
            delay %= 86400000L;
        }
        if ((hours = delay / 3600000L) > 0L) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(hours);
            sb.append("h");
            delay %= 3600000L;
        }
        if ((minutes = delay / 60000L) > 0L) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(minutes);
            sb.append("min");
            delay %= 60000L;
        }
        if ((seconds = delay / 1000L) > 0L) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(seconds);
            sb.append("s");
            delay %= 1000L;
        }
        if (sb.length() > 0) {
            sb.append(" ");
        }
        sb.append(delay);
        sb.append("ms");
        return sb.toString();
    }
}

