/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CodepointMatchKey;
import net.sf.saxon.functions.Count;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeKey
implements MapItem {
    private CodepointMatchKey min;
    private CodepointMatchKey max;
    private XPathContext context;
    private TreeMap<AtomicMatchKey, List<NodeInfo>> index;

    public RangeKey(String min, String max, XPathContext context, TreeMap<AtomicMatchKey, List<NodeInfo>> index) throws XPathException {
        this.min = min == null ? null : new CodepointMatchKey(min);
        this.max = max == null ? null : new CodepointMatchKey(max);
        this.index = index;
        this.context = context;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public OperandRole[] getOperandRoles() {
        return new OperandRole[]{OperandRole.SINGLE_ATOMIC};
    }

    @Override
    public AtomicSequence atomize() throws XPathException {
        throw new XPathException("Maps cannot be atomized", "FOTY0013");
    }

    @Override
    public Sequence get(AtomicValue key) {
        CodepointMatchKey k = new CodepointMatchKey(key.getStringValue());
        if (!(this.min != null && this.min.compareTo(k) > 0 || this.max != null && this.max.compareTo(k) < 0)) {
            List<NodeInfo> nodes = this.index.get(k);
            if (nodes == null) {
                return EmptySequence.getInstance();
            }
            return SequenceExtent.makeSequenceExtent(nodes);
        }
        return EmptySequence.getInstance();
    }

    @Override
    public int size() {
        try {
            return Count.count(this.keys());
        }
        catch (XPathException err) {
            return 0;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.keys().next() == null;
    }

    @Override
    public AtomicIterator keys() {
        return new RangeKeyIterator();
    }

    @Override
    public Iterator<KeyValuePair> iterator() {
        AtomicValue key;
        ArrayList<KeyValuePair> list = new ArrayList<KeyValuePair>();
        AtomicIterator keys = this.keys();
        while ((key = keys.next()) != null) {
            list.add(new KeyValuePair(key, this.get(key)));
        }
        return list.iterator();
    }

    @Override
    public MapItem remove(AtomicValue key) throws XPathException {
        HashTrieMap copy = HashTrieMap.copy(this, this.context);
        return copy.remove(key);
    }

    @Override
    public AtomicType getKeyType() {
        return BuiltInAtomicType.STRING;
    }

    @Override
    public UType getKeyUType() {
        return UType.STRING;
    }

    @Override
    public SequenceType getValueType() {
        return SequenceType.NODE_SEQUENCE;
    }

    @Override
    public MapType getFunctionItemType() {
        return new MapType(BuiltInAtomicType.STRING, SequenceType.NODE_SEQUENCE);
    }

    @Override
    public StructuredQName getFunctionName() {
        return null;
    }

    @Override
    public String getDescription() {
        return "range key";
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] args) throws XPathException {
        return this.get((AtomicValue)args[0].head());
    }

    @Override
    public boolean deepEquals(Function other, XPathContext context, AtomicComparer comparer, int flags) throws XPathException {
        if (other instanceof RangeKey) {
            RangeKey rk = (RangeKey)other;
            return this.min.equals(rk.min) && this.max.equals(rk.max) && this.index.equals(rk.index);
        }
        return false;
    }

    @Override
    public Function itemAt(int n) {
        return this;
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        if (start <= 0 && length >= 1) {
            return this;
        }
        return EmptySequence.getInstance();
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("The effective boolean value of a map is not defined");
    }

    @Override
    public GroundedValue reduce() {
        return this;
    }

    @Override
    public String getStringValue() {
        throw new UnsupportedOperationException("Cannot get the string value of a map");
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.getStringValue();
    }

    @Override
    public Function head() {
        return this;
    }

    @Override
    public UnfailingIterator iterate() {
        return SingletonIterator.makeIterator(this);
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("range-key-map");
        out.emitAttribute("size", this.size() + "");
        out.endElement();
    }

    @Override
    public boolean isTrustedResultType() {
        return false;
    }

    private class RangeKeyIterator
    implements AtomicIterator {
        int pos = 0;
        CodepointMatchKey curr = null;
        CodepointMatchKey top;

        public RangeKeyIterator() {
            this.top = (CodepointMatchKey)(RangeKey.this.max == null ? (AtomicMatchKey)RangeKey.this.index.lastKey() : (AtomicMatchKey)RangeKey.this.index.floorKey(RangeKey.this.max));
        }

        public StringValue next() {
            if (this.pos <= 0) {
                if (this.pos < 0) {
                    return null;
                }
                if (RangeKey.this.min == null) {
                    this.curr = (CodepointMatchKey)RangeKey.this.index.firstKey();
                } else {
                    this.curr = RangeKey.this.index.ceilingKey(RangeKey.this.min);
                    if (this.curr != null && RangeKey.this.max != null && this.curr.compareTo(RangeKey.this.max) > 0) {
                        this.curr = null;
                    }
                }
            } else {
                this.curr = this.curr.equals(this.top) ? null : RangeKey.this.index.higherKey(this.curr);
            }
            if (this.curr == null) {
                this.pos = -1;
                return null;
            }
            ++this.pos;
            return new StringValue(this.curr.toString());
        }

        public AtomicIterator getAnother() {
            return new RangeKeyIterator();
        }

        public void close() {
        }

        public int getProperties() {
            return 0;
        }
    }
}

