/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.regex.BMPString;
import net.sf.saxon.regex.LatinString;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.UntypedAtomicValue;

public class StringValue
extends AtomicValue {
    public static final StringValue EMPTY_STRING = new StringValue("");
    public static final StringValue SINGLE_SPACE = new StringValue(" ");
    public static final StringValue TRUE = new StringValue("true");
    public static final StringValue FALSE = new StringValue("false");
    protected CharSequence value;

    protected StringValue() {
        this.value = "";
        this.typeLabel = BuiltInAtomicType.STRING;
    }

    public StringValue(CharSequence value) {
        this.value = value == null ? "" : value;
        this.typeLabel = BuiltInAtomicType.STRING;
    }

    public StringValue(CharSequence value, AtomicType typeLabel) {
        this.value = value;
        this.typeLabel = typeLabel;
    }

    public synchronized void setContainsNoSurrogates() {
        if (!(this.value instanceof BMPString) && !(this.value instanceof LatinString)) {
            this.value = new BMPString(this.value);
        }
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        StringValue v = new StringValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.STRING;
    }

    public static StringValue makeStringValue(CharSequence value) {
        if (value == null || value.length() == 0) {
            return EMPTY_STRING;
        }
        return new StringValue(value);
    }

    public final CharSequence getPrimitiveStringValue() {
        return this.value;
    }

    public final void setStringValueCS(CharSequence value) {
        this.value = value;
    }

    public synchronized int getStringLength() {
        if (!(this.value instanceof UnicodeString)) {
            this.makeUnicodeString();
        }
        return ((UnicodeString)this.value).uLength();
    }

    public synchronized int getStringLengthUpperBound() {
        if (this.value instanceof UnicodeString) {
            return ((UnicodeString)this.value).uLength();
        }
        return this.value.length();
    }

    public synchronized UnicodeString getUnicodeString() {
        if (!(this.value instanceof UnicodeString)) {
            this.makeUnicodeString();
        }
        return (UnicodeString)this.value;
    }

    private void makeUnicodeString() {
        this.value = UnicodeString.makeUnicodeString(this.value);
    }

    public static int getStringLength(CharSequence s) {
        if (s instanceof UnicodeString) {
            return ((UnicodeString)s).uLength();
        }
        int n = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '\ud800' && c <= '\udbff') continue;
            ++n;
        }
        return n;
    }

    public boolean isZeroLength() {
        return this.value.length() == 0;
    }

    public boolean containsSurrogatePairs() {
        return UnicodeString.containsSurrogatePairs(this.value);
    }

    public boolean isKnownToContainNoSurrogates() {
        return this.value instanceof BMPString || this.value instanceof LatinString;
    }

    public UnfailingIterator iterateCharacters() {
        CharSequence val = this.value;
        if (val instanceof UnicodeString) {
            return new UnicodeCharacterIterator((UnicodeString)val);
        }
        return new CharacterIterator(val);
    }

    public static int[] expand(CharSequence s) {
        int[] array = new int[StringValue.getStringLength(s)];
        int o = 0;
        for (int i = 0; i < s.length(); ++i) {
            int charval;
            int c = s.charAt(i);
            if (c >= 55296 && c <= 56319) {
                charval = (c - 55296) * 1024 + (s.charAt(i + 1) - 56320) + 65536;
                ++i;
            } else {
                charval = c;
            }
            array[o++] = charval;
        }
        return array;
    }

    public static CharSequence contract(int[] codes, int used) {
        FastStringBuffer sb = new FastStringBuffer(codes.length);
        for (int i = 0; i < used; ++i) {
            sb.appendWideChar(codes[i]);
        }
        return sb;
    }

    public AtomicMatchKey getXPathComparable(boolean ordered, StringCollator collator, int implicitTimezone) {
        return collator.getCollationKey(this.asString());
    }

    public boolean equals(Object other) {
        throw new ClassCastException("equals on StringValue is not allowed");
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public synchronized String asString() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        String s = this.value.toString();
        this.value = s;
        return s;
    }

    public boolean codepointEquals(StringValue other) {
        return this.value.length() == other.value.length() && this.asString().equals(other.asString());
    }

    public boolean effectiveBooleanValue() {
        return this.value.length() > 0;
    }

    public String toString() {
        return "\"" + this.value + '\"';
    }

    public Comparable getSchemaComparable() {
        return this.asString();
    }

    public boolean isIdentical(AtomicValue v) {
        return v instanceof StringValue && this instanceof AnyURIValue == v instanceof AnyURIValue && this instanceof UntypedAtomicValue == v instanceof UntypedAtomicValue && this.asString().equals(((StringValue)v).asString());
    }

    public static String diagnosticDisplay(String s) {
        FastStringBuffer fsb = new FastStringBuffer(s.length());
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= ' ' && c <= '~') {
                fsb.append(c);
                continue;
            }
            fsb.append("\\u");
            for (int shift = 12; shift >= 0; shift -= 4) {
                fsb.append("0123456789ABCDEF".charAt(c >> shift & 0xF));
            }
        }
        return fsb.toString();
    }

    public final class UnicodeCharacterIterator
    implements UnfailingIterator {
        UnicodeString val;
        int inpos = 0;

        public UnicodeCharacterIterator(UnicodeString val) {
            this.val = val;
        }

        public Int64Value next() {
            if (this.inpos < this.val.uLength()) {
                return new Int64Value(this.val.uCharAt(this.inpos++));
            }
            return null;
        }

        public void close() {
        }

        public UnfailingIterator getAnother() {
            return new UnicodeCharacterIterator(this.val);
        }

        public int getProperties() {
            return 0;
        }
    }

    public final class CharacterIterator
    implements UnfailingIterator {
        CharSequence val;
        int inpos = 0;

        public CharacterIterator(CharSequence val) {
            this.val = val;
        }

        public Int64Value next() {
            if (this.inpos < this.val.length()) {
                int current;
                int c;
                if ((c = this.val.charAt(this.inpos++)) >= 55296 && c <= 56319) {
                    try {
                        current = (c - 55296) * 1024 + (this.val.charAt(this.inpos++) - 56320) + 65536;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        System.err.println("Invalid surrogate at end of string");
                        System.err.println(StringValue.diagnosticDisplay(StringValue.this.value.toString()));
                        e.printStackTrace();
                        throw e;
                    }
                } else {
                    current = c;
                }
                return new Int64Value(current);
            }
            return null;
        }

        public void close() {
        }

        public UnfailingIterator getAnother() {
            return new CharacterIterator(this.val);
        }

        public int getProperties() {
            return 0;
        }
    }
}

