/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.MessageListenerProxy;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.serialize.ReconfigurableSerializer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyBuilder;

public class XsltTransformer
implements Destination {
    private Processor processor;
    private Controller controller;
    private GlobalParameterSet parameters;
    private Source initialSource;
    private Destination destination;
    private Builder sourceTreeBuilder;
    boolean baseOutputUriWasSet = false;

    protected XsltTransformer(Processor processor, Controller controller, GlobalParameterSet staticParameters) {
        this.processor = processor;
        this.controller = controller;
        this.parameters = new GlobalParameterSet(staticParameters);
    }

    public void setInitialTemplate(QName templateName) throws SaxonApiException {
        try {
            this.controller.setInitialTemplate(templateName == null ? null : templateName.getStructuredQName());
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public QName getInitialTemplate() {
        StructuredQName templateName = this.controller.getInitialTemplate();
        return templateName == null ? null : new QName(templateName);
    }

    public void setInitialMode(QName modeName) throws IllegalArgumentException {
        try {
            this.controller.setInitialMode(modeName == null ? null : modeName.getStructuredQName());
        }
        catch (XPathException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public QName getInitialMode() {
        StructuredQName mode = this.controller.getInitialModeName();
        if (mode == null) {
            return null;
        }
        return new QName(mode);
    }

    public void setSchemaValidationMode(ValidationMode mode) {
        if (mode != null) {
            this.controller.setSchemaValidationMode(mode.getNumber());
        }
    }

    public ValidationMode getSchemaValidationMode() {
        return ValidationMode.get(this.controller.getSchemaValidationMode());
    }

    public void setSource(Source source) throws SaxonApiException {
        if (source instanceof NodeInfo) {
            this.setInitialContextNode(new XdmNode((NodeInfo)source));
        } else if (source instanceof DOMSource) {
            if (((DOMSource)source).getNode() == null) {
                DocumentImpl doc = new DocumentImpl();
                doc.setConfiguration(this.controller.getConfiguration());
                this.setInitialContextNode(new XdmNode(doc));
            } else {
                this.setInitialContextNode(this.processor.newDocumentBuilder().wrap(source));
            }
        } else {
            this.initialSource = source;
        }
    }

    public void setInitialContextNode(XdmNode node) {
        this.initialSource = node == null ? null : node.getUnderlyingNode();
    }

    public XdmNode getInitialContextNode() {
        if (this.initialSource instanceof NodeInfo) {
            return (XdmNode)XdmValue.wrap((NodeInfo)this.initialSource);
        }
        return null;
    }

    public void setParameter(QName name, XdmValue value) {
        this.parameters.put(name.getStructuredQName(), value == null ? null : value.getUnderlyingValue());
    }

    public void clearParameters() {
        this.parameters = new GlobalParameterSet();
    }

    public XdmValue getParameter(QName name) {
        Sequence oval = this.parameters.get(name.getStructuredQName());
        return oval == null ? null : XdmValue.wrap(oval);
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
        if (destination instanceof Serializer) {
            Properties declaredProperties = this.controller.getExecutable().getDefaultOutputProperties();
            String nextInChain = declaredProperties.getProperty("{http://saxon.sf.net/}next-in-chain");
            if (nextInChain != null && !nextInChain.isEmpty()) {
                try {
                    String base = declaredProperties.getProperty("{http://saxon.sf.net/}next-in-chain-base-uri");
                    Source nextStylesheet = this.getURIResolver().resolve(nextInChain, base);
                    XsltTransformer next = this.processor.newXsltCompiler().compile(nextStylesheet).load();
                    next.setDestination(destination);
                    this.setDestination(next);
                }
                catch (Exception e) {
                    final Exception err = e;
                    this.setDestination(new Destination(){

                        public Receiver getReceiver(Configuration config) throws SaxonApiException {
                            throw new SaxonApiException("Failed to configure next-in-chain stylesheet", err);
                        }

                        public void close() throws SaxonApiException {
                        }
                    });
                }
            } else {
                Serializer serializer = (Serializer)destination;
                serializer.setDefaultOutputProperties(declaredProperties);
                serializer.setCharacterMap(this.controller.getExecutable().getCharacterMapIndex());
            }
        }
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setBaseOutputURI(String uri) {
        this.controller.setBaseOutputURI(uri);
        this.baseOutputUriWasSet = uri != null;
    }

    public String getBaseOutputURI() {
        return this.controller.getBaseOutputURI();
    }

    public void setURIResolver(URIResolver resolver) {
        this.controller.setURIResolver(resolver);
    }

    public URIResolver getURIResolver() {
        return this.controller.getURIResolver();
    }

    public void setErrorListener(ErrorListener listener) {
        this.controller.setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.controller.getErrorListener();
    }

    public void setMessageListener(MessageListener listener) {
        this.controller.setMessageEmitter(new MessageListenerProxy(listener, this.controller.makePipelineConfiguration()));
    }

    public MessageListener getMessageListener() {
        Receiver r = this.controller.getMessageEmitter();
        if (r instanceof MessageListenerProxy) {
            return ((MessageListenerProxy)r).getMessageListener();
        }
        return null;
    }

    public void setTraceListener(TraceListener listener) {
        this.controller.setTraceListener(listener);
    }

    public TraceListener getTraceListener() {
        return this.controller.getTraceListener();
    }

    public void setTraceFunctionDestination(Logger stream) {
        this.controller.setTraceFunctionDestination(stream);
    }

    public Logger getTraceFunctionDestination() {
        return this.controller.getTraceFunctionDestination();
    }

    public void transform() throws SaxonApiException {
        if (this.destination == null) {
            throw new IllegalStateException("No destination has been supplied");
        }
        if (this.baseOutputUriWasSet && this.destination instanceof XdmDestination && ((XdmDestination)this.destination).getBaseURI() == null && this.controller.getBaseOutputURI() != null) {
            try {
                ((XdmDestination)this.destination).setBaseURI(new URI(this.controller.getBaseOutputURI()));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        try {
            Receiver out = this.getDestinationReceiver();
            this.controller.initializeController(this.parameters);
            this.controller.transform(this.initialSource, out);
            this.destination.close();
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                try {
                    this.getErrorListener().error(e);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
            }
            throw new SaxonApiException(e);
        }
    }

    private Receiver getDestinationReceiver() throws SaxonApiException {
        if (this.destination instanceof Serializer) {
            Serializer serializer = (Serializer)this.destination;
            Object dest = serializer.getOutputDestination();
            if (!this.baseOutputUriWasSet && dest instanceof File) {
                this.controller.setBaseOutputURI(((File)dest).toURI().toString());
            }
            PipelineConfiguration pipe = this.controller.makePipelineConfiguration();
            Receiver r = ((Serializer)this.destination).getReceiver(pipe);
            pipe.setLocationProvider(this.controller.getExecutable().getLocationMap());
            return new ReconfigurableSerializer(r, serializer.getLocalOutputProperties(), serializer.getResult());
        }
        Receiver r = this.destination.getReceiver(this.controller.getConfiguration());
        PipelineConfiguration pipe = r.getPipelineConfiguration();
        pipe.setController(this.controller);
        pipe.setLocationProvider(this.controller.getExecutable().getLocationMap());
        return r;
    }

    public Receiver getReceiver(Configuration config) throws SaxonApiException {
        if (this.destination == null) {
            throw new IllegalStateException("No destination has been supplied");
        }
        try {
            this.controller.initializeController(this.parameters);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        if (this.controller.getInitialMode().isDeclaredStreamable()) {
            try {
                return this.controller.getStreamingReceiver(this.controller.getInitialMode(), this.getDestinationReceiver());
            }
            catch (TransformerException e) {
                throw new SaxonApiException(e);
            }
        }
        this.sourceTreeBuilder = this.controller.makeBuilder();
        if (this.sourceTreeBuilder instanceof TinyBuilder) {
            ((TinyBuilder)this.sourceTreeBuilder).setStatistics(Statistics.SOURCE_DOCUMENT_STATISTICS);
        }
        Receiver stripper = this.controller.makeStripper(this.sourceTreeBuilder);
        if (this.controller.getExecutable().stripsInputTypeAnnotations()) {
            stripper = this.controller.getConfiguration().getAnnotationStripper(stripper);
        }
        return stripper;
    }

    public void close() throws SaxonApiException {
        if (this.sourceTreeBuilder != null) {
            NodeInfo doc = this.sourceTreeBuilder.getCurrentRoot();
            this.sourceTreeBuilder = null;
            if (doc != null) {
                Receiver result = this.getDestinationReceiver();
                try {
                    this.controller.transformDocument(doc, result);
                }
                catch (TransformerException e) {
                    throw new SaxonApiException(e);
                }
            }
            this.destination.close();
        }
    }

    public Controller getUnderlyingController() {
        return this.controller;
    }
}

