/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.EquivalenceComparer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;

public class EquivalenceComparison
extends BinaryExpression
implements ComparisonExpression {
    private AtomicComparer comparer;
    private boolean knownToBeComparable = false;

    public EquivalenceComparison(Expression p1, int operator, Expression p2) {
        super(p1, operator, p2);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        StaticContext env = visitor.getStaticContext();
        String defaultCollationName = env.getDefaultCollationName();
        Configuration config = visitor.getConfiguration();
        StringCollator collation = config.getCollation(defaultCollationName);
        if (collation == null) {
            collation = CodepointCollator.getInstance();
        }
        this.comparer = new EquivalenceComparer(collation, 632, config.getConversionContext());
        Expression oldOp0 = this.operand0;
        Expression oldOp1 = this.operand1;
        this.operand0 = visitor.typeCheck(this.operand0, contextInfo);
        this.operand1 = visitor.typeCheck(this.operand1, contextInfo);
        Optimizer opt = config.obtainOptimizer();
        this.operand0 = this.operand0.unordered(false, false);
        this.operand1 = this.operand1.unordered(false, false);
        SequenceType atomicType = SequenceType.OPTIONAL_ATOMIC;
        RoleLocator role0 = new RoleLocator(1, "eq", 0);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, atomicType, false, role0, visitor);
        RoleLocator role1 = new RoleLocator(1, "eq", 1);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, atomicType, false, role1, visitor);
        if (this.operand0 != oldOp0) {
            this.adoptChildExpression(this.operand0);
        }
        if (this.operand1 != oldOp1) {
            this.adoptChildExpression(this.operand1);
        }
        ItemType t0 = this.operand0.getItemType();
        ItemType t1 = this.operand1.getItemType();
        if (t0 instanceof ErrorType) {
            t0 = BuiltInAtomicType.ANY_ATOMIC;
        }
        if (t1 instanceof ErrorType) {
            t1 = BuiltInAtomicType.ANY_ATOMIC;
        }
        if (((AtomicType)t0).isExternalType() || ((AtomicType)t1).isExternalType()) {
            XPathException err = new XPathException("Cannot perform comparisons involving external objects");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            err.setLocator(this);
            throw err;
        }
        BuiltInAtomicType pt0 = (BuiltInAtomicType)t0.getPrimitiveItemType();
        BuiltInAtomicType pt1 = (BuiltInAtomicType)t1.getPrimitiveItemType();
        if (!(t0.equals(BuiltInAtomicType.ANY_ATOMIC) || t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || t1.equals(BuiltInAtomicType.ANY_ATOMIC) || t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC))) {
            if (Type.isGuaranteedComparable(pt0, pt1, false)) {
                this.knownToBeComparable = true;
            } else if (!Type.isPossiblyComparable(pt0, pt1, false)) {
                env.issueWarning("Cannot compare " + t0.toString() + " to " + t1.toString(), this);
            }
        }
        try {
            if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
                GroundedValue v = SequenceTool.toGroundedValue(this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext()));
                return Literal.makeLiteral(v, this.getContainer());
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return this;
    }

    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    public int getSingletonOperator() {
        return this.operator;
    }

    public boolean convertsUntypedToOther() {
        return false;
    }

    public int computeCardinality() {
        return 16384;
    }

    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    public boolean isKnownToBeComparable() {
        return this.knownToBeComparable;
    }

    public AtomicComparer getComparer() {
        return this.comparer;
    }

    public Expression copy() {
        EquivalenceComparison sc = new EquivalenceComparison(this.operand0.copy(), this.operator, this.operand1.copy());
        sc.comparer = this.comparer;
        sc.knownToBeComparable = this.knownToBeComparable;
        return sc;
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        AtomicValue v0 = (AtomicValue)this.operand0.evaluateItem(context);
        AtomicValue v1 = (AtomicValue)this.operand1.evaluateItem(context);
        if (v0 == null || v1 == null) {
            return v0 == v1;
        }
        return (this.knownToBeComparable || Type.isGuaranteedComparable(v0.getPrimitiveType(), v1.getPrimitiveType(), false)) && this.comparer.comparesEqual(v0, v1);
    }

    protected void explainExtraAttributes(ExpressionPresenter out) {
        out.emitAttribute("cardinality", "singleton");
    }
}

