/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.event.Transmitter;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Bindery;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.DelegatingErrorListener;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StandardURIResolver;
import net.sf.saxon.lib.StandardUnparsedTextResolver;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.serialize.ImplicitResultChecker;
import net.sf.saxon.trace.TraceEventMulticaster;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.wrapper.AbstractVirtualNode;
import net.sf.saxon.tree.wrapper.SpaceStrippedDocument;
import net.sf.saxon.tree.wrapper.TypeStrippedDocument;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.SingletonClosure;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller {
    private Configuration config;
    private Executable executable;
    private Item initialContextItem;
    private Item contextForGlobalVariables;
    private Bindery bindery;
    private String messageReceiverClassName;
    private Receiver messageReceiver;
    private TraceListener traceListener;
    private boolean tracingPaused;
    private Logger traceFunctionDestination;
    private URIResolver standardURIResolver;
    private URIResolver userURIResolver;
    private Receiver principalResult;
    private String principalResultURI;
    private String cookedPrincipalResultURI;
    private boolean thereHasBeenAnExplicitResultDocument;
    private OutputURIResolver outputURIResolver;
    private UnparsedTextURIResolver unparsedTextResolver;
    private CollectionURIResolver collectionURIResolver;
    private String defaultCollectionURI;
    private UnfailingErrorListener errorListener;
    private int recoveryPolicy;
    private TreeModel treeModel = TreeModel.TINY_TREE;
    private Template initialTemplate = null;
    private HashSet<DocumentURI> allOutputDestinations;
    private DocumentPool sourceDocumentPool;
    private HashMap<String, Object> userDataTable;
    private DateTimeValue currentDateTime;
    private boolean dateTimePreset = false;
    private Mode initialMode = null;
    private FunctionItem initialFunction = null;
    private NodeInfo lastRememberedNode = null;
    private int lastRememberedNumber = -1;
    private PathMap pathMap = null;
    private int validationMode;
    private boolean inUse = false;
    private boolean stripSourceTrees = true;
    private Map<StructuredQName, Sequence> initialTemplateParams;
    private Map<StructuredQName, Sequence> initialTemplateTunnelParams;
    public static final String ANONYMOUS_PRINCIPAL_OUTPUT_URI = "dummy:/anonymous/principal/result";

    public Controller(Configuration config) {
        this.config = config;
        this.executable = new Executable(config);
        this.sourceDocumentPool = new DocumentPool();
        this.reset();
    }

    public Controller(Configuration config, Executable executable) {
        this.config = config;
        this.executable = executable;
        this.sourceDocumentPool = new DocumentPool();
        this.reset();
    }

    public void reset() {
        TraceListener tracer;
        this.bindery = new Bindery();
        this.standardURIResolver = this.config.getSystemURIResolver();
        this.userURIResolver = this.config.getURIResolver();
        this.outputURIResolver = this.config.getOutputURIResolver();
        this.unparsedTextResolver = new StandardUnparsedTextResolver();
        this.setErrorListener(this.config.getErrorListener());
        this.recoveryPolicy = this.config.getRecoveryPolicy();
        this.validationMode = this.config.getSchemaValidationMode();
        if (this.errorListener instanceof StandardErrorListener) {
            Logger ps = ((StandardErrorListener)this.errorListener).getLogger();
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(this.executable.getHostLanguage());
            ((StandardErrorListener)this.errorListener).setLogger(ps);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(this.recoveryPolicy);
        }
        this.traceListener = null;
        this.traceFunctionDestination = this.config.getLogger();
        try {
            tracer = this.config.makeTraceListener();
        }
        catch (XPathException err) {
            throw new IllegalStateException(err.getMessage());
        }
        if (tracer != null) {
            this.addTraceListener(tracer);
        }
        this.setModel(this.config.getParseOptions().getModel());
        this.contextForGlobalVariables = null;
        this.messageReceiver = null;
        this.currentDateTime = null;
        this.dateTimePreset = false;
        this.initialContextItem = null;
        this.initialMode = null;
        this.initialTemplate = null;
        this.clearPerTransformationData();
    }

    private void clearPerTransformationData() {
        this.userDataTable = new HashMap(20);
        this.principalResult = null;
        this.allOutputDestinations = null;
        this.thereHasBeenAnExplicitResultDocument = false;
        this.lastRememberedNode = null;
        this.lastRememberedNumber = -1;
        this.tracingPaused = false;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setInitialMode(StructuredQName expandedModeName) throws XPathException {
        if (expandedModeName == null) {
            this.initialMode = null;
        } else {
            this.initialMode = ((PreparedStylesheet)this.executable).getRuleManager().getMode(expandedModeName, false);
            if (this.initialMode == null) {
                throw new XPathException("Requested initial mode " + expandedModeName + " is not defined in the stylesheet", "XTDE0045");
            }
        }
    }

    public StructuredQName getInitialModeName() {
        return this.initialMode == null ? null : this.initialMode.getModeName();
    }

    public Mode getInitialMode() {
        if (this.initialMode == null) {
            this.initialMode = ((PreparedStylesheet)this.executable).getRuleManager().getUnnamedMode();
        }
        return this.initialMode;
    }

    public Sequence getParameter(StructuredQName name) {
        return this.getBindery().getSuppliedParameters().get(name);
    }

    public void setBaseOutputURI(String uri) {
        this.principalResultURI = uri;
    }

    public String getBaseOutputURI() {
        return this.principalResultURI;
    }

    public String getCookedBaseOutputURI() {
        if (this.cookedPrincipalResultURI == null) {
            String base = this.getBaseOutputURI();
            if (base == null && this.config.getBooleanProperty("http://saxon.sf.net/feature/allow-external-functions")) {
                base = new File(System.getProperty("user.dir")).toURI().toString();
            }
            if (base != null) {
                base = EscapeURI.iriToUri(base).toString();
            }
            this.cookedPrincipalResultURI = base;
        }
        return this.cookedPrincipalResultURI;
    }

    public Receiver getPrincipalResult() {
        return this.principalResult;
    }

    public synchronized boolean checkUniqueOutputDestination(DocumentURI uri) {
        if (uri == null) {
            return true;
        }
        if (this.allOutputDestinations == null) {
            this.allOutputDestinations = new HashSet(20);
        }
        return !this.allOutputDestinations.contains(uri);
    }

    public void addUnavailableOutputDestination(DocumentURI uri) {
        if (this.allOutputDestinations == null) {
            this.allOutputDestinations = new HashSet(20);
        }
        this.allOutputDestinations.add(uri);
    }

    public void removeUnavailableOutputDestination(DocumentURI uri) {
        if (this.allOutputDestinations != null) {
            this.allOutputDestinations.remove(uri);
        }
    }

    public boolean isUnusedOutputDestination(DocumentURI uri) {
        return this.allOutputDestinations == null || !this.allOutputDestinations.contains(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkImplicitResultTree() throws XPathException {
        String implicitURI = this.principalResultURI;
        if (implicitURI == null) {
            implicitURI = ANONYMOUS_PRINCIPAL_OUTPUT_URI;
        }
        DocumentURI documentURI = new DocumentURI(implicitURI);
        Controller controller = this;
        synchronized (controller) {
            if (!this.checkUniqueOutputDestination(documentURI)) {
                XPathException err = new XPathException("Cannot write an implicit result document if an explicit result document has been written to the same URI: " + (implicitURI.equals(ANONYMOUS_PRINCIPAL_OUTPUT_URI) ? "(no URI supplied)" : implicitURI));
                err.setErrorCode("XTDE1490");
                throw err;
            }
            this.addUnavailableOutputDestination(documentURI);
        }
    }

    public void setThereHasBeenAnExplicitResultDocument() {
        this.thereHasBeenAnExplicitResultDocument = true;
    }

    public boolean hasThereBeenAnExplicitResultDocument() {
        return this.thereHasBeenAnExplicitResultDocument;
    }

    public synchronized SequenceOutputter allocateSequenceOutputter(int size) {
        PipelineConfiguration pipe = this.makePipelineConfiguration();
        return new SequenceOutputter(pipe, this, size);
    }

    public void reuseSequenceOutputter(SequenceOutputter out) {
    }

    public void setInitialTemplate(StructuredQName qName) throws XPathException {
        if (qName == null) {
            this.initialTemplate = null;
            return;
        }
        Template t = ((PreparedStylesheet)this.getExecutable()).getNamedTemplate(qName);
        if (t == null) {
            XPathException err = new XPathException("The requested initial template " + qName.getDisplayName() + " does not exist");
            err.setErrorCode("XTDE0040");
            this.reportFatalError(err);
            throw err;
        }
        this.initialTemplate = t;
    }

    public StructuredQName getInitialTemplate() {
        if (this.initialTemplate == null) {
            return null;
        }
        return this.initialTemplate.getTemplateName();
    }

    public void setInitialTemplateParameters(Map<StructuredQName, Sequence> params, boolean tunnel) throws XPathException {
        if (!params.isEmpty() && !this.executable.isAllowXPath30()) {
            throw new XPathException("Cannot supply initial template parameters when running as XSLT 2.0", "SXST0070");
        }
        if (tunnel) {
            this.initialTemplateTunnelParams = params;
        } else {
            this.initialTemplateParams = params;
        }
    }

    public Map<StructuredQName, Sequence> getInitialTemplateParameters(boolean tunnel) {
        return tunnel ? this.initialTemplateTunnelParams : this.initialTemplateParams;
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipe = this.config.makePipelineConfiguration();
        pipe.setURIResolver(this.userURIResolver == null ? this.standardURIResolver : this.userURIResolver);
        pipe.setController(this);
        Executable executable = this.getExecutable();
        if (executable != null) {
            pipe.setLocationProvider(executable.getLocationMap());
            pipe.setHostLanguage(executable.getHostLanguage());
        }
        return pipe;
    }

    public void setMessageReceiverClassName(String name) {
        this.messageReceiverClassName = name;
    }

    private Receiver makeMessageReceiver() throws XPathException {
        Object messageReceiver = this.config.getInstance(this.messageReceiverClassName, null);
        if (!(messageReceiver instanceof Receiver)) {
            throw new XPathException(this.messageReceiverClassName + " is not a Receiver");
        }
        ((Receiver)messageReceiver).setPipelineConfiguration(this.makePipelineConfiguration());
        this.setMessageEmitter((Receiver)messageReceiver);
        return (Receiver)messageReceiver;
    }

    public void setMessageEmitter(Receiver receiver) {
        this.messageReceiver = receiver;
        receiver.setPipelineConfiguration(this.makePipelineConfiguration());
        if (receiver instanceof Emitter && ((Emitter)receiver).getOutputProperties() == null) {
            try {
                Properties props = new Properties();
                props.setProperty("method", "xml");
                props.setProperty("indent", "yes");
                props.setProperty("omit-xml-declaration", "yes");
                ((Emitter)receiver).setOutputProperties(props);
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
    }

    public Receiver getMessageEmitter() {
        return this.messageReceiver;
    }

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
        if (this.errorListener instanceof StandardErrorListener) {
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(policy);
        }
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener instanceof UnfailingErrorListener ? (UnfailingErrorListener)listener : new DelegatingErrorListener(listener);
    }

    public UnfailingErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void recoverableError(XPathException err) throws XPathException {
        if (this.executable.getHostLanguage() == 51 || this.recoveryPolicy == 2) {
            throw err;
        }
        if (this.executable.getHostLanguage() == 50 && this.executable.isAllowXPath30()) {
            this.errorListener.warning(err);
        } else {
            this.errorListener.error(err);
        }
    }

    public void reportFatalError(XPathException err) {
        if (!err.hasBeenReported()) {
            this.getErrorListener().fatalError(err);
            err.setHasBeenReported(true);
        }
    }

    public void warning(String message, String errorCode) {
        this.getErrorListener().warning(new XPathException(message, errorCode));
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public DocumentPool getDocumentPool() {
        return this.sourceDocumentPool;
    }

    public void clearDocumentPool() {
        this.sourceDocumentPool.discardIndexes(this.getKeyManager());
        this.sourceDocumentPool = new DocumentPool();
    }

    public void setInitialContextItem(Item item) {
        if (item instanceof NodeInfo) {
            item = this.prepareInputTree((NodeInfo)item);
        }
        this.initialContextItem = item;
        this.contextForGlobalVariables = item;
    }

    public Bindery getBindery() {
        return this.bindery;
    }

    public Item getInitialContextItem() {
        return this.initialContextItem;
    }

    public Item getContextForGlobalVariables() {
        return this.contextForGlobalVariables;
    }

    public void setURIResolver(URIResolver resolver) {
        this.userURIResolver = resolver;
        if (resolver instanceof StandardURIResolver) {
            ((StandardURIResolver)resolver).setConfiguration(this.getConfiguration());
        }
    }

    public URIResolver getURIResolver() {
        return this.userURIResolver;
    }

    public URIResolver getStandardURIResolver() {
        return this.standardURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver resolver) {
        this.outputURIResolver = resolver == null ? this.config.getOutputURIResolver() : resolver;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.outputURIResolver;
    }

    public void setUnparsedTextURIResolver(UnparsedTextURIResolver resolver) {
        this.unparsedTextResolver = resolver;
    }

    public UnparsedTextURIResolver getUnparsedTextURIResolver() {
        return this.unparsedTextResolver;
    }

    public void setCollectionURIResolver(CollectionURIResolver resolver) {
        this.collectionURIResolver = resolver;
    }

    public CollectionURIResolver getCollectionURIResolver() {
        return this.collectionURIResolver == null ? this.getConfiguration().getCollectionURIResolver() : this.collectionURIResolver;
    }

    public void setDefaultCollection(String uri) {
        this.defaultCollectionURI = uri;
    }

    public String getDefaultCollection() {
        return this.defaultCollectionURI == null ? this.getConfiguration().getDefaultCollection() : this.defaultCollectionURI;
    }

    public int getSchemaValidationMode() {
        return this.validationMode;
    }

    public void setSchemaValidationMode(int validationMode) {
        this.validationMode = validationMode;
    }

    public KeyManager getKeyManager() {
        return this.executable.getKeyManager();
    }

    public void setTreeModel(int model) {
        this.treeModel = TreeModel.getTreeModel(model);
    }

    public int getTreeModel() {
        return this.treeModel.getSymbolicValue();
    }

    public void setModel(TreeModel model) {
        this.treeModel = model;
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public Builder makeBuilder() {
        Builder b = this.treeModel.makeBuilder(this.makePipelineConfiguration());
        b.setTiming(this.config.isTiming());
        b.setLineNumbering(this.config.isLineNumbering());
        return b;
    }

    public void setStripSourceTrees(boolean strip) {
        this.stripSourceTrees = strip;
    }

    public boolean isStripSourceTree() {
        return this.stripSourceTrees;
    }

    public Stripper makeStripper(Receiver next) {
        if (next == null) {
            next = new Sink(this.makePipelineConfiguration());
        }
        return new Stripper(this.getSpaceStrippingRule(), next);
    }

    public SpaceStrippingRule getSpaceStrippingRule() {
        if (this.config.isStripsAllWhiteSpace()) {
            return AllElementsSpaceStrippingRule.getInstance();
        }
        if (this.executable == null) {
            return NoElementsSpaceStrippingRule.getInstance();
        }
        return this.executable.getStripperRules();
    }

    public void registerDocument(DocumentInfo doc, DocumentURI uri) throws XPathException {
        if (doc == null) {
            throw new NullPointerException("null");
        }
        if (!this.getExecutable().isSchemaAware() && !Untyped.getInstance().equals(doc.getSchemaType())) {
            String task = this.getExecutable().getHostLanguage() == 50 ? "transformation" : "query";
            throw new XPathException("The " + task + " is not schema-aware, so the source document must be untyped");
        }
        if (uri != null) {
            this.sourceDocumentPool.add(doc, uri);
        }
    }

    public RuleManager getRuleManager() {
        Executable exec = this.getExecutable();
        return exec instanceof PreparedStylesheet ? ((PreparedStylesheet)this.getExecutable()).getRuleManager() : null;
    }

    public void setTraceListener(TraceListener listener) {
        this.traceListener = listener;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public final boolean isTracing() {
        return this.traceListener != null && !this.tracingPaused;
    }

    public final void pauseTracing(boolean pause) {
        this.tracingPaused = pause;
    }

    public void addTraceListener(TraceListener trace) {
        if (trace != null) {
            this.traceListener = TraceEventMulticaster.add(this.traceListener, trace);
        }
    }

    public void removeTraceListener(TraceListener trace) {
        this.traceListener = TraceEventMulticaster.remove(this.traceListener, trace);
    }

    public void setTraceFunctionDestination(Logger stream) {
        this.traceFunctionDestination = stream;
    }

    public Logger getTraceFunctionDestination() {
        return this.traceFunctionDestination;
    }

    public void setExecutable(Executable exec) {
        this.executable = exec;
    }

    public void initializeController(GlobalParameterSet params) throws XPathException {
        if (this.traceListener != null) {
            this.traceListener.open(this);
        }
        this.bindery = new Bindery();
        this.bindery.allocateGlobals(this.executable.getGlobalVariableMap());
        this.executable.checkAllRequiredParamsArePresent(params);
        this.bindery.defineGlobalParameters(params);
    }

    public Object getUserData(Object key, String name) {
        String keyValue = key.hashCode() + " " + name;
        return this.userDataTable.get(keyValue);
    }

    public void setUserData(Object key, String name, Object data) {
        String keyVal = key.hashCode() + " " + name;
        if (data == null) {
            this.userDataTable.remove(keyVal);
        } else {
            this.userDataTable.put(keyVal, data);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transform(Source source, Receiver receiver) throws XPathException {
        if (this.inUse) {
            throw new IllegalStateException("The Transformer is being used recursively or concurrently. This is not permitted.");
        }
        this.inUse = true;
        this.clearPerTransformationData();
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been prepared");
        }
        if (!this.dateTimePreset) {
            this.currentDateTime = null;
        }
        if (source instanceof SAXSource && this.config.getBooleanProperty("http://saxon.sf.net/feature/ignoreSAXSourceParser")) {
            ((SAXSource)source).setXMLReader(null);
        }
        boolean close = false;
        try {
            Source s2;
            NodeInfo startNode = null;
            boolean wrap = true;
            boolean streaming = false;
            int validationMode = this.getSchemaValidationMode();
            Source underSource = source;
            if (source instanceof AugmentedSource) {
                Boolean localWrap = ((AugmentedSource)source).getWrapDocument();
                if (localWrap != null) {
                    wrap = localWrap;
                }
                close = ((AugmentedSource)source).isPleaseCloseAfterUse();
                int localValidate = ((AugmentedSource)source).getSchemaValidation();
                if (localValidate != 0) {
                    validationMode = localValidate;
                }
                if (validationMode == 1 || validationMode == 2) {
                    wrap = false;
                }
                underSource = ((AugmentedSource)source).getContainedSource();
            }
            if ((s2 = this.config.getSourceResolver().resolveSource(underSource, this.config)) != null) {
                underSource = s2;
            }
            if (wrap && (underSource instanceof NodeInfo || underSource instanceof DOMSource)) {
                startNode = this.prepareInputTree(underSource);
                String uri = underSource.getSystemId();
                DocumentInfo root = startNode.getDocumentRoot();
                if (root != null) {
                    this.registerDocument(startNode.getDocumentRoot(), uri == null ? null : new DocumentURI(uri));
                }
            } else if (source == null) {
                if (this.initialMode != null) {
                    throw new XPathException("Either a source document or initial match selection must be specified for an initial mode", "XTDE0044");
                }
                if (this.initialTemplate == null && this.initialFunction == null) {
                    throw new XPathException("Either a source document, an initial template or an initial function must be specified");
                }
            } else {
                Mode mode = this.initialMode;
                if (mode == null) {
                    mode = ((PreparedStylesheet)this.executable).getRuleManager().getUnnamedMode();
                }
                if (mode == null || this.initialMode != null && mode.isEmpty()) {
                    throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getModeName().getDisplayName()) + " does not exist", "XTDE0045");
                }
                if (mode.isDeclaredStreamable()) {
                    if (!(source instanceof StreamSource) && !(source instanceof SAXSource) && !(source instanceof Transmitter)) throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getModeName().getDisplayName()) + " is streamable: must supply a SAXSource or StreamSource", "SXST0061");
                    streaming = true;
                    this.transformStream(source, mode, receiver);
                } else {
                    Builder sourceBuilder = this.makeBuilder();
                    if (sourceBuilder instanceof TinyBuilder) {
                        ((TinyBuilder)sourceBuilder).setStatistics(Statistics.SOURCE_DOCUMENT_STATISTICS);
                    }
                    Receiver r = sourceBuilder;
                    if (this.config.isStripsAllWhiteSpace() || this.executable.stripsWhitespace() || validationMode == 1 || validationMode == 2) {
                        r = this.makeStripper(sourceBuilder);
                    }
                    if (this.executable.stripsInputTypeAnnotations()) {
                        r = this.config.getAnnotationStripper(r);
                    }
                    PipelineConfiguration pipe = sourceBuilder.getPipelineConfiguration();
                    pipe.getParseOptions().setSchemaValidationMode(validationMode);
                    r.setPipelineConfiguration(pipe);
                    Sender.send(source, r, null);
                    if (close) {
                        ((AugmentedSource)source).close();
                    }
                    DocumentInfo doc = (DocumentInfo)sourceBuilder.getCurrentRoot();
                    sourceBuilder.reset();
                    if (source.getSystemId() != null) {
                        this.registerDocument(doc, new DocumentURI(source.getSystemId()));
                    }
                    startNode = doc;
                }
            }
            if (streaming) return;
            this.transformDocument(startNode, receiver);
            return;
        }
        catch (TerminationException err) {
            if (err.hasBeenReported()) throw err;
            this.reportFatalError(err);
            throw err;
        }
        catch (XPathException err) {
            Throwable cause = err.getException();
            if (cause != null && cause instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)cause;
                if (!((cause = spe.getException()) instanceof RuntimeException)) throw err;
                this.reportFatalError(err);
                throw err;
            } else {
                this.reportFatalError(err);
            }
            throw err;
        }
        finally {
            this.inUse = false;
            if (close && source instanceof AugmentedSource) {
                ((AugmentedSource)source).close();
            }
            if (this.messageReceiver != null) {
                this.messageReceiver.close();
            }
        }
    }

    public void applyTemplates(Sequence source, Receiver outputDestination) throws XPathException {
        if (this.inUse) {
            throw new IllegalStateException("The Transformer is being used recursively or concurrently. This is not permitted.");
        }
        this.inUse = true;
        this.clearPerTransformationData();
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been prepared");
        }
        if (!this.dateTimePreset) {
            this.currentDateTime = null;
        }
        boolean close = false;
        try {
            Item next;
            Mode mode = this.initialMode;
            if (mode == null) {
                mode = ((PreparedStylesheet)this.executable).getRuleManager().getUnnamedMode();
            }
            if (mode == null || this.initialMode != null && mode.isEmpty()) {
                throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getModeName().getDisplayName()) + " does not exist", "XTDE0045");
            }
            if (mode.isDeclaredStreamable()) {
                throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getModeName().getDisplayName()) + " is streamable: must supply a StreamSource or SAXSource");
            }
            this.openMessageEmitter();
            boolean mustClose = false;
            this.principalResult = outputDestination;
            if (this.principalResultURI == null) {
                this.principalResultURI = outputDestination.getSystemId();
            }
            ParameterSet ordinaryParams = null;
            if (this.initialTemplateParams != null) {
                ordinaryParams = new ParameterSet(this.initialTemplateParams);
            }
            ParameterSet tunnelParams = null;
            if (this.initialTemplateTunnelParams != null) {
                tunnelParams = new ParameterSet(this.initialTemplateTunnelParams);
            }
            XPathContextMajor initialContext = this.newXPathContext();
            initialContext.createThreadManager();
            initialContext.setOriginatingConstructType(2000);
            ItemMappingIterator<Item, Item> iter = source.iterate();
            initialContext.setCurrentIterator(new FocusTrackingIterator(iter));
            while ((next = iter.next()) != null) {
                if (!(next instanceof NodeInfo)) continue;
                NodeInfo startNode = (NodeInfo)next;
                if (startNode.getConfiguration() == null) {
                    throw new XPathException("The supplied source document must be associated with a Configuration");
                }
                if (!startNode.getConfiguration().isCompatible(this.executable.getConfiguration())) {
                    throw new XPathException("Source document and stylesheet must use the same or compatible Configurations", "SXXP0004");
                }
                if (!(startNode instanceof DocumentInfo) || !((DocumentInfo)startNode).isTyped() || this.executable.isSchemaAware()) continue;
                throw new XPathException("Cannot use a schema-validated source document unless the stylesheet is schema-aware");
            }
            if (this.stripSourceTrees && this.executable.stripsWhitespace()) {
                ItemMappingFunction<Item, Item> spaceStripper = new ItemMappingFunction<Item, Item>(){

                    @Override
                    public Item mapItem(Item item) throws XPathException {
                        if (item instanceof DocumentInfo) {
                            return new SpaceStrippedDocument((DocumentInfo)item, Controller.this.executable.getStripperRules());
                        }
                        return item;
                    }
                };
                iter = new ItemMappingIterator<Item, Item>(iter, spaceStripper);
            }
            if (this.executable.stripsInputTypeAnnotations()) {
                ItemMappingFunction<Item, Item> typeStripper = new ItemMappingFunction<Item, Item>(){

                    @Override
                    public Item mapItem(Item item) throws XPathException {
                        if (item instanceof DocumentInfo) {
                            return new TypeStrippedDocument((DocumentInfo)item);
                        }
                        return item;
                    }
                };
                iter = new ItemMappingIterator<Item, Item>(iter, typeStripper);
            }
            boolean raw = outputDestination instanceof SequenceOutputter;
            outputDestination = this.openResult(outputDestination, initialContext, raw);
            initialContext.setCurrentIterator(new FocusTrackingIterator(iter.getAnother()));
            initialContext.setCurrentMode(mode);
            for (TailCall tc = mode.applyTemplates(ordinaryParams, tunnelParams, initialContext, 0); tc != null; tc = tc.processLeavingTail()) {
            }
            if (this.traceListener != null) {
                this.traceListener.close();
            }
            initialContext.notifyChildThreads();
            this.closeResult(outputDestination, mustClose, initialContext, raw);
        }
        catch (TerminationException err) {
            if (!err.hasBeenReported()) {
                this.reportFatalError(err);
            }
            throw err;
        }
        catch (XPathException err) {
            Throwable cause = err.getException();
            if (cause != null && cause instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)cause;
                if ((cause = spe.getException()) instanceof RuntimeException) {
                    this.reportFatalError(err);
                }
            } else {
                this.reportFatalError(err);
            }
            throw err;
        }
        finally {
            this.inUse = false;
            this.closeMessageEmitter();
            if (close && source instanceof AugmentedSource) {
                ((AugmentedSource)((Object)source)).close();
            }
            this.principalResultURI = null;
        }
    }

    public NodeInfo prepareInputTree(Source source) {
        AbstractVirtualNode strippedDoc;
        DocumentInfo docInfo;
        NodeInfo start = this.getConfiguration().unravel(source);
        if (this.stripSourceTrees && this.executable.stripsWhitespace()) {
            docInfo = start.getDocumentRoot();
            strippedDoc = new SpaceStrippedDocument(docInfo, this.getSpaceStrippingRule());
            start = ((SpaceStrippedDocument)strippedDoc).wrap(start);
        }
        if (this.executable.stripsInputTypeAnnotations()) {
            docInfo = start.getDocumentRoot();
            if (!Untyped.getInstance().equals(docInfo.getSchemaType())) {
                strippedDoc = new TypeStrippedDocument(docInfo);
                start = ((TypeStrippedDocument)strippedDoc).wrap(start);
            }
        }
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformDocument(NodeInfo startNode, Receiver outputDestination) throws XPathException {
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been compiled");
        }
        this.openMessageEmitter();
        boolean mustClose = false;
        try {
            this.principalResult = outputDestination;
            if (this.principalResultURI == null) {
                this.principalResultURI = outputDestination.getSystemId();
            }
            XPathContextMajor initialContext = this.newXPathContext();
            initialContext.createThreadManager();
            initialContext.setOriginatingConstructType(2000);
            if (startNode != null) {
                this.initialContextItem = startNode;
                this.contextForGlobalVariables = startNode.getRoot();
                if (startNode.getConfiguration() == null) {
                    throw new XPathException("The supplied source document must be associated with a Configuration");
                }
                if (!startNode.getConfiguration().isCompatible(this.executable.getConfiguration())) {
                    throw new XPathException("Source document and stylesheet must use the same or compatible Configurations", "SXXP0004");
                }
                if (startNode instanceof DocumentInfo && ((DocumentInfo)startNode).isTyped() && !this.executable.isSchemaAware()) {
                    throw new XPathException("Cannot use a schema-validated source document unless the stylesheet is schema-aware");
                }
                UnfailingIterator currentIter = SingletonIterator.makeIterator(startNode);
                FocusTrackingIterator focus = new FocusTrackingIterator(currentIter);
                if (this.initialTemplate != null) {
                    focus.next();
                }
                initialContext.setCurrentIterator(focus);
            }
            if (this.traceListener != null) {
                this.preEvaluateGlobals(initialContext);
            }
            boolean raw = outputDestination instanceof SequenceOutputter;
            outputDestination = this.openResult(outputDestination, initialContext, raw);
            ParameterSet ordinaryParams = null;
            if (this.initialTemplateParams != null) {
                ordinaryParams = new ParameterSet(this.initialTemplateParams);
            }
            ParameterSet tunnelParams = null;
            if (this.initialTemplateTunnelParams != null) {
                tunnelParams = new ParameterSet(this.initialTemplateTunnelParams);
            }
            if (this.initialTemplate == null) {
                NodeInfo topElement;
                this.initialContextItem = startNode;
                Mode mode = this.initialMode;
                if (mode == null) {
                    mode = ((PreparedStylesheet)this.executable).getRuleManager().getUnnamedMode();
                }
                if (this.initialMode != null && mode.isEmpty()) {
                    throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getModeName().getDisplayName()) + " does not exist", "XTDE0045");
                }
                if (mode.isDeclaredStreamable()) {
                    throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getModeName().getDisplayName()) + " is streamable: must supply a StreamSource or SAXSource");
                }
                if (startNode instanceof DocumentInfo && !this.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/suppressXsltNamespaceCheck") && (topElement = startNode.iterateAxis((byte)3, NodeKindTest.ELEMENT).next()) != null) {
                    String uri = topElement.getURI();
                    Set<String> explicitNamespaces = mode.getExplicitNamespaces(this.getConfiguration().getNamePool());
                    if (!explicitNamespaces.isEmpty() && !explicitNamespaces.contains(uri)) {
                        NodeInfo element;
                        AxisIterator allElements = startNode.iterateAxis((byte)4, NodeKindTest.ELEMENT);
                        boolean found = false;
                        while ((element = allElements.next()) != null) {
                            String ns = element.getURI();
                            if (!explicitNamespaces.contains(ns)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            String suffix = "(Use --suppressXsltNamespaceCheck:on to avoid this warning)";
                            if (explicitNamespaces.size() == 1 && explicitNamespaces.contains("")) {
                                this.warning("The source document is in namespace " + uri + ", but all the template rules match elements in no namespace " + suffix, "SXXP0005");
                            } else if (uri.equals("")) {
                                this.warning("The source document is in no namespace, but the template rules all expect elements in a namespace " + suffix, "SXXP0005");
                            } else {
                                this.warning("The source document is in namespace " + uri + ", but none of the template rules match elements in this namespace " + suffix, "SXXP0005");
                            }
                        }
                    }
                }
                initialContext.setCurrentMode(mode);
                for (TailCall tc = mode.applyTemplates(ordinaryParams, tunnelParams, initialContext, 0); tc != null; tc = tc.processLeavingTail()) {
                }
            } else {
                Template t = this.initialTemplate;
                XPathContextMajor c2 = initialContext.newContext();
                initialContext.setOriginatingConstructType(2000);
                c2.setCurrentComponent(t.getDeclaringComponent());
                c2.openStackFrame(t.getStackFrameMap());
                c2.setLocalParameters(ordinaryParams);
                c2.setTunnelParameters(tunnelParams);
                for (TailCall tc = t.expand(c2); tc != null; tc = tc.processLeavingTail()) {
                }
            }
            if (this.traceListener != null) {
                this.traceListener.close();
            }
            initialContext.notifyChildThreads();
            this.closeResult(outputDestination, mustClose, initialContext, raw);
        }
        finally {
            this.closeMessageEmitter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callTemplate(StructuredQName initialTemplateName, Receiver outputDestination) throws XPathException {
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been compiled");
        }
        if (this.initialMode != null && !this.initialMode.isDefaultMode()) {
            throw new XPathException("Initial mode and template cannot both be defined", "XTDE0047");
        }
        this.openMessageEmitter();
        boolean mustClose = false;
        try {
            Template t;
            this.principalResult = outputDestination;
            if (this.principalResultURI == null) {
                this.principalResultURI = outputDestination.getSystemId();
            }
            XPathContextMajor initialContext = this.newXPathContext();
            initialContext.createThreadManager();
            initialContext.setOriginatingConstructType(2000);
            NodeInfo startNode = null;
            if (this.initialContextItem != null) {
                startNode = (NodeInfo)this.initialContextItem.head();
            }
            if (startNode != null) {
                this.initialContextItem = startNode;
                this.contextForGlobalVariables = startNode.getRoot();
                if (startNode.getConfiguration() == null) {
                    throw new XPathException("The supplied source document must be associated with a Configuration");
                }
                if (!startNode.getConfiguration().isCompatible(this.executable.getConfiguration())) {
                    throw new XPathException("Source document and stylesheet must use the same or compatible Configurations", "SXXP0004");
                }
                if (startNode instanceof DocumentInfo && ((DocumentInfo)startNode).isTyped() && !this.executable.isSchemaAware()) {
                    throw new XPathException("Cannot use a schema-validated source document unless the stylesheet is schema-aware");
                }
                UnfailingIterator currentIter = SingletonIterator.makeIterator(startNode);
                FocusTrackingIterator focus = new FocusTrackingIterator(currentIter);
                if (initialTemplateName != null) {
                    focus.next();
                }
                initialContext.setCurrentIterator(focus);
            }
            if (this.traceListener != null) {
                this.preEvaluateGlobals(initialContext);
            }
            boolean raw = outputDestination instanceof SequenceOutputter;
            outputDestination = this.openResult(outputDestination, initialContext, raw);
            ParameterSet ordinaryParams = null;
            if (this.initialTemplateParams != null) {
                ordinaryParams = new ParameterSet(this.initialTemplateParams);
            }
            ParameterSet tunnelParams = null;
            if (this.initialTemplateTunnelParams != null) {
                tunnelParams = new ParameterSet(this.initialTemplateTunnelParams);
            }
            if ((t = ((PreparedStylesheet)this.executable).getNamedTemplate(initialTemplateName)) == null) {
                throw new XPathException("Template " + initialTemplateName.getDisplayName() + " does not exist (or is not public)", "XTDE0040");
            }
            XPathContextMajor c2 = initialContext.newContext();
            initialContext.setOriginatingConstructType(2000);
            c2.setCurrentComponent(t.getDeclaringComponent());
            c2.openStackFrame(t.getStackFrameMap());
            c2.setLocalParameters(ordinaryParams);
            c2.setTunnelParameters(tunnelParams);
            for (TailCall tc = t.expand(c2); tc != null; tc = tc.processLeavingTail()) {
            }
            if (this.traceListener != null) {
                this.traceListener.close();
            }
            initialContext.notifyChildThreads();
            this.closeResult(outputDestination, mustClose, initialContext, raw);
        }
        finally {
            this.closeMessageEmitter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformStream(Source source, Mode mode, Receiver result) throws XPathException {
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been compiled");
        }
        this.openMessageEmitter();
        try {
            boolean mustClose = result instanceof StreamResult && ((StreamResult)((Object)result)).getOutputStream() == null;
            this.principalResult = result;
            if (this.principalResultURI == null) {
                this.principalResultURI = result.getSystemId();
            }
            XPathContextMajor initialContext = this.newXPathContext();
            initialContext.setOriginatingConstructType(2000);
            this.initialContextItem = null;
            this.contextForGlobalVariables = null;
            boolean raw = result instanceof SequenceOutputter;
            result = this.openResult(result, initialContext, raw);
            if (!mode.isDeclaredStreamable()) {
                if (this.config.getBooleanProperty("http://saxon.sf.net/feature/streamingFallback")) {
                    this.warning("Mode is not streamable; attempting fallback to non-streamed evaluation", "");
                    DocumentInfo doc = this.config.buildDocument(source);
                    this.initialMode = mode;
                    this.transformDocument(doc, result);
                    return;
                }
                throw new XPathException("mode supplied to transformStream() must be streamable");
            }
            Receiver despatcher = this.config.makeStreamingTransformer(initialContext, mode);
            if (despatcher == null) {
                throw new XPathException("Streaming requires Saxon-EE");
            }
            if (this.config.isStripsAllWhiteSpace() || this.executable.stripsWhitespace()) {
                despatcher = this.makeStripper(despatcher);
            }
            PipelineConfiguration pipe = despatcher.getPipelineConfiguration();
            pipe.getParseOptions().setSchemaValidationMode(this.validationMode);
            try {
                Sender.send(source, despatcher, null);
            }
            catch (QuitParsingException quitParsingException) {
                // empty catch block
            }
            if (this.traceListener != null) {
                this.traceListener.close();
            }
            this.closeResult(result, mustClose, initialContext, raw);
        }
        finally {
            this.closeMessageEmitter();
        }
    }

    public Receiver getStreamingReceiver(Mode mode, Receiver result) throws XPathException {
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been compiled");
        }
        this.openMessageEmitter();
        final boolean mustClose = result instanceof StreamResult && ((StreamResult)((Object)result)).getOutputStream() == null;
        this.principalResult = result;
        if (this.principalResultURI == null) {
            this.principalResultURI = result.getSystemId();
        }
        final XPathContextMajor initialContext = this.newXPathContext();
        initialContext.setOriginatingConstructType(2000);
        this.initialContextItem = null;
        this.contextForGlobalVariables = null;
        final boolean raw = result instanceof SequenceOutputter;
        final Receiver result2 = this.openResult(result, initialContext, raw);
        if (!mode.isDeclaredStreamable()) {
            throw new XPathException("mode supplied to getStreamingReceiver() must be streamable");
        }
        Receiver despatcher = this.config.makeStreamingTransformer(initialContext, mode);
        if (despatcher == null) {
            throw new XPathException("Streaming requires Saxon-EE");
        }
        if (this.config.isStripsAllWhiteSpace() || this.executable.stripsWhitespace()) {
            despatcher = this.makeStripper(despatcher);
        }
        despatcher.setPipelineConfiguration(this.makePipelineConfiguration());
        return new ProxyReceiver(despatcher){

            public void close() throws XPathException {
                if (Controller.this.traceListener != null) {
                    Controller.this.traceListener.close();
                }
                Controller.this.closeResult(result2, mustClose, initialContext, raw);
                Controller.this.closeMessageEmitter();
            }
        };
    }

    private void closeMessageEmitter() throws XPathException {
        Receiver me = this.getMessageEmitter();
        if (me != null) {
            me.close();
        }
    }

    private void closeResult(Result result, boolean mustClose, XPathContextMajor initialContext, boolean raw) throws XPathException {
        OutputStream os;
        SequenceReceiver out = initialContext.getReceiver();
        if (!raw) {
            out.endDocument();
        }
        out.close();
        if (mustClose && result instanceof StreamResult && (os = ((StreamResult)result).getOutputStream()) != null) {
            try {
                os.close();
            }
            catch (IOException err) {
                throw new XPathException(err);
            }
        }
    }

    private Receiver openResult(Receiver result, XPathContextMajor initialContext, boolean raw) throws XPathException {
        Receiver receiver = result;
        boolean openNow = false;
        if (this.getExecutable().createsSecondaryResult()) {
            receiver = new ImplicitResultChecker(receiver, this);
            receiver.setPipelineConfiguration(this.makePipelineConfiguration());
        } else {
            openNow = true;
        }
        receiver.getPipelineConfiguration().setController(this);
        if (raw) {
            initialContext.setReceiver((SequenceOutputter)receiver);
        } else {
            initialContext.changeOutputDestination(receiver, null);
        }
        if (openNow) {
            SequenceReceiver out = initialContext.getReceiver();
            out.open();
            if (!raw) {
                out.startDocument(0);
            }
        }
        return result;
    }

    private void openMessageEmitter() throws XPathException {
        if (this.getMessageEmitter() == null) {
            Receiver me = this.makeMessageReceiver();
            this.setMessageEmitter(me);
            if (me instanceof Emitter && ((Emitter)me).getWriter() == null) {
                ((Emitter)me).setStreamResult(this.getConfiguration().getLogger().asStreamResult());
            }
        }
        this.getMessageEmitter().open();
    }

    public void preEvaluateGlobals(XPathContext context) throws XPathException {
        List<GlobalVariable> vars = this.getExecutable().getCompiledGlobalVariables();
        if (vars != null) {
            for (GlobalVariable var : vars) {
                if (var.isUnused()) continue;
                try {
                    var.evaluateVariable(context, var.getDeclaringComponent());
                }
                catch (XPathException err) {
                    SingletonClosure closure = new SingletonClosure(new ErrorExpression(err), context);
                    this.getBindery().setGlobalVariable(var, closure);
                }
            }
        }
    }

    public void setCurrentDateTime(DateTimeValue dateTime) throws XPathException {
        if (this.currentDateTime == null) {
            if (dateTime.getComponent(7) == null) {
                throw new XPathException("No timezone is present in supplied value of current date/time");
            }
        } else {
            throw new IllegalStateException("Current date and time can only be set once, and cannot subsequently be changed");
        }
        this.currentDateTime = dateTime;
        this.dateTimePreset = true;
    }

    public DateTimeValue getCurrentDateTime() {
        if (this.currentDateTime == null) {
            this.currentDateTime = new DateTimeValue(new GregorianCalendar(), true);
        }
        return this.currentDateTime;
    }

    public int getImplicitTimezone() {
        return this.getCurrentDateTime().getTimezoneInMinutes();
    }

    public XPathContextMajor newXPathContext() {
        XPathContextMajor c = new XPathContextMajor(this);
        c.setCurrentOutputUri(this.principalResultURI);
        return c;
    }

    public void setRememberedNumber(NodeInfo node, int number) {
        this.lastRememberedNode = node;
        this.lastRememberedNumber = number;
    }

    public int getRememberedNumber(NodeInfo node) {
        if (this.lastRememberedNode == node) {
            return this.lastRememberedNumber;
        }
        return -1;
    }

    public void setUseDocumentProjection(PathMap pathMap) {
        this.pathMap = pathMap;
    }

    public PathMap getPathMapForDocumentProjection() {
        return this.pathMap;
    }
}

