<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:math="http://www.w3.org/2005/xpath-functions/math" xmlns:map="http://www.w3.org/2005/xpath-functions/map" xmlns:doc="http://www.saxonica.com/ns/doc"
    xmlns:f="MyFunctions" xmlns:svg="http://www.w3.org/2000/svg" xmlns:saxon="http://saxon.sf.net/" exclude-result-prefixes="xs math f doc" version="3.0">

    <doc:synopsis title="Template call display">
        <p>Generate a set of displays for template calls</p>
    </doc:synopsis>

    <!-- *IMPORTANT* This needs the '-l' option on Saxon to track source line numbers -->

    <xsl:include href="stats.svg.xsl"/>
    <xsl:param name="CSS.file">../../../mystyle.css</xsl:param>
    
    <xsl:variable name="USE-OLD-MAP" select="starts-with(system-property('xsl:product-version'),'9.6')" static="yes"/>
    <xsl:variable name="USE-NEW-MAP" select="not($USE-OLD-MAP)" static="yes"/>
    
    <xsl:output method="xml" indent="yes"/>
  <!--  <xsl:template match="/">
        <xsl:apply-templates select="." mode="stats.time"/>
    </xsl:template>-->

    <xsl:mode name="stats.time" on-no-match="shallow-copy"/>

    <xsl:template match="group[tokenize(@show, '\s+') = 'call']" mode="stats.call">
        <xsl:param name="svg.root" select="@svg" tunnel="yes"/>
        <xsl:variable name="n.cases" select="count(case)"/>

        <xsl:variable name="explain.docs" select="case/@explain/doc(.)"/>

        <!--<xsl:variable name="modes"
            select="
                map:merge($explain.docs/stylesheet/mode/map:entry((@name,
                '#default')[1], .))"/>-->
        <xsl:variable name="modes" select="
                map:merge(stylesheet/mode/map:entry(@name, template))"/>
        <!--<xsl:variable name="sources" select="distinct-values($explain.docs//templateRule/@module)"/>-->
        <xsl:variable name="sources" select="distinct-values(map:keys($modes)!$modes(.)/@module)" as="xs:string*"/>
        <!--<xsl:variable name="sources" select="distinct-values($explain.doc//templateRule/substring-after(@loc,'#'))"/>-->
        <xsl:variable name="stylesheet.templates" select="map:new($sources ! map:entry(tokenize(., '/')[last()], doc(.)//xsl:template[@match]))"/>
        <xsl:variable name="sources.short" select="distinct-values($sources ! tokenize(., '/')[last()])"/>
        <xsl:variable name="short2long" select="map:new($sources ! map:entry(tokenize(., '/')[last()], .))"/>
        <xsl:variable name="sources.matches" select="map:new($sources ! map:entry(., map:new(doc(.)//xsl:template/@match/map:entry(saxon:line-number(.), .))))"/>

        <!-- <xsl:variable name="times" select="case/stats/rule"/>
-->
        <xsl:variable name="key" as="element()*" xmlns="http://www.w3.org/2000/svg" expand-text="yes">
            <svg x="800" y="130">
                <xsl:for-each select="case">
                    <circle cx="5" cy="{20*position() - 8}" r="5" class="{@name}" stroke="none"/>
                    <text x="20" y="{20*position()}" class="key label">{(@label,@name)[1]}</text>
                </xsl:for-each>
            </svg>
        </xsl:variable>

        <xsl:variable name="values" as="element()*">
            <xsl:for-each select="comparison/mode">
                <xsl:copy>
                    <xsl:sequence select="@*"/>
                    <xsl:for-each select="rule">
                        <xsl:sort select="max(case/@invocations)" order="descending"/>
                        <xsl:copy>
                            <xsl:sequence select="@*"/>
                            <xsl:attribute name="max" select="max(case/@invocations)"/>
                            <xsl:variable name="line" select="number(substring-after(@loc, '#'))"/>
                            <xsl:variable name="module" select="substring-before(@loc, '#')"/>
                            <xsl:attribute name="match" select="$sources.matches($module)($line)"/>
                            <xsl:sequence select="*"/>
                        </xsl:copy>
                    </xsl:for-each>
                </xsl:copy>
            </xsl:for-each>
        </xsl:variable>

        <!--<xsl:variable name="mode.wanted">#default</xsl:variable>-->
        <!--        <times>
            <xsl:sequence select="$values[@name = $mode.wanted]"/>
        </times>-->
        <xsl:for-each select="$values[@isBig=true()]">
            <xsl:variable name="graphics" as="element()*">
                <xsl:apply-templates select="reverse(subsequence(./*, 1, 7))" mode="svg:barchart-call">
                    <xsl:with-param name="sep" select="$n.cases + 2" tunnel="yes"/>
                </xsl:apply-templates>
            </xsl:variable>

         <!--   <graphics>
                <xsl:sequence select="$graphics"/>
            </graphics>-->
            <xsl:variable name="g"
                select="map:merge((f:graphics.vals($graphics), 
                map{ 
                'grid' := svg:makeGrid.vertical#3,
                'axis.x.format':= function($a) {format-number($a idiv 1,'0')} ,
                'axis.x.label' := '# calls',
                'ABCDEF' := $key,                
                'label' := ('Template pattern matches','mode:'||@name)
                } ))" use-when="$USE-OLD-MAP"/>
            <xsl:variable name="g"
                select="map:merge((f:graphics.vals($graphics), 
                map{ 
                'grid' : svg:makeGrid.vertical#3,
                'axis.x.format' : function($a) {format-number($a idiv 1,'0')} ,
                'axis.x.label' : '# calls',
                'ABCDEF' : $key,                
                'label' : ('Template pattern matches','mode:'||@name)
                } ))" use-when="$USE-NEW-MAP"/>
            <xsl:call-template name="svg:makeFile" use-when="true()">
                <xsl:with-param name="svg.root" select="$svg.root"/>
                <xsl:with-param name="mode" select="@name"/>
                <xsl:with-param name="g" select="$g"/>
                <xsl:with-param name="name">calls</xsl:with-param>
                <xsl:with-param name="content" select="$graphics"/>
            </xsl:call-template>
        </xsl:for-each>
   </xsl:template>

    <xsl:mode name="svg:barchart-call" on-no-match="deep-skip"/>

    <xsl:template match="rule" mode="svg:barchart-call" xmlns="http://www.w3.org/2000/svg" expand-text="yes">
        <xsl:param name="sep" as="xs:integer?" select="4" tunnel="yes"/>
        <xsl:variable name="pos" select="(position() - 1) * $sep"/>
        <text class="match" x="0.5" y="{$pos + $sep - 1.5}">{@order}:{@rank} → {@match}</text>
        <xsl:apply-templates mode="#current">
            <xsl:with-param name="y" select="$pos + 1" tunnel="yes"/>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="rule/case" mode="svg:barchart-call" xmlns="http://www.w3.org/2000/svg">
        <xsl:param name="atts" as="attribute()*" tunnel="yes"/>
        <xsl:param name="y" as="xs:integer?" select="0" tunnel="yes"/>
        <xsl:variable name="start" as="xs:integer" select="0"/>
        <xsl:variable name="end" as="xs:integer" select="@invocations"/>
        <xsl:variable name="y" select="position() + $y - 1"/>
        <line class="{@name} total" x1="0" x2="{$end}" y1="{$y}" y2="{$y}"/>
    </xsl:template>

</xsl:stylesheet>
