/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.java.util.concurrent.locks;

import net.sf.retrotranslator.runtime.impl.WeakIdentityTable;

public class LockSupport_ {
    private static final WeakIdentityTable table = new WeakIdentityTable(){

        protected ThreadLock initialValue() {
            return new ThreadLock();
        }

        protected /* synthetic */ Object initialValue() {
            return this.initialValue();
        }
    };

    private LockSupport_() {
    }

    public static void park() {
        try {
            ((ThreadLock)table.obtain(Thread.currentThread())).park();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void parkNanos(long nanos) {
        try {
            ((ThreadLock)table.obtain(Thread.currentThread())).parkNanos(nanos);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void parkUntil(long deadline) {
        try {
            ((ThreadLock)table.obtain(Thread.currentThread())).parkUntil(deadline);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void unpark(Thread thread) {
        ((ThreadLock)table.obtain(thread)).unpark();
    }

    private static class ThreadLock {
        private boolean permit;

        public synchronized void park() throws InterruptedException {
            if (this.permit) {
                this.permit = false;
            } else {
                this.wait();
            }
        }

        public synchronized void parkNanos(long nanos) throws InterruptedException {
            if (this.permit) {
                this.permit = false;
            } else {
                this.wait(nanos / 1000000L, (int)(nanos % 1000000L));
            }
        }

        public synchronized void parkUntil(long deadline) throws InterruptedException {
            if (this.permit) {
                this.permit = false;
            } else {
                long millis = deadline - System.currentTimeMillis();
                if (millis > 0L) {
                    this.wait(millis);
                }
            }
        }

        public synchronized void unpark() {
            if (!this.permit) {
                this.permit = true;
                this.notify();
            }
        }
    }
}

