/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.jbehave;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.serenitybdd.jbehave.SerenityJBehaveSystemProperties;
import net.thucydides.core.util.EnvironmentVariables;
import org.codehaus.plexus.util.StringUtils;

class StoryPathFinder {
    private final String storyNames;
    private final EnvironmentVariables environmentVariables;
    Set<String> identifiedStoryPaths = Sets.newHashSet();

    public StoryPathFinder(EnvironmentVariables environmentVariables, String storyNames) {
        this.environmentVariables = environmentVariables;
        this.storyNames = storyNames;
    }

    public Set<String> findAllElements() {
        List<String> rootStoryNames = this.rootStoryNamesFrom(this.storyNames);
        HashSet storyPathElements = Sets.newHashSet();
        for (String rootStoryName : rootStoryNames) {
            rootStoryName = this.stripLeadingWildcards(rootStoryName);
            HashSet newPathElements = Sets.newHashSet();
            Optional<URL> storyOnClasspath = this.storyOnClasspath(rootStoryName);
            if (storyOnClasspath.isPresent() && this.unidentified((URL)storyOnClasspath.get())) {
                this.addPathElement(newPathElements, rootStoryName, (URL)storyOnClasspath.get());
            }
            for (String packagePath : this.getClasspathPackages()) {
                String storyFile = this.sanitizedPath(this.join(packagePath, rootStoryName));
                storyOnClasspath = this.storyOnClasspath(storyFile);
                if (!storyOnClasspath.isPresent() || !this.unidentified((URL)storyOnClasspath.get())) continue;
                this.addPathElement(newPathElements, storyFile, (URL)storyOnClasspath.get());
            }
            if (newPathElements.isEmpty()) {
                storyPathElements.add(this.withWildcard(rootStoryName));
                continue;
            }
            storyPathElements.addAll(newPathElements);
        }
        return storyPathElements;
    }

    private void addPathElement(Set<String> storyPathElements, String storyName, URL storyPath) {
        storyPathElements.add(storyName);
        this.identifiedStoryPaths.add(storyPath.getFile().toLowerCase());
    }

    private String stripLeadingWildcards(String rootStoryName) {
        return rootStoryName.startsWith("**/") ? rootStoryName.substring(3) : rootStoryName;
    }

    private boolean unidentified(URL storyPath) {
        return !this.identifiedStoryPaths.contains(storyPath.getFile().toLowerCase());
    }

    private String sanitizedPath(String rawPath) {
        return rawPath.replace("//", "/");
    }

    private String withWildcard(String resourceName) {
        return "**/" + resourceName;
    }

    private Optional<URL> storyOnClasspath(String storyFile) {
        return Optional.fromNullable((Object)this.getClassLoader().getResource(storyFile));
    }

    private List<String> rootStoryNamesFrom(String storyNames) {
        return Lists.newArrayList((Iterable)Splitter.on((String)";").trimResults().omitEmptyStrings().split((CharSequence)storyNames));
    }

    private String join(String packagePath, String storyName) {
        if (packagePath == null) {
            return storyName;
        }
        if (packagePath.endsWith("/")) {
            return packagePath + storyName;
        }
        return packagePath + "/" + storyName;
    }

    private List<String> getClasspathPackages() {
        String storyDirectory = this.environmentVariables.getProperty((Enum)SerenityJBehaveSystemProperties.STORY_DIRECTORY, "stories");
        ArrayList packages = Lists.newArrayList((Object[])new String[]{"/", storyDirectory, "/" + storyDirectory});
        String storyPackages = this.environmentVariables.getProperty(SerenityJBehaveSystemProperties.JBEHAVE_STORY_PACKAGES.getName());
        if (StringUtils.isNotEmpty((String)storyPackages)) {
            packages.addAll(Lists.newArrayList((Iterable)Splitter.on((String)";").trimResults().omitEmptyStrings().split((CharSequence)storyPackages)));
        }
        return packages;
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

