/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa.output;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import net.rootdev.javardfa.output.NTripleSink;

public class TurtleSink
extends NTripleSink {
    private String currentSubject = null;
    private String currentPredicate = null;

    public TurtleSink(OutputStream os, String ... comments) throws UnsupportedEncodingException {
        super(new OutputStreamWriter(os, "UTF-8"), comments);
    }

    public TurtleSink(Writer writer, String ... comments) {
        super(writer, comments);
    }

    @Override
    public void end() {
        this.out.println(".");
        super.end();
    }

    @Override
    public void addObject(String subject, String predicate, String object) {
        this.emitTriple(subject, predicate, this.toNode(object));
    }

    @Override
    public void addLiteral(String subject, String predicate, String lex, String lang, String datatype) {
        this.emitTriple(subject, predicate, this.toLiteral(lex, lang, datatype));
    }

    private void emitTriple(String subject, String predicate, String objectEncoded) {
        if (subject.equals(this.currentSubject)) {
            if (predicate.equals(this.currentPredicate)) {
                this.out.println(",");
                this.out.print("\t\t");
                this.out.print(objectEncoded);
            } else {
                this.out.println(";");
                this.out.print("\t");
                this.out.println(this.toNode(predicate));
                this.out.print("\t\t");
                this.out.print(objectEncoded);
                this.currentPredicate = predicate;
            }
        } else {
            if (this.currentSubject != null) {
                this.out.println(".");
            }
            this.out.println(this.toNode(subject));
            this.out.print("\t");
            this.out.println(this.toNode(predicate));
            this.out.print("\t\t");
            this.out.print(objectEncoded);
            this.currentPredicate = predicate;
            this.currentSubject = subject;
        }
    }

    @Override
    protected final String enc(int codepoint) {
        return new String(new int[]{codepoint}, 0, 1);
    }

    @Override
    protected final String longenc(int codepoint) {
        return new String(new int[]{codepoint}, 0, 1);
    }
}

