/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.encryt;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.List;
import javax.inject.Singleton;
import net.hasor.dataql.UdfSourceAssembly;
import net.hasor.utils.ArrayUtils;

@Singleton
public class CodecUdfSource
implements UdfSourceAssembly {
    public static String encodeString(String content) {
        if (content == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(content.getBytes());
    }

    public static String encodeBytes(List<Byte> content) {
        if (content == null || content.size() == 0) {
            return null;
        }
        byte[] bytes = ArrayUtils.toPrimitive((Byte[])content.toArray(new Byte[0]));
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static String decodeString(String content) {
        if (content == null) {
            return null;
        }
        return new String(Base64.getDecoder().decode(content));
    }

    public static byte[] decodeBytes(String content) {
        if (content == null) {
            return null;
        }
        return Base64.getDecoder().decode(content);
    }

    public static String urlEncode(String content) throws UnsupportedEncodingException {
        if (content == null) {
            return null;
        }
        return URLEncoder.encode(content, "utf-8");
    }

    public static String urlDecode(String content) throws UnsupportedEncodingException {
        if (content == null) {
            return null;
        }
        return URLDecoder.decode(content, "utf-8");
    }
}

