/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db;

import java.util.Map;
import net.hasor.core.AppContext;
import net.hasor.dataql.fx.db.dialect.Db2Dialect;
import net.hasor.dataql.fx.db.dialect.HsqldbDialect;
import net.hasor.dataql.fx.db.dialect.InformixDialect;
import net.hasor.dataql.fx.db.dialect.MySqlDialect;
import net.hasor.dataql.fx.db.dialect.OracleDialect;
import net.hasor.dataql.fx.db.dialect.SqlPageDialect;
import net.hasor.dataql.fx.db.dialect.SqlServer2012Dialect;
import net.hasor.utils.ref.LinkedCaseInsensitiveMap;

public class SqlPageDialectRegister {
    private static Map<String, Class<?>> dialectAliasMap = new LinkedCaseInsensitiveMap();
    private static Map<String, SqlPageDialect> dialectCache = new LinkedCaseInsensitiveMap();

    public static void registerDialectAlias(String alias, Class<? extends SqlPageDialect> dialectClass) {
        dialectAliasMap.put(alias, dialectClass);
    }

    public static SqlPageDialect findOrCreate(String dialectName, AppContext appContext) {
        SqlPageDialect dialect = dialectCache.get(dialectName);
        if (dialect != null) {
            return dialect;
        }
        Class<?> aClass = dialectAliasMap.get(dialectName);
        if (aClass != null) {
            dialect = (SqlPageDialect)appContext.getInstance(aClass);
        } else {
            try {
                aClass = appContext.getClassLoader().loadClass(dialectName);
                dialect = (SqlPageDialect)appContext.getInstance(aClass);
            }
            catch (ClassNotFoundException e) {
                dialect = (SqlPageDialect)appContext.getInstance(dialectName);
            }
        }
        if (dialect == null) {
            throw new IllegalArgumentException("Unable to load dialect " + dialectName);
        }
        dialectCache.put(dialectName, dialect);
        return dialect;
    }

    static {
        SqlPageDialectRegister.registerDialectAlias("h2", HsqldbDialect.class);
        SqlPageDialectRegister.registerDialectAlias("hsqldb", HsqldbDialect.class);
        SqlPageDialectRegister.registerDialectAlias("postgresql", HsqldbDialect.class);
        SqlPageDialectRegister.registerDialectAlias("phoenix", HsqldbDialect.class);
        SqlPageDialectRegister.registerDialectAlias("mysql", MySqlDialect.class);
        SqlPageDialectRegister.registerDialectAlias("mariadb", MySqlDialect.class);
        SqlPageDialectRegister.registerDialectAlias("sqlite", MySqlDialect.class);
        SqlPageDialectRegister.registerDialectAlias("herddb", MySqlDialect.class);
        SqlPageDialectRegister.registerDialectAlias("sqlserver2012", SqlServer2012Dialect.class);
        SqlPageDialectRegister.registerDialectAlias("derby", SqlServer2012Dialect.class);
        SqlPageDialectRegister.registerDialectAlias("oracle", OracleDialect.class);
        SqlPageDialectRegister.registerDialectAlias("db2", Db2Dialect.class);
        SqlPageDialectRegister.registerDialectAlias("informix", InformixDialect.class);
    }
}

