/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.service;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import net.contextfw.web.application.PageContext;
import net.contextfw.web.application.PageHandle;
import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.component.Component;
import net.contextfw.web.application.component.DOMBuilder;
import net.contextfw.web.application.internal.ComponentUpdateHandler;
import net.contextfw.web.application.internal.ComponentUpdateHandlerFactory;
import net.contextfw.web.application.internal.WebResponder;
import net.contextfw.web.application.internal.component.ComponentBuilder;
import net.contextfw.web.application.internal.component.InternalComponentRegister;
import net.contextfw.web.application.internal.component.WebApplicationComponent;
import net.contextfw.web.application.internal.initializer.InitializerContextImpl;
import net.contextfw.web.application.internal.service.UpdateInvocation;
import net.contextfw.web.application.internal.service.WebApplication;
import net.contextfw.web.application.internal.service.WebApplicationConf;
import net.contextfw.web.application.internal.servlet.UriMapping;
import net.contextfw.web.application.internal.util.AttributeHandler;
import net.contextfw.web.application.lifecycle.PageScoped;
import net.contextfw.web.application.lifecycle.ResourceView;
import net.contextfw.web.application.remote.DelayedUpdateHandler;
import net.contextfw.web.application.remote.ResourceBody;
import net.contextfw.web.application.remote.ResourceResponse;
import net.contextfw.web.application.scope.Provided;

@PageScoped
public class WebApplicationImpl
implements WebApplication {
    @Inject
    @Provided
    private Gson gson;
    @Inject
    @Provided
    private ComponentUpdateHandlerFactory euhf;
    @Inject
    @Provided
    private ComponentBuilder builder;
    private static volatile Map<String, ComponentUpdateHandler> updateHandlers = new HashMap<String, ComponentUpdateHandler>();
    @Inject
    @Provided
    private Injector injector;
    @Inject
    private PageContext pageContext;
    @Inject
    private InternalComponentRegister componentRegister;
    @Inject
    private WebApplicationComponent rootComponent;
    private List<Class<? extends Component>> chain;
    private InitializerContextImpl context = null;
    @Inject
    @Provided
    private WebResponder responder;
    private WebResponder.Mode mode = WebResponder.Mode.INIT;
    @Inject
    @Provided
    private AttributeHandler attributes;
    @Inject
    private PageHandle pageHandle;
    private final WebApplicationConf conf;

    @Inject
    public WebApplicationImpl(WebApplicationConf conf) {
        this.conf = conf;
    }

    @Override
    public void initState(UriMapping mapping) {
        this.context = new InitializerContextImpl(this.builder, mapping, this.pageContext.getRequestURI().substring(this.pageContext.getRequest().getContextPath().length()), this.injector, this.pageContext.getRequest(), this.chain);
        this.getRootComponent().registerChild(this.context.initChild());
    }

    @Override
    public boolean sendResponse() {
        try {
            if (this.mode == WebResponder.Mode.INIT) {
                if (this.pageContext.getRedirectUrl() != null) {
                    this.pageContext.getResponse().sendRedirect(this.pageContext.getRedirectUrl());
                    return true;
                }
                if (this.pageContext.getErrorCode() != null) {
                    this.pageContext.getResponse().sendError(this.pageContext.getErrorCode().intValue(), this.pageContext.getErrorMsg());
                    return true;
                }
                if (this.pageContext.isReload()) {
                    StringBuilder sb = new StringBuilder(this.pageContext.getRequestURI());
                    if (this.pageContext.getQueryString() != null) {
                        sb.append("?").append(this.pageContext.getQueryString());
                    }
                    this.pageContext.getResponse().sendRedirect(sb.toString());
                }
            }
            try {
                if (this.mode == WebResponder.Mode.INIT && this.context.getLeaf() instanceof ResourceView) {
                    return this.sendResourceResponse();
                }
                this.sendNormalResponse();
                return false;
            }
            catch (Exception e) {
                if (e instanceof WebApplicationException) {
                    throw (WebApplicationException)e;
                }
                throw new WebApplicationException("Exception while trying to init state", e);
            }
        }
        catch (IOException e) {
            throw new WebApplicationException(e);
        }
    }

    private boolean sendResourceResponse() throws IOException {
        boolean expire = true;
        ResourceView leaf = (ResourceView)((Object)this.context.getLeaf());
        try {
            ResourceBody annotation = leaf.getClass().getMethod("getResponse", new Class[0]).getAnnotation(ResourceBody.class);
            if (annotation != null) {
                expire = annotation.expire();
            }
        }
        catch (SecurityException e) {
            throw new WebApplicationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new WebApplicationException(e);
        }
        Object retVal = leaf.getResponse();
        if (retVal == null) {
            return expire;
        }
        if (retVal instanceof ResourceResponse) {
            ((ResourceResponse)retVal).serve(this.pageContext.getRequest(), this.pageContext.getResponse());
        } else {
            HttpServletResponse response = this.pageContext.getResponse();
            this.setHeaders(response);
            response.setContentType("application/json; charset=UTF-8");
            this.gson.toJson(retVal, (Appendable)response.getWriter());
        }
        return expire;
    }

    private void sendNormalResponse() throws ServletException, IOException {
        this.pageContext.getResponse().setContentType("text/html; charset=UTF-8");
        DOMBuilder d = this.mode == WebResponder.Mode.INIT ? new DOMBuilder("WebApplication", this.attributes, this.builder, this.conf.getNamespaces()) : new DOMBuilder("WebApplication.update", this.attributes, this.builder, this.conf.getNamespaces());
        d.attr("handle", this.pageHandle.toString());
        d.attr("contextPath", this.pageContext.getRequest().getContextPath());
        if (this.pageContext.getLocale() != null) {
            d.attr("xml:lang", this.pageContext.getLocale().toString());
            d.attr("lang", this.pageContext.getLocale().toString());
        }
        if (this.mode == WebResponder.Mode.INIT) {
            this.getRootComponent().buildChild(d);
        } else if (this.pageContext.getRedirectUrl() != null) {
            d.descend("Redirect").attr("href", this.pageContext.getRedirectUrl());
        } else if (this.pageContext.getErrorCode() != null) {
            d.descend("Error").attr("code", this.pageContext.getErrorCode()).text(this.pageContext.getErrorMsg());
        } else if (this.pageContext.isReload()) {
            d.descend("Reload");
        } else {
            this.getRootComponent().buildChildUpdate(d, this.builder);
        }
        this.getRootComponent().clearCascadedUpdate();
        if (this.conf.getXmlParamName() == null || this.pageContext.getRequest().getParameter(this.conf.getXmlParamName()) == null) {
            this.responder.sendResponse(d.toDocument(), this.pageContext.getResponse(), this.mode);
        } else {
            this.responder.sendResponse(d.toDocument(), this.pageContext.getResponse(), WebResponder.Mode.XML);
        }
    }

    @Override
    public UpdateInvocation updateState(String componentId, String method) {
        this.mode = WebResponder.Mode.UPDATE;
        return this.updateElements(componentId, method);
    }

    protected UpdateInvocation updateElements(String id, String method) {
        try {
            ComponentUpdateHandler handler;
            Component element = this.componentRegister.findComponent(id);
            String key = ComponentUpdateHandler.getKey(element.getClass(), method);
            if (!updateHandlers.containsKey(key) || this.conf.isDevelopmentMode()) {
                updateHandlers.put(key, this.euhf.createHandler(element.getClass(), method));
            }
            if ((handler = updateHandlers.get(key)) != null) {
                if (handler.getDelayed() == null || !((DelayedUpdateHandler)this.injector.getInstance(handler.getDelayed().value())).isUpdateDelayed(element, this.pageContext.getRequest())) {
                    return new UpdateInvocation(handler.isResource(), handler.invoke(this.rootComponent, element, this.pageContext.getRequest()));
                }
                return UpdateInvocation.DELAYED;
            }
            return UpdateInvocation.NONE;
        }
        catch (Exception e) {
            if (e instanceof WebApplicationException) {
                throw (WebApplicationException)e;
            }
            throw new WebApplicationException("Failed to update elements", e);
        }
    }

    @Override
    public void setInitializerChain(List<Class<? extends Component>> chain) {
        this.chain = chain;
    }

    public void setHeaders(HttpServletResponse response) {
        response.addHeader("Expires", "Sun, 19 Nov 1978 05:00:00 GMT");
        response.addHeader("Last-Modified", new Date().toString());
        response.addHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Pragma", "no-cache");
        response.setHeader("Connection", "Keep-Alive");
    }

    public WebApplicationComponent getRootComponent() {
        return this.rootComponent;
    }
}

