/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.configuration;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.contextfw.web.application.DocumentProcessor;
import net.contextfw.web.application.PropertyProvider;
import net.contextfw.web.application.SystemPropertyProvider;
import net.contextfw.web.application.configuration.AddableProperty;
import net.contextfw.web.application.configuration.BindableProperty;
import net.contextfw.web.application.configuration.ReloadableClassProperty;
import net.contextfw.web.application.configuration.SelfAddableProperty;
import net.contextfw.web.application.configuration.SelfKeyValueSetProperty;
import net.contextfw.web.application.configuration.SettableProperty;
import net.contextfw.web.application.configuration.TemporalProperty;
import net.contextfw.web.application.development.DefaultXMLResponseLogger;
import net.contextfw.web.application.development.XMLResponseLogger;
import net.contextfw.web.application.internal.configuration.BasicSettableProperty;
import net.contextfw.web.application.internal.configuration.BindablePropertyImpl;
import net.contextfw.web.application.internal.configuration.Property;
import net.contextfw.web.application.internal.configuration.ReloadableClassPropertyImpl;
import net.contextfw.web.application.internal.configuration.SelfKeyValueSetPropertyImpl;
import net.contextfw.web.application.internal.configuration.SelfSettableProperty;
import net.contextfw.web.application.internal.configuration.SetPropertyImpl;
import net.contextfw.web.application.internal.configuration.StringSetPropertyImpl;
import net.contextfw.web.application.internal.configuration.TemporalPropertyImpl;
import net.contextfw.web.application.lifecycle.DefaultLifecycleListener;
import net.contextfw.web.application.lifecycle.DefaultRequestInvocationFilter;
import net.contextfw.web.application.lifecycle.LifecycleListener;
import net.contextfw.web.application.lifecycle.RequestInvocationFilter;
import net.contextfw.web.application.scope.DefaultWebApplicationStorage;
import net.contextfw.web.application.scope.WebApplicationStorage;
import net.contextfw.web.application.serialize.AttributeJsonSerializer;
import net.contextfw.web.application.serialize.AttributeSerializer;

public class Configuration {
    private static final String KEY_NAMESPACE = "contextfw.namespace";
    private static final String KEY_ATTRIBUTE_SERIALIZER = "contextfw.attributeSerializer";
    private static final String KEY_JSON_SERIALIZER = "contextfw.jsonSerializer";
    private static final String KEY_JSON_DESERIALIZER = "contextfw.jsonDeserializer";
    private static final String KEY_ATTRIBUTE_JSON_SERIALIZER = "contextfw.attributeJsonSerializer";
    private static final String KEY_REMOVAL_SCHEDULE_PERIOD = "contextfw.removalSchedulePeriod";
    private static final String KEY_MAX_INACTIVITY = "contextfw.maxInactivity";
    private static final String KEY_INITIAL_MAX_INACTIVITY = "contextfw.initialMaxInactivity";
    private static final String KEY_VIEW_COMPONENT_ROOT_PACKAGE = "contextfw.viewComponentRootPackage";
    private static final String KEY_RESOURCE_PATH = "contextfw.resourcePath";
    private static final String KEY_LIFECYCLE_LISTENER = "contextfw.lifecycleListener";
    private static final String KEY_REQUEST_INVOCATION_FILTER = "contextfw.requestInvocationFilter";
    private static final String KEY_PROPERTY_PROVIDER = "contextfw.propertyProvider";
    private static final String KEY_XSL_POST_PROCESSOR = "contextfw.xslPostProcessor";
    private static final String KEY_XML_PARAM_NAME = "contextfw.xmlParamName";
    private static final String KEY_RESOURCES_PREFIX = "contextfw.resourcesPrefix";
    private static final String KEY_LOG_XML = "contextfw.logXML";
    private static final String KEY_XML_RESPONSE_LOGGER = "contextfw.xmlResponseLogger";
    private static final String KEY_RELOADABLE_ROOT_PACKAGE = "contextfw.reloadableRootPackage";
    private static final String KEY_DEVELOPMENT_MODE = "contextfw.developmentMode";
    private static final String KEY_CLASS_RELOADING_ENABLED = "contextfw.classReloadingEnabled";
    private static final String KEY_WEB_APPLICATION_STORAGE = "contextfw.webApplicationStorage";
    private static final String KEY_HOST = "contextfw.host";
    private static final String KEY_VERSION = "contextfw.version";
    public static final SettableProperty<Boolean> DEVELOPMENT_MODE = Configuration.createProperty(Boolean.class, "contextfw.developmentMode");
    public static final SettableProperty<Boolean> CLASS_RELOADING_ENABLED = Configuration.createProperty(Boolean.class, "contextfw.classReloadingEnabled");
    public static final SettableProperty<Boolean> LOG_XML = Configuration.createProperty(Boolean.class, "contextfw.logXML");
    public static final SettableProperty<String> RESOURCES_PREFIX = Configuration.createProperty(String.class, "contextfw.resourcesPrefix");
    public static final SettableProperty<String> HOST = Configuration.createProperty(String.class, "contextfw.host");
    public static final SettableProperty<String> VERSION = Configuration.createProperty(String.class, "contextfw.version");
    public static final SettableProperty<String> XML_PARAM_NAME = Configuration.createProperty(String.class, "contextfw.xmlParamName");
    public static final SettableProperty<PropertyProvider> PROPERTY_PROVIDER = Configuration.createProperty(PropertyProvider.class, "contextfw.propertyProvider");
    public static final BindableProperty<LifecycleListener> LIFECYCLE_LISTENER = Configuration.createBindableProperty(LifecycleListener.class, "contextfw.lifecycleListener");
    public static final BindableProperty<WebApplicationStorage> WEB_APPLICATION_STORAGE = Configuration.createBindableProperty(WebApplicationStorage.class, "contextfw.webApplicationStorage");
    public static final SettableProperty<RequestInvocationFilter> REQUEST_INVOCATION_FILTER = Configuration.createProperty(RequestInvocationFilter.class, "contextfw.requestInvocationFilter");
    public static final BindableProperty<XMLResponseLogger> XML_RESPONSE_LOGGER = Configuration.createBindableProperty(XMLResponseLogger.class, "contextfw.xmlResponseLogger");
    public static final BindableProperty<DocumentProcessor> XSL_POST_PROCESSOR = Configuration.createBindableProperty(DocumentProcessor.class, "contextfw.xslPostProcessor");
    public static final AddableProperty<Set<String>, String> RESOURCE_PATH = new StringSetPropertyImpl("contextfw.resourcePath");
    public static final AddableProperty<Set<String>, String> VIEW_COMPONENT_ROOT_PACKAGE = new StringSetPropertyImpl("contextfw.viewComponentRootPackage");
    public static final ReloadableClassProperty RELOADABLE_CLASSES = new ReloadableClassPropertyImpl("contextfw.reloadableRootPackage");
    public static final TemporalProperty INITIAL_MAX_INACTIVITY = Configuration.createTemporalProperty("contextfw.initialMaxInactivity");
    public static final TemporalProperty MAX_INACTIVITY = Configuration.createTemporalProperty("contextfw.maxInactivity");
    public static final TemporalProperty REMOVAL_SCHEDULE_PERIOD = Configuration.createTemporalProperty("contextfw.removalSchedulePeriod");
    public static final SelfKeyValueSetProperty<String, String> NAMESPACE = new SelfKeyValueSetPropertyImpl<String, String>("contextfw.namespace");
    public static final SelfKeyValueSetProperty<Class<?>, Class<? extends AttributeJsonSerializer<?>>> ATTRIBUTE_JSON_SERIALIZER = new SelfKeyValueSetPropertyImpl("contextfw.attributeJsonSerializer");
    public static final SelfKeyValueSetProperty<Class<?>, Class<? extends JsonDeserializer<?>>> JSON_DESERIALIZER = new SelfKeyValueSetPropertyImpl("contextfw.jsonDeserializer");
    public static final SelfKeyValueSetProperty<Class<?>, Class<? extends JsonSerializer<?>>> JSON_SERIALIZER = new SelfKeyValueSetPropertyImpl("contextfw.jsonSerializer");
    public static final SelfKeyValueSetProperty<Class<?>, Class<? extends AttributeSerializer<?>>> ATTRIBUTE_SERIALIZER = new SelfKeyValueSetPropertyImpl("contextfw.attributeSerializer");
    private final Map<String, Object> values = new HashMap<String, Object>();

    public static Configuration getDefaults() {
        return new Configuration().set(DEVELOPMENT_MODE, Boolean.valueOf(true)).set(CLASS_RELOADING_ENABLED, Boolean.valueOf(true)).set(LOG_XML, Boolean.valueOf(true)).set(RESOURCES_PREFIX, "/resources").set(XML_PARAM_NAME, null).set(XML_RESPONSE_LOGGER.asInstance(new DefaultXMLResponseLogger())).set(PROPERTY_PROVIDER, new SystemPropertyProvider()).set(REQUEST_INVOCATION_FILTER, new DefaultRequestInvocationFilter()).set(LIFECYCLE_LISTENER.as(DefaultLifecycleListener.class)).set(WEB_APPLICATION_STORAGE.as(DefaultWebApplicationStorage.class)).set(RESOURCE_PATH, new HashSet()).set(VIEW_COMPONENT_ROOT_PACKAGE, new HashSet()).set(INITIAL_MAX_INACTIVITY.inSeconds(30L)).set(REMOVAL_SCHEDULE_PERIOD.inMinutes(1L)).set(MAX_INACTIVITY.inMinutes(2L)).set(NAMESPACE, new HashSet()).set(ATTRIBUTE_JSON_SERIALIZER, new HashSet()).set(JSON_SERIALIZER, new HashSet()).set(JSON_DESERIALIZER, new HashSet()).set(ATTRIBUTE_SERIALIZER, new HashSet());
    }

    public Configuration() {
    }

    private <T> Configuration(Map<String, Object> values, Property<T> property, T value) {
        this.values.putAll(values);
        this.values.put(property.getKey(), property.validate(value));
    }

    public <T> T get(Property<T> property) {
        return (T)property.validate(this.values.get(property.getKey()));
    }

    public <T> T getOrElse(Property<T> property, T def) {
        Object value = this.values.get(property.getKey());
        return (T)(value != null ? property.validate(value) : def);
    }

    public <T> Configuration set(SettableProperty<T> property, T value) {
        return new Configuration(this.values, property, value);
    }

    public <T extends Collection<V>, V> Configuration set(AddableProperty<T, V> property, T value) {
        return new Configuration(this.values, property, value);
    }

    public <T extends Collection<V>, V> Configuration set(SelfAddableProperty<T, V> property, T value) {
        return new Configuration(this.values, property, value);
    }

    public <T> Configuration set(SelfSettableProperty<T> property) {
        return new Configuration(this.values, property, property.getValue());
    }

    public <T extends Collection<V>, V> Configuration add(AddableProperty<T, V> property, V value) {
        return new Configuration(this.values, property, property.add((Collection)this.get(property), value));
    }

    public <T extends Collection<V>, V> Configuration add(SelfAddableProperty<T, V> property) {
        return new Configuration(this.values, property, property.add((Collection)this.get(property), property.getValue()));
    }

    public static <T> SettableProperty<T> createProperty(Class<T> type, String key) {
        return new BasicSettableProperty(key);
    }

    public static <T> BindableProperty<T> createBindableProperty(Class<T> type, String key) {
        return new BindablePropertyImpl(key);
    }

    public static TemporalProperty createTemporalProperty(String key) {
        return new TemporalPropertyImpl(key);
    }

    public static <T> AddableProperty<Set<T>, T> createAddableProperty(Class<T> type, String key) {
        return new SetPropertyImpl(key);
    }
}

