/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.bundle;

import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18nUtil;
import org.nuiton.i18n.bundle.I18nBundle;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleScope;

public class I18nBundleUtil {
    private static final Log log = LogFactory.getLog(I18nBundleUtil.class);
    public static final String DIRECTORY_SEARCH_BUNDLE_PATTERN = "i18n";
    private static final I18nBundleEntry[] EMPTY_I18N_BUNDLE_ENTRYS_ARRAY = new I18nBundleEntry[0];
    public static final URL[] EMPTY_URL_ARRAY = new URL[0];

    public static Locale[] getLocales(I18nBundle ... bundles) {
        HashSet<Locale> result = new HashSet<Locale>();
        for (I18nBundle i18nBundle : bundles) {
            for (I18nBundleEntry entry : i18nBundle.getEntries()) {
                Locale o = entry.getLocale();
                if (o == null) continue;
                result.add(o);
            }
        }
        return result.toArray(new Locale[result.size()]);
    }

    public static String[] getBundleNames(I18nBundle ... bundles) {
        ArrayList<String> result = new ArrayList<String>();
        for (I18nBundle i18nBundle : bundles) {
            result.add(i18nBundle.getBundlePrefix());
        }
        return result.toArray(new String[result.size()]);
    }

    public static I18nBundle[] getBundles(Locale l, I18nBundle ... bundles) {
        ArrayList<I18nBundle> result = new ArrayList<I18nBundle>();
        for (I18nBundle i18nBundle : bundles) {
            if (!i18nBundle.matchLocale(l)) continue;
            result.add(i18nBundle);
        }
        return result.toArray(new I18nBundle[result.size()]);
    }

    public static I18nBundleEntry[] getBundleEntries(I18nBundle ... bundles) {
        ArrayList<I18nBundleEntry> result = new ArrayList<I18nBundleEntry>();
        for (I18nBundle i18nBundle : bundles) {
            List<I18nBundleEntry> list = i18nBundle.getEntries();
            if (list.isEmpty()) continue;
            result.addAll(list);
        }
        return result.toArray(new I18nBundleEntry[result.size()]);
    }

    public static I18nBundleEntry[] getBundleEntries(Locale l, Locale defaultLocale, I18nBundle ... bundles) {
        return I18nBundleUtil.getBundleEntries(l, defaultLocale, false, bundles);
    }

    public static I18nBundleEntry[] getBundleEntries(Locale l, Locale defaultLocale, boolean promuteGeneral, I18nBundle ... bundles) {
        ArrayList<I18nBundleEntry> result = new ArrayList<I18nBundleEntry>();
        for (I18nBundle i18nBundle : bundles) {
            I18nBundleEntry[] entries = i18nBundle.getEntries(l);
            if (entries.length == 0) {
                entries = I18nBundleUtil.promoteBundle(i18nBundle, l, defaultLocale, promuteGeneral);
            }
            result.addAll(Arrays.asList(entries));
        }
        return result.toArray(new I18nBundleEntry[result.size()]);
    }

    public static I18nBundleEntry[] getBundleEntries(Locale l, I18nBundle ... bundles) {
        ArrayList<I18nBundleEntry> result = new ArrayList<I18nBundleEntry>();
        for (I18nBundle i18nBundle : bundles) {
            I18nBundleEntry[] entries;
            for (I18nBundleEntry entry : entries = i18nBundle.getEntries(l)) {
                if (!l.equals(entry.getLocale())) continue;
                result.add(entry);
            }
        }
        return result.toArray(new I18nBundleEntry[result.size()]);
    }

    public static URL[] getURLs(URL ... urls) {
        try {
            ArrayList<URL> urlToSeek = new ArrayList<URL>();
            urlToSeek.addAll(Arrays.asList(urls));
            int size = urlToSeek.size();
            Iterator it = urlToSeek.iterator();
            while (it.hasNext()) {
                URL url = (URL)it.next();
                if (I18nUtil.containsDirectDirectory(url, DIRECTORY_SEARCH_BUNDLE_PATTERN)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("skip url with no %s directory : %s", DIRECTORY_SEARCH_BUNDLE_PATTERN, url));
                }
                it.remove();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("detect %d i18n capable url (out of %d)", urlToSeek.size(), size));
            }
            ArrayList<URL> listURLs = new ArrayList<URL>();
            for (URL url : urlToSeek) {
                List<URL> result = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("seek in : %s", url));
                }
                String fileName = url.getFile();
                File file = new File(fileName.replaceAll("%20", " "));
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("url to search %s", file));
                    log.debug((Object)String.format("Is a exsting file or directory ? %s", file.exists()));
                }
                if (I18nUtil.isJar(fileName)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("jar to search %s", file));
                    }
                    result = I18nBundleUtil.getURLsFromJar(url, file);
                } else if (file.isDirectory()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("directory to search %s", file));
                    }
                    result = I18nBundleUtil.getURLsFromDirectory(url, file);
                }
                if (result == null || result.isEmpty()) continue;
                listURLs.addAll(result);
            }
            return listURLs.toArray(new URL[listURLs.size()]);
        }
        catch (Exception eee) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Unable to find urls for urls : %s for reason %s", Arrays.toString(urls), eee.getMessage()), (Throwable)eee);
            }
            return EMPTY_URL_ARRAY;
        }
    }

    public static boolean isEmpty(I18nBundle ... bundles) {
        for (I18nBundle i18nBundle : bundles) {
            if (i18nBundle.getEntries().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static List<I18nBundle> detectBundles(URL ... urls) {
        ArrayList<String> bundleNames = new ArrayList<String>();
        ArrayList<I18nBundle> bundles = new ArrayList<I18nBundle>();
        for (URL url : urls) {
            if (I18nBundleUtil.addBundleEntry(url, I18nBundleScope.FULL, bundleNames, bundles) || I18nBundleUtil.addBundleEntry(url, I18nBundleScope.LANGUAGE, bundleNames, bundles)) continue;
            I18nBundleUtil.addBundleEntry(url, I18nBundleScope.GENERAL, bundleNames, bundles);
        }
        bundleNames.clear();
        for (I18nBundle bundle : bundles) {
            Collections.sort(bundle.getEntries());
        }
        return bundles;
    }

    protected static boolean addBundleEntry(URL url, I18nBundleScope scope, List<String> bundleNames, List<I18nBundle> bundles) {
        String path = url.toString();
        Matcher matcher = scope.getMatcher(path);
        if (!matcher.matches()) {
            return false;
        }
        I18nBundleEntry entry = new I18nBundleEntry(url, scope.getLocale(matcher), scope);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("bundle (%d) : %s", bundles.size(), entry));
        }
        I18nBundle bundle = I18nBundleUtil.addBundle(scope.getBundlePrefix(matcher), bundleNames, bundles);
        bundle.addEntry(entry);
        return true;
    }

    protected static I18nBundle addBundle(String bundleName, List<String> bundleNames, List<I18nBundle> bundles) {
        I18nBundle bundle;
        int index = bundleNames.indexOf(bundleName);
        if (index > -1) {
            bundle = bundles.get(index);
        } else {
            bundle = new I18nBundle(bundleName);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("bundle (%d) : %s", bundles.size(), bundle));
            }
            bundles.add(bundle);
            bundleNames.add(bundleName);
        }
        return bundle;
    }

    protected static I18nBundleEntry[] promoteBundle(I18nBundle bundle, Locale l, Locale defaultLocale, boolean promuteGeneral) {
        I18nBundleScope scope = I18nBundleScope.valueOf(l);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s%s] did not find matching entries for locale %s. Try to detect best entries...", Character.valueOf('['), bundle.getBundlePrefix(), l));
        }
        if (bundle.size() == 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"PROMOTE NO ENTRY FOUND");
            }
            return EMPTY_I18N_BUNDLE_ENTRYS_ARRAY;
        }
        if (bundle.size() == 1) {
            I18nBundleEntry entry = bundle.getEntries().get(0);
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("PROMOTE %s to %s [%s]", l, entry.getLocale(), bundle.getBundlePrefix()));
            }
            return new I18nBundleEntry[]{entry};
        }
        ArrayList<I18nBundleEntry> result = new ArrayList<I18nBundleEntry>();
        switch (scope) {
            case FULL: {
                I18nBundleUtil.promoteFull(bundle, l, defaultLocale, result, promuteGeneral);
                break;
            }
            case LANGUAGE: {
                I18nBundleUtil.promoteLanguage(bundle, l, defaultLocale, result, promuteGeneral);
                break;
            }
            case GENERAL: {
                if (!promuteGeneral) break;
                I18nBundleUtil.promoteGeneral(bundle, l, defaultLocale, result);
            }
        }
        return result.toArray(new I18nBundleEntry[result.size()]);
    }

    protected static void promoteFull(I18nBundle bundle, Locale locale, Locale defaultLocale, List<I18nBundleEntry> result, boolean promuteGeneral) {
        if (bundle.size() == 0) {
            return;
        }
        for (I18nBundleEntry entry : bundle.getEntries()) {
            I18nBundleScope i18nBundleScope = entry.getScope();
            Locale locale1 = entry.getLocale();
            if (i18nBundleScope != I18nBundleScope.FULL || locale1.getCountry().equals(locale.getCountry()) || !locale1.getLanguage().equals(locale.getLanguage())) continue;
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("%s to %s [%s]", locale, locale1, bundle.getBundlePrefix()));
            }
            result.add(entry);
            break;
        }
        if (result.isEmpty()) {
            I18nBundleUtil.promoteLanguage(bundle, locale, defaultLocale, result, promuteGeneral);
        }
    }

    protected static void promoteLanguage(I18nBundle bundle, Locale locale, Locale defaultLocale, List<I18nBundleEntry> result, boolean promuteGeneral) {
        if (bundle.size() == 0) {
            return;
        }
        for (I18nBundleEntry entry : bundle.getEntries()) {
            I18nBundleScope i18nBundleScope = entry.getScope();
            Locale locale1 = entry.getLocale();
            if (i18nBundleScope != I18nBundleScope.FULL || !locale1.getLanguage().equals(locale.getLanguage())) continue;
            result.add(entry);
            if (!log.isWarnEnabled()) break;
            log.warn((Object)String.format("%s to %s [%s]", locale, locale1, bundle.getBundlePrefix()));
            break;
        }
        if (result.isEmpty() && promuteGeneral) {
            I18nBundleUtil.promoteGeneral(bundle, locale, defaultLocale, result);
        }
    }

    protected static void promoteGeneral(I18nBundle bundle, Locale locale, Locale defaultLocale, List<I18nBundleEntry> result) {
        if (bundle.size() == 0) {
            return;
        }
        if (bundle.size() == 1) {
            I18nBundleEntry entry = bundle.getEntries().get(0);
            result.add(entry);
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("%s to %s [%s]", locale, entry.getLocale(), bundle.getBundlePrefix()));
            }
            return;
        }
        I18nBundleScope scope = I18nBundleScope.valueOf(defaultLocale);
        for (I18nBundleEntry entry : bundle.getEntries(scope)) {
            if (!entry.getLocale().equals(defaultLocale)) continue;
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("%s to %s [%s]", locale, entry.getLocale(), bundle.getBundlePrefix()));
            }
            result.add(entry);
            return;
        }
        I18nBundleEntry entry = bundle.getEntries().get(0);
        result.add(entry);
        if (log.isWarnEnabled()) {
            log.warn((Object)String.format("%s to %s [%s]", locale, entry.getLocale(), bundle.getBundlePrefix()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static List<URL> getURLsFromJar(URL incomingURL, File jarfile) {
        String pattern = ".*i18n/.+\\.properties";
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(jarfile));){
            ZipEntry entry;
            ArrayList<URL> result = new ArrayList<URL>();
            URLClassLoader cl = new URLClassLoader(new URL[]{incomingURL}, I18nBundleUtil.class.getClassLoader());
            while (zis.available() != 0 && (entry = zis.getNextEntry()) != null) {
                String name = entry.getName();
                if (!name.matches(pattern)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%s accepted for pattern %s", name, pattern));
                }
                URL url = cl.getResource(name);
                result.add(url);
            }
            ArrayList<URL> arrayList = result;
            return arrayList;
        }
        catch (Exception eee) {
            throw new RuntimeException(String.format("n'a pas pu trouve la resource dans le jar %s", jarfile.getAbsolutePath()), eee);
        }
    }

    protected static String getSearchBundlePattern() {
        String result = ".*i18n";
        String path = File.separator;
        result = result + ("\\".equals(path) ? path + path : path);
        return result + ".+\\.properties";
    }

    protected static List<URL> getURLsFromDirectory(URL incomingURL, File repository) {
        String pattern = I18nBundleUtil.getSearchBundlePattern();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("search '%s' in %s", pattern, repository));
            }
            ArrayList<URL> urlList = new ArrayList<URL>();
            File[] filesList = repository.listFiles();
            if (filesList != null) {
                for (File file : filesList) {
                    String name = file.getAbsolutePath();
                    if (file.exists() && file.isDirectory()) {
                        urlList.addAll(I18nUtil.getURLsFromDirectory(file, pattern));
                        continue;
                    }
                    if (!name.matches(pattern)) continue;
                    URL url = file.toURI().toURL();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("directory: %s url: %s", repository, url));
                    }
                    urlList.add(url);
                }
            }
            return urlList;
        }
        catch (MalformedURLException eee) {
            throw new RuntimeException(String.format("n'a pas pu trouve la resource dans le repertoire %s", repository.getAbsolutePath()), eee);
        }
    }
}

