/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.util;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.XML;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineModelResolver {
    private OpenAPI openAPI;
    private boolean skipMatches;
    static Logger LOGGER = LoggerFactory.getLogger(InlineModelResolver.class);
    Map<String, Schema> addedModels = new HashMap<String, Schema>();
    Map<String, String> generatedSignature = new HashMap<String, String>();

    public void flatten(OpenAPI openAPI) {
        this.openAPI = openAPI;
        if (openAPI.getComponents() != null && openAPI.getComponents().getSchemas() == null) {
            openAPI.getComponents().setSchemas(new HashMap());
        }
        Paths paths = openAPI.getPaths();
        if (openAPI.getComponents() == null) {
            openAPI.setComponents(new Components());
        }
        Map models = openAPI.getComponents().getSchemas();
        if (paths != null) {
            for (String pathname : paths.keySet()) {
                PathItem path = (PathItem)paths.get(pathname);
                for (Operation operation : path.readOperations()) {
                    ApiResponses responses;
                    Parameter parameter2;
                    List parameters;
                    RequestBody body = operation.getRequestBody();
                    if (body != null && body.getContent() != null) {
                        Content content = body.getContent();
                        for (String key : content.keySet()) {
                            ObjectSchema op;
                            ArraySchema am;
                            Schema inner;
                            MediaType mediaType;
                            if (content.get(key) == null || (mediaType = (MediaType)content.get(key)).getSchema() == null) continue;
                            Schema model = mediaType.getSchema();
                            if (model.getProperties() != null && model.getProperties().size() > 0) {
                                this.flattenProperties(model.getProperties(), pathname);
                                String modelName = this.resolveModelName(model.getTitle(), "body");
                                mediaType.setSchema(new Schema().$ref(modelName));
                                this.addGenerated(modelName, model);
                                openAPI.getComponents().addSchemas(modelName, model);
                                continue;
                            }
                            if (!(model instanceof ArraySchema) || !((inner = (am = (ArraySchema)model).getItems()) instanceof ObjectSchema) || (op = (ObjectSchema)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                            this.flattenProperties(op.getProperties(), pathname);
                            String modelName = this.resolveModelName(op.getTitle(), "body");
                            Schema innerModel = this.modelFromProperty(op, modelName);
                            String existing = this.matchGenerated(innerModel);
                            if (existing != null) {
                                am.setItems(new Schema().$ref(existing));
                                continue;
                            }
                            am.setItems(new Schema().$ref(modelName));
                            this.addGenerated(modelName, innerModel);
                            openAPI.getComponents().addSchemas(modelName, innerModel);
                        }
                    }
                    if ((parameters = operation.getParameters()) != null) {
                        for (Parameter parameter2 : parameters) {
                            ObjectSchema op;
                            ArraySchema am;
                            Schema inner;
                            if (parameter2.getSchema() == null) continue;
                            Schema model = parameter2.getSchema();
                            if (model.getProperties() != null) {
                                if (model.getType() != null && !"object".equals(model.getType()) || model.getProperties() == null || model.getProperties().size() <= 0) continue;
                                this.flattenProperties(model.getProperties(), pathname);
                                String modelName = this.resolveModelName(model.getTitle(), parameter2.getName());
                                parameter2.setSchema(new Schema().$ref(modelName));
                                this.addGenerated(modelName, model);
                                openAPI.getComponents().addSchemas(modelName, model);
                                continue;
                            }
                            if (!(model instanceof ArraySchema) || !((inner = (am = (ArraySchema)model).getItems()) instanceof ObjectSchema) || (op = (ObjectSchema)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                            this.flattenProperties(op.getProperties(), pathname);
                            String modelName = this.resolveModelName(op.getTitle(), parameter2.getName());
                            Schema innerModel = this.modelFromProperty(op, modelName);
                            String existing = this.matchGenerated(innerModel);
                            if (existing != null) {
                                am.setItems(new Schema().$ref(existing));
                                continue;
                            }
                            am.setItems(new Schema().$ref(modelName));
                            this.addGenerated(modelName, innerModel);
                            openAPI.getComponents().addSchemas(modelName, innerModel);
                        }
                    }
                    if ((responses = operation.getResponses()) == null) continue;
                    parameter2 = responses.keySet().iterator();
                    while (parameter2.hasNext()) {
                        String key = (String)parameter2.next();
                        ApiResponse response = (ApiResponse)responses.get(key);
                        if (response.getContent() == null) continue;
                        Content content = response.getContent();
                        for (String name : content.keySet()) {
                            ObjectSchema op;
                            Schema innerProperty;
                            MediaType media;
                            if (content.get(name) == null || (media = (MediaType)content.get(name)).getSchema() == null) continue;
                            Schema property = media.getSchema();
                            if (property instanceof ObjectSchema) {
                                ObjectSchema op2 = (ObjectSchema)property;
                                if (op2.getProperties() == null || op2.getProperties().size() <= 0) continue;
                                String modelName = this.resolveModelName(op2.getTitle(), "inline_response_" + key);
                                Schema model = this.modelFromProperty(op2, modelName);
                                String existing = this.matchGenerated(model);
                                if (existing != null) {
                                    media.setSchema(this.makeRefProperty(existing, property));
                                    continue;
                                }
                                media.setSchema(this.makeRefProperty(modelName, property));
                                this.addGenerated(modelName, model);
                                openAPI.getComponents().addSchemas(modelName, model);
                                continue;
                            }
                            if (property instanceof ArraySchema) {
                                ObjectSchema op3;
                                ArraySchema ap = (ArraySchema)property;
                                Schema inner = ap.getItems();
                                if (!(inner instanceof ObjectSchema) || (op3 = (ObjectSchema)inner).getProperties() == null || op3.getProperties().size() <= 0) continue;
                                this.flattenProperties(op3.getProperties(), pathname);
                                String modelName = this.resolveModelName(op3.getTitle(), "inline_response_" + key);
                                Schema innerModel = this.modelFromProperty(op3, modelName);
                                String existing = this.matchGenerated(innerModel);
                                if (existing != null) {
                                    ap.setItems(this.makeRefProperty(existing, (Schema)op3));
                                    continue;
                                }
                                ap.setItems(this.makeRefProperty(modelName, (Schema)op3));
                                this.addGenerated(modelName, innerModel);
                                openAPI.getComponents().addSchemas(modelName, innerModel);
                                continue;
                            }
                            if (property.getAdditionalProperties() == null || !(property.getAdditionalProperties() instanceof Schema) || !((innerProperty = (Schema)property.getAdditionalProperties()) instanceof ObjectSchema) || (op = (ObjectSchema)innerProperty).getProperties() == null || op.getProperties().size() <= 0) continue;
                            this.flattenProperties(op.getProperties(), pathname);
                            String modelName = this.resolveModelName(op.getTitle(), "inline_response_" + key);
                            Schema innerModel = this.modelFromProperty(op, modelName);
                            String existing = this.matchGenerated(innerModel);
                            if (existing != null) {
                                property.setAdditionalProperties((Object)new Schema().$ref(existing));
                                continue;
                            }
                            property.setAdditionalProperties((Object)new Schema().$ref(modelName));
                            this.addGenerated(modelName, innerModel);
                            openAPI.getComponents().addSchemas(modelName, innerModel);
                        }
                    }
                }
            }
        }
        if (models != null) {
            ArrayList modelNames = new ArrayList(models.keySet());
            for (String modelName : modelNames) {
                Schema model = (Schema)models.get(modelName);
                if (model.getProperties() != null) {
                    Map properties = model.getProperties();
                    this.flattenProperties(properties, modelName);
                    this.fixStringModel(model);
                    continue;
                }
                if (model instanceof ArraySchema) {
                    ObjectSchema op;
                    ArraySchema m = (ArraySchema)model;
                    Schema inner = m.getItems();
                    if (!(inner instanceof ObjectSchema) || (op = (ObjectSchema)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                    String innerModelName = this.resolveModelName(op.getTitle(), modelName + "_inner");
                    Schema innerModel = this.modelFromProperty(op, innerModelName);
                    String existing = this.matchGenerated(innerModel);
                    if (existing == null) {
                        openAPI.getComponents().addSchemas(innerModelName, innerModel);
                        this.addGenerated(innerModelName, innerModel);
                        m.setItems(new Schema().$ref(innerModelName));
                        continue;
                    }
                    m.setItems(new Schema().$ref(existing));
                    continue;
                }
                if (!(model instanceof ComposedSchema)) continue;
                ComposedSchema composedSchema = (ComposedSchema)model;
                List list = null;
                if (composedSchema.getAllOf() != null) {
                    list = composedSchema.getAllOf();
                } else if (composedSchema.getAnyOf() != null) {
                    list = composedSchema.getAnyOf();
                } else if (composedSchema.getOneOf() != null) {
                    list = composedSchema.getOneOf();
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (((Schema)list.get(i)).getProperties() == null) continue;
                    this.flattenProperties(((Schema)list.get(i)).getProperties(), modelName);
                }
            }
        }
    }

    private void fixStringModel(Schema m) {
        String example;
        if (m.getType() != null && m.getType().equals("string") && m.getExample() != null && (example = m.getExample().toString()).substring(0, 1).equals("\"") && example.substring(example.length() - 1).equals("\"")) {
            m.setExample((Object)example.substring(1, example.length() - 1));
        }
    }

    private String resolveModelName(String title, String key) {
        if (title == null) {
            return this.uniqueName(key);
        }
        return this.uniqueName(title);
    }

    public String matchGenerated(Schema model) {
        if (this.skipMatches) {
            return null;
        }
        String json = Json.pretty((Object)model);
        if (this.generatedSignature.containsKey(json)) {
            return this.generatedSignature.get(json);
        }
        return null;
    }

    public void addGenerated(String name, Schema model) {
        this.generatedSignature.put(Json.pretty((Object)model), name);
    }

    public String uniqueName(String key) {
        int count = 0;
        boolean done = false;
        key = key.replaceAll("[^a-z_\\.A-Z0-9 ]", "");
        while (!done) {
            String name = key;
            if (count > 0) {
                name = key + "_" + count;
            }
            if (this.openAPI.getComponents().getSchemas() == null) {
                return name;
            }
            if (!this.openAPI.getComponents().getSchemas().containsKey(name)) {
                return name;
            }
            ++count;
        }
        return key;
    }

    public void flattenProperties(Map<String, Schema> properties, String path) {
        if (properties == null) {
            return;
        }
        HashMap<String, Schema> propsToUpdate = new HashMap<String, Schema>();
        HashMap<String, Schema> modelsToAdd = new HashMap<String, Schema>();
        for (String key : properties.keySet()) {
            ObjectSchema op;
            Schema inner;
            Schema property = properties.get(key);
            if (property instanceof ObjectSchema && ((ObjectSchema)property).getProperties() != null && ((ObjectSchema)property).getProperties().size() > 0) {
                ObjectSchema op2 = (ObjectSchema)property;
                String modelName = this.resolveModelName(op2.getTitle(), path + "_" + key);
                Schema model = this.modelFromProperty(op2, modelName);
                String existing = this.matchGenerated(model);
                if (existing != null) {
                    propsToUpdate.put(key, new Schema().$ref(existing));
                    continue;
                }
                propsToUpdate.put(key, new Schema().$ref(modelName));
                modelsToAdd.put(modelName, model);
                this.addGenerated(modelName, model);
                this.openAPI.getComponents().addSchemas(modelName, model);
                continue;
            }
            if (property instanceof ArraySchema) {
                ObjectSchema op3;
                ArraySchema ap = (ArraySchema)property;
                Schema inner2 = ap.getItems();
                if (!(inner2 instanceof ObjectSchema) || (op3 = (ObjectSchema)inner2).getProperties() == null || op3.getProperties().size() <= 0) continue;
                this.flattenProperties(op3.getProperties(), path);
                String modelName = this.resolveModelName(op3.getTitle(), path + "_" + key);
                Schema innerModel = this.modelFromProperty(op3, modelName);
                String existing = this.matchGenerated(innerModel);
                if (existing != null) {
                    ap.setItems(new Schema().$ref(existing));
                    continue;
                }
                ap.setItems(new Schema().$ref(modelName));
                this.addGenerated(modelName, innerModel);
                this.openAPI.getComponents().addSchemas(modelName, innerModel);
                continue;
            }
            if (property.getAdditionalProperties() == null || !(property.getAdditionalProperties() instanceof Schema) || !((inner = (Schema)property.getAdditionalProperties()) instanceof ObjectSchema) || (op = (ObjectSchema)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
            this.flattenProperties(op.getProperties(), path);
            String modelName = this.resolveModelName(op.getTitle(), path + "_" + key);
            Schema innerModel = this.modelFromProperty(op, modelName);
            String existing = this.matchGenerated(innerModel);
            if (existing != null) {
                property.setAdditionalProperties((Object)new Schema().$ref(existing));
                continue;
            }
            property.setAdditionalProperties((Object)new Schema().$ref(modelName));
            this.addGenerated(modelName, innerModel);
            this.openAPI.getComponents().addSchemas(modelName, innerModel);
        }
        if (propsToUpdate.size() > 0) {
            for (String key : propsToUpdate.keySet()) {
                properties.put(key, (Schema)propsToUpdate.get(key));
            }
        }
        for (String key : modelsToAdd.keySet()) {
            this.openAPI.getComponents().addSchemas(key, (Schema)modelsToAdd.get(key));
            this.addedModels.put(key, (Schema)modelsToAdd.get(key));
        }
    }

    public Schema modelFromProperty(ArraySchema object, String path) {
        Schema inner;
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        if ((inner = object.getItems()) instanceof ObjectSchema) {
            ArraySchema model = new ArraySchema();
            model.setDescription(description);
            model.setExample((Object)example);
            model.setItems(object.getItems());
            return model;
        }
        return null;
    }

    public Schema modelFromProperty(ObjectSchema object, String path) {
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        String name = object.getName();
        XML xml = object.getXml();
        Map properties = object.getProperties();
        Schema model = new Schema();
        model.setDescription(description);
        model.setExample((Object)example);
        model.setName(name);
        model.setXml(xml);
        if (properties != null) {
            this.flattenProperties(properties, path);
            model.setProperties(properties);
        }
        return model;
    }

    public Schema modelFromProperty(Schema object, String path) {
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        ArraySchema model = new ArraySchema();
        model.setDescription(description);
        model.setExample((Object)example);
        if (object.getAdditionalProperties() != null && object.getAdditionalProperties() instanceof Schema) {
            model.setItems((Schema)object.getAdditionalProperties());
        }
        return model;
    }

    public Schema makeRefProperty(String ref, Schema property) {
        Schema newProperty = new Schema().$ref(ref);
        this.copyVendorExtensions(property, newProperty);
        return newProperty;
    }

    public void copyVendorExtensions(Schema source, Schema target) {
        if (source.getExtensions() != null) {
            Map vendorExtensions = source.getExtensions();
            for (String extName : vendorExtensions.keySet()) {
                target.addExtension(extName, vendorExtensions.get(extName));
            }
        }
    }

    public boolean isSkipMatches() {
        return this.skipMatches;
    }

    public void setSkipMatches(boolean skipMatches) {
        this.skipMatches = skipMatches;
    }
}

