/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.swagger.v3.parser.util.RefUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SchemaProcessor {
    private final ResolverCache cache;
    private final ExternalRefProcessor externalRefProcessor;

    public SchemaProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processSchema(Schema schema) {
        if (schema != null) {
            if (schema.get$ref() != null) {
                this.processReferenceSchema(schema);
            } else {
                this.processSchemaType(schema);
            }
        }
    }

    public void processSchemaType(Schema schema) {
        if (schema instanceof ArraySchema) {
            this.processArraySchema((ArraySchema)schema);
        } else if (schema instanceof ComposedSchema) {
            this.processComposedSchema((ComposedSchema)schema);
        }
        if (schema.getProperties() != null) {
            this.processPropertySchema(schema);
        }
        if (schema.getNot() != null) {
            this.processNotSchema(schema);
        }
        if (schema.getAdditionalProperties() != null) {
            this.processAdditionalProperties(schema);
        }
    }

    private void processAdditionalProperties(Object additionalProperties) {
        Schema schema;
        if (additionalProperties instanceof Schema && (schema = (Schema)additionalProperties).getAdditionalProperties() != null && schema.getAdditionalProperties() instanceof Schema) {
            Schema additionalPropertiesSchema = (Schema)schema.getAdditionalProperties();
            if (additionalPropertiesSchema.get$ref() != null) {
                this.processReferenceSchema(additionalPropertiesSchema);
            } else {
                this.processSchemaType(additionalPropertiesSchema);
            }
        }
    }

    private void processNotSchema(Schema schema) {
        if (schema.getNot() != null) {
            if (schema.getNot().get$ref() != null) {
                this.processReferenceSchema(schema.getNot());
            } else {
                this.processSchemaType(schema.getNot());
            }
        }
    }

    public void processPropertySchema(Schema schema) {
        Map properties;
        if (schema.get$ref() != null) {
            this.processReferenceSchema(schema);
        }
        if ((properties = schema.getProperties()) != null) {
            for (Map.Entry propertyEntry : properties.entrySet()) {
                Schema property = (Schema)propertyEntry.getValue();
                if (property instanceof ArraySchema) {
                    this.processArraySchema((ArraySchema)property);
                }
                if (property.get$ref() == null) continue;
                this.processReferenceSchema(property);
            }
        }
    }

    public void processComposedSchema(ComposedSchema composedSchema) {
        List schemas;
        if (composedSchema.getAllOf() != null && (schemas = composedSchema.getAllOf()) != null) {
            for (Schema schema : schemas) {
                if (schema.get$ref() != null) {
                    this.processReferenceSchema(schema);
                    continue;
                }
                this.processSchemaType(schema);
            }
        }
        if (composedSchema.getOneOf() != null && (schemas = composedSchema.getOneOf()) != null) {
            for (Schema schema : schemas) {
                if (schema.get$ref() != null) {
                    String oldRef = schema.get$ref();
                    this.processReferenceSchema(schema);
                    String newRef = schema.get$ref();
                    this.changeDiscriminatorMapping(composedSchema, oldRef, newRef);
                    continue;
                }
                this.processSchemaType(schema);
            }
        }
        if (composedSchema.getAnyOf() != null && (schemas = composedSchema.getAnyOf()) != null) {
            for (Schema schema : schemas) {
                if (schema.get$ref() != null) {
                    this.processReferenceSchema(schema);
                    continue;
                }
                this.processSchemaType(schema);
            }
        }
    }

    private void changeDiscriminatorMapping(ComposedSchema composedSchema, String oldRef, String newRef) {
        Discriminator discriminator = composedSchema.getDiscriminator();
        if (!oldRef.equals(newRef) && discriminator != null) {
            String oldName = RefUtils.computeDefinitionName(oldRef, new HashSet<String>());
            String newName = RefUtils.computeDefinitionName(newRef, new HashSet<String>());
            String mappingName = null;
            if (discriminator.getMapping() != null) {
                for (String name : discriminator.getMapping().keySet()) {
                    if (!oldRef.equals(discriminator.getMapping().get(name))) continue;
                    mappingName = name;
                    break;
                }
                if (mappingName != null) {
                    discriminator.getMapping().put(mappingName, newRef);
                }
            }
            if (mappingName == null && !oldName.equals(newName)) {
                if (discriminator.getMapping() == null) {
                    discriminator.setMapping(new HashMap());
                }
                discriminator.getMapping().put(oldName, newRef);
            }
        }
    }

    public void processArraySchema(ArraySchema arraySchema) {
        Schema items = arraySchema.getItems();
        if (items.get$ref() != null) {
            this.processReferenceSchema(items);
        } else {
            this.processSchemaType(items);
        }
    }

    private void processReferenceSchema(Schema schema) {
        String newRef;
        RefFormat refFormat = RefUtils.computeRefFormat(schema.get$ref());
        String $ref = schema.get$ref();
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalSchema($ref, refFormat)) != null) {
            schema.set$ref(newRef);
        }
    }
}

