/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.GrantType;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.service.VendorExtension;

public class OAuth
extends SecurityScheme {
    private final List<AuthorizationScope> scopes;
    private final LinkedHashMap<String, GrantType> grantTypes;

    public OAuth(String name, List<AuthorizationScope> scopes, List<GrantType> grantTypes, List<VendorExtension> vendorExtensions) {
        super(name, "oauth2");
        this.scopes = scopes;
        this.grantTypes = this.initializeGrantTypes(grantTypes);
        this.addValidVendorExtensions(vendorExtensions);
    }

    public OAuth(String name, List<AuthorizationScope> scopes, List<GrantType> grantTypes) {
        this(name, scopes, grantTypes, new ArrayList<VendorExtension>());
    }

    private LinkedHashMap<String, GrantType> initializeGrantTypes(List<GrantType> gTypes) {
        if (null != gTypes) {
            LinkedHashMap<String, GrantType> map = new LinkedHashMap<String, GrantType>();
            for (GrantType grantType : gTypes) {
                map.put(grantType.getType(), grantType);
            }
            return map;
        }
        return null;
    }

    public List<AuthorizationScope> getScopes() {
        return this.scopes;
    }

    public List<GrantType> getGrantTypes() {
        return new ArrayList<GrantType>(this.grantTypes.values());
    }
}

