/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.http.HttpMethod;
import springfox.documentation.OperationNameGenerator;
import springfox.documentation.annotations.Incubating;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.builders.ParameterMerger;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.VendorExtension;

public class OperationBuilder {
    private static final Collection<String> REQUEST_BODY_MEDIA_TYPES = Stream.of("application/json", "application/xml").collect(Collectors.toSet());
    private final OperationNameGenerator nameGenerator;
    private HttpMethod method = HttpMethod.GET;
    private String summary;
    private String notes;
    private String uniqueId;
    private String codeGenMethodNameStem;
    private int position;
    private Set<String> produces = new LinkedHashSet<String>();
    private Set<String> consumes = new LinkedHashSet<String>();
    private Set<String> protocol = new LinkedHashSet<String>();
    private List<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private Set<ResponseMessage> responseMessages = new HashSet<ResponseMessage>();
    private Set<String> tags = new LinkedHashSet<String>();
    private String deprecated;
    private boolean isHidden;
    private ModelReference responseModel;
    private List<VendorExtension> vendorExtensions = new ArrayList<VendorExtension>();

    public OperationBuilder(OperationNameGenerator nameGenerator) {
        this.nameGenerator = nameGenerator;
    }

    public OperationBuilder method(HttpMethod method) {
        this.method = BuilderDefaults.defaultIfAbsent(method, this.method);
        return this;
    }

    public OperationBuilder summary(String summary) {
        this.summary = BuilderDefaults.defaultIfAbsent(summary, this.summary);
        return this;
    }

    public OperationBuilder notes(String notes) {
        this.notes = BuilderDefaults.defaultIfAbsent(notes, this.notes);
        return this;
    }

    public OperationBuilder uniqueId(String uniqueId) {
        this.uniqueId = BuilderDefaults.defaultIfAbsent(uniqueId, this.uniqueId);
        return this;
    }

    @Incubating(value="2.3.0")
    public OperationBuilder codegenMethodNameStem(String codeGenMethodNameStem) {
        this.codeGenMethodNameStem = BuilderDefaults.defaultIfAbsent(codeGenMethodNameStem, this.codeGenMethodNameStem);
        return this;
    }

    public OperationBuilder position(int position) {
        this.position = position;
        return this;
    }

    public OperationBuilder produces(Set<String> mediaTypes) {
        this.produces.addAll(BuilderDefaults.nullToEmptySet(mediaTypes));
        return this;
    }

    public OperationBuilder consumes(Set<String> mediaTypes) {
        this.consumes.addAll(BuilderDefaults.nullToEmptySet(mediaTypes));
        return this;
    }

    public OperationBuilder protocols(Set<String> protocols) {
        this.protocol.addAll(BuilderDefaults.nullToEmptySet(protocols));
        return this;
    }

    public OperationBuilder authorizations(Collection<SecurityReference> securityReferences) {
        this.securityReferences.addAll(BuilderDefaults.nullToEmptyList(securityReferences));
        return this;
    }

    public OperationBuilder parameters(List<Parameter> parameters) {
        List<Parameter> source = BuilderDefaults.nullToEmptyList(parameters);
        ArrayList<Parameter> destination = new ArrayList<Parameter>(this.parameters);
        ParameterMerger merger = new ParameterMerger(destination, source);
        this.parameters = new ArrayList<Parameter>(merger.merged());
        return this;
    }

    public OperationBuilder responseMessages(Set<ResponseMessage> responseMessages) {
        this.responseMessages = new HashSet<ResponseMessage>(this.mergeResponseMessages(responseMessages));
        return this;
    }

    public OperationBuilder deprecated(String deprecated) {
        this.deprecated = BuilderDefaults.defaultIfAbsent(deprecated, this.deprecated);
        return this;
    }

    public OperationBuilder hidden(boolean isHidden) {
        this.isHidden = isHidden;
        return this;
    }

    public OperationBuilder responseModel(ModelReference responseType) {
        this.responseModel = BuilderDefaults.defaultIfAbsent(responseType, this.responseModel);
        return this;
    }

    public OperationBuilder tags(Set<String> tags) {
        this.tags = BuilderDefaults.nullToEmptySet(tags);
        return this;
    }

    public OperationBuilder extensions(List<VendorExtension> extensions) {
        this.vendorExtensions.addAll(BuilderDefaults.nullToEmptyList(extensions));
        return this;
    }

    public Operation build() {
        String uniqueOperationId = this.nameGenerator.startingWith(this.uniqueOperationIdStem());
        return new Operation(this.method, this.summary, this.notes, this.responseModel, uniqueOperationId, this.position, this.tags, this.produces, this.adjustConsumableMediaTypes(), this.protocol, this.securityReferences, this.parameters, this.responseMessages, this.deprecated, this.isHidden, this.vendorExtensions);
    }

    private Set<String> adjustConsumableMediaTypes() {
        HashSet<String> adjustedConsumes = new HashSet<String>(this.consumes);
        if (Stream.of(HttpMethod.GET, HttpMethod.DELETE).anyMatch(Predicate.isEqual(this.method))) {
            adjustedConsumes.removeAll(REQUEST_BODY_MEDIA_TYPES);
        }
        return adjustedConsumes;
    }

    private String uniqueOperationIdStem() {
        String defaultStem = String.format("%sUsing%s", this.uniqueId, this.method);
        return Optional.ofNullable(this.codeGenMethodNameStem).filter(((Predicate<String>)String::isEmpty).negate()).orElse(defaultStem);
    }

    private Set<ResponseMessage> mergeResponseMessages(Set<ResponseMessage> responseMessages) {
        Map responsesByCode = this.responseMessages.stream().collect(Collectors.toMap(ResponseMessage::getCode, Function.identity()));
        HashSet<ResponseMessage> merged = new HashSet<ResponseMessage>(this.responseMessages);
        for (ResponseMessage each : responseMessages) {
            if (responsesByCode.containsKey(each.getCode())) {
                ResponseMessage responseMessage = (ResponseMessage)responsesByCode.get(each.getCode());
                String message = BuilderDefaults.defaultIfAbsent(Optional.ofNullable(each.getMessage()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null), responseMessage.getMessage());
                List<Example> examples = Stream.concat(Optional.ofNullable(responseMessage.getExamples()).orElse(Collections.emptyList()).stream(), Optional.ofNullable(each.getExamples()).orElse(Collections.emptyList()).stream()).collect(Collectors.toList());
                ModelReference responseWithModel = BuilderDefaults.defaultIfAbsent(each.getResponseModel(), responseMessage.getResponseModel());
                merged.remove(responseMessage);
                merged.add(new ResponseMessageBuilder().code(each.getCode()).message(message).responseModel(responseWithModel).examples(examples).headersWithDescription(responseMessage.getHeaders()).headersWithDescription(each.getHeaders()).build());
                continue;
            }
            merged.add(each);
        }
        return merged;
    }
}

