/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.Objects;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.VoidType;
import org.jboss.jandex.WildcardType;

class TypeParser {
    private final String str;
    private int pos = 0;

    TypeParser(String str) {
        this.str = Objects.requireNonNull(str);
    }

    Type parse() {
        String token = this.nextToken();
        if (token.isEmpty()) {
            throw this.unexpected(token);
        }
        Type result = token.equals("void") ? VoidType.VOID : (this.isPrimitiveType(token) && this.peekToken().isEmpty() ? PrimitiveType.decode(token) : this.parseReferenceType(token));
        this.expect("");
        return result;
    }

    private Type parseReferenceType(String token) {
        if (this.isPrimitiveType(token)) {
            PrimitiveType primitive = PrimitiveType.decode(token);
            return this.parseArrayType(primitive);
        }
        if (this.isClassType(token)) {
            Type result = ClassType.create(token);
            if (this.peekToken().equals("<")) {
                this.expect("<");
                ParameterizedType.Builder builder = ParameterizedType.builder(result.name());
                builder.addArgument(this.parseTypeArgument());
                while (this.peekToken().equals(",")) {
                    this.expect(",");
                    builder.addArgument(this.parseTypeArgument());
                }
                this.expect(">");
                result = builder.build();
            }
            if (this.peekToken().equals("[")) {
                return this.parseArrayType(result);
            }
            return result;
        }
        throw this.unexpected(token);
    }

    private Type parseArrayType(Type elementType) {
        this.expect("[");
        this.expect("]");
        int dimensions = 1;
        while (this.peekToken().equals("[")) {
            this.expect("[");
            this.expect("]");
            ++dimensions;
        }
        return ArrayType.create(elementType, dimensions);
    }

    private Type parseTypeArgument() {
        String token = this.nextToken();
        if (token.equals("?")) {
            if (this.peekToken().equals("extends")) {
                this.expect("extends");
                Type bound = this.parseReferenceType(this.nextToken());
                return WildcardType.createUpperBound(bound);
            }
            if (this.peekToken().equals("super")) {
                this.expect("super");
                Type bound = this.parseReferenceType(this.nextToken());
                return WildcardType.createLowerBound(bound);
            }
            return WildcardType.UNBOUNDED;
        }
        return this.parseReferenceType(token);
    }

    private boolean isPrimitiveType(String token) {
        return token.equals("boolean") || token.equals("byte") || token.equals("short") || token.equals("int") || token.equals("long") || token.equals("float") || token.equals("double") || token.equals("char");
    }

    private boolean isClassType(String token) {
        return !token.isEmpty() && Character.isJavaIdentifierStart(token.charAt(0));
    }

    private void expect(String expected) {
        String token = this.nextToken();
        if (!expected.equals(token)) {
            throw this.unexpected(token);
        }
    }

    private IllegalArgumentException unexpected(String token) {
        if (token.isEmpty()) {
            throw new IllegalArgumentException("Unexpected end of input: " + this.str);
        }
        return new IllegalArgumentException("Unexpected token '" + token + "' at position " + (this.pos - token.length()) + ": " + this.str);
    }

    private String peekToken() {
        while (this.pos < this.str.length() && Character.isWhitespace(this.str.charAt(this.pos))) {
            ++this.pos;
        }
        if (this.pos == this.str.length()) {
            return "";
        }
        int pos = this.pos;
        if (this.isSpecial(this.str.charAt(pos))) {
            return this.str.substring(pos, pos + 1);
        }
        int begin = pos;
        while (pos < this.str.length() && Character.isJavaIdentifierStart(this.str.charAt(pos))) {
            while (++pos < this.str.length() && Character.isJavaIdentifierPart(this.str.charAt(pos))) {
            }
            if (pos < this.str.length() && this.str.charAt(pos) == '.') {
                ++pos;
                continue;
            }
            return this.str.substring(begin, pos);
        }
        if (pos == this.str.length()) {
            throw new IllegalArgumentException("Unexpected end of input: " + this.str);
        }
        throw new IllegalArgumentException("Unexpected character '" + this.str.charAt(pos) + "' at position " + pos + ": " + this.str);
    }

    private String nextToken() {
        String result = this.peekToken();
        this.pos += result.length();
        return result;
    }

    private boolean isSpecial(char c) {
        return c == ',' || c == '?' || c == '<' || c == '>' || c == '[' || c == ']';
    }
}

