/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.Config;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.inject.MetadataInjectionPoint;
import io.smallrye.config.inject.SecuritySupport;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;

public class ConfigMappingInjectionBean<T>
implements Bean<T> {
    private final BeanManager bm;
    private final ConfigMappings.ConfigClass configClass;

    public ConfigMappingInjectionBean(ConfigMappings.ConfigClass configClass, BeanManager bm) {
        this.bm = bm;
        this.configClass = configClass;
    }

    public Class<T> getBeanClass() {
        return this.configClass.getType();
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public T create(CreationalContext<T> creationalContext) {
        ConfigMapping configMapping;
        InjectionPoint injectionPoint = (InjectionPoint)this.bm.getInjectableReference((InjectionPoint)new MetadataInjectionPoint(), creationalContext);
        String prefix = this.configClass.getPrefix();
        if (injectionPoint != null && injectionPoint.getAnnotated() != null && (configMapping = (ConfigMapping)injectionPoint.getAnnotated().getAnnotation(ConfigMapping.class)) != null) {
            prefix = configMapping.prefix();
        }
        return (T)Config.get((ClassLoader)SecuritySupport.getContextClassLoader()).getConfigMapping(this.getBeanClass(), prefix);
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.configClass.getType());
    }

    public Set<Annotation> getQualifiers() {
        return Collections.singleton(Default.Literal.INSTANCE);
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return this.getClass().getSimpleName() + "_" + this.configClass.getType().getName();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }
}

