/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.bootstrap.util.ZipUtils;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationStartBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationSourceBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.ShutdownListenerBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.netty.runtime.virtual.VirtualServerChannel;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.LiveReloadConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.shutdown.ShutdownConfig;
import io.quarkus.runtime.shutdown.ShutdownListener;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.core.deployment.EventLoopCountBuildItem;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.DefaultRouteBuildItem;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.InitialRouterBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RequireBodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.RequireVirtualHttpBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.VertxWebRouterBuildItem;
import io.quarkus.vertx.http.deployment.WebsocketSubProtocolsBuildItem;
import io.quarkus.vertx.http.deployment.devmode.HttpRemoteDevClientProvider;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.runtime.CurrentRequestProducer;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpHostConfigSource;
import io.quarkus.vertx.http.runtime.VertxHttpRecorder;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.cors.CORSRecorder;
import io.quarkus.vertx.http.runtime.filters.GracefulShutdownFilter;
import io.vertx.core.Handler;
import io.vertx.core.http.impl.Http1xServerRequest;
import io.vertx.core.impl.VertxImpl;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

class VertxHttpProcessor {
    private static final Logger logger = Logger.getLogger(VertxHttpProcessor.class);

    VertxHttpProcessor() {
    }

    @BuildStep
    LogCategoryBuildItem logging() {
        return new LogCategoryBuildItem(Http1xServerRequest.class.getName(), Level.OFF);
    }

    @BuildStep
    HttpRootPathBuildItem httpRoot(HttpBuildTimeConfig httpBuildTimeConfig) {
        return new HttpRootPathBuildItem(httpBuildTimeConfig.rootPath);
    }

    @BuildStep
    NonApplicationRootPathBuildItem frameworkRoot(HttpBuildTimeConfig httpBuildTimeConfig) {
        return new NonApplicationRootPathBuildItem(httpBuildTimeConfig.rootPath, httpBuildTimeConfig.nonApplicationRootPath);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    FilterBuildItem cors(CORSRecorder recorder) {
        return new FilterBuildItem((Handler<RoutingContext>)recorder.corsHandler(), 300);
    }

    @BuildStep
    AdditionalBeanBuildItem additionalBeans() {
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(CurrentVertxRequest.class).addBeanClass(CurrentRequestProducer.class).build();
    }

    @BuildStep
    void filterMultipleVertxInstancesWarning(LaunchModeBuildItem launchModeBuildItem, BuildProducer<LogCleanupFilterBuildItem> logCleanupFilterBuildItemBuildProducer) {
        if (launchModeBuildItem.getLaunchMode().equals((Object)LaunchMode.DEVELOPMENT)) {
            logCleanupFilterBuildItemBuildProducer.produce((BuildItem)new LogCleanupFilterBuildItem(VertxImpl.class.getName(), new String[]{"You're already on a Vert.x context, are you sure you want to create a new Vertx instance"}));
        }
    }

    @BuildStep
    public KubernetesPortBuildItem kubernetes() {
        int port = ConfigProvider.getConfig().getOptionalValue("quarkus.http.port", Integer.class).orElse(8080);
        return new KubernetesPortBuildItem(port, "http");
    }

    @BuildStep
    void notFoundRoutes(List<RouteBuildItem> routes, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> notFound) {
        for (RouteBuildItem i : routes) {
            if (i.getNotFoundPageDisplayableEndpoint() == null) continue;
            notFound.produce((BuildItem)i.getNotFoundPageDisplayableEndpoint());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void preinitializeRouter(CoreVertxBuildItem vertx, VertxHttpRecorder recorder, BuildProducer<InitialRouterBuildItem> initialRouter, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        RuntimeValue httpRouteRouter = recorder.initializeRouter(vertx.getVertx());
        RuntimeValue mutinyRouter = recorder.createMutinyRouter(httpRouteRouter);
        initialRouter.produce((BuildItem)new InitialRouterBuildItem((RuntimeValue<Router>)httpRouteRouter, (RuntimeValue<io.vertx.mutiny.ext.web.Router>)mutinyRouter));
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Router.class).scope(BuiltinScope.APPLICATION.getInfo())).setRuntimeInit().runtimeValue(httpRouteRouter).done());
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(io.vertx.mutiny.ext.web.Router.class).scope(BuiltinScope.APPLICATION.getInfo())).setRuntimeInit().runtimeValue(mutinyRouter).done());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    VertxWebRouterBuildItem initializeRouter(VertxHttpRecorder recorder, InitialRouterBuildItem initialRouter, CoreVertxBuildItem vertx, List<RouteBuildItem> routes, HttpBuildTimeConfig httpBuildTimeConfig, NonApplicationRootPathBuildItem nonApplicationRootPath, ShutdownContextBuildItem shutdown) {
        RuntimeValue<Router> httpRouteRouter = initialRouter.getHttpRouter();
        RuntimeValue<io.vertx.mutiny.ext.web.Router> mutinyRouter = initialRouter.getMutinyRouter();
        RuntimeValue frameworkRouter = null;
        RuntimeValue mainRouter = null;
        ArrayList redirectRoutes = new ArrayList();
        boolean frameworkRouterCreated = false;
        boolean mainRouterCreated = false;
        for (RouteBuildItem route2 : routes) {
            if (nonApplicationRootPath.isDedicatedRouterRequired() && route2.isFrameworkRoute()) {
                if (!frameworkRouterCreated) {
                    frameworkRouter = recorder.initializeRouter(vertx.getVertx());
                    frameworkRouterCreated = true;
                }
                recorder.addRoute(frameworkRouter, route2.getRouteFunction(), route2.getHandler(), route2.getType());
                continue;
            }
            if (route2.isAbsoluteRoute()) {
                if (!mainRouterCreated) {
                    mainRouter = recorder.initializeRouter(vertx.getVertx());
                    mainRouterCreated = true;
                }
                recorder.addRoute(mainRouter, route2.getRouteFunction(), route2.getHandler(), route2.getType());
                continue;
            }
            recorder.addRoute(httpRouteRouter, route2.getRouteFunction(), route2.getHandler(), route2.getType());
        }
        if (frameworkRouterCreated && redirectRoutes.size() > 0) {
            recorder.setNonApplicationRedirectHandler(nonApplicationRootPath.getNonApplicationRootPath(), nonApplicationRootPath.getNormalizedHttpRootPath());
            redirectRoutes.forEach(route -> recorder.addRoute(httpRouteRouter, route.getRouteFunction(), recorder.getNonApplicationRedirectHandler(), route.getType()));
        }
        return new VertxWebRouterBuildItem(httpRouteRouter, mainRouter, frameworkRouter, mutinyRouter);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    BodyHandlerBuildItem bodyHandler(VertxHttpRecorder recorder) {
        return new BodyHandlerBuildItem((Handler<RoutingContext>)recorder.createBodyHandler());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem finalizeRouter(VertxHttpRecorder recorder, BeanContainerBuildItem beanContainer, CoreVertxBuildItem vertx, LaunchModeBuildItem launchMode, List<DefaultRouteBuildItem> defaultRoutes, List<FilterBuildItem> filters, VertxWebRouterBuildItem httpRouteRouter, HttpRootPathBuildItem httpRootPathBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, HttpBuildTimeConfig httpBuildTimeConfig, List<RequireBodyHandlerBuildItem> requireBodyHandlerBuildItems, BodyHandlerBuildItem bodyHandlerBuildItem, BuildProducer<ShutdownListenerBuildItem> shutdownListenerBuildItemBuildProducer, ShutdownConfig shutdownConfig, LiveReloadConfig lrc, CoreVertxBuildItem core, ExecutorBuildItem executorBuildItem) throws BuildException, IOException {
        Optional<Object> mainRouter;
        Optional<Object> defaultRoute;
        if (defaultRoutes == null || defaultRoutes.isEmpty()) {
            defaultRoute = Optional.empty();
        } else {
            if (defaultRoutes.size() > 1) {
                throw new BuildException("Too many default routes.", Collections.emptyList());
            }
            defaultRoute = Optional.of(defaultRoutes.get(0));
        }
        HttpRemoteDevClientProvider.liveReloadConfig = lrc;
        GracefulShutdownFilter gracefulShutdownFilter = recorder.createGracefulShutdownHandler();
        shutdownListenerBuildItemBuildProducer.produce((BuildItem)new ShutdownListenerBuildItem((ShutdownListener)gracefulShutdownFilter));
        List listOfFilters = filters.stream().filter(f -> f.getHandler() != null).map(FilterBuildItem::toFilter).collect(Collectors.toList());
        Handler<RoutingContext> bodyHandler = !requireBodyHandlerBuildItems.isEmpty() ? bodyHandlerBuildItem.getHandler() : null;
        Optional<Object> optional = mainRouter = httpRouteRouter.getMainRouter() != null ? Optional.of(httpRouteRouter.getMainRouter()) : Optional.empty();
        if (httpRouteRouter.getFrameworkRouter() != null) {
            if (nonApplicationRootPathBuildItem.isAttachedToMainRouter()) {
                recorder.mountFrameworkRouter(httpRouteRouter.getHttpRouter(), httpRouteRouter.getFrameworkRouter(), nonApplicationRootPathBuildItem.getVertxRouterPath());
            } else {
                if (!mainRouter.isPresent()) {
                    mainRouter = Optional.of(recorder.initializeRouter(vertx.getVertx()));
                }
                recorder.mountFrameworkRouter((RuntimeValue)mainRouter.get(), httpRouteRouter.getFrameworkRouter(), nonApplicationRootPathBuildItem.getVertxRouterPath());
            }
        }
        recorder.finalizeRouter(beanContainer.getValue(), (Consumer)defaultRoute.map(DefaultRouteBuildItem::getRoute).orElse(null), listOfFilters, vertx.getVertx(), lrc, mainRouter, httpRouteRouter.getHttpRouter(), httpRouteRouter.getMutinyRouter(), httpRootPathBuildItem.getRootPath(), launchMode.getLaunchMode(), !requireBodyHandlerBuildItems.isEmpty(), bodyHandler, gracefulShutdownFilter, shutdownConfig, (Executor)executorBuildItem.getExecutorProxy());
        return new ServiceStartBuildItem("vertx-http");
    }

    @BuildStep
    void hostDefault(BuildProducer<RunTimeConfigurationSourceBuildItem> serviceProviderBuildItem) {
        serviceProviderBuildItem.produce((BuildItem)new RunTimeConfigurationSourceBuildItem(HttpHostConfigSource.class.getName(), OptionalInt.of(Integer.MIN_VALUE)));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void openSocket(ApplicationStartBuildItem start, LaunchModeBuildItem launchMode, CoreVertxBuildItem vertx, ShutdownContextBuildItem shutdown, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, HttpBuildTimeConfig httpBuildTimeConfig, Optional<RequireVirtualHttpBuildItem> requireVirtual, EventLoopCountBuildItem eventLoopCount, List<WebsocketSubProtocolsBuildItem> websocketSubProtocols, VertxHttpRecorder recorder) throws IOException {
        boolean startVirtual;
        boolean bl = startVirtual = requireVirtual.isPresent() || httpBuildTimeConfig.virtual;
        if (startVirtual) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new Class[]{VirtualServerChannel.class}));
        }
        boolean startSocket = !(startVirtual && launchMode.getLaunchMode() == LaunchMode.NORMAL || !requireVirtual.isEmpty() && requireVirtual.get().isAlwaysVirtual());
        recorder.startServer(vertx.getVertx(), (ShutdownContext)shutdown, launchMode.getLaunchMode(), startVirtual, startSocket, eventLoopCount.getEventLoopCount(), websocketSubProtocols.stream().map(bi -> bi.getWebsocketSubProtocols()).collect(Collectors.toList()), launchMode.isAuxiliaryApplication());
    }

    @BuildStep
    void configureNativeCompilation(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClasses) {
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.ext.web.handler.sockjs.impl.XhrTransport"));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.ext.auth.impl.jose.JWT"));
    }

    @BuildStep
    void registerExchangeAttributeBuilders(BuildProducer<ServiceProviderBuildItem> exchangeAttributeBuilderService) throws BuildException {
        CodeSource codeSource = ExchangeAttributeBuilder.class.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            logger.debug((Object)("Skipping registration of service providers for " + ExchangeAttributeBuilder.class));
            return;
        }
        try (FileSystem jarFileSystem = ZipUtils.newFileSystem((URI)new URI("jar", codeSource.getLocation().toURI().toString(), null), Collections.emptyMap());){
            Path serviceDescriptorFilePath = jarFileSystem.getPath("META-INF", "services", "io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder");
            if (!Files.exists(serviceDescriptorFilePath, new LinkOption[0])) {
                logger.debug((Object)("Skipping registration of service providers for " + ExchangeAttributeBuilder.class + " since no service descriptor file found"));
                return;
            }
            ServiceProviderBuildItem serviceProviderBuildItem = ServiceProviderBuildItem.allProviders((String)ExchangeAttributeBuilder.class.getName(), (Path)serviceDescriptorFilePath);
            exchangeAttributeBuilderService.produce((BuildItem)serviceProviderBuildItem);
        }
        catch (IOException | URISyntaxException e) {
            throw new BuildException((Throwable)e, Collections.emptyList());
        }
    }
}

