/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.quarkus.runtime.TemplateHtmlBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class QuarkusErrorServlet
extends HttpServlet {
    public static final String SHOW_STACK = "show-stack";

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean showStack;
        Object details = "";
        String stack = "";
        Object uuid = req.getAttribute("quarkus.error.id");
        Throwable exception = (Throwable)req.getAttribute("javax.servlet.error.exception");
        String errorMessage = (String)req.getAttribute("javax.servlet.error.message");
        if (errorMessage != null) {
            details = errorMessage;
        }
        if ((showStack = Boolean.parseBoolean(this.getInitParameter(SHOW_STACK))) && exception != null) {
            details = QuarkusErrorServlet.generateHeaderMessage(exception, uuid == null ? null : uuid.toString());
            stack = QuarkusErrorServlet.generateStackTrace(exception);
        } else if (uuid != null) {
            details = (String)details + "Error id " + uuid;
        }
        String accept = req.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            resp.setContentType("application/json");
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            String escapedDetails = QuarkusErrorServlet.escapeJsonString((String)details);
            String escapedStack = QuarkusErrorServlet.escapeJsonString(stack);
            StringBuilder jsonPayload = new StringBuilder("{\"details\":\"").append(escapedDetails).append("\",\"stack\":\"").append(escapedStack).append("\"}");
            resp.getWriter().write(jsonPayload.toString());
        } else {
            resp.setContentType("text/html");
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            TemplateHtmlBuilder htmlBuilder = new TemplateHtmlBuilder("Internal Server Error", (String)details, (String)details);
            if (showStack && exception != null) {
                htmlBuilder.stack(exception);
            }
            resp.getWriter().write(htmlBuilder.toString());
        }
    }

    private static String generateStackTrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString().trim();
    }

    private static String generateHeaderMessage(Throwable exception, String uuid) {
        return String.format("Error handling %s, %s: %s", uuid, exception.getClass().getName(), QuarkusErrorServlet.extractFirstLine(exception.getMessage()));
    }

    private static String extractFirstLine(String message) {
        if (null == message) {
            return "";
        }
        String[] lines = message.split("\\r?\\n");
        return lines[0].trim();
    }

    private static String escapeJsonString(String text) {
        StringBuilder sb = new StringBuilder();
        block9: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

