/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.AbstractServerJacksonMessageBodyReader;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.jboss.resteasy.reactive.common.util.StreamUtil;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyReader;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public class ServerJacksonMessageBodyReader
extends AbstractServerJacksonMessageBodyReader
implements ServerMessageBodyReader<Object> {
    public ServerJacksonMessageBodyReader() {
    }

    @Inject
    public ServerJacksonMessageBodyReader(Instance<ObjectMapper> mapper) {
        super(mapper);
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            return this.doReadFrom(type, genericType, entityStream);
        }
        catch (InvalidDefinitionException | MismatchedInputException e) {
            throw e;
        }
        catch (StreamReadException | DatabindException e) {
            throw new WebApplicationException(e, Response.Status.BAD_REQUEST);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadable(mediaType, type);
    }

    public boolean isReadable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo lazyMethod, MediaType mediaType) {
        return this.isReadable(mediaType, type);
    }

    public Object readFrom(Class<Object> type, Type genericType, MediaType mediaType, ServerRequestContext context) throws WebApplicationException, IOException {
        return this.readFrom(type, genericType, null, mediaType, null, context.getInputStream());
    }

    private Object doReadFrom(Class<Object> type, Type genericType, InputStream entityStream) throws IOException {
        if (StreamUtil.isEmpty((InputStream)entityStream)) {
            return null;
        }
        try {
            ObjectReader reader = this.getEffectiveReader();
            return reader.forType(reader.getTypeFactory().constructType(genericType != null ? genericType : type)).readValue(entityStream);
        }
        catch (MismatchedInputException e) {
            if (this.isEmptyInputException(e)) {
                return null;
            }
            throw e;
        }
    }

    private boolean isEmptyInputException(MismatchedInputException e) {
        return e.getMessage().startsWith("No content");
    }
}

