/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.deployment.processor;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.Switch;
import io.quarkus.resteasy.reactive.jackson.deployment.processor.JacksonCodeGenerator;
import io.quarkus.resteasy.reactive.jackson.deployment.processor.JacksonSerializationUtils;
import io.quarkus.resteasy.reactive.jackson.runtime.mappers.JacksonMapperUtil;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.VoidType;

public class JacksonDeserializerFactory
extends JacksonCodeGenerator {
    public JacksonDeserializerFactory(BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, IndexView jandexIndex) {
        super(generatedClassBuildItemBuildProducer, jandexIndex);
    }

    @Override
    protected String getSuperClassName() {
        return StdDeserializer.class.getName();
    }

    @Override
    protected String getClassSuffix() {
        return "$quarkusjacksondeserializer";
    }

    @Override
    protected String[] getInterfacesNames(ClassInfo classInfo) {
        String[] stringArray;
        if (classInfo.typeParameters().isEmpty()) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ContextualDeserializer.class.getName();
        }
        return stringArray;
    }

    @Override
    protected boolean createSerializationMethod(ClassInfo classInfo, ClassCreator classCreator, String beanClassName) {
        ResultHandle deserializedHandle;
        MethodCreator deserialize = ((MethodCreator)classCreator.getMethodCreator("deserialize", Object.class, new Class[]{JsonParser.class, DeserializationContext.class}).setModifiers(1)).addException(IOException.class).addException(JacksonException.class);
        Optional<MethodInfo> ctorOpt = this.findConstructor(classInfo);
        if (ctorOpt.isEmpty()) {
            return false;
        }
        MethodInfo ctor = ctorOpt.get();
        DeserializationData deserData = new DeserializationData(classInfo, ctor, classCreator, deserialize, JacksonDeserializerFactory.getJsonNode(deserialize), this.parseTypeParameters(classInfo, classCreator), new HashSet<String>());
        ResultHandle resultHandle = deserializedHandle = ctor.parametersCount() == 0 ? deserData.methodCreator.newInstance(MethodDescriptor.ofConstructor((String)deserData.classInfo.name().toString(), (String[])new String[0]), new ResultHandle[0]) : this.createDeserializedObject(deserData);
        if (deserializedHandle == null) {
            return false;
        }
        boolean valid = this.deserializeObjectFields(deserData, deserializedHandle);
        deserialize.returnValue(deserializedHandle);
        return valid;
    }

    private static ResultHandle getJsonNode(MethodCreator deserialize) {
        ResultHandle jsonParser = deserialize.getMethodParam(0);
        ResultHandle objectCodec = deserialize.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonParser.class, (String)"getCodec", ObjectCodec.class, (Class[])new Class[0]), jsonParser, new ResultHandle[0]);
        ResultHandle treeNode = deserialize.invokeVirtualMethod(MethodDescriptor.ofMethod(ObjectCodec.class, (String)"readTree", TreeNode.class, (Class[])new Class[]{JsonParser.class}), objectCodec, new ResultHandle[]{jsonParser});
        return deserialize.checkCast(treeNode, JsonNode.class);
    }

    private ResultHandle createDeserializedObject(DeserializationData deserData) {
        ResultHandle[] params = new ResultHandle[deserData.constructor.parameters().size()];
        int i = 0;
        for (MethodParameterInfo paramInfo : deserData.constructor.parameters()) {
            JacksonCodeGenerator.FieldSpecs fieldSpecs = this.fieldSpecsFromFieldParam(paramInfo);
            deserData.constructorFields.add(fieldSpecs.jsonName);
            ResultHandle fieldValue = deserData.methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonNode.class, (String)"get", JsonNode.class, (Class[])new Class[]{String.class}), deserData.jsonNode, new ResultHandle[]{deserData.methodCreator.load(fieldSpecs.jsonName)});
            params[i++] = this.readValueFromJson(deserData.classCreator, (BytecodeCreator)deserData.methodCreator, deserData.methodCreator.getMethodParam(1), fieldSpecs, deserData.typeParametersIndex, fieldValue);
        }
        return deserData.methodCreator.newInstance(deserData.constructor, params);
    }

    private boolean deserializeObjectFields(DeserializationData deserData, ResultHandle objHandle) {
        ResultHandle fieldsIterator = deserData.methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonNode.class, (String)"fields", Iterator.class, (Class[])new Class[0]), deserData.jsonNode, new ResultHandle[0]);
        BytecodeCreator loopCreator = deserData.methodCreator.whileLoop(c -> this.iteratorHasNext((BytecodeCreator)c, fieldsIterator)).block();
        ResultHandle nextField = loopCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), fieldsIterator, new ResultHandle[0]);
        ResultHandle mapEntry = loopCreator.checkCast(nextField, Map.Entry.class);
        ResultHandle fieldValue = loopCreator.checkCast(loopCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.Entry.class, (String)"getValue", Object.class, (Class[])new Class[0]), mapEntry, new ResultHandle[0]), JsonNode.class);
        BytecodeCreator fieldReader = loopCreator.ifTrue(loopCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonNode.class, (String)"isNull", Boolean.TYPE, (Class[])new Class[0]), fieldValue, new ResultHandle[0])).falseBranch();
        ResultHandle fieldName = fieldReader.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.Entry.class, (String)"getKey", Object.class, (Class[])new Class[0]), mapEntry, new ResultHandle[0]);
        Switch.StringSwitch strSwitch = fieldReader.stringSwitch(fieldName);
        return this.deserializeFields(deserData, deserData.methodCreator.getMethodParam(1), objHandle, fieldValue, deserData.constructorFields, strSwitch);
    }

    private BranchResult iteratorHasNext(BytecodeCreator creator, ResultHandle iterator) {
        return creator.ifTrue(creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]), iterator, new ResultHandle[0]));
    }

    private Map<String, Integer> parseTypeParameters(ClassInfo classInfo, ClassCreator classCreator) {
        List typeParameters = classInfo.typeParameters();
        if (typeParameters.isEmpty()) {
            return Map.of();
        }
        JacksonDeserializerFactory.createContextualMethod(classCreator);
        HashMap<String, Integer> typeParametersIndex = new HashMap<String, Integer>();
        int index = 0;
        for (TypeVariable typeParameter : typeParameters) {
            typeParametersIndex.put(typeParameter.name().toString(), index++);
        }
        return typeParametersIndex;
    }

    private static void createContextualMethod(ClassCreator classCreator) {
        FieldDescriptor valueTypesField = FieldDescriptor.of((String)classCreator.getClassName(), (String)"valueTypes", JavaType[].class);
        classCreator.getFieldCreator(valueTypesField);
        MethodCreator createContextual = (MethodCreator)classCreator.getMethodCreator("createContextual", JsonDeserializer.class, new Class[]{DeserializationContext.class, BeanProperty.class}).setModifiers(1);
        ResultHandle deserializationContext = createContextual.getMethodParam(0);
        ResultHandle beanProperty = createContextual.getMethodParam(1);
        MethodDescriptor getGenericsJavaTypes = MethodDescriptor.ofMethod(JacksonMapperUtil.class, (String)"getGenericsJavaTypes", JavaType[].class, (Class[])new Class[]{DeserializationContext.class, BeanProperty.class});
        ResultHandle valueTypes = createContextual.invokeStaticMethod(getGenericsJavaTypes, new ResultHandle[]{deserializationContext, beanProperty});
        ResultHandle deserializer = createContextual.newInstance(MethodDescriptor.ofConstructor((String)classCreator.getClassName(), (String[])new String[0]), new ResultHandle[0]);
        createContextual.writeInstanceField(valueTypesField, deserializer, valueTypes);
        createContextual.returnValue(deserializer);
    }

    private boolean deserializeFields(DeserializationData deserData, ResultHandle deserializationContext, ResultHandle objHandle, ResultHandle fieldValue, Set<String> deserializedFields, Switch.StringSwitch strSwitch) {
        AtomicBoolean valid = new AtomicBoolean(true);
        for (FieldInfo fieldInfo : this.classFields(deserData.classInfo)) {
            if (this.deserializeFieldSpecs(deserData, deserializationContext, objHandle, fieldValue, deserializedFields, strSwitch, this.fieldSpecsFromField(deserData.classInfo, deserData.constructor, fieldInfo), valid)) continue;
            return false;
        }
        for (MethodInfo methodInfo : this.classMethods(deserData.classInfo)) {
            if (this.deserializeFieldSpecs(deserData, deserializationContext, objHandle, fieldValue, deserializedFields, strSwitch, this.fieldSpecsFromMethod(methodInfo), valid)) continue;
            return false;
        }
        return valid.get();
    }

    private boolean deserializeFieldSpecs(DeserializationData deserData, ResultHandle deserializationContext, ResultHandle objHandle, ResultHandle fieldValue, Set<String> deserializedFields, Switch.StringSwitch strSwitch, JacksonCodeGenerator.FieldSpecs fieldSpecs, AtomicBoolean valid) {
        if (fieldSpecs != null && deserializedFields.add(fieldSpecs.jsonName)) {
            if (fieldSpecs.isIgnoredField()) {
                return true;
            }
            if (fieldSpecs.hasUnknownAnnotation()) {
                return false;
            }
            strSwitch.caseOf((Object)fieldSpecs.jsonName, bytecode -> valid.compareAndSet(true, this.deserializeField(deserData, (BytecodeCreator)bytecode, objHandle, fieldValue, fieldSpecs, deserializationContext)));
        }
        return true;
    }

    private boolean deserializeField(DeserializationData deserData, BytecodeCreator bytecode, ResultHandle objHandle, ResultHandle fieldValue, JacksonCodeGenerator.FieldSpecs fieldSpecs, ResultHandle deserializationContext) {
        ResultHandle valueHandle = this.readValueFromJson(deserData.classCreator, bytecode, deserializationContext, fieldSpecs, deserData.typeParametersIndex, fieldValue);
        if (valueHandle == null) {
            return false;
        }
        this.writeValueToObject(deserData.classInfo, objHandle, fieldSpecs, bytecode, fieldSpecs.toValueWriterHandle(bytecode, valueHandle));
        return true;
    }

    private JacksonCodeGenerator.FieldSpecs fieldSpecsFromMethod(MethodInfo methodInfo) {
        return this.isSetterMethod(methodInfo) ? new JacksonCodeGenerator.FieldSpecs(methodInfo) : null;
    }

    private boolean isSetterMethod(MethodInfo methodInfo) {
        return Modifier.isPublic(methodInfo.flags()) && !Modifier.isStatic(methodInfo.flags()) && methodInfo.returnType() instanceof VoidType && methodInfo.parametersCount() == 1 && methodInfo.name().startsWith("set");
    }

    private ResultHandle readValueFromJson(ClassCreator classCreator, BytecodeCreator bytecode, ResultHandle deserializationContext, JacksonCodeGenerator.FieldSpecs fieldSpecs, Map<String, Integer> typeParametersIndex, ResultHandle valueNode) {
        ResultHandle typeHandle;
        Type fieldType = fieldSpecs.fieldType;
        String fieldTypeName = fieldType.name().toString();
        if (JacksonSerializationUtils.isBasicJsonType(fieldType)) {
            return JacksonDeserializerFactory.readValueForPrimitiveFields(bytecode, fieldType, valueNode);
        }
        JacksonCodeGenerator.FieldKind fieldKind = this.registerTypeToBeGenerated(fieldType, fieldTypeName);
        switch (fieldKind) {
            case TYPE_VARIABLE: {
                ResultHandle resultHandle;
                Integer parameterIndex = typeParametersIndex.get(fieldTypeName);
                if (parameterIndex == null) {
                    resultHandle = null;
                    break;
                }
                FieldDescriptor valueTypesField = FieldDescriptor.of((String)classCreator.getClassName(), (String)"valueTypes", JavaType[].class);
                ResultHandle valueTypes = bytecode.readInstanceField(valueTypesField, bytecode.getThis());
                resultHandle = bytecode.readArrayValue(valueTypes, parameterIndex.intValue());
                break;
            }
            case LIST: 
            case SET: {
                Type listType = (Type)((ParameterizedType)fieldType).arguments().get(0);
                MethodDescriptor getTypeFactory = MethodDescriptor.ofMethod(DeserializationContext.class, (String)"getTypeFactory", TypeFactory.class, (Class[])new Class[0]);
                ResultHandle typeFactory = bytecode.invokeVirtualMethod(getTypeFactory, deserializationContext, new ResultHandle[0]);
                MethodDescriptor constructCollectionType = MethodDescriptor.ofMethod(TypeFactory.class, (String)"constructCollectionType", CollectionType.class, (Class[])new Class[]{Class.class, Class.class});
                ResultHandle resultHandle = bytecode.invokeVirtualMethod(constructCollectionType, typeFactory, new ResultHandle[]{bytecode.loadClass(fieldKind == JacksonCodeGenerator.FieldKind.SET ? HashSet.class : ArrayList.class), bytecode.loadClass(listType.name().toString())});
                break;
            }
            case MAP: {
                Type keyType = (Type)((ParameterizedType)fieldType).arguments().get(0);
                Type valueType = (Type)((ParameterizedType)fieldType).arguments().get(1);
                MethodDescriptor getTypeFactory = MethodDescriptor.ofMethod(DeserializationContext.class, (String)"getTypeFactory", TypeFactory.class, (Class[])new Class[0]);
                ResultHandle typeFactory = bytecode.invokeVirtualMethod(getTypeFactory, deserializationContext, new ResultHandle[0]);
                MethodDescriptor constructMapType = MethodDescriptor.ofMethod(TypeFactory.class, (String)"constructMapType", MapType.class, (Class[])new Class[]{Class.class, Class.class, Class.class});
                ResultHandle resultHandle = bytecode.invokeVirtualMethod(constructMapType, typeFactory, new ResultHandle[]{bytecode.loadClass(HashMap.class), bytecode.loadClass(keyType.name().toString()), bytecode.loadClass(valueType.name().toString())});
                break;
            }
            default: {
                ResultHandle resultHandle = typeHandle = bytecode.loadClass(fieldTypeName);
            }
        }
        if (typeHandle == null) {
            return null;
        }
        MethodDescriptor readTreeAsValue = MethodDescriptor.ofMethod(DeserializationContext.class, (String)"readTreeAsValue", Object.class, (Class[])new Class[]{JsonNode.class, fieldKind.isGeneric() ? JavaType.class : Class.class});
        return bytecode.invokeVirtualMethod(readTreeAsValue, deserializationContext, new ResultHandle[]{valueNode, typeHandle});
    }

    private void writeValueToObject(ClassInfo classInfo, ResultHandle objHandle, JacksonCodeGenerator.FieldSpecs fieldSpecs, BytecodeCreator bytecode, ResultHandle valueHandle) {
        if (fieldSpecs.isPublicField()) {
            bytecode.writeInstanceField(fieldSpecs.fieldInfo, objHandle, valueHandle);
        } else {
            MethodInfo setterMethod = this.setterMethodInfo(classInfo, fieldSpecs);
            if (setterMethod != null) {
                if (setterMethod.declaringClass().isInterface()) {
                    bytecode.invokeInterfaceMethod(setterMethod, objHandle, new ResultHandle[]{valueHandle});
                } else {
                    bytecode.invokeVirtualMethod(setterMethod, objHandle, new ResultHandle[]{valueHandle});
                }
            }
        }
    }

    private MethodInfo setterMethodInfo(ClassInfo classInfo, JacksonCodeGenerator.FieldSpecs fieldSpecs) {
        String methodName = "set" + JacksonDeserializerFactory.ucFirst(fieldSpecs.fieldName);
        MethodInfo setter = this.findMethod(classInfo, methodName, fieldSpecs.fieldType);
        if (setter == null) {
            setter = this.findMethod(classInfo, fieldSpecs.fieldName, fieldSpecs.fieldType);
        }
        return setter;
    }

    private static ResultHandle readValueForPrimitiveFields(BytecodeCreator bytecode, Type fieldType, ResultHandle valueNode) {
        AssignableResultHandle result = bytecode.createVariable(DescriptorUtils.typeToString((Type)fieldType));
        BranchResult isValueNull = bytecode.ifNull(valueNode);
        BytecodeCreator isValueNullTrue = isValueNull.trueBranch();
        isValueNullTrue.assign(result, JacksonSerializationUtils.getDefaultValue(isValueNullTrue, fieldType));
        BranchResult isNullNode = isValueNull.falseBranch().ifTrue(isValueNull.falseBranch().invokeVirtualMethod(MethodDescriptor.ofMethod(JsonNode.class, (String)"isNull", Boolean.TYPE, (Class[])new Class[0]), valueNode, new ResultHandle[0]));
        isNullNode.trueBranch().assign(result, JacksonSerializationUtils.getDefaultValue(isNullNode.trueBranch(), fieldType));
        BytecodeCreator isValueNullFalse = isNullNode.falseBranch();
        ResultHandle convertedValue = switch (fieldType.name().toString()) {
            case "java.lang.String" -> isValueNullFalse.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonNode.class, (String)"asText", String.class, (Class[])new Class[0]), valueNode, new ResultHandle[0]);
            case "char", "java.lang.Character" -> isValueNullFalse.invokeVirtualMethod(MethodDescriptor.ofMethod(String.class, (String)"charAt", Character.TYPE, (Class[])new Class[]{Integer.TYPE}), isValueNullFalse.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonNode.class, (String)"asText", String.class, (Class[])new Class[0]), valueNode, new ResultHandle[0]), new ResultHandle[]{isValueNullFalse.load(0)});
            case "short", "java.lang.Short" -> isValueNullFalse.convertPrimitive(isValueNullFalse.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonNode.class, (String)"asInt", Integer.TYPE, (Class[])new Class[0]), valueNode, new ResultHandle[0]), Short.TYPE);
            case "int" -> isValueNullFalse.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonNode.class, (String)"asInt", Integer.TYPE, (Class[])new Class[0]), valueNode, new ResultHandle[0]);
            case "java.lang.Integer" -> isValueNullFalse.invokeStaticMethod(MethodDescriptor.ofMethod(Integer.class, (String)"valueOf", Integer.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{isValueNullFalse.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonNode.class, (String)"asInt", Integer.TYPE, (Class[])new Class[0]), valueNode, new ResultHandle[0])});
            case "long", "java.lang.Long" -> isValueNullFalse.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonNode.class, (String)"asLong", Long.TYPE, (Class[])new Class[0]), valueNode, new ResultHandle[0]);
            case "float", "java.lang.Float" -> isValueNullFalse.convertPrimitive(isValueNullFalse.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonNode.class, (String)"asDouble", Double.TYPE, (Class[])new Class[0]), valueNode, new ResultHandle[0]), Float.TYPE);
            case "double", "java.lang.Double" -> isValueNullFalse.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonNode.class, (String)"asDouble", Double.TYPE, (Class[])new Class[0]), valueNode, new ResultHandle[0]);
            case "boolean", "java.lang.Boolean" -> isValueNullFalse.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonNode.class, (String)"asBoolean", Boolean.TYPE, (Class[])new Class[0]), valueNode, new ResultHandle[0]);
            default -> throw new IllegalStateException("Type " + String.valueOf(fieldType) + " should be handled by the switch");
        };
        isValueNullFalse.assign(result, convertedValue);
        return result;
    }

    @Override
    protected boolean shouldGenerateCodeFor(ClassInfo classInfo) {
        return super.shouldGenerateCodeFor(classInfo) && classInfo.hasNoArgsConstructor();
    }

    private record DeserializationData(ClassInfo classInfo, MethodInfo constructor, ClassCreator classCreator, MethodCreator methodCreator, ResultHandle jsonNode, Map<String, Integer> typeParametersIndex, Set<String> constructorFields) {
    }
}

