/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.TenantIdentityProvider;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcIdentityProvider;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.function.Supplier;

final class TenantSpecificOidcIdentityProvider
extends OidcIdentityProvider
implements TenantIdentityProvider {
    private final String tenantId;
    private final BlockingSecurityExecutor blockingExecutor;

    TenantSpecificOidcIdentityProvider(String tenantId, DefaultTenantConfigResolver resolver, BlockingSecurityExecutor blockingExecutor) {
        super(resolver, blockingExecutor);
        this.blockingExecutor = blockingExecutor;
        this.tenantId = tenantId;
    }

    TenantSpecificOidcIdentityProvider(String tenantId) {
        this(tenantId, (DefaultTenantConfigResolver)Arc.container().instance(DefaultTenantConfigResolver.class, new Annotation[0]).get(), (BlockingSecurityExecutor)Arc.container().instance(BlockingSecurityExecutor.class, new Annotation[0]).get());
    }

    @Override
    public Uni<SecurityIdentity> authenticate(AccessTokenCredential token) {
        return this.authenticate(new TokenAuthenticationRequest((TokenCredential)token));
    }

    @Override
    protected Uni<TenantConfigContext> resolveTenantConfigContext(TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        return this.tenantResolver.resolveContext(this.tenantId).onItem().ifNull().failWith((Supplier)new Supplier<Throwable>(){

            @Override
            public Throwable get() {
                return new OIDCException("Failed to resolve tenant context");
            }
        });
    }

    @Override
    protected Map<String, Object> getRequestData(TokenAuthenticationRequest request) {
        RoutingContext context = HttpSecurityUtils.getRoutingContextAttribute((AuthenticationRequest)request);
        if (context != null) {
            return context.data();
        }
        return Map.of();
    }

    private Uni<SecurityIdentity> authenticate(TokenAuthenticationRequest request) {
        return this.authenticate(request, new AuthenticationRequestContext(){

            public Uni<SecurityIdentity> runBlocking(Supplier<SecurityIdentity> function) {
                return TenantSpecificOidcIdentityProvider.this.blockingExecutor.executeBlocking(function);
            }
        });
    }
}

