// en.js
import { str } from '@lit/localize';

export const templates = {
    // Menu
    'menu-extensions': 'Extensions',
    'menu-configuration': 'Configuration',
    'menu-workspace': 'Workspace',
    'menu-endpoints': 'Endpoints',
    'menu-continuous_testing': 'Continuous Testing',
    'menu-dev_services': 'Dev Services',
    'menu-build_metrics': 'Build Metrics',
    'menu-readme': 'Readme',
    'menu-dependencies': 'Dependencies',
    'menu-remove-context-item': 'Remove',
    
    // Settings dialog
    'settings-title': 'Settings',
    'settings-general': 'General',
    'settings-storage': 'Storage',
    'settings-dev_mcp': 'Dev MCP',
    'theme-label': 'Theme',
    'language-label': 'Language',
    'theme-desktop-label': 'Workspace',
    'theme-light-label': 'Light',
    'theme-dark-label': 'Dark',
    'bugs-feature-label': 'Bugs / Features',
    'report-bug': 'Report a bug',
    'request-feature': 'Request a new feature',
    'storage-name': 'Name',
    'storage-value': 'Value',
    
    // Dev MCP
    'devmcp-read-more-link': 'Read more about Dev MCP',
    'devmcp-connected-title': 'Connected MCP clients',
    'devmcp-no-clients': 'No MCP client is connected to Dev MCP.',
    'devmcp-not-enabled': 'Dev MCP is not enabled.',
    'devmcp-enable': 'Enable Dev MCP',
    'devmcp-disable': 'Disable Dev MCP',
    'devmcp-connect-instr': 'Connect to the Quarkus Dev MCP Server with:',
    'devmcp-protocol-label': 'Protocol:',
    'devmcp-protocol': 'Remote Streamable HTTP',
    'devmcp-url-label': 'URL:',
    'devmcp-copy-title': 'Copy to clipboard',
    'devmcp-copied': 'Copied to clipboard.',
    'devmcp-copy-failed': 'Failed to copy to clipboard.',
    'devmcp-fetching-tools': 'Fetching tools...',
    'devmcp-enabled': 'Enabled',
    'devmcp-namespace': 'Namespace',
    'devmcp-method': 'Method',
    'devmcp-description': 'Description',
    'devmcp-params': 'Params',
    'devmcp-filter': 'Filter',
    'devmcp-invocation-result': 'Tool invocation result',
    'devmcp-input': 'Input',
    'devmcp-test': 'Test',
    'devmcp-fetching-resources': 'Fetching resources...',
    'devmcp-read-resource': 'Read resource',
    'devmcp-resource': 'Resource',
    'devmcp-no-data': 'No data found',

    // Assistant
    'assistant-warning-explanation': 'Quarkus assistant can make mistakes. Check responses.',
    'assistant-warning': 'Warning',
    'assistant-chat-title' : 'Go to the assistant chat screen to continue this discussion.',
    'assistant-chat-button' : 'Chat',
    
    // Footer
    'footer-server': 'Server',
    'footer-testing': 'Testing',
    'footer-dev_ui': 'Dev UI',
    'footer-http': 'HTTP',
    
    // Server log
    'log-toggle': 'On/off switch',
    'log-zoom-out': 'Zoom out',
    'log-zoom-in': 'Zoom in',
    'log-clear': 'Clear',
    'log-follow': 'Follow log',
    'log-levels': 'Log levels',
    'log-columns': 'Columns',

    // Server log help
    'loghelp-available-commands': 'The following commands are available',
    'loghelp-continuous-testing': 'Continuous Testing',
    'loghelp-resume-or-rerun': 'Resume testing / Re-run all tests',
    'loghelp-rerun-failed': 'Re-run failed tests',
    'loghelp-toggle-broken-only': "Toggle 'broken only' mode, where only failing tests are run",
    'loghelp-print-failures': 'Print failures from the last test run',
    'loghelp-pause-tests': 'Pause tests',
    'loghelp-toggle-output': 'Toggle test output',
    'loghelp-system': 'System',
    'loghelp-force-restart': 'Force restart',
    'loghelp-toggle-instrumentation-reload': 'Toggle instrumentation-based reload',
    'loghelp-toggle-live-reload': 'Toggle live reload',
    'loghelp-show-help': 'Show this help',

    // Log entries cols
    'logline-level_icon': 'Level icon',
    'logline-sequence-number': 'Sequence number',
    'logline-host-name': 'Host name',
    'logline-date': 'Date',
    'logline-time': 'Time',
    'logline-level': 'Level',
    'logline-short': 'Short',
    'logline-logger-name': 'Logger name',
    'logline-logger-class-name': 'Logger class name',
    'logline-source-full-class-name': 'Source full class name',
    'logline-source-class-name': 'Source class name',
    'logline-source-method-name': 'Source method name',
    'logline-source-file-name': 'Source file name',
    'logline-source-line-number': 'Source line number',
    'logline-process-id': 'Process Id',
    'logline-process-name': 'Process name',
    'logline-thread-id': 'Thread Id',
    'logline-thread-name': 'Thread name',
    'logline-message': 'Message',

    // Log level dialog
    'loglevelsdialog-filter': 'Filter',
    'loglevelsdialog-name': 'Name',
    'loglevelsdialog-level': 'Level',

    // Connection status
    'connection-disconnected_from': 'Disconnected from',
    'connection-connecting_to': 'Connecting to',
    'connection-hot_reloading': 'Hot reloading',
    'connection-connected_to': 'Connected to',
    
    // Server disconnected dialog
    'disconnected-dialog-header': 'Server unreachable',
    'disconnected-dialog-retry-button': 'Retry',
    'disconnected-dialog-text': 'It looks like the application is currently unavailable. After several reconnection attempts, we’re unable to connect. Once the application is back online, click “Retry” to reconnect.',
    
    // Open with IDE
    'ide-open-failed': 'Could not open your IDE.',
    
    // Welcome screen
    'welcome-congratulations': 'Congratulations!',
    'welcome-application': 'Application',
    'welcome-group-id': 'GroupId',
    'welcome-artifact-id': 'ArtifactId',
    'welcome-version': 'Version',
    'welcome-quarkus-version': 'Quarkus Version',
    'welcome-created-app': 'You just made a Quarkus application.',
    'welcome-served-by-devui': 'This page is served by the Quarkus Dev UI (only in dev mode) until you provide your own Web UI',
    'welcome-visit-devui': 'Visit the Dev UI',
    'welcome-resource-endpoints': 'Resource Endpoints',
    'welcome-documentation': 'Documentation',
    'welcome-guides-blurb': 'Practical step-by-step guides to help you achieve a specific goal. Use them to help get your work done.',
    'welcome-setup-ide': 'Set up your IDE',
    'welcome-setup-ide-blurb': 'Everyone has a favorite IDE they like to use to code. Learn how to configure yours to maximize your Quarkus productivity.',
    'welcome-add-static-content': 'Learn how you can add your own static web content',
    'welcome-static-assets': 'Static assets',
    'welcome-app-configuration': 'App configuration',
    'welcome-code': 'Code',
    'welcome-selected-extensions': 'Selected extensions',
    
    // External page (embedded)
    'external-loading': 'Loading content...',
    'external-download': 'Download',
    
    // Extensions (Menu)
    'extensions-favorites': 'Favorites',
    'extensions-active': 'Active',
    'extensions-inactive': 'Inactive',
    'extensions-namespaces-failed': 'Could not list namespaces',
    'extensions-search': 'Search extensions…',
    'extensions-add': 'Add extension',
    'extensions-installing': 'installation in progress',
    'extensions-install-failed': 'installation failed',
    'extensions-filter-cards': 'Filter extension cards',
    'extensions-details': 'extension details',
    // extensions-favour / extensions-unfavour are region-specific and live in en-GB/en-US
    'extensions-guide': str`Go to the ${0} guide`,
    'extensions-more': str`More about the ${0} extension`,
    'extensions-config': str`Configuration for the ${0} extension`,
    'extensions-name': 'Name',
    'extensions-namespace': 'Namespace',
    'extensions-description': 'Description',
    'extensions-guide-label': 'Guide',
    'extensions-artifact': 'Artifact',
    'extensions-short-name': 'Short name',
    'extensions-keywords': 'Keywords',
    'extensions-status': 'Status',
    'extensions-config-filter': 'Config Filter',
    'extensions-categories': 'Categories',
    'extensions-unlisted': 'Unlisted',
    'extensions-built-with': 'Built with',
    'extensions-capabilities': 'Provides capabilities',
    'extensions-dependencies': 'Extension dependencies',
    'extensions-loading-installable': 'Loading installable extensions',
    'extensions-remove': 'Remove this extension',
    'extensions-removing': 'removal in progress',
    'extensions-remove-failed': 'removal failed',
    'extensions-filter': 'Filter',
    'extensions-category': 'Category',
    'extensions-artifact-col': 'Artifact',
    'extensions-version': 'Version',
    'extensions-platform': 'Platform',
    'extensions-scm': 'SCM',
    'extensions-min-java': 'Minimum Java version',
    'extensions-categories-col': 'Categories',
    'extensions-keywords-col': 'Keywords',
    'extensions-dependencies-col': 'Extension dependencies',

    // Configuration (Menu)
    'configuration-my-properties': 'My properties',
    'configuration-waiting': 'Waiting for backend connection...',
    'configuration-loading': 'Loading configuration properties...',
    'configuration-filter': 'Filter',
    'configuration-filter-sources': 'Filter by config sources',
    'configuration-phase': 'Phase',
    'configuration-name': 'Name',
    'configuration-value': 'Value',
    'configuration-fixed-build': 'Fixed at build time (not overridable at runtime)',
    'configuration-auto-devservices': 'Automatically set by Dev Services',
    'configuration-add-group': 'This will add a new named config group',
    'configuration-default-value': 'Default value',
    'configuration-no-default': 'No default value',
    'configuration-none': 'None',
    'configuration-unknown': 'Unknown',
    'configuration-source': 'Config source',
    'configuration-env-var': 'Environment variable',
    'configuration-updated': str`Property ${0} updated`,
    'configuration-error': 'Error',
    'configuration-save': 'Save',
    'configuration-update-failed': 'Configuration failed to update. See log file for details',
    'configuration-update-success': 'Configuration successfully updated',

    // Workspace (Menu)
    'workspace-unsaved-leave': 'You have unsaved changes. Are you sure you want to leave?',
    'workspace-no-code': 'No code found.',
    'workspace-check-now': 'Check now',
    'workspace-source-code': 'Source Code',
    'workspace-save': 'Save',
    'workspace-copy': 'Copy',
    'workspace-open-ide': 'Open in IDE',
    'workspace-close': 'Close',
    'workspace-unsaved': 'Unsaved changes',
    'workspace-discard': 'Discard',
    'workspace-unsaved-dialog': 'There are unsaved changes. Do you want to discard or save them?',
    'workspace-check-logs': 'Please check your logs.',
    'workspace-error': 'An error occured.',
    'workspace-saved-success': 'saved successfully',
    'workspace-not-saved': 'NOT saved',
    'workspace-no-content': 'has no content',
    'workspace-copy-success': 'Content copied to clipboard',
    'workspace-copy-failed': 'Failed to copy content',
    'workspace-action': 'Action',
    'workspace-binary': 'Binary content.',
    'workspace-download': 'Download',

    // Endpoints (Menu)
    'endpoints-resource_endpoints': 'Resource Endpoints',
    'endpoints-additional_endpoints': 'Additional endpoints',
    'endpoints-test-swagger-ui': 'Test this Swagger UI',
    'endpoints-fetching-info': 'Fetching information...',
    'endpoints-url': 'URL',
    'endpoints-description': 'Description',
    'endpoints-handler': 'Handler',
    'endpoints-order': 'Order',
    'endpoints-path': 'Path',
    'endpoints-fetching-routes': 'Fetching routes...',
    'endpoints-context-handler': 'Context Handler',
    'endpoints-failure-handler': 'Failure Handler',
    'endpoints-unknown': 'Unknown (could not detect)',
    
    // Continuous Testing (Menu)
    'continuoustesting-title': 'Continuous Testing',
    'continuoustesting-tests': 'Tests',
    'continuoustesting-total-time': 'Total time',
    'continuoustesting-tags': 'Tags',
    'continuoustesting-test-class': 'Test Class',
    'continuoustesting-name': 'Name',
    'continuoustesting-time': 'Time',
    'continuoustesting-not-running': 'Continuous Testing is not running. Click the Start button or press [r] in the console to start.',
    'continuoustesting-read-more': 'Read more about Continuous Testing',
    'continuoustesting-start': 'Start',
    'continuoustesting-stop': 'Stop',
    'continuoustesting-run-all': 'Run all',
    'continuoustesting-run-failed': 'Run failed',
    'continuoustesting-only-run-failing': 'Only run failing tests',
    'continuoustesting-display-tags': 'Display tags (if available)',

    // Dev Services (Menu)
    'devservice-config': 'Config',
    'devservice-no-services': 'You do not have any Dev Services running.',
    'devservice-read-more': 'Read more about Dev Services',
    'devservice-make-copy-for': 'Make a copy for',
    'devservice-copy-config-test': 'Copy config for test environment',
    'devservice-test': 'Test',
    'devservice-copy-config-prod': 'Copy config for prod environment',
    'devservice-prod': 'Prod',
    'devservice-copied': 'Copied to clipboard',
    'devservice-copy-failed': 'Clipboard write failed',
    
    // Build Metrics (Menu)
    'buildmetrics-loading-steps': 'Loading build steps...',
    'buildmetrics-summary': str`Executed ${0} build steps on ${1} threads in ${2} ms`,
    'buildmetrics-concurrent-chart': 'Build Steps Concurrent Execution Chart',
    'buildmetrics-filter': 'Filter',
    'buildmetrics-step': 'Build step',
    'buildmetrics-started': 'Started',
    'buildmetrics-duration': 'Duration (ms)',
    'buildmetrics-thread': 'Thread',
    'buildmetrics-thread-count': 'Number of build threads used in a time slot',
    'buildmetrics-time-slots': 'time slots',
    'buildmetrics-loading-graph': 'Loading Build Steps Execution Graph...',
    'buildmetrics-legend': 'Legend',
    'buildmetrics-loading-deps': 'Loading Dependency Graph...',
    'buildmetrics-no-step': 'No build step provided',
    'buildmetrics-back': 'Back',
    'buildmetrics-simple-description': 'Simple description',
    'buildmetrics-loading-items': 'Loading build items...',
    'buildmetrics-items-produced': str`Produced ${0} build items of ${1} types.`,
    'buildmetrics-item': 'Build item',
    'buildmetrics-count': 'Count',
    
    // Dependencies (Menu)
    'dependencies-show-path-to': 'Show path to...',
    'dependencies-simple-description': 'Simple description',
    'dependencies-direct-only': 'Direct Only'
};
