/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Objects;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public interface PlatformReleaseVersion
extends Comparable<PlatformReleaseVersion> {
    public static PlatformReleaseVersion fromString(String s) {
        return new VersionImpl(s);
    }

    @JsonSerialize(using=Serializer.class)
    @JsonDeserialize(using=Deserializer.class)
    public static class VersionImpl
    implements PlatformReleaseVersion {
        private final String version;

        private VersionImpl(String version) {
            this.version = Objects.requireNonNull(version);
        }

        @Override
        public int compareTo(PlatformReleaseVersion o) {
            if (o instanceof VersionImpl) {
                return this.version.compareTo(((VersionImpl)o).version);
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionImpl that = (VersionImpl)o;
            return Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.version);
        }

        public String toString() {
            return this.version;
        }
    }

    public static class Serializer
    extends JsonSerializer<VersionImpl> {
        public void serialize(VersionImpl value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.toString());
        }
    }

    public static class Deserializer
    extends JsonDeserializer<PlatformReleaseVersion> {
        public PlatformReleaseVersion deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return PlatformReleaseVersion.fromString(p.getText());
        }
    }
}

