/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandlers;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.platform.catalog.processor.ExtensionProcessor;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionOrigin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ListExtensionsCommandHandler
implements QuarkusCommandHandler {
    private static final String ID_FORMAT = "%-1s %s";
    private static final String CONCISE_FORMAT = "%-1s %-50s %s";
    private static final String ORIGINS_FORMAT = "%-1s %-50s %-50s %-25s %s";
    private static final String SUPPORT_SCOPE_FORMAT = "%-1s %-50s %-50s %-25s %s";
    private static final String FULL_FORMAT = "%-1s %-50s %-60s %-25s %s";

    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        Map installedByKey;
        BiConsumer<MessageWriter, DisplayData> currentFormatter;
        Collection<Extension> extensions;
        MessageWriter log = invocation.log();
        boolean all = invocation.getValue("quarkus.list-extensions.all", true);
        boolean installedOnly = invocation.getValue("quarkus.list-extensions.installed", false);
        String format = invocation.getValue("quarkus.list-extensions.format", "");
        String search = invocation.getValue("quarkus.list-extensions.search", "*");
        String category = invocation.getValue("quarkus.list-extensions.category", "");
        boolean batchMode = invocation.getValue("quarkus.list-extensions.batch-mode", false);
        ExtensionManager extensionManager = invocation.getValue("quarkus.list-extensions.extension-manager", invocation.getQuarkusProject().getExtensionManager());
        Collection<Extension> collection = extensions = search == null ? invocation.getExtensionsCatalog().getExtensions() : QuarkusCommandHandlers.listExtensions(search, invocation.getExtensionsCatalog().getExtensions(), true).getExtensions();
        if (extensions.isEmpty()) {
            if (!format.equalsIgnoreCase("object")) {
                log.info("No extension found with pattern '%s'", new Object[]{search});
            }
            return QuarkusCommandOutcome.success();
        }
        if (!batchMode && !format.equalsIgnoreCase("object")) {
            String extensionStatus;
            String string = extensionStatus = all ? "available" : "installable";
            if (installedOnly) {
                extensionStatus = "installed";
            }
            log.info("Current Quarkus extensions %s: ", new Object[]{extensionStatus});
            log.info("");
        }
        switch (format.toLowerCase()) {
            case "object": {
                currentFormatter = null;
                break;
            }
            case "id": 
            case "name": {
                currentFormatter = this::idFormatter;
                log.info(String.format(ID_FORMAT, "\u272c", "ArtifactId"));
                break;
            }
            default: {
                currentFormatter = this::conciseFormatter;
                log.info(String.format(CONCISE_FORMAT, "\u272c", "ArtifactId", "Extension Name"));
                break;
            }
            case "origins": {
                currentFormatter = this::originsFormatter;
                log.info(String.format("%-1s %-50s %-50s %-25s %s", "\u272c", "ArtifactId", "Extension Name", "Version", "Origin"));
                break;
            }
            case "full": {
                currentFormatter = this::fullFormatter;
                log.info(String.format(FULL_FORMAT, "\u272c", "ArtifactId", "Extension", "Version", "Guide"));
                break;
            }
            case "support-scope": {
                currentFormatter = this::offeringsFormatter;
                log.info(String.format("%-1s %-50s %-50s %-25s %s", "\u272c", "ArtifactId", "Extension Name", "Version", "Support scope"));
            }
        }
        try {
            installedByKey = extensionManager.getInstalled().stream().collect(Collectors.toMap(ArtifactCoords::getKey, Function.identity()));
        }
        catch (IOException e2) {
            throw new QuarkusCommandException("Failed to determine the list of installed extensions", e2);
        }
        Predicate<Extension> categoryFilter = category != null && !category.isBlank() ? e -> ExtensionProcessor.of(e).getCategories().contains(category) : e -> true;
        if (currentFormatter == null) {
            List filteredExtensions = extensions.stream().filter(e -> !ExtensionProcessor.of(e).isUnlisted()).filter(categoryFilter).filter(e -> {
                ArtifactCoords installed = (ArtifactCoords)installedByKey.get(Extensions.toKey(e));
                if (installedOnly && installed == null) {
                    return false;
                }
                return installedOnly || all || installed == null;
            }).sorted(Comparator.comparing(e -> e.getArtifact().getArtifactId())).collect(Collectors.toList());
            return QuarkusCommandOutcome.success(filteredExtensions);
        }
        extensions.stream().filter(e -> !ExtensionProcessor.of(e).isUnlisted()).filter(categoryFilter).sorted(Comparator.comparing(e -> e.getArtifact().getArtifactId())).forEach(e -> this.display(log, (Extension)e, (ArtifactCoords)installedByKey.get(Extensions.toKey(e)), all, installedOnly, currentFormatter));
        return QuarkusCommandOutcome.success();
    }

    private void idFormatter(MessageWriter writer, DisplayData data) {
        writer.info(String.format(ID_FORMAT, data.isPlatform(), data.getExtensionArtifactId()));
    }

    private void conciseFormatter(MessageWriter writer, DisplayData data) {
        writer.info(String.format(CONCISE_FORMAT, data.isPlatform(), data.trimToFit(50, data.getExtensionArtifactId()), data.getExtensionName()));
    }

    private void originsFormatter(MessageWriter writer, DisplayData data) {
        List<String> origins = data.getOrigins();
        writer.info(String.format("%-1s %-50s %-50s %-25s %s", data.isPlatform(), data.trimToFit(50, data.getExtensionArtifactId()), data.trimToFit(50, data.getExtensionName()), data.getVersion(), origins.isEmpty() ? "" : origins.get(0)));
        for (int i = 1; i < origins.size(); ++i) {
            writer.info(String.format("%-1s %-50s %-50s %-25s %s", "", "", "", "", origins.get(i)));
        }
    }

    private void offeringsFormatter(MessageWriter writer, DisplayData data) {
        List<String> supportScopes = data.getSupportScopes();
        writer.info(String.format("%-1s %-50s %-50s %-25s %s", data.isPlatform(), data.trimToFit(50, data.getExtensionArtifactId()), data.trimToFit(50, data.getExtensionName()), data.getVersion(), supportScopes.isEmpty() ? "" : supportScopes.get(0)));
        for (int i = 1; i < supportScopes.size(); ++i) {
            writer.info(String.format("%-1s %-50s %-50s %-25s %s", "", "", "", "", supportScopes.get(i)));
        }
    }

    private void fullFormatter(MessageWriter writer, DisplayData data) {
        String guide = ExtensionProcessor.getGuide(data.e);
        writer.info(String.format(FULL_FORMAT, data.isPlatform(), data.trimToFit(50, data.getExtensionArtifactId()), data.trimToFit(60, data.getExtensionName()), data.getVersion(), guide != null ? guide : ""));
    }

    private void display(MessageWriter messageWriter, Extension e, ArtifactCoords installed, boolean all, boolean installedOnly, BiConsumer<MessageWriter, DisplayData> formatter) {
        if (installedOnly && installed == null) {
            return;
        }
        if (!installedOnly && !all && installed != null) {
            return;
        }
        formatter.accept(messageWriter, new DisplayData(e, installed));
    }

    class DisplayData {
        Extension e;
        ArtifactCoords installed;

        DisplayData(Extension e, ArtifactCoords installed) {
            this.e = e;
            this.installed = installed;
        }

        String getExtensionName() {
            return this.e.getName();
        }

        String getExtensionArtifactId() {
            return this.e.getArtifact().getArtifactId();
        }

        List<String> getOrigins() {
            ExtensionOrigin origin = null;
            int i = 0;
            List origins = this.e.getOrigins();
            while (i < origins.size() && origin == null) {
                ExtensionOrigin o;
                if (!(o = (ExtensionOrigin)origins.get(i++)).isPlatform()) continue;
                origin = o;
            }
            if (origins.isEmpty() || origin == null) {
                return Arrays.asList("");
            }
            ArrayList<String> result = new ArrayList<String>();
            result.add(origin.getBom().toString().replace("::pom", ""));
            ExtensionOrigin o = origin;
            origins.stream().filter(e -> e.isPlatform()).filter(e -> e != o).map(e -> e.getBom().toString().replace("::pom", "")).collect(Collectors.toCollection(() -> result));
            return result;
        }

        String getVersion() {
            if (this.installed == null || this.installed.getVersion() == null) {
                return this.e.getArtifact().getVersion();
            }
            return this.installed.getVersion();
        }

        String isPlatform() {
            return this.e.hasPlatformOrigin() ? "\u272c" : "";
        }

        String trimToFit(int max, String s) {
            if (s.length() >= max) {
                return s.substring(0, max - 4) + "...";
            }
            return s;
        }

        List<String> getSupportScopes() {
            String selectedSupportKey = this.getRegistryUserSelectedSupportKey();
            if (selectedSupportKey == null) {
                return List.of();
            }
            Object value = this.e.getMetadata().get(selectedSupportKey);
            if (value == null) {
                return null;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                if (col.isEmpty()) {
                    return List.of();
                }
                if (col.size() == 1) {
                    return List.of(String.valueOf(col.iterator().next()));
                }
                ArrayList<String> result = new ArrayList<String>(col.size());
                for (Object i : col) {
                    result.add(String.valueOf(i));
                }
                Collections.sort(result);
                return result;
            }
            return List.of(value.toString());
        }

        String getRegistryUserSelectedSupportKey() {
            Object supportKey = this.e.getMetadata().get("registry-user-selected-support-key");
            if (supportKey == null) {
                return null;
            }
            return supportKey.toString();
        }
    }
}

