/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.banner.BannerConfig;
import io.quarkus.builder.BuildResult;
import io.quarkus.deployment.dev.testing.TestConfig;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.deployment.jvm.JvmModulesReconfigurer;
import io.quarkus.deployment.jvm.ResolvedJVMRequirements;
import io.quarkus.deployment.steps.BannerProcessor;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.runtime.BannerRecorder;
import io.quarkus.runtime.BannerRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.logging.LoggingSetupRecorder;
import io.smallrye.config.SmallRyeConfig;
import java.util.function.BiConsumer;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class TestHandler
implements BiConsumer<Object, BuildResult> {
    private static final JvmModulesReconfigurer jvmModulesReconfigurer = JvmModulesReconfigurer.getInstance();

    @Override
    public void accept(Object o, BuildResult buildResult) {
        ResolvedJVMRequirements jvmRequirements = (ResolvedJVMRequirements)buildResult.consume(ResolvedJVMRequirements.class);
        jvmRequirements.applyJavaModuleConfigurationToRuntime(jvmModulesReconfigurer, Thread.currentThread().getContextClassLoader());
        QuarkusConsole.start();
        TestSupport.instance().get().start();
        final SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        BannerConfig banner = (BannerConfig)config.getConfigMapping(BannerConfig.class);
        LoggingSetupRecorder.handleFailedStart(new BannerProcessor().recordBanner(new BannerRecorder(new RuntimeValue((Object)new BannerRuntimeConfig(){

            public boolean enabled() {
                return config.getOptionalValue("quarkus.banner.enabled", Boolean.class).orElse(true);
            }
        })), banner).getBannerSupplier());
        if (!config.getOptionalValue("quarkus.test.continuous-testing", TestConfig.Mode.class).orElse(TestConfig.Mode.PAUSED).equals((Object)TestConfig.Mode.DISABLED)) {
            Logger.getLogger((String)"io.quarkus.test").info((Object)"Quarkus continuous testing mode started");
        }
    }
}

