/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.arc.runtime.InterceptorBindings;
import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheException;
import io.quarkus.cache.CacheKey;
import io.quarkus.cache.CacheManager;
import io.quarkus.cache.CompositeCacheKey;
import io.quarkus.cache.runtime.CacheInterceptionContext;
import io.quarkus.cache.runtime.CacheKeyParameterPositions;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

public abstract class CacheInterceptor {
    public static final int BASE_PRIORITY = 0;
    private static final Logger LOGGER = Logger.getLogger(CacheInterceptor.class);
    private static final String PERFORMANCE_WARN_MSG = "Cache key resolution based on reflection calls. Please create a GitHub issue in the Quarkus repository, the maintainers might be able to improve your application performance.";
    protected static final String UNHANDLED_ASYNC_RETURN_TYPE_MSG = "Unhandled async return type";
    @Inject
    CacheManager cacheManager;

    protected <T extends Annotation> CacheInterceptionContext<T> getInterceptionContext(final InvocationContext invocationContext, final Class<T> interceptorBindingClass, final boolean supportsCacheKey) {
        return this.getArcCacheInterceptionContext(invocationContext, interceptorBindingClass).orElseGet(new Supplier<CacheInterceptionContext<T>>(){

            @Override
            public CacheInterceptionContext<T> get() {
                return CacheInterceptor.this.getNonArcCacheInterceptionContext(invocationContext, interceptorBindingClass, supportsCacheKey);
            }
        });
    }

    private <T extends Annotation> Optional<CacheInterceptionContext<T>> getArcCacheInterceptionContext(InvocationContext invocationContext, Class<T> interceptorBindingClass) {
        Set bindings = InterceptorBindings.getInterceptorBindings((InvocationContext)invocationContext);
        if (bindings == null) {
            LOGGER.trace((Object)"Interceptor bindings not found in ArC");
            return Optional.empty();
        }
        ArrayList<T> interceptorBindings = new ArrayList<T>();
        ArrayList<Short> cacheKeyParameterPositions = new ArrayList<Short>();
        for (Annotation binding : bindings) {
            if (binding instanceof CacheKeyParameterPositions) {
                for (short position : ((CacheKeyParameterPositions)binding).value()) {
                    cacheKeyParameterPositions.add(position);
                }
                continue;
            }
            if (!interceptorBindingClass.isInstance(binding)) continue;
            interceptorBindings.add(this.cast(binding, interceptorBindingClass));
        }
        return Optional.of(new CacheInterceptionContext(interceptorBindings, cacheKeyParameterPositions));
    }

    private <T extends Annotation> CacheInterceptionContext<T> getNonArcCacheInterceptionContext(InvocationContext invocationContext, Class<T> interceptorBindingClass, boolean supportsCacheKey) {
        LOGGER.trace((Object)"Retrieving interceptor bindings using reflection");
        ArrayList<T> interceptorBindings = new ArrayList<T>();
        ArrayList<Short> cacheKeyParameterPositions = new ArrayList<Short>();
        boolean cacheKeyParameterPositionsFound = false;
        for (Annotation annotation : invocationContext.getMethod().getAnnotations()) {
            if (annotation instanceof CacheKeyParameterPositions) {
                cacheKeyParameterPositionsFound = true;
                for (short position : ((CacheKeyParameterPositions)annotation).value()) {
                    cacheKeyParameterPositions.add(position);
                }
                continue;
            }
            if (!interceptorBindingClass.isInstance(annotation)) continue;
            interceptorBindings.add(this.cast(annotation, interceptorBindingClass));
        }
        if (supportsCacheKey && !cacheKeyParameterPositionsFound) {
            LOGGER.warn((Object)PERFORMANCE_WARN_MSG);
            Parameter[] parameters = invocationContext.getMethod().getParameters();
            for (short i = 0; i < parameters.length; i = (short)(i + 1)) {
                if (!parameters[i].isAnnotationPresent(CacheKey.class)) continue;
                cacheKeyParameterPositions.add(i);
            }
        }
        return new CacheInterceptionContext(interceptorBindings, cacheKeyParameterPositions);
    }

    private <T extends Annotation> T cast(Annotation annotation, Class<T> interceptorBindingClass) {
        return (T)annotation;
    }

    protected Object getCacheKey(Cache cache, List<Short> cacheKeyParameterPositions, Object[] methodParameterValues) {
        if (methodParameterValues == null || methodParameterValues.length == 0) {
            return cache.getDefaultKey();
        }
        if (cacheKeyParameterPositions.size() == 1) {
            return methodParameterValues[cacheKeyParameterPositions.get(0)];
        }
        if (cacheKeyParameterPositions.size() >= 2) {
            ArrayList<Object> keyElements = new ArrayList<Object>();
            for (short position : cacheKeyParameterPositions) {
                keyElements.add(methodParameterValues[position]);
            }
            return new CompositeCacheKey(keyElements.toArray(new Object[0]));
        }
        if (methodParameterValues.length == 1) {
            return methodParameterValues[0];
        }
        return new CompositeCacheKey(methodParameterValues);
    }

    protected static ReturnType determineReturnType(Class<?> returnType) {
        if (Uni.class.isAssignableFrom(returnType)) {
            return ReturnType.Uni;
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            return ReturnType.CompletionStage;
        }
        return ReturnType.NonAsync;
    }

    protected Uni<?> asyncInvocationResultToUni(final Object invocationResult, ReturnType returnType) {
        if (returnType == ReturnType.Uni) {
            return (Uni)invocationResult;
        }
        if (returnType == ReturnType.CompletionStage) {
            return Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<? extends Object>>(){

                @Override
                public CompletionStage<?> get() {
                    return (CompletionStage)invocationResult;
                }
            });
        }
        throw new CacheException(new IllegalStateException(UNHANDLED_ASYNC_RETURN_TYPE_MSG));
    }

    protected Object createAsyncResult(Uni<Object> cacheValue, ReturnType returnType) {
        if (returnType == ReturnType.Uni) {
            return cacheValue;
        }
        if (returnType == ReturnType.CompletionStage) {
            return cacheValue.subscribeAsCompletionStage();
        }
        throw new CacheException(new IllegalStateException(UNHANDLED_ASYNC_RETURN_TYPE_MSG));
    }

    protected static enum ReturnType {
        NonAsync,
        Uni,
        CompletionStage;

    }
}

