/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import io.quarkus.paths.OpenContainerPathTree;
import io.quarkus.paths.PathFilter;
import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathTreeWithManifest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;

public class DirectoryPathTree
extends OpenContainerPathTree
implements Serializable {
    private static final long serialVersionUID = 2255956884896445059L;
    private Path dir;

    public DirectoryPathTree() {
    }

    public DirectoryPathTree(Path dir) {
        this(dir, null);
    }

    public DirectoryPathTree(Path dir, PathFilter pathFilter) {
        this(dir, pathFilter, false);
    }

    public DirectoryPathTree(Path dir, PathFilter pathFilter, boolean manifestEnabled) {
        super(pathFilter, manifestEnabled);
        this.dir = Objects.requireNonNull(dir, "Directory is null");
    }

    protected DirectoryPathTree(Path dir, PathFilter pathFilter, PathTreeWithManifest pathTreeWithManifest) {
        super(pathFilter, pathTreeWithManifest);
        this.dir = Objects.requireNonNull(dir, "Directory is null");
    }

    @Override
    public boolean isArchiveOrigin() {
        return false;
    }

    @Override
    protected Path getRootPath() {
        return this.dir;
    }

    @Override
    protected Path getContainerPath() {
        return this.dir;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        if (Files.exists(this.dir, new LinkOption[0])) {
            boolean bl;
            block9: {
                Stream<Path> stream = Files.list(this.dir);
                try {
                    bl = stream.findAny().isEmpty();
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to list content of " + String.valueOf(this.dir), e);
                    }
                }
                stream.close();
            }
            return bl;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public PathTree getOriginalTree() {
        return this;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.dir.toAbsolutePath().toString());
        out.writeObject(this.pathFilter);
        out.writeBoolean(this.manifestEnabled);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.dir = Path.of(in.readUTF(), new String[0]);
        this.pathFilter = (PathFilter)in.readObject();
        this.manifestEnabled = in.readBoolean();
    }
}

