/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.workspace;

import io.quarkus.bootstrap.model.Mappable;
import io.quarkus.bootstrap.model.MappableCollectionFactory;
import io.quarkus.bootstrap.workspace.LazySourceDir;
import io.quarkus.paths.PathTree;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;

public interface SourceDir
extends Mappable {
    public static SourceDir of(Path src, Path dest) {
        return SourceDir.of(src, dest, null);
    }

    public static SourceDir of(Path src, Path dest, Path generatedSources) {
        return new LazySourceDir(src, dest, generatedSources);
    }

    public Path getDir();

    public PathTree getSourceTree();

    default public boolean isOutputAvailable() {
        Path outputDir = this.getOutputDir();
        return outputDir != null && Files.exists(outputDir, new LinkOption[0]);
    }

    public Path getOutputDir();

    public Path getAptSourcesDir();

    public PathTree getOutputTree();

    default public <T> T getValue(Object key, Class<T> type) {
        return null;
    }

    @Override
    default public Map<String, Object> asMap(MappableCollectionFactory factory) {
        Path aptSourcesDir;
        Path outputDir;
        Map<String, Object> map = factory.newMap(3);
        Path dir = this.getDir();
        if (dir != null) {
            map.put("dir", dir.toString());
        }
        if ((outputDir = this.getOutputDir()) != null) {
            map.put("dest-dir", outputDir.toString());
        }
        if ((aptSourcesDir = this.getAptSourcesDir()) != null) {
            map.put("apt-sources-dir", aptSourcesDir.toString());
        }
        return map;
    }
}

